/*
 * The Kuali Financial System, a comprehensive financial management system for higher education.
 *
 * Copyright 2005-2021 Kuali, Inc.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
package org.kuali.kfs.module.ar.document.web.struts;

import org.kuali.kfs.kns.web.struts.form.KualiTransactionalDocumentFormBase;
import org.kuali.kfs.module.ar.ArConstants;
import org.kuali.kfs.module.ar.businessobject.FinalBilledIndicatorEntry;
import org.kuali.kfs.module.ar.document.FinalBilledIndicatorDocument;

/**
 * Form class for Final Billed Indicator Document.
 */
public class FinalBilledIndicatorForm extends KualiTransactionalDocumentFormBase {

    private FinalBilledIndicatorEntry invoiceEntry;

    // this in sync with the default value set in the document business object
    public FinalBilledIndicatorForm() {
        super();
    }

    public FinalBilledIndicatorDocument getFinalBilledIndicatorDocument() {
        return (FinalBilledIndicatorDocument) getDocument();
    }

    @Override
    protected String getDefaultDocumentTypeName() {
        return ArConstants.ArDocumentTypeCodes.FINAL_BILLED_INDICATOR_DOCUMENT_TYPE_CODE;
    }

    public FinalBilledIndicatorEntry getInvoiceEntry() {
        return invoiceEntry;
    }

    public void setInvoiceEntry(FinalBilledIndicatorEntry invoiceEntry) {
        this.invoiceEntry = invoiceEntry;
    }

}
