/*
 * The Kuali Financial System, a comprehensive financial management system for higher education.
 *
 * Copyright 2005-2021 Kuali, Inc.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
package org.kuali.kfs.module.ar.rest.resource.requests;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;

import java.util.Objects;

@JsonIgnoreProperties(ignoreUnknown = true)
public class AdHocRoutePersonRequest {
    private String principalName;
    private String action;

    public AdHocRoutePersonRequest(@JsonProperty("principalName") String principalName,
                                   @JsonProperty("action") String action
    ) {
        Validate.isTrue(StringUtils.isNotBlank(principalName), "principalName must be supplied");
        Validate.isTrue(StringUtils.isNotBlank(action), "action must be supplied");
        this.principalName = principalName;
        this.action = action;
    }

    public String getPrincipalName() {
        return principalName;
    }

    public String getAction() {
        return action;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }

        if (o == null || getClass() != o.getClass()) {
            return false;
        }

        AdHocRoutePersonRequest that = (AdHocRoutePersonRequest) o;
        return principalName.equals(that.principalName) && action.equals(that.action);
    }

    @Override
    public int hashCode() {
        return Objects.hash(principalName, action);
    }
}
