/*
 * The Kuali Financial System, a comprehensive financial management system for higher education.
 *
 * Copyright 2005-2022 Kuali, Inc.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
package org.kuali.kfs.module.ar.businessobject;

import org.kuali.kfs.core.api.datetime.DateTimeService;
import org.kuali.kfs.integration.cg.ContractsAndGrantsAward;
import org.kuali.kfs.integration.cg.ContractsAndGrantsBillingAward;
import org.kuali.kfs.kim.impl.identity.Person;
import org.kuali.kfs.krad.bo.PersistableBusinessObjectBase;
import org.kuali.kfs.krad.service.DocumentService;
import org.kuali.kfs.krad.util.KRADConstants;
import org.kuali.kfs.krad.util.ObjectUtils;
import org.kuali.kfs.krad.util.UrlFactory;
import org.kuali.kfs.module.ar.document.ContractsGrantsInvoiceDocument;
import org.kuali.kfs.sys.KFSConstants;
import org.kuali.kfs.sys.KFSPropertyConstants;
import org.kuali.kfs.sys.context.SpringContext;

import java.sql.Date;
import java.sql.Timestamp;
import java.util.HashMap;
import java.util.Map;

/**
 * Collection Event class.
 */
public class CollectionEvent extends PersistableBusinessObjectBase {

    private Long id;
    private String collectionEventCode;
    private String invoiceNumber;
    private String activityCode;
    private Date activityDate;
    private String activityText;
    private Date followupDate;
    private Date completedDate;
    private Timestamp postedDate;
    private String userPrincipalId;
    private String proposalNumber;
    private String proposalNumberForInquiry;

    private transient Person user;
    private ContractsAndGrantsAward award;
    private ContractsGrantsInvoiceDocument invoiceDocument;
    private CollectionActivityType collectionActivityType;

    public Long getId() {
        return id;
    }

    public void setId(final Long id) {
        this.id = id;
    }

    public String getCollectionEventCode() {
        return collectionEventCode;
    }

    public void setCollectionEventCode(final String collectionEventCode) {
        this.collectionEventCode = collectionEventCode;
    }

    public String getInvoiceNumber() {
        return invoiceNumber;
    }

    public void setInvoiceNumber(final String invoiceNumber) {
        this.invoiceNumber = invoiceNumber;
    }

    public String getActivityCode() {
        return activityCode;
    }

    public void setActivityCode(final String activityCode) {
        this.activityCode = activityCode;
    }

    public Date getActivityDate() {
        return activityDate;
    }

    public void setActivityDate(final Date activityDate) {
        this.activityDate = activityDate;
    }

    public String getActivityText() {
        return activityText;
    }

    public void setActivityText(final String activityText) {
        this.activityText = activityText;
    }

    public Date getFollowupDate() {
        return followupDate;
    }

    public void setFollowupDate(final Date followupDate) {
        this.followupDate = followupDate;
    }

    public Date getCompletedDate() {
        return completedDate;
    }

    public void setCompletedDate(final Date completedDate) {
        this.completedDate = completedDate;
    }

    public java.util.Date getPostedDate() {
        return postedDate;
    }

    public void setPostedDate(final Timestamp postedDate) {
        this.postedDate = postedDate;
    }

    public String getUserPrincipalId() {
        return userPrincipalId;
    }

    public void setUserPrincipalId(final String userPrincipalId) {
        this.userPrincipalId = userPrincipalId;
    }

    public String getProposalNumber() {
        return proposalNumber;
    }

    public void setProposalNumber(final String proposalNumber) {
        this.proposalNumber = proposalNumber;
    }

    public String getProposalNumberForInquiry() {
        final Map<String, String> params = new HashMap<>();
        params.put(KFSConstants.BUSINESS_OBJECT_CLASS_ATTRIBUTE, ContractsAndGrantsBillingAward.class.getName());
        params.put(KFSConstants.DISPATCH_REQUEST_PARAMETER, KRADConstants.CONTINUE_WITH_INQUIRY_METHOD_TO_CALL);
        params.put(KFSPropertyConstants.PROPOSAL_NUMBER, proposalNumber);
        return UrlFactory.parameterizeUrl(KFSConstants.INQUIRY_ACTION, params);
    }

    public Person getUser() {
        return user;
    }

    public void setUser(final Person user) {
        this.user = user;
    }

    public ContractsAndGrantsAward getAward() {
        return award;
    }

    public void setAward(final ContractsAndGrantsAward award) {
        this.award = award;
    }

    public ContractsGrantsInvoiceDocument getInvoiceDocument() {
        if (ObjectUtils.isNull(invoiceDocument)) {
            final DocumentService documentService = SpringContext.getBean(DocumentService.class);
            invoiceDocument = (ContractsGrantsInvoiceDocument) documentService.getByDocumentHeaderId(invoiceNumber);
        }
        return invoiceDocument;
    }

    public void setInvoiceDocument(final ContractsGrantsInvoiceDocument invoiceDocument) {
        this.invoiceDocument = invoiceDocument;
    }

    public CollectionActivityType getCollectionActivityType() {
        return collectionActivityType;
    }

    public void setCollectionActivityType(final CollectionActivityType collectionActivityType) {
        this.collectionActivityType = collectionActivityType;
    }

    public boolean isCompleted() {
        boolean retVal = false;
        if (ObjectUtils.isNotNull(getCompletedDate())) {
            retVal = SpringContext.getBean(DateTimeService.class).getCurrentSqlDate().after(getCompletedDate());
        }
        return retVal;
    }

}
