/*
 * The Kuali Financial System, a comprehensive financial management system for higher education.
 *
 * Copyright 2005-2022 Kuali, Inc.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
package org.kuali.kfs.module.ar.businessobject;

import org.kuali.kfs.integration.ar.Billable;
import org.kuali.kfs.integration.cg.ContractsAndGrantsBillingAward;
import org.kuali.kfs.integration.cg.ContractsAndGrantsBillingAwardAccount;
import org.kuali.kfs.krad.bo.TransientBusinessObjectBase;
import org.kuali.kfs.krad.util.ObjectUtils;
import org.kuali.kfs.module.ar.ArConstants;
import org.kuali.kfs.core.api.util.type.KualiDecimal;

import java.sql.Date;

/**
 * Defines an award entry for the Contracts & Grants Invoice Lookup Results
 */
public class ContractsGrantsInvoiceLookupResultAward extends TransientBusinessObjectBase implements Billable {

    private String proposalNumber;
    private String chartOfAccountsCode;
    private String accountNumber;
    private Date awardBeginningDate;
    private Date awardEndingDate;
    private String billingFrequencyCode;
    private String instrumentTypeDescription;
    private String invoicingOptionDescription;
    private KualiDecimal awardTotalAmount = KualiDecimal.ZERO;

    public ContractsGrantsInvoiceLookupResultAward() {
    }

    public ContractsGrantsInvoiceLookupResultAward(
            final ContractsAndGrantsBillingAward award,
            final ContractsAndGrantsBillingAwardAccount awardAccount) {
        setProposalNumber(award.getProposalNumber());
        setChartOfAccountsCode(awardAccount.getChartOfAccountsCode());
        setAccountNumber(awardAccount.getAccountNumber());
        setAwardBeginningDate(award.getAwardBeginningDate());
        setAwardEndingDate(award.getAwardEndingDate());
        setBillingFrequencyCode(award.getBillingFrequencyCode());
        setInvoicingOptionDescription(award.getInvoicingOptionDescription());
        setAwardTotalAmount(award.getAwardTotalAmount());

        if (ObjectUtils.isNotNull(award.getInstrumentType())) {
            setInstrumentTypeDescription(award.getInstrumentType().getInstrumentTypeDescription());
        }

    }

    public String getProposalNumber() {
        return proposalNumber;
    }

    public void setProposalNumber(final String proposalNumber) {
        this.proposalNumber = proposalNumber;
    }

    public String getChartOfAccountsCode() {
        return chartOfAccountsCode;
    }

    public void setChartOfAccountsCode(final String chartOfAccountsCode) {
        this.chartOfAccountsCode = chartOfAccountsCode;
    }

    public String getAccountNumber() {
        return accountNumber;
    }

    public void setAccountNumber(final String accountNumber) {
        this.accountNumber = accountNumber;
    }

    public Date getAwardBeginningDate() {
        return awardBeginningDate;
    }

    public void setAwardBeginningDate(final Date awardBeginningDate) {
        this.awardBeginningDate = awardBeginningDate;
    }

    public Date getAwardEndingDate() {
        return awardEndingDate;
    }

    public void setAwardEndingDate(final Date awardEndingDate) {
        this.awardEndingDate = awardEndingDate;
    }

    @Override
    public String getBillingFrequencyCode() {
        return billingFrequencyCode;
    }

    public void setBillingFrequencyCode(final String billingFrequencyCode) {
        this.billingFrequencyCode = billingFrequencyCode;
    }

    public String getInstrumentTypeDescription() {
        return instrumentTypeDescription;
    }

    public void setInstrumentTypeDescription(final String instrumentTypeDescription) {
        this.instrumentTypeDescription = instrumentTypeDescription;
    }

    public String getInvoicingOptionDescription() {
        return invoicingOptionDescription;
    }

    public void setInvoicingOptionDescription(final String invoicingOptionDescription) {
        this.invoicingOptionDescription = invoicingOptionDescription;
    }

    public KualiDecimal getAwardTotalAmount() {
        return awardTotalAmount;
    }

    public void setAwardTotalAmount(final KualiDecimal awardTotalAmount) {
        this.awardTotalAmount = awardTotalAmount;
    }

    /**
     * The objectId is query award accounts to display based on what the user selected in the lookup. For MS or PDBS,
     * this is individual selected award accounts, but for other billing frequencies, we want all the award accounts.
     *
     * @return the objectId used for later queries
     */
    public String getObjectId() {
        if (ArConstants.BillingFrequencyValues.isMilestone(this)
                || ArConstants.BillingFrequencyValues.isPredeterminedBilling(this)) {
            return proposalNumber + "-" + chartOfAccountsCode + "-" + accountNumber;
        } else {
            return proposalNumber + "-*-*";
        }
    }
}
