/*
 * The Kuali Financial System, a comprehensive financial management system for higher education.
 *
 * Copyright 2005-2022 Kuali, Inc.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
package org.kuali.kfs.module.ar.businessobject;

import java.sql.Date;

import org.kuali.kfs.coa.businessobject.Account;
import org.kuali.kfs.coa.businessobject.Chart;
import org.kuali.kfs.core.api.mo.common.active.MutableInactivatable;
import org.kuali.kfs.core.api.util.type.KualiDecimal;
import org.kuali.kfs.integration.cg.ContractsAndGrantsBillingAward;
import org.kuali.kfs.krad.bo.TransientBusinessObjectBase;

public class ContractsGrantsPredeterminedBillingReport extends TransientBusinessObjectBase
        implements MutableInactivatable {

    private String proposalNumber;
    private String chartOfAccountsCode;
    private String accountNumber;
    private boolean active;

    private boolean billed;
    private String billNumber;
    private String billDescription;
    private Date billDate;
    private KualiDecimal estimatedAmount;
    private String invoiceDocumentNumber;

    private Account account;
    private Chart chart;
    private ContractsAndGrantsBillingAward award;

    public ContractsGrantsPredeterminedBillingReport() {
        this.billed = false;
    }

    public String getProposalNumber() {
        return proposalNumber;
    }

    public void setProposalNumber(final String proposalNumber) {
        this.proposalNumber = proposalNumber;
    }

    public String getChartOfAccountsCode() {
        return chartOfAccountsCode;
    }

    public void setChartOfAccountsCode(final String chartOfAccountsCode) {
        this.chartOfAccountsCode = chartOfAccountsCode;
    }

    public String getAccountNumber() {
        return accountNumber;
    }

    public void setAccountNumber(final String accountNumber) {
        this.accountNumber = accountNumber;
    }

    public Account getAccount() {
        return account;
    }

    public void setAccount(final Account account) {
        this.account = account;
    }

    public Chart getChart() {
        return chart;
    }

    public void setChart(final Chart chart) {
        this.chart = chart;
    }

    public ContractsAndGrantsBillingAward getAward() {
        return award;
    }

    public void setAward(final ContractsAndGrantsBillingAward award) {
        this.award = award;
    }

    @Override
    public boolean isActive() {
        return active;
    }

    @Override
    public void setActive(final boolean active) {
        this.active = active;
    }

    public boolean isBilled() {
        return billed;
    }

    public void setBilled(final boolean billed) {
        this.billed = billed;
    }

    public String getBillNumber() {
        return billNumber;
    }

    public void setBillNumber(final String billNumber) {
        this.billNumber = billNumber;
    }

    public String getBillDescription() {
        return billDescription;
    }

    public void setBillDescription(final String billDescription) {
        this.billDescription = billDescription;
    }

    public Date getBillDate() {
        return billDate;
    }

    public void setBillDate(final Date billDate) {
        this.billDate = billDate;
    }

    public KualiDecimal getEstimatedAmount() {
        return estimatedAmount;
    }

    public void setEstimatedAmount(final KualiDecimal estimatedAmount) {
        this.estimatedAmount = estimatedAmount;
    }

    public String getInvoiceDocumentNumber() {
        return invoiceDocumentNumber;
    }

    public void setInvoiceDocumentNumber(final String invoiceDocumentNumber) {
        this.invoiceDocumentNumber = invoiceDocumentNumber;
    }
}
