/*
 * The Kuali Financial System, a comprehensive financial management system for higher education.
 *
 * Copyright 2005-2022 Kuali, Inc.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
package org.kuali.kfs.module.ar.businessobject;

import org.kuali.kfs.core.api.util.type.KualiDecimal;
import org.kuali.kfs.integration.cg.ContractsAndGrantsBillingAgency;
import org.kuali.kfs.integration.cg.ContractsAndGrantsBillingAward;
import org.kuali.kfs.kim.impl.identity.Person;
import org.kuali.kfs.krad.bo.TransientBusinessObjectBase;
import org.kuali.kfs.sys.KFSConstants;

import java.sql.Date;

/**
 * The transient class for Ticklers Report.
 */
public class TicklersReport extends TransientBusinessObjectBase implements CollectionsReport {

    private Long eventId;
    private String collectionEventCode;
    private String principalId;
    private Date followupDate;
    private String activityCode;
    private String proposalNumber;
    private String agencyNumber;
    private boolean completed;
    private Date completedDate;

    private String invoiceNumber;
    private String accountNumber;
    private String agencyName;
    private String activityText;
    private Date activityDate;
    private String activityDescription;
    private String user;
    private KualiDecimal invoiceAmount = KualiDecimal.ZERO;
    private KualiDecimal paymentAmount = KualiDecimal.ZERO;
    private KualiDecimal balanceDue = KualiDecimal.ZERO;

    private Person collector;
    private final String userLookupRoleNamespaceCode = KFSConstants.OptionalModuleNamespaces.ACCOUNTS_RECEIVABLE;
    private final String userLookupRoleName = KFSConstants.SysKimApiConstants.ACCOUNTS_RECEIVABLE_COLLECTOR;
    private ContractsAndGrantsBillingAward award;
    private ContractsAndGrantsBillingAgency agency;

    @Override
    public Long getEventId() {
        return eventId;
    }

    public void setEventId(final Long eventId) {
        this.eventId = eventId;
    }

    @Override
    public String getCollectionEventCode() {
        return collectionEventCode;
    }

    public void setCollectionEventCode(final String collectionEventCode) {
        this.collectionEventCode = collectionEventCode;
    }

    public String getPrincipalId() {
        return principalId;
    }

    public void setPrincipalId(final String principalId) {
        this.principalId = principalId;
    }

    public String getUserLookupRoleNamespaceCode() {
        return userLookupRoleNamespaceCode;
    }

    public String getUserLookupRoleName() {
        return userLookupRoleName;
    }

    public Person getCollector() {
        return collector;
    }

    public void setCollector(final Person collector) {
        this.collector = collector;
    }

    public Date getFollowupDate() {
        return followupDate;
    }

    public void setFollowupDate(final Date followupDate) {
        this.followupDate = followupDate;
    }

    public String getActivityCode() {
        return activityCode;
    }

    public void setActivityCode(final String activityCode) {
        this.activityCode = activityCode;
    }

    @Override
    public String getProposalNumber() {
        return proposalNumber;
    }

    public void setProposalNumber(final String proposalNumber) {
        this.proposalNumber = proposalNumber;
    }

    public String getAgencyNumber() {
        return agencyNumber;
    }

    public void setAgencyNumber(final String agencyNumber) {
        this.agencyNumber = agencyNumber;
    }

    public boolean isCompleted() {
        return completed;
    }

    public void setCompleted(final boolean completed) {
        this.completed = completed;
    }

    @Override
    public String getInvoiceNumber() {
        return invoiceNumber;
    }

    public void setInvoiceNumber(final String invoiceNumber) {
        this.invoiceNumber = invoiceNumber;
    }

    public String getAccountNumber() {
        return accountNumber;
    }

    public void setAccountNumber(final String accountNumber) {
        this.accountNumber = accountNumber;
    }

    public String getAgencyName() {
        return agencyName;
    }

    public void setAgencyName(final String agencyName) {
        this.agencyName = agencyName;
    }

    public String getActivityText() {
        return activityText;
    }

    public void setActivityText(final String activityText) {
        this.activityText = activityText;
    }

    public String getActivityDescription() {
        return activityDescription;
    }

    public void setActivityDescription(final String activityDescription) {
        this.activityDescription = activityDescription;
    }

    public KualiDecimal getInvoiceAmount() {
        return invoiceAmount;
    }

    public void setInvoiceAmount(final KualiDecimal invoiceAmount) {
        this.invoiceAmount = invoiceAmount;
    }

    public KualiDecimal getPaymentAmount() {
        return paymentAmount;
    }

    public void setPaymentAmount(final KualiDecimal paymentAmount) {
        this.paymentAmount = paymentAmount;
    }

    public KualiDecimal getBalanceDue() {
        return balanceDue;
    }

    public void setBalanceDue(final KualiDecimal balanceDue) {
        this.balanceDue = balanceDue;
    }

    public ContractsAndGrantsBillingAward getAward() {
        return award;
    }

    public void setAward(final ContractsAndGrantsBillingAward award) {
        this.award = award;
    }

    public ContractsAndGrantsBillingAgency getAgency() {
        return agency;
    }

    public void setAgency(final ContractsAndGrantsBillingAgency agency) {
        this.agency = agency;
    }

    public Date getActivityDate() {
        return activityDate;
    }

    public void setActivityDate(final Date activityDate) {
        this.activityDate = activityDate;
    }

    public String getUser() {
        return user;
    }

    public void setUser(final String user) {
        this.user = user;
    }

    public Date getCompletedDate() {
        return completedDate;
    }

    public void setCompletedDate(final Date completedDate) {
        this.completedDate = completedDate;
    }

}
