/*
 * The Kuali Financial System, a comprehensive financial management system for higher education.
 *
 * Copyright 2005-2022 Kuali, Inc.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
package org.kuali.kfs.module.ar.document.validation;

import org.kuali.kfs.krad.service.KRADServiceLocator;
import org.kuali.kfs.module.ar.ArKeyConstants;

/**
 * Base class with code setter/getter that SuspensionCategory classes can inherit from.
 */
public abstract class SuspensionCategoryBase implements SuspensionCategory {

    protected String code;

    /**
     * @see org.kuali.kfs.module.ar.document.validation.SuspensionCategory#getCode()
     */
    @Override
    public String getCode() {
        return code;
    }

    public void setCode(final String code) {
        this.code = code;
    }

    @Override
    public String getDescription() {
        return KRADServiceLocator.getKualiConfigurationService().getPropertyValueAsString(ArKeyConstants.INVOICE_DOCUMENT_SUSPENSION_CATEGORY + code);
    }

    @Override
    public String getCodeAndDescription() {
        return getCode() + " - " + getDescription();
    }
}
