/*
 * The Kuali Financial System, a comprehensive financial management system for higher education.
 *
 * Copyright 2005-2022 Kuali, Inc.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
package org.kuali.kfs.module.ar.report.util;

import org.kuali.kfs.module.ar.businessobject.CustomerInvoiceDetail;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * To group and hold the data presented to working reports of extract process
 */
public class CustomerInvoiceReportDataHolder {

    private Map<String, String> invoice;
    private Map<String, String> customer;
    private Map<String, String> sysinfo;
    private List<CustomerInvoiceDetail> details;


    private Map<String, Object> reportData;

    public static final String KEY_OF_INVOICE_ENTRY = "invoice";
    public static final String KEY_OF_CUSTOMER_ENTRY = "customer";
    public static final String KEY_OF_SYSINFO_ENTRY = "sysinfo";
    public static final String KEY_OF_DETAILS_ENTRY = "details";

    public CustomerInvoiceReportDataHolder() {
        invoice = new HashMap<>();
        customer = new HashMap<>();
        sysinfo = new HashMap<>();
        details = new ArrayList<>();
        reportData = new HashMap<>();
    }

    public Map<String, String> getInvoice() {
        return invoice;
    }

    public void setInvoice(final Map<String, String> invoice) {
        this.invoice = invoice;
    }

    public Map<String, String> getCustomer() {
        return customer;
    }

    public void setCustomer(final Map<String, String> customer) {
        this.customer = customer;
    }

    public Map<String, String> getSysinfo() {
        return sysinfo;
    }

    public void setSysinfo(final Map<String, String> sysinfo) {
        this.sysinfo = sysinfo;
    }

    public List<CustomerInvoiceDetail> getDetails() {
        return details;
    }

    public void setDetails(final List<CustomerInvoiceDetail> details) {
        this.details = details;
    }

    public Map<String, Object> getReportData() {
        reportData.put(KEY_OF_INVOICE_ENTRY, invoice);
        reportData.put(KEY_OF_CUSTOMER_ENTRY, customer);
        reportData.put(KEY_OF_SYSINFO_ENTRY, sysinfo);
        reportData.put(KEY_OF_DETAILS_ENTRY, details);

        return reportData;
    }

    public void setReportData(final Map<String, Object> reportData) {
        this.reportData = reportData;
    }

    @Override
    public String toString() {
        return getReportData().toString();
    }
}
