/*
 * The Kuali Financial System, a comprehensive financial management system for higher education.
 *
 * Copyright 2005-2023 Kuali, Inc.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
package org.kuali.kfs.module.ar.businessobject;

import org.apache.commons.lang3.StringUtils;
import org.kuali.kfs.core.api.util.type.KualiDecimal;
import org.kuali.kfs.krad.bo.PersistableBusinessObjectBase;
import org.kuali.kfs.krad.service.DocumentService;
import org.kuali.kfs.krad.util.ObjectUtils;
import org.kuali.kfs.module.ar.document.CashControlDocument;
import org.kuali.kfs.module.ar.document.PaymentApplicationDocument;
import org.kuali.kfs.sys.context.SpringContext;

import java.sql.Date;

public class CashControlDetail extends PersistableBusinessObjectBase {

    private String documentNumber;
    private String referenceFinancialDocumentNumber;
    private String customerPaymentMediumIdentifier;
    private KualiDecimal financialDocumentLineAmount;
    private String customerPaymentDescription;
    private String customerNumber;
    private String status;
    private Date customerPaymentDate;

    private transient PaymentApplicationDocument referenceFinancialDocument;
    private transient CashControlDocument cashControlDocument;

    private Customer customer;

    public CashControlDetail() {
        financialDocumentLineAmount = new KualiDecimal(0);
    }

    public String getDocumentNumber() {
        return documentNumber;
    }

    public void setDocumentNumber(final String documentNumber) {
        this.documentNumber = documentNumber;
    }

    public String getReferenceFinancialDocumentNumber() {
        return referenceFinancialDocumentNumber;
    }

    public void setReferenceFinancialDocumentNumber(final String referenceFinancialDocumentNumber) {
        this.referenceFinancialDocumentNumber = referenceFinancialDocumentNumber;
    }

    public String getCustomerPaymentMediumIdentifier() {
        return customerPaymentMediumIdentifier;
    }

    public void setCustomerPaymentMediumIdentifier(final String customerPaymentMediumIdentifier) {
        this.customerPaymentMediumIdentifier = customerPaymentMediumIdentifier;
    }

    public KualiDecimal getFinancialDocumentLineAmount() {
        return financialDocumentLineAmount;
    }

    public void setFinancialDocumentLineAmount(final KualiDecimal financialDocumentLineAmount) {
        this.financialDocumentLineAmount = financialDocumentLineAmount;
    }

    public String getCustomerPaymentDescription() {
        return customerPaymentDescription;
    }

    public void setCustomerPaymentDescription(final String customerPaymentDescription) {
        this.customerPaymentDescription = customerPaymentDescription;
    }

    public String getCustomerNumber() {
        return customerNumber;
    }

    public void setCustomerNumber(final String customerNumber) {
        this.customerNumber = customerNumber;
    }

    public Date getCustomerPaymentDate() {
        return customerPaymentDate;
    }

    public void setCustomerPaymentDate(final Date customerPaymentDate) {
        this.customerPaymentDate = customerPaymentDate;
    }

    public PaymentApplicationDocument getReferenceFinancialDocument() {
        //This is to add NP checking on referenceFinancialDocumentNumber
        if (ObjectUtils.isNull(referenceFinancialDocument) && StringUtils.isNotEmpty(referenceFinancialDocumentNumber)) {
            referenceFinancialDocument = (PaymentApplicationDocument) SpringContext.getBean(DocumentService.class).getByDocumentHeaderId(
                    referenceFinancialDocumentNumber);
        }
        return referenceFinancialDocument;
    }

    public void setReferenceFinancialDocument(final PaymentApplicationDocument referenceFinancialDocument) {
        this.referenceFinancialDocument = referenceFinancialDocument;
    }

    public Customer getCustomer() {
        return customer;
    }

    @Deprecated
    public void setCustomer(final Customer customer) {
        this.customer = customer;
    }

    public CashControlDocument getCashControlDocument() {
        if (cashControlDocument == null) {
            final String n = getDocumentNumber();
            if (null == n) {
                return null;
            }
            cashControlDocument = (CashControlDocument) SpringContext.getBean(DocumentService.class).getByDocumentHeaderId(n);
        }
        return cashControlDocument;
    }

    public void setCashControlDocument(final CashControlDocument cashControlDocument) {
        this.cashControlDocument = cashControlDocument;
    }

    public String getStatus() {
        return status;
    }

    public void setStatus(final String status) {
        this.status = status;
    }

}
