/*
 * The Kuali Financial System, a comprehensive financial management system for higher education.
 *
 * Copyright 2005-2023 Kuali, Inc.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
package org.kuali.kfs.module.ar.businessobject;

import org.kuali.kfs.coa.businessobject.Account;
import org.kuali.kfs.coa.businessobject.Chart;
import org.kuali.kfs.coa.businessobject.Organization;
import org.kuali.kfs.core.api.util.type.KualiDecimal;
import org.kuali.kfs.integration.cg.ContractsAndGrantsBillingAward;
import org.kuali.kfs.kim.impl.identity.Person;
import org.kuali.kfs.krad.bo.TransientBusinessObjectBase;
import org.kuali.kfs.module.ar.ArConstants;
import org.kuali.kfs.sys.KFSConstants;

import java.util.Date;

public class ContractsAndGrantsAgingReport extends TransientBusinessObjectBase {

    private String reportOption = ArConstants.ReportOptionFieldValues.PROCESSING_ORG;
    private String organizationCode;
    private String processingOrBillingChartCode;

    private String customerName;
    private String customerNumber;
    private String accountChartOfAccountsCode;
    private String accountNumber;
    private String fundManager;
    private String proposalNumber;
    private String awardDocumentNumber;
    private boolean markedAsFinal;
    private Date awardEndDate;
    private String invoiceNumber;
    private Date reportRunDate;
    private String reportingName;
    private String agencyNumber;
    private Date invoiceDate;
    private String contractsAndGrantsAccountResponsibilityId;

    private KualiDecimal unpaidBalance0to30 = KualiDecimal.ZERO;
    private KualiDecimal unpaidBalance31to60 = KualiDecimal.ZERO;
    private KualiDecimal unpaidBalance61to90 = KualiDecimal.ZERO;
    private KualiDecimal unpaidBalance91toSYSPR = KualiDecimal.ZERO;
    private KualiDecimal unpaidBalanceSYSPRplus1orMore = KualiDecimal.ZERO;

    private KualiDecimal totalOpenInvoices = KualiDecimal.ZERO;
    private KualiDecimal totalCredits = KualiDecimal.ZERO;
    private KualiDecimal totalWriteOff = KualiDecimal.ZERO;

    private String principalId;
    private Person collector;

    private final String userLookupRoleNamespaceCode = KFSConstants.OptionalModuleNamespaces.ACCOUNTS_RECEIVABLE;
    private final String userLookupRoleName = KFSConstants.SysKimApiConstants.ACCOUNTS_RECEIVABLE_COLLECTOR;
    private Person lookupFundMgrPerson;
    private Customer customer;
    private Account account;
    private Chart chart;
    private ContractsAndGrantsBillingAward award;
    private Organization organization;

    public String getCustomerName() {
        return customerName;
    }

    public void setCustomerName(final String customerName) {
        this.customerName = customerName;
    }

    public String getCustomerNumber() {
        return customerNumber;
    }

    public void setCustomerNumber(final String customerNumber) {
        this.customerNumber = customerNumber;
    }

    public String getAccountChartOfAccountsCode() {
        return accountChartOfAccountsCode;
    }

    public void setAccountChartOfAccountsCode(final String accountChartOfAccountsCode) {
        this.accountChartOfAccountsCode = accountChartOfAccountsCode;
    }

    public String getAccountNumber() {
        return accountNumber;
    }

    public void setAccountNumber(final String accountNumber) {
        this.accountNumber = accountNumber;
    }

    public String getFundManager() {
        return fundManager;
    }

    public void setFundManager(final String fundManager) {
        this.fundManager = fundManager;
    }

    public String getProposalNumber() {
        return proposalNumber;
    }

    public void setProposalNumber(final String proposalNumber) {
        this.proposalNumber = proposalNumber;
    }

    public Person getCollector() {
        return collector;
    }

    public void setCollector(final Person collector) {
        this.collector = collector;
    }

    public String getAwardDocumentNumber() {
        return awardDocumentNumber;
    }

    public void setAwardDocumentNumber(final String awardDocumentNumber) {
        this.awardDocumentNumber = awardDocumentNumber;
    }

    public boolean isMarkedAsFinal() {
        return markedAsFinal;
    }

    public void setMarkedAsFinal(final boolean markedAsFinal) {
        this.markedAsFinal = markedAsFinal;
    }

    public Date getAwardEndDate() {
        return awardEndDate;
    }

    public void setAwardEndDate(final Date awardEndDate) {
        this.awardEndDate = awardEndDate;
    }

    public String getInvoiceNumber() {
        return invoiceNumber;
    }

    public void setInvoiceNumber(final String invoiceNumber) {
        this.invoiceNumber = invoiceNumber;
    }

    public Date getReportRunDate() {
        return reportRunDate;
    }

    public void setReportRunDate(final Date reportRunDate) {
        this.reportRunDate = reportRunDate;
    }

    public KualiDecimal getUnpaidBalance0to30() {
        return unpaidBalance0to30;
    }

    public void setUnpaidBalance0to30(final KualiDecimal unpaidBalance0to30) {
        this.unpaidBalance0to30 = unpaidBalance0to30;
    }

    public KualiDecimal getUnpaidBalance31to60() {
        return unpaidBalance31to60;
    }

    public void setUnpaidBalance31to60(final KualiDecimal unpaidBalance31to60) {
        this.unpaidBalance31to60 = unpaidBalance31to60;
    }

    public KualiDecimal getUnpaidBalance61to90() {
        return unpaidBalance61to90;
    }

    public void setUnpaidBalance61to90(final KualiDecimal unpaidBalance61to90) {
        this.unpaidBalance61to90 = unpaidBalance61to90;
    }

    public KualiDecimal getUnpaidBalance91toSYSPR() {
        return unpaidBalance91toSYSPR;
    }

    public void setUnpaidBalance91toSYSPR(final KualiDecimal unpaidBalance91toSYSPR) {
        this.unpaidBalance91toSYSPR = unpaidBalance91toSYSPR;
    }

    public KualiDecimal getUnpaidBalanceSYSPRplus1orMore() {
        return unpaidBalanceSYSPRplus1orMore;
    }

    public void setUnpaidBalanceSYSPRplus1orMore(final KualiDecimal unpaidBalanceSYSPRplus1orMore) {
        this.unpaidBalanceSYSPRplus1orMore = unpaidBalanceSYSPRplus1orMore;
    }

    public String getReportingName() {
        return reportingName;
    }

    public void setReportingName(final String reportingName) {
        this.reportingName = reportingName;
    }

    public KualiDecimal getTotalOpenInvoices() {
        return totalOpenInvoices;
    }

    public void setTotalOpenInvoices(final KualiDecimal totalOpenInvoices) {
        this.totalOpenInvoices = totalOpenInvoices;
    }

    public KualiDecimal getTotalCredits() {
        return totalCredits;
    }

    public void setTotalCredits(final KualiDecimal totalCredits) {
        this.totalCredits = totalCredits;
    }

    public KualiDecimal getTotalWriteOff() {
        return totalWriteOff;
    }

    public void setTotalWriteOff(final KualiDecimal totalWriteOff) {
        this.totalWriteOff = totalWriteOff;
    }

    public String getAgencyNumber() {
        return agencyNumber;
    }

    public void setAgencyNumber(final String agencyNumber) {
        this.agencyNumber = agencyNumber;
    }

    public String getPrincipalId() {
        return principalId;
    }

    public void setPrincipalId(final String principalId) {
        this.principalId = principalId;
    }

    public String getUserLookupRoleNamespaceCode() {
        return userLookupRoleNamespaceCode;
    }

    public String getUserLookupRoleName() {
        return userLookupRoleName;
    }

    public String getOrganizationCode() {
        return organizationCode;
    }

    public void setOrganizationCode(final String organizationCode) {
        this.organizationCode = organizationCode;
    }

    public Person getLookupFundMgrPerson() {
        return lookupFundMgrPerson;
    }

    public void setLookupFundMgrPerson(final Person lookupFundMgrPerson) {
        this.lookupFundMgrPerson = lookupFundMgrPerson;
    }

    public Date getInvoiceDate() {
        return invoiceDate;
    }

    public void setInvoiceDate(final Date invoiceDate) {
        this.invoiceDate = invoiceDate;
    }

    public Customer getCustomer() {
        return customer;
    }

    public void setCustomer(final Customer customer) {
        this.customer = customer;
    }

    public Account getAccount() {
        return account;
    }

    public void setAccount(final Account account) {
        this.account = account;
    }

    public String getContractsAndGrantsAccountResponsibilityId() {
        return contractsAndGrantsAccountResponsibilityId;
    }

    public void setContractsAndGrantsAccountResponsibilityId(final String contractsAndGrantsAccountResponsibilityId) {
        this.contractsAndGrantsAccountResponsibilityId = contractsAndGrantsAccountResponsibilityId;
    }

    public String getReportOption() {
        return reportOption;
    }

    public void setReportOption(final String reportOption) {
        this.reportOption = reportOption;
    }

    public String getProcessingOrBillingChartCode() {
        return processingOrBillingChartCode;
    }

    public void setProcessingOrBillingChartCode(final String processingOrBillingChartCode) {
        this.processingOrBillingChartCode = processingOrBillingChartCode;
    }

    public Chart getChart() {
        return chart;
    }

    public void setChart(final Chart chart) {
        this.chart = chart;
    }

    public Organization getOrganization() {
        return organization;
    }

    public void setOrganization(final Organization organization) {
        this.organization = organization;
    }

    public ContractsAndGrantsBillingAward getAward() {
        return award;
    }

    public void setAward(final ContractsAndGrantsBillingAward award) {
        this.award = award;
    }

}
