/*
 * The Kuali Financial System, a comprehensive financial management system for higher education.
 *
 * Copyright 2005-2023 Kuali, Inc.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
package org.kuali.kfs.module.ar.businessobject;

import org.kuali.kfs.coa.businessobject.Chart;
import org.kuali.kfs.coa.businessobject.Organization;
import org.kuali.kfs.coreservice.framework.parameter.ParameterService;
import org.kuali.kfs.integration.ar.AccountsReceivableOrganizationOptions;
import org.kuali.kfs.krad.bo.PersistableBusinessObjectBase;
import org.kuali.kfs.module.ar.ArParameterConstants;
import org.kuali.kfs.module.ar.document.service.SystemInformationService;
import org.kuali.kfs.sys.KFSConstants;
import org.kuali.kfs.sys.businessobject.Country;
import org.kuali.kfs.sys.businessobject.PostalCode;
import org.kuali.kfs.sys.businessobject.State;
import org.kuali.kfs.sys.context.SpringContext;
import org.kuali.kfs.sys.service.UniversityDateService;

public class OrganizationOptions extends PersistableBusinessObjectBase implements
        AccountsReceivableOrganizationOptions {

    protected String chartOfAccountsCode;
    protected String organizationCode;
    protected String processingChartOfAccountCode;
    protected String processingOrganizationCode;
    protected String printInvoiceIndicator;
    protected String organizationPaymentTermsText;
    protected String organizationMessageText;
    protected String organizationRemitToAddressName;
    protected String organizationRemitToLine1StreetAddress;
    protected String organizationRemitToLine2StreetAddress;
    protected String organizationRemitToCityName;
    protected String organizationRemitToStateCode;
    protected String organizationRemitToZipCode;
    protected String organizationRemitToCountryCode = KFSConstants.COUNTRY_CODE_UNITED_STATES;
    protected String organizationPhoneNumber;
    protected String organization800PhoneNumber;
    protected String organizationFaxNumber;
    protected String universityName;
    protected String organizationCheckPayableToName;
    protected String organizationPostalZipCode;
    protected String organizationPostalCountryCode;
    private boolean cgBillerIndicator;
    protected Organization organization;
    protected Chart chartOfAccounts;
    protected Chart processingChartOfAccount;
    protected Organization processingOrganization;
    protected State organizationRemitToState;
    protected PrintInvoiceOptions printInvoiceOptions;
    protected PostalCode orgPostalZipCode;
    protected PostalCode orgRemitToZipCode;
    protected Country orgPostalCountryCode;
    private Country orgRemitToCountry;

    protected transient SystemInformation systemInformationForAddress;
    protected transient SystemInformation systemInformationForAddressName;
    protected static transient ParameterService parameterService;
    protected static transient SystemInformationService systemInformationService;
    protected static transient UniversityDateService universityDateService;

    public boolean isCgBillerIndicator() {
        return cgBillerIndicator;
    }

    public void setCgBillerIndicator(final boolean cgBillerIndicator) {
        this.cgBillerIndicator = cgBillerIndicator;
    }

    public String getChartOfAccountsCode() {
        return chartOfAccountsCode;
    }

    public void setChartOfAccountsCode(final String chartOfAccountsCode) {
        this.chartOfAccountsCode = chartOfAccountsCode;
    }

    public String getOrganizationCode() {
        return organizationCode;
    }

    public void setOrganizationCode(final String organizationCode) {
        this.organizationCode = organizationCode;
    }

    @Override
    public String getProcessingChartOfAccountCode() {
        return processingChartOfAccountCode;
    }

    public void setProcessingChartOfAccountCode(final String processingChartOfAccountCode) {
        this.processingChartOfAccountCode = processingChartOfAccountCode;
    }

    @Override
    public String getProcessingOrganizationCode() {
        return processingOrganizationCode;
    }

    public void setProcessingOrganizationCode(final String processingOrganizationCode) {
        this.processingOrganizationCode = processingOrganizationCode;
    }

    @Override
    public String getPrintInvoiceIndicator() {
        return printInvoiceIndicator;
    }

    public void setPrintInvoiceIndicator(final String printInvoiceIndicator) {
        this.printInvoiceIndicator = printInvoiceIndicator;
    }

    @Override
    public String getOrganizationPaymentTermsText() {
        return organizationPaymentTermsText;
    }

    public void setOrganizationPaymentTermsText(final String organizationPaymentTermsText) {
        this.organizationPaymentTermsText = organizationPaymentTermsText;
    }

    public String getOrganizationMessageText() {
        return organizationMessageText;
    }

    public void setOrganizationMessageText(final String organizationMessageText) {
        this.organizationMessageText = organizationMessageText;
    }

    public String getOrganizationRemitToAddressName() {
        final SystemInformation systemInfo = getSystemInformationForRemitToAddressName();
        if (systemInfo != null) {
            return systemInfo.getOrganizationRemitToAddressName();
        }
        return organizationRemitToAddressName;
    }

    public void setOrganizationRemitToAddressName(final String organizationRemitToAddressName) {
        this.organizationRemitToAddressName = organizationRemitToAddressName;
    }

    public String getOrganizationRemitToLine1StreetAddress() {
        final SystemInformation systemInfo = getSystemInformationForRemitToAddress();
        if (systemInfo != null) {
            return systemInfo.getOrganizationRemitToLine1StreetAddress();
        }
        return organizationRemitToLine1StreetAddress;
    }

    public void setOrganizationRemitToLine1StreetAddress(final String organizationRemitToLine1StreetAddress) {
        this.organizationRemitToLine1StreetAddress = organizationRemitToLine1StreetAddress;
    }

    public String getOrganizationRemitToLine2StreetAddress() {
        final SystemInformation systemInfo = getSystemInformationForRemitToAddress();
        if (systemInfo != null) {
            return systemInfo.getOrganizationRemitToLine2StreetAddress();
        }
        return organizationRemitToLine2StreetAddress;
    }

    public void setOrganizationRemitToLine2StreetAddress(final String organizationRemitToLine2StreetAddress) {
        this.organizationRemitToLine2StreetAddress = organizationRemitToLine2StreetAddress;
    }

    public String getOrganizationRemitToCityName() {
        final SystemInformation systemInfo = getSystemInformationForRemitToAddress();
        if (systemInfo != null) {
            return systemInfo.getOrganizationRemitToCityName();
        }
        return organizationRemitToCityName;
    }

    public void setOrganizationRemitToCityName(final String organizationRemitToCityName) {
        this.organizationRemitToCityName = organizationRemitToCityName;
    }

    public String getOrganizationRemitToStateCode() {
        final SystemInformation systemInfo = getSystemInformationForRemitToAddress();
        if (systemInfo != null) {
            return systemInfo.getOrganizationRemitToStateCode();
        }
        return organizationRemitToStateCode;
    }

    public void setOrganizationRemitToStateCode(final String organizationRemitToStateCode) {
        this.organizationRemitToStateCode = organizationRemitToStateCode;
    }

    public String getOrganizationRemitToZipCode() {
        final SystemInformation systemInfo = getSystemInformationForRemitToAddress();
        if (systemInfo != null) {
            return systemInfo.getOrganizationRemitToZipCode();
        }
        return organizationRemitToZipCode;
    }

    public void setOrganizationRemitToZipCode(final String organizationRemitToZipCode) {
        this.organizationRemitToZipCode = organizationRemitToZipCode;
    }

    public String getOrganizationPhoneNumber() {
        return organizationPhoneNumber;
    }

    public void setOrganizationPhoneNumber(final String organizationPhoneNumber) {
        this.organizationPhoneNumber = organizationPhoneNumber;
    }

    public String getOrganization800PhoneNumber() {
        return organization800PhoneNumber;
    }

    public void setOrganization800PhoneNumber(final String organization800PhoneNumber) {
        this.organization800PhoneNumber = organization800PhoneNumber;
    }

    public String getOrganizationFaxNumber() {
        return organizationFaxNumber;
    }

    public void setOrganizationFaxNumber(final String organizationFaxNumber) {
        this.organizationFaxNumber = organizationFaxNumber;
    }

    public String getUniversityName() {
        return universityName;
    }

    public void setUniversityName(final String universityName) {
        this.universityName = universityName;
    }

    public String getOrganizationCheckPayableToName() {
        final SystemInformation systemInfo = getSystemInformationForRemitToAddress();
        if (systemInfo != null) {
            return systemInfo.getOrganizationCheckPayableToName();
        }
        return organizationCheckPayableToName;
    }

    public void setOrganizationCheckPayableToName(final String organizationCheckPayableToName) {
        this.organizationCheckPayableToName = organizationCheckPayableToName;
    }

    public Organization getOrganization() {
        return organization;
    }

    @Deprecated
    public void setOrganization(final Organization organization) {
        this.organization = organization;
    }

    public Chart getChartOfAccounts() {
        return chartOfAccounts;
    }

    @Deprecated
    public void setChartOfAccounts(final Chart chartOfAccounts) {
        this.chartOfAccounts = chartOfAccounts;
    }

    public Chart getProcessingChartOfAccount() {
        return processingChartOfAccount;
    }

    @Deprecated
    public void setProcessingChartOfAccount(final Chart processingChartOfAccount) {
        this.processingChartOfAccount = processingChartOfAccount;
    }

    public Organization getProcessingOrganization() {
        return processingOrganization;
    }

    @Deprecated
    public void setProcessingOrganization(final Organization processingOrganization) {
        this.processingOrganization = processingOrganization;
    }

    public State getOrganizationRemitToState() {
        return organizationRemitToState;
    }

    @Deprecated
    public void setOrganizationRemitToState(final State organizationRemitToState) {
        this.organizationRemitToState = organizationRemitToState;
    }

    public PrintInvoiceOptions getPrintInvoiceOptions() {
        return printInvoiceOptions;
    }

    public void setPrintInvoiceOptions(final PrintInvoiceOptions printInvoiceOptions) {
        this.printInvoiceOptions = printInvoiceOptions;
    }

    /**
     * This method (a hack by any other name...) returns a string so that an organization options can have a link to
     * view its own inquiry page after a look up
     *
     * @return the String "View Organization Options"
     */
    public String getOrganizationOptionsViewer() {
        return "View Organization Options";
    }

    public String getOrganizationPostalZipCode() {
        return organizationPostalZipCode;
    }

    public String getOrganizationPostalCountryCode() {
        return organizationPostalCountryCode;
    }

    public void setOrganizationPostalCountryCode(final String organizationPostalCountryCode) {
        this.organizationPostalCountryCode = organizationPostalCountryCode;
    }

    public void setOrganizationPostalZipCode(final String organizationPostalZipCode) {
        this.organizationPostalZipCode = organizationPostalZipCode;
    }

    public PostalCode getOrgPostalZipCode() {
        return orgPostalZipCode;
    }

    public void setOrgPostalZipCode(final PostalCode orgPostalZipCode) {
        this.orgPostalZipCode = orgPostalZipCode;
    }

    public PostalCode getOrgRemitToZipCode() {
        return orgRemitToZipCode;
    }

    public void setOrgRemitToZipCode(final PostalCode orgRemitToZipCode) {
        this.orgRemitToZipCode = orgRemitToZipCode;
    }

    public Country getOrgPostalCountryCode() {
        return orgPostalCountryCode;
    }

    public void setOrgPostalCountryCode(final Country orgPostalCountryCode) {
        this.orgPostalCountryCode = orgPostalCountryCode;
    }

    /**
     * @return the related SystemInformation object with the address to use as remit to address, if the remit to
     *         address is not editable on this OrganizationOptions business object
     */
    protected SystemInformation getSystemInformationForRemitToAddress() {
        if (!isRemitToAddressEditable()) {
            if (systemInformationForAddressName == null) {
                final Integer currentFiscalYear = getUniversityDateService().getCurrentFiscalYear();
                systemInformationForAddressName = getSystemInformationService()
                    .getByProcessingChartOrgAndFiscalYear(processingChartOfAccountCode, processingOrganizationCode,
                            currentFiscalYear);
            }
            return systemInformationForAddressName;
        }
        return null;
    }

    /**
     * @return the related SystemInformation object with the address to use as remit to address name, if the remit to
     *         address name is not editable on this OrganizationOptions business object
     */
    protected SystemInformation getSystemInformationForRemitToAddressName() {
        if (!isRemitToAddressNameEditable()) {
            if (systemInformationForAddress == null) {
                final Integer currentFiscalYear = getUniversityDateService().getCurrentFiscalYear();
                systemInformationForAddress = getSystemInformationService()
                    .getByProcessingChartOrgAndFiscalYear(processingChartOfAccountCode, processingOrganizationCode,
                            currentFiscalYear);
            }
            return systemInformationForAddress;
        }
        return null;
    }

    /**
     * @return true if the name for the remit to address is editable, false otherwise
     */
    protected boolean isRemitToAddressNameEditable() {
        return getParameterService().getParameterValueAsBoolean(OrganizationOptions.class,
                ArParameterConstants.REMIT_TO_IND);
    }

    /**
     * @return true if the remit to address is editable, false otherwise
     */
    protected boolean isRemitToAddressEditable() {
        return getParameterService().getParameterValueAsBoolean(OrganizationOptions.class,
                ArParameterConstants.REMIT_TO_ADDRESS_IND);
    }

    protected ParameterService getParameterService() {
        if (parameterService == null) {
            parameterService = SpringContext.getBean(ParameterService.class);
        }
        return parameterService;
    }

    protected SystemInformationService getSystemInformationService() {
        if (systemInformationService == null) {
            systemInformationService = SpringContext.getBean(SystemInformationService.class);
        }
        return systemInformationService;
    }

    protected UniversityDateService getUniversityDateService() {
        if (universityDateService == null) {
            universityDateService = SpringContext.getBean(UniversityDateService.class);
        }
        return universityDateService;
    }

    public String getOrganizationRemitToCountryCode() {
        final SystemInformation systemInfo = getSystemInformationForRemitToAddress();
        if (systemInfo != null) {
            return systemInfo.getOrganizationRemitToCountryCode();
        }
        return organizationRemitToCountryCode;
    }

    public void setOrganizationRemitToCountryCode(final String organizationRemitToCountryCode) {
        this.organizationRemitToCountryCode = organizationRemitToCountryCode;
    }

    public Country getOrgRemitToCountry() {
        return orgRemitToCountry;
    }

    public void setOrgRemitToCountry(final Country orgRemitToCountry) {
        this.orgRemitToCountry = orgRemitToCountry;
    }
}
