/*
 * The Kuali Financial System, a comprehensive financial management system for higher education.
 *
 * Copyright 2005-2023 Kuali, Inc.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
package org.kuali.kfs.module.ar.report;

import java.math.BigDecimal;
import java.sql.Date;

/**
 * Defines a data holder class for the Contracts & Grants Aging Report.
 */
public class ContractsGrantsAgingReportDetailDataHolder {

    private String agencyName;
    private String proposalNumber;
    private String documentNumber;
    private String invoiceType;
    private Date invoiceDate;
    private Date awardEndDate;
    private String customerNumber;
    private String sortedFieldValue;
    private BigDecimal invoiceAmount;
    private BigDecimal paymentAmount;
    private BigDecimal remainingAmount;
    private Long ageInDays;
    private BigDecimal invoiceSubTotal;
    private BigDecimal paymentSubTotal;
    private BigDecimal remainingSubTotal;
    public boolean displaySubtotal;
    public boolean displayTotal;
    private BigDecimal invoiceTotal;
    private BigDecimal paymentTotal;
    private BigDecimal remainingTotal;
    private Date lastEventDate;
    private String collectorName;
    private String agencyNumber;

    public String getProposalNumber() {
        return proposalNumber;
    }

    public void setProposalNumber(final String proposalNumber) {
        this.proposalNumber = proposalNumber;
    }

    public String getDocumentNumber() {
        return documentNumber;
    }

    public void setDocumentNumber(final String documentNumber) {
        this.documentNumber = documentNumber;
    }

    public String getInvoiceType() {
        return invoiceType;
    }

    public void setInvoiceType(final String invoiceType) {
        this.invoiceType = invoiceType;
    }

    public Date getInvoiceDate() {
        return invoiceDate;
    }

    public void setInvoiceDate(final Date invoiceDate) {
        this.invoiceDate = invoiceDate;
    }

    public String getCustomerNumber() {
        return customerNumber;
    }

    public void setCustomerNumber(final String customerNumber) {
        this.customerNumber = customerNumber;
    }

    public String getSortedFieldValue() {
        return sortedFieldValue;
    }

    public void setSortedFieldValue(final String sortedFieldValue) {
        this.sortedFieldValue = sortedFieldValue;
    }

    public BigDecimal getInvoiceAmount() {
        return invoiceAmount;
    }

    public void setInvoiceAmount(final BigDecimal invoiceAmount) {
        this.invoiceAmount = invoiceAmount;
    }

    public BigDecimal getPaymentAmount() {
        return paymentAmount;
    }

    public void setPaymentAmount(final BigDecimal paymentAmount) {
        this.paymentAmount = paymentAmount;
    }

    public BigDecimal getRemainingAmount() {
        return remainingAmount;
    }

    public void setRemainingAmount(final BigDecimal remainingAmount) {
        this.remainingAmount = remainingAmount;
    }

    public Long getAgeInDays() {
        return ageInDays;
    }

    public void setAgeInDays(final Long ageInDays) {
        this.ageInDays = ageInDays;
    }

    public BigDecimal getInvoiceSubTotal() {
        return invoiceSubTotal;
    }

    public void setInvoiceSubTotal(final BigDecimal invoiceSubTotal) {
        this.invoiceSubTotal = invoiceSubTotal;
    }

    public BigDecimal getPaymentSubTotal() {
        return paymentSubTotal;
    }

    public void setPaymentSubTotal(final BigDecimal paymentSubTotal) {
        this.paymentSubTotal = paymentSubTotal;
    }

    public BigDecimal getRemainingSubTotal() {
        return remainingSubTotal;
    }

    public void setRemainingSubTotal(final BigDecimal remainingSubTotal) {
        this.remainingSubTotal = remainingSubTotal;
    }

    public boolean isDisplaySubtotal() {
        return displaySubtotal;
    }

    public void setDisplaySubtotal(final boolean displaySubtotal) {
        this.displaySubtotal = displaySubtotal;
    }

    public String getAgencyName() {
        return agencyName;
    }

    public void setAgencyName(final String agencyName) {
        this.agencyName = agencyName;
    }

    public Date getAwardEndDate() {
        return awardEndDate;
    }

    public void setAwardEndDate(final Date awardEndDate) {
        this.awardEndDate = awardEndDate;
    }

    public boolean isDisplayTotal() {
        return displayTotal;
    }

    public void setDisplayTotal(final boolean displayTotal) {
        this.displayTotal = displayTotal;
    }

    public BigDecimal getInvoiceTotal() {
        return invoiceTotal;
    }

    public void setInvoiceTotal(final BigDecimal invoiceTotal) {
        this.invoiceTotal = invoiceTotal;
    }

    public BigDecimal getPaymentTotal() {
        return paymentTotal;
    }

    public void setPaymentTotal(final BigDecimal paymentTotal) {
        this.paymentTotal = paymentTotal;
    }

    public BigDecimal getRemainingTotal() {
        return remainingTotal;
    }

    public void setRemainingTotal(final BigDecimal remainingTotal) {
        this.remainingTotal = remainingTotal;
    }

    public Date getLastEventDate() {
        return lastEventDate;
    }

    public void setLastEventDate(final Date lastEventDate) {
        this.lastEventDate = lastEventDate;
    }

    public String getCollectorName() {
        return collectorName;
    }

    public void setCollectorName(final String collectorName) {
        this.collectorName = collectorName;
    }

    public String getAgencyNumber() {
        return agencyNumber;
    }

    public void setAgencyNumber(final String agencyNumber) {
        this.agencyNumber = agencyNumber;
    }

}
