/*
 * The Kuali Financial System, a comprehensive financial management system for higher education.
 *
 * Copyright 2005-2023 Kuali, Inc.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
package org.kuali.kfs.module.ar.web.struts;

import org.kuali.kfs.kns.web.struts.form.LookupForm;
import org.kuali.kfs.module.ar.ArConstants;
import org.kuali.kfs.module.ar.businessobject.ContractsGrantsSuspendedInvoiceSummaryReport;
import org.kuali.kfs.krad.bo.BusinessObject;

/**
 * Action class for for the Contracts & Grants Suspended Invoice Summary Report Lookup.
 */
public class ContractsGrantsSuspendedInvoiceSummaryReportLookupAction extends ContractsGrantsReportLookupAction {

    /**
     * This report does not have a title
     */
    @Override
    public String generateReportTitle(final LookupForm lookupForm) {
        return null;
    }

    /**
     * Returns "contractsGrantsSuspendedInvoiceReportBuilderService"
     */
    @Override
    public String getReportBuilderServiceBeanName() {
        return ArConstants.ReportBuilderDataServiceBeanNames.CONTRACTS_GRANTS_SUSPENDED_INVOICE_SUMMARY;
    }

    /**
     * Returns the sort field for this report's pdf generation, "ContractsGrantsSuspendedInvoiceSummaryReport"
     */
    @Override
    protected String getSortFieldName() {
        return ArConstants.CONTRACTS_GRANTS_SUSPENDED_INVOICE_SUMMARY_REPORT;
    }

    /**
     * Returns the class of ContractsGrantsSuspendedInvoiceSummaryReport
     */
    @Override
    public Class<? extends BusinessObject> getPrintSearchCriteriaClass() {
        return ContractsGrantsSuspendedInvoiceSummaryReport.class;
    }
}
