/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.ar;

import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.kuali.kfs.integration.ar.Billable;
import org.kuali.kfs.integration.cg.ContractsAndGrantsBillingAward;
import org.kuali.kfs.module.ar.ArConstants;
import org.kuali.kfs.module.ar.businessobject.InvoiceGeneralDetail;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.jupiter.MockitoExtension;

@ExtendWith(value={MockitoExtension.class})
class BillingFrequencyEnumTest {
    BillingFrequencyEnumTest() {
    }

    @Test
    void milestoneAward(@Mock ContractsAndGrantsBillingAward cgbAwardMock) {
        Mockito.when((Object)cgbAwardMock.getBillingFrequencyCode()).thenReturn((Object)ArConstants.BillingFrequencyValues.MILESTONE.getCode());
        Assertions.assertTrue((boolean)ArConstants.BillingFrequencyValues.isMilestone((Billable)cgbAwardMock), (String)"ArConstants.BillingFrequency.isMilestone should be true of awards with milestone");
        Assertions.assertFalse((boolean)ArConstants.BillingFrequencyValues.isPredeterminedBilling((Billable)cgbAwardMock), (String)"ArConstants.BillingFrequency.isPredeterminedBilling should not be true of awards with milestones");
        Assertions.assertFalse((boolean)ArConstants.BillingFrequencyValues.isLetterOfCredit((Billable)cgbAwardMock), (String)"ArConstants.BillingFrequency.isLetterOfCredit should not be true of awards with milestones");
    }

    @Test
    void predeterminedBillingAward(@Mock ContractsAndGrantsBillingAward cgbAwardMock) {
        Mockito.when((Object)cgbAwardMock.getBillingFrequencyCode()).thenReturn((Object)ArConstants.BillingFrequencyValues.PREDETERMINED_BILLING.getCode());
        Assertions.assertTrue((boolean)ArConstants.BillingFrequencyValues.isPredeterminedBilling((Billable)cgbAwardMock), (String)"ArConstants.BillingFrequency.isPredeterminedBilling should be true of awards with predetermined billing");
        Assertions.assertFalse((boolean)ArConstants.BillingFrequencyValues.isMilestone((Billable)cgbAwardMock), (String)"ArConstants.BillingFrequency.isMilestone should not be true of awards with predetermined billing");
        Assertions.assertFalse((boolean)ArConstants.BillingFrequencyValues.isLetterOfCredit((Billable)cgbAwardMock), (String)"ArConstants.BillingFrequency.isLetterOfCredit should not be true of awards with predetermined billing");
    }

    @Test
    void letterOfCreditAward(@Mock ContractsAndGrantsBillingAward cgbAwardMock) {
        Mockito.when((Object)cgbAwardMock.getBillingFrequencyCode()).thenReturn((Object)ArConstants.BillingFrequencyValues.LETTER_OF_CREDIT.getCode());
        Assertions.assertTrue((boolean)ArConstants.BillingFrequencyValues.isLetterOfCredit((Billable)cgbAwardMock), (String)"ArConstants.BillingFrequency.isLetterOfCredit should be true of awards with letter of credit");
        Assertions.assertFalse((boolean)ArConstants.BillingFrequencyValues.isMilestone((Billable)cgbAwardMock), (String)"ArConstants.BillingFrequency.isMilestone should not be true of awards with letter of credit");
        Assertions.assertFalse((boolean)ArConstants.BillingFrequencyValues.isPredeterminedBilling((Billable)cgbAwardMock), (String)"ArConstants.BillingFrequency.isPredeterminedBilling should not be true of awards with letter of credit");
    }

    @Test
    void milestoneInvoiceGeneralDetail(@Mock InvoiceGeneralDetail invoiceDetailMock) {
        Mockito.when((Object)invoiceDetailMock.getBillingFrequencyCode()).thenReturn((Object)ArConstants.BillingFrequencyValues.MILESTONE.getCode());
        Assertions.assertTrue((boolean)ArConstants.BillingFrequencyValues.isMilestone((Billable)invoiceDetailMock), (String)"ArConstants.BillingFrequency.isMilestone should be true of invoice general details with milestone");
        Assertions.assertFalse((boolean)ArConstants.BillingFrequencyValues.isPredeterminedBilling((Billable)invoiceDetailMock), (String)"ArConstants.BillingFrequency.isPredeterminedBilling should not be true of invoice general details with milestones");
        Assertions.assertFalse((boolean)ArConstants.BillingFrequencyValues.isLetterOfCredit((Billable)invoiceDetailMock), (String)"ArConstants.BillingFrequency.isLetterOfCredit should not be true of invoice general details with milestones");
        Assertions.assertFalse((boolean)ArConstants.BillingFrequencyValues.isTimeBased((Billable)invoiceDetailMock), (String)"ArConstants.BillingFrequency.isTimeBased should not be true of invoice general details with milestones");
    }

    @Test
    void predeterminedBillingInvoiceGeneralDetail(@Mock InvoiceGeneralDetail invoiceDetailMock) {
        Mockito.when((Object)invoiceDetailMock.getBillingFrequencyCode()).thenReturn((Object)ArConstants.BillingFrequencyValues.PREDETERMINED_BILLING.getCode());
        Assertions.assertTrue((boolean)ArConstants.BillingFrequencyValues.isPredeterminedBilling((Billable)invoiceDetailMock), (String)"ArConstants.BillingFrequency.isPredeterminedBilling should be true of invoice general details with predetermined billing");
        Assertions.assertFalse((boolean)ArConstants.BillingFrequencyValues.isMilestone((Billable)invoiceDetailMock), (String)"ArConstants.BillingFrequency.isMilestone should not be true of invoice general details with predetermined billing");
        Assertions.assertFalse((boolean)ArConstants.BillingFrequencyValues.isLetterOfCredit((Billable)invoiceDetailMock), (String)"ArConstants.BillingFrequency.isLetterOfCredit should not be true of invoice general details with predetermined billing");
        Assertions.assertFalse((boolean)ArConstants.BillingFrequencyValues.isTimeBased((Billable)invoiceDetailMock), (String)"ArConstants.BillingFrequency.isTimeBased should not be true of invoice general details with predetermined billing");
    }

    @Test
    void letterOfCreditInvoiceGeneralDetail(@Mock InvoiceGeneralDetail invoiceDetailMock) {
        Mockito.when((Object)invoiceDetailMock.getBillingFrequencyCode()).thenReturn((Object)ArConstants.BillingFrequencyValues.LETTER_OF_CREDIT.getCode());
        Assertions.assertFalse((boolean)ArConstants.BillingFrequencyValues.isPredeterminedBilling((Billable)invoiceDetailMock), (String)"ArConstants.BillingFrequency.isPredeterminedBilling should not be true of invoice general details with letter of credit billing");
        Assertions.assertFalse((boolean)ArConstants.BillingFrequencyValues.isMilestone((Billable)invoiceDetailMock), (String)"ArConstants.BillingFrequency.isMilestone should not be true of invoice general details with letter of credit billing");
        Assertions.assertTrue((boolean)ArConstants.BillingFrequencyValues.isLetterOfCredit((Billable)invoiceDetailMock), (String)"ArConstants.BillingFrequency.isLetterOfCredit should be true of invoice general details with letter of credit billing");
        Assertions.assertFalse((boolean)ArConstants.BillingFrequencyValues.isTimeBased((Billable)invoiceDetailMock), (String)"ArConstants.BillingFrequency.isTimeBased should not be true of invoice general details with letter of credit billing");
    }

    @Test
    void annuallyInvoiceGeneralDetail(@Mock InvoiceGeneralDetail invoiceDetailMock) {
        Mockito.when((Object)invoiceDetailMock.getBillingFrequencyCode()).thenReturn((Object)ArConstants.BillingFrequencyValues.ANNUALLY.getCode());
        Assertions.assertFalse((boolean)ArConstants.BillingFrequencyValues.isPredeterminedBilling((Billable)invoiceDetailMock), (String)"ArConstants.BillingFrequency.isPredeterminedBilling should be not true of invoice general details with annual billing");
        Assertions.assertFalse((boolean)ArConstants.BillingFrequencyValues.isMilestone((Billable)invoiceDetailMock), (String)"ArConstants.BillingFrequency.isMilestone should not be true of invoice general details with annual billing");
        Assertions.assertFalse((boolean)ArConstants.BillingFrequencyValues.isLetterOfCredit((Billable)invoiceDetailMock), (String)"ArConstants.BillingFrequency.isLetterOfCredit should not be true of invoice general details with annual billing");
        Assertions.assertTrue((boolean)ArConstants.BillingFrequencyValues.isTimeBased((Billable)invoiceDetailMock), (String)"ArConstants.BillingFrequency.isTimeBased should be true of invoice general details with annual billing");
    }

    @Test
    void semiAnnuallyInvoiceGeneralDetail(@Mock InvoiceGeneralDetail invoiceDetailMock) {
        Mockito.when((Object)invoiceDetailMock.getBillingFrequencyCode()).thenReturn((Object)ArConstants.BillingFrequencyValues.SEMI_ANNUALLY.getCode());
        Assertions.assertFalse((boolean)ArConstants.BillingFrequencyValues.isPredeterminedBilling((Billable)invoiceDetailMock), (String)"ArConstants.BillingFrequency.isPredeterminedBilling should not be true of invoice general details with semi-annual billing");
        Assertions.assertFalse((boolean)ArConstants.BillingFrequencyValues.isMilestone((Billable)invoiceDetailMock), (String)"ArConstants.BillingFrequency.isMilestone should not be true of invoice general details with semi-annual billing");
        Assertions.assertFalse((boolean)ArConstants.BillingFrequencyValues.isLetterOfCredit((Billable)invoiceDetailMock), (String)"ArConstants.BillingFrequency.isLetterOfCredit should not be true of invoice general details with semi-annual billing");
        Assertions.assertTrue((boolean)ArConstants.BillingFrequencyValues.isTimeBased((Billable)invoiceDetailMock), (String)"ArConstants.BillingFrequency.isTimeBased should be true of invoice general details with semi-annual billing");
    }

    @Test
    void quarterlyInvoiceGeneralDetail(@Mock InvoiceGeneralDetail invoiceDetailMock) {
        Mockito.when((Object)invoiceDetailMock.getBillingFrequencyCode()).thenReturn((Object)ArConstants.BillingFrequencyValues.QUARTERLY.getCode());
        Assertions.assertFalse((boolean)ArConstants.BillingFrequencyValues.isPredeterminedBilling((Billable)invoiceDetailMock), (String)"ArConstants.BillingFrequency.isPredeterminedBilling should not be true of invoice general details with quarterly billing");
        Assertions.assertFalse((boolean)ArConstants.BillingFrequencyValues.isMilestone((Billable)invoiceDetailMock), (String)"ArConstants.BillingFrequency.isMilestone should not be true of invoice general details with quarterly billing");
        Assertions.assertFalse((boolean)ArConstants.BillingFrequencyValues.isLetterOfCredit((Billable)invoiceDetailMock), (String)"ArConstants.BillingFrequency.isLetterOfCredit should not be true of invoice general details with quarterly billing");
        Assertions.assertTrue((boolean)ArConstants.BillingFrequencyValues.isTimeBased((Billable)invoiceDetailMock), (String)"ArConstants.BillingFrequency.isTimeBased should be true of invoice general details with quarterly billing");
    }

    @Test
    void monthlyInvoiceGeneralDetail(@Mock InvoiceGeneralDetail invoiceDetailMock) {
        Mockito.when((Object)invoiceDetailMock.getBillingFrequencyCode()).thenReturn((Object)ArConstants.BillingFrequencyValues.MONTHLY.getCode());
        Assertions.assertFalse((boolean)ArConstants.BillingFrequencyValues.isPredeterminedBilling((Billable)invoiceDetailMock), (String)"ArConstants.BillingFrequency.isPredeterminedBilling should not be true of invoice general details with monthly billing");
        Assertions.assertFalse((boolean)ArConstants.BillingFrequencyValues.isMilestone((Billable)invoiceDetailMock), (String)"ArConstants.BillingFrequency.isMilestone should not be true of invoice general details with monthly billing");
        Assertions.assertFalse((boolean)ArConstants.BillingFrequencyValues.isLetterOfCredit((Billable)invoiceDetailMock), (String)"ArConstants.BillingFrequency.isLetterOfCredit should not be true of invoice general details with monthly billing");
        Assertions.assertTrue((boolean)ArConstants.BillingFrequencyValues.isTimeBased((Billable)invoiceDetailMock), (String)"ArConstants.BillingFrequency.isTimeBased should be true of invoice general details with monthly billing");
    }
}

