/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.ar.batch;

import java.math.BigDecimal;
import java.sql.Date;
import java.time.LocalDate;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.kuali.kfs.coa.service.AccountService;
import org.kuali.kfs.core.api.datetime.DateTimeService;
import org.kuali.kfs.core.api.util.type.AbstractKualiDecimal;
import org.kuali.kfs.core.api.util.type.KualiDecimal;
import org.kuali.kfs.krad.service.BusinessObjectService;
import org.kuali.kfs.krad.service.DocumentService;
import org.kuali.kfs.module.ar.batch.CustomerInvoiceDocumentBatchStep;
import org.kuali.kfs.module.ar.batch.service.LockboxService;
import org.kuali.kfs.module.ar.businessobject.CustomerInvoiceDetail;
import org.kuali.kfs.module.ar.document.CustomerInvoiceDocument;
import org.kuali.kfs.module.ar.document.service.CustomerAddressService;
import org.kuali.kfs.module.ar.document.service.CustomerInvoiceDocumentService;
import org.kuali.kfs.module.ar.document.service.CustomerInvoiceWriteoffDocumentService;
import org.kuali.kfs.sys.context.SpringContext;
import org.mockito.Mock;
import org.mockito.MockedStatic;
import org.mockito.Mockito;
import org.mockito.junit.jupiter.MockitoExtension;
import org.springframework.test.util.ReflectionTestUtils;

@ExtendWith(value={MockitoExtension.class})
class CustomerInvoiceDocumentBatchStepTest {
    private static final String ACCOUNT_NUMBER = "654321";
    private static final String ACCOUNTS_RECEIVABLE_OBJECT_CODE = "8118";
    private static final String CHART_CODE = "BL";
    private static final String DOCUMENT_NUMBER = "123456";
    private static final String FINANCIAL_OBJECT_CODE = "1800";
    private static final String INVOICE_ITEM_CODE = "ABCD";
    private static final KualiDecimal INVOICE_ITEM_TAX_AMOUNT = new KualiDecimal(100);
    private static final KualiDecimal QUANTITY = new KualiDecimal(5);
    private static final BigDecimal UNIT_PRICE = BigDecimal.valueOf(10.5);
    @Mock(stubOnly=true)
    private AccountService accountServiceMock;
    @Mock(stubOnly=true)
    private BusinessObjectService businessObjectServiceMock;
    @Mock(stubOnly=true)
    private CustomerAddressService customerAddressServiceMock;
    @Mock(stubOnly=true)
    private CustomerInvoiceDocumentService customerInvoiceDocumentServiceMock;
    @Mock(stubOnly=true)
    private CustomerInvoiceWriteoffDocumentService writeoffServiceMock;
    @Mock(stubOnly=true)
    private DateTimeService dateTimeSvcMock;
    @Mock
    private DocumentService documentServiceMock;
    @Mock(stubOnly=true)
    private LockboxService lockboxServiceMock;
    private CustomerInvoiceDocumentBatchStep cut;

    CustomerInvoiceDocumentBatchStepTest() {
    }

    @BeforeEach
    void setup() {
        this.cut = new CustomerInvoiceDocumentBatchStep();
        ReflectionTestUtils.setField((Object)this.cut, (String)"customerInvoiceDocumentService", (Object)this.customerInvoiceDocumentServiceMock);
        ReflectionTestUtils.setField((Object)this.cut, (String)"businessObjectService", (Object)this.businessObjectServiceMock);
        ReflectionTestUtils.setField((Object)this.cut, (String)"documentService", (Object)this.documentServiceMock);
        ReflectionTestUtils.setField((Object)this.cut, (String)"dateTimeService", (Object)this.dateTimeSvcMock);
        ReflectionTestUtils.setField((Object)this.cut, (String)"lockboxService", (Object)this.lockboxServiceMock);
        ReflectionTestUtils.setField((Object)this.cut, (String)"customerAddressService", (Object)this.customerAddressServiceMock);
        ReflectionTestUtils.setField((Object)this.cut, (String)"writeoffService", (Object)this.writeoffServiceMock);
    }

    @Test
    void createCustomerInvoiceDetailForFunctionalTesting(@Mock(stubOnly=true) CustomerInvoiceDocument customerInvoiceDocument) {
        Date currentSqlDate = Date.valueOf(LocalDate.now());
        Mockito.when((Object)customerInvoiceDocument.getDocumentNumber()).thenReturn((Object)DOCUMENT_NUMBER);
        Mockito.when((Object)this.dateTimeSvcMock.getCurrentSqlDate()).thenReturn((Object)currentSqlDate);
        try (MockedStatic springContextStaticMock = Mockito.mockStatic(SpringContext.class);){
            springContextStaticMock.when(() -> SpringContext.getBean(AccountService.class)).thenReturn((Object)this.accountServiceMock);
            CustomerInvoiceDetail expected = new CustomerInvoiceDetail();
            expected.setDocumentNumber(DOCUMENT_NUMBER);
            expected.setChartOfAccountsCode(CHART_CODE);
            expected.setAccountNumber(ACCOUNT_NUMBER);
            expected.setFinancialObjectCode(FINANCIAL_OBJECT_CODE);
            expected.setAccountsReceivableObjectCode(ACCOUNTS_RECEIVABLE_OBJECT_CODE);
            expected.setInvoiceItemCode(INVOICE_ITEM_CODE);
            expected.setInvoiceItemServiceDate(currentSqlDate);
            expected.setInvoiceItemUnitPrice(UNIT_PRICE);
            expected.setInvoiceItemQuantity(QUANTITY.bigDecimalValue());
            expected.setInvoiceItemTaxAmount(INVOICE_ITEM_TAX_AMOUNT);
            expected.setTaxableIndicator(true);
            expected.setAmount((KualiDecimal)QUANTITY.multiply((AbstractKualiDecimal)new KualiDecimal(UNIT_PRICE)));
            expected.setPostingYear(Integer.valueOf(LocalDate.now().getYear()));
            CustomerInvoiceDetail actual = this.cut.createCustomerInvoiceDetailForFunctionalTesting(customerInvoiceDocument, QUANTITY, UNIT_PRICE, ACCOUNT_NUMBER, CHART_CODE, INVOICE_ITEM_CODE);
            Assertions.assertEquals((Object)actual, (Object)expected);
        }
    }
}

