/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.ar.batch;

import java.io.InputStream;
import java.net.URL;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.kuali.kfs.module.ar.batch.CustomerInvoiceWriteoffBatchInputFileType;
import org.kuali.kfs.module.ar.batch.vo.CustomerInvoiceWriteoffBatchVO;
import org.kuali.kfs.sys.batch.BatchInputFileType;
import org.kuali.kfs.sys.batch.service.impl.BatchInputFileServiceImpl;
import org.mockito.Mockito;
import org.mockito.Spy;
import org.mockito.junit.jupiter.MockitoExtension;

@ExtendWith(value={MockitoExtension.class})
class CustomerInvoiceWriteoffBatchInputFileTypeTest {
    private static final String XML_SAMPLE_FILE = "org/kuali/kfs/module/ar/batch/sample/CustomerInvoiceWriteoffBatch-Sample-Good.xml";
    private static final String SCHEMA_FILE = "org/kuali/kfs/module/ar/batch/customerInvoiceWriteoffBatch.xsd";
    @Spy
    private CustomerInvoiceWriteoffBatchInputFileType cut;

    CustomerInvoiceWriteoffBatchInputFileTypeTest() {
    }

    @Test
    void customerInvoiceWriteoffBatchParse() throws Exception {
        BatchInputFileServiceImpl batchInputFileService = new BatchInputFileServiceImpl();
        this.cut.setOutputClass(CustomerInvoiceWriteoffBatchVO.class);
        this.cut.setSchemaLocation(SCHEMA_FILE);
        URL schemaUrl = this.getClass().getClassLoader().getResource(SCHEMA_FILE);
        SchemaFactory schemaFactory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
        Schema schema = schemaFactory.newSchema(schemaUrl);
        ((CustomerInvoiceWriteoffBatchInputFileType)Mockito.doReturn((Object)schema).when((Object)this.cut)).getSchema(SCHEMA_FILE);
        InputStream sampleFileStream = ClassLoader.getSystemResourceAsStream(XML_SAMPLE_FILE);
        byte[] fileByteContent = IOUtils.toByteArray((InputStream)sampleFileStream);
        CustomerInvoiceWriteoffBatchVO parsedBatchVO = (CustomerInvoiceWriteoffBatchVO)batchInputFileService.parse((BatchInputFileType)this.cut, fileByteContent);
        Assertions.assertTrue((boolean)StringUtils.isNotBlank((CharSequence)parsedBatchVO.getSubmittedByPrincipalName()), (String)"SubmittedBy PersonUserID should not be blank.");
        Assertions.assertTrue((boolean)StringUtils.isNotBlank((CharSequence)parsedBatchVO.getSubmittedOn()), (String)"SubmittedOn should not be blank.");
        Assertions.assertNotNull((Object)parsedBatchVO.getInvoiceNumbers(), (String)"InvoiceNumbers should not be null.");
        Assertions.assertFalse((boolean)parsedBatchVO.getInvoiceNumbers().isEmpty(), (String)"InvoiceNumbers should not be empty.");
        Assertions.assertEquals((int)3, (int)parsedBatchVO.getInvoiceNumbers().size(), (String)"InvoiceNumbers should have 3 elements in the set.");
    }
}

