/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.ar.batch;

import java.io.InputStream;
import java.util.List;
import org.apache.commons.io.IOUtils;
import org.kuali.kfs.module.ar.batch.CustomerLoadCSVInputFileType;
import org.kuali.kfs.sys.ConfigureContext;
import org.kuali.kfs.sys.context.KualiIntegTestBase;
import org.kuali.kfs.sys.context.SpringContext;
import org.kuali.kfs.sys.fixture.UserNameFixture;

@ConfigureContext(session=UserNameFixture.khuntley)
public class CustomerLoadCSVInputFileTypeIntegTest
extends KualiIntegTestBase {
    private static final String CSV_SAMPLE_DIRECTORY = "org/kuali/kfs/module/ar/batch/sample/";
    private static final String CSV_TEST_FILE = "CustomerLoad_Test.csv";
    CustomerLoadCSVInputFileType batchInput;
    byte[] byteArraybyteArray;

    public void setUp() throws Exception {
        this.batchInput = (CustomerLoadCSVInputFileType)SpringContext.getBean(CustomerLoadCSVInputFileType.class);
        InputStream inputStream = ((Object)((Object)this)).getClass().getClassLoader().getResourceAsStream("org/kuali/kfs/module/ar/batch/sample/CustomerLoad_Test.csv");
        this.byteArraybyteArray = IOUtils.toByteArray((InputStream)inputStream);
    }

    public void testContentParsing() {
        Object parsedContent = this.batchInput.parse(this.byteArraybyteArray);
        CustomerLoadCSVInputFileTypeIntegTest.assertNotNull((Object)parsedContent);
    }

    public void testObjectVOConversion() {
        List customerVOs = (List)this.batchInput.parse(this.byteArraybyteArray);
        int customerSize = 7;
        CustomerLoadCSVInputFileTypeIntegTest.assertFalse((String)"Parse customer should  not be empty.", (boolean)customerVOs.isEmpty());
        CustomerLoadCSVInputFileTypeIntegTest.assertEquals((String)"The parsed VO size does not match expected", (int)customerVOs.size(), (int)7);
    }

    public void testValidation() {
        List customerVOs = (List)this.batchInput.parse(this.byteArraybyteArray);
        boolean result = this.batchInput.validate((Object)customerVOs);
        CustomerLoadCSVInputFileTypeIntegTest.assertTrue((String)"The Validation should have produced no error messages.", (boolean)result);
    }
}

