/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.ar.batch;

import java.io.InputStream;
import java.util.List;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.kuali.kfs.core.api.datetime.DateTimeService;
import org.kuali.kfs.core.api.resourceloader.GlobalResourceLoader;
import org.kuali.kfs.core.impl.datetime.DateTimeServiceImpl;
import org.kuali.kfs.krad.util.GlobalVariables;
import org.kuali.kfs.module.ar.batch.CustomerLoadInputFileType;
import org.kuali.kfs.module.ar.batch.vo.CustomerAddressVO;
import org.kuali.kfs.module.ar.batch.vo.CustomerVO;
import org.kuali.kfs.module.ar.batch.vo.CustomersVO;
import org.kuali.kfs.sys.context.SpringContext;
import org.mockito.Mock;
import org.mockito.MockedStatic;
import org.mockito.Mockito;
import org.mockito.junit.jupiter.MockitoExtension;
import org.springframework.core.io.ClassPathResource;

@ExtendWith(value={MockitoExtension.class})
class CustomerLoadInputFileTypeTest {
    private static final String XML_SAMPLE_FILE = "org/kuali/kfs/module/ar/batch/sample/CustomerLoad-all-the-fields.xml";
    private static final String CUSTOMER_XSD_PATH = "classpath:org/kuali/kfs/module/ar/batch/customer.xsd";
    private static final String CLASSPATH_URL_PREFIX = "classpath:";
    @Mock(stubOnly=true)
    private CustomerVO mockCustomerVO;
    @Mock(stubOnly=true)
    private CustomerAddressVO mockedAddressVO1;
    @Mock(stubOnly=true)
    private CustomerAddressVO mockedAddressVO2;
    @Mock(stubOnly=true)
    private DateTimeServiceImpl mockDateTimeServiceImpl;
    private CustomerLoadInputFileType cut;

    CustomerLoadInputFileTypeTest() {
    }

    @BeforeEach
    void setUp() {
        GlobalVariables.clear();
        this.cut = new CustomerLoadInputFileType();
        this.cut.setSchemaLocation(CUSTOMER_XSD_PATH);
        this.cut.setOutputClass(CustomersVO.class);
    }

    @AfterEach
    void tearDown() {
        GlobalVariables.clear();
    }

    @Test
    void parse_ShouldUnmarshallToIdenticalCustomerDigesterVO() throws Exception {
        try (MockedStatic globalResourceLoaderMockedStatic = Mockito.mockStatic(GlobalResourceLoader.class);
             MockedStatic springContextMockedStatic = Mockito.mockStatic(SpringContext.class);
             InputStream inputStream = this.getClass().getClassLoader().getResourceAsStream(XML_SAMPLE_FILE);){
            assert (inputStream != null);
            byte[] xmlBytes = inputStream.readAllBytes();
            ClassPathResource resource = new ClassPathResource(CUSTOMER_XSD_PATH.substring(CLASSPATH_URL_PREFIX.length()), this.getClass().getClassLoader());
            springContextMockedStatic.when(() -> SpringContext.getBean(DateTimeService.class)).thenReturn((Object)this.mockDateTimeServiceImpl);
            globalResourceLoaderMockedStatic.when(() -> GlobalResourceLoader.getResource((String)CUSTOMER_XSD_PATH)).thenReturn((Object)resource);
            this.mockTheCustomer();
            List customersVOList = ((CustomersVO)this.cut.parse(xmlBytes)).getCustomerVOs();
            Assertions.assertNotNull((Object)customersVOList);
            Assertions.assertEquals((int)1, (int)customersVOList.size());
            CustomerVO parsedCustomerVO = (CustomerVO)customersVOList.get(0);
            List customerAddressVOList = parsedCustomerVO.getCustomerAddresses();
            Assertions.assertEquals((int)2, (int)customerAddressVOList.size());
            CustomerAddressVO addressVO1 = (CustomerAddressVO)customerAddressVOList.get(0);
            CustomerAddressVO addressVO2 = (CustomerAddressVO)customerAddressVOList.get(1);
            Assertions.assertEquals((Object)this.mockCustomerVO.getCustomerName(), (Object)parsedCustomerVO.getCustomerName());
            Assertions.assertEquals((Object)this.mockCustomerVO.getCustomerParentCompanyNumber(), (Object)parsedCustomerVO.getCustomerParentCompanyNumber());
            Assertions.assertEquals((Object)this.mockCustomerVO.getCustomerTypeCode(), (Object)parsedCustomerVO.getCustomerTypeCode());
            Assertions.assertEquals((Object)this.mockCustomerVO.getCustomerLastActivityDate(), (Object)parsedCustomerVO.getCustomerLastActivityDate());
            Assertions.assertEquals((Object)this.mockCustomerVO.getCustomerTaxTypeCode(), (Object)parsedCustomerVO.getCustomerTaxTypeCode());
            Assertions.assertEquals((Object)this.mockCustomerVO.getCustomerTaxNbr(), (Object)parsedCustomerVO.getCustomerTaxNbr());
            Assertions.assertEquals((Object)this.mockCustomerVO.getCustomerActiveIndicator(), (Object)parsedCustomerVO.getCustomerActiveIndicator());
            Assertions.assertEquals((Object)this.mockCustomerVO.getCustomerPhoneNumber(), (Object)parsedCustomerVO.getCustomerPhoneNumber());
            Assertions.assertEquals((Object)this.mockCustomerVO.getCustomer800PhoneNumber(), (Object)parsedCustomerVO.getCustomer800PhoneNumber());
            Assertions.assertEquals((Object)this.mockCustomerVO.getCustomerContactName(), (Object)parsedCustomerVO.getCustomerContactName());
            Assertions.assertEquals((Object)this.mockCustomerVO.getCustomerContactPhoneNumber(), (Object)parsedCustomerVO.getCustomerContactPhoneNumber());
            Assertions.assertEquals((Object)this.mockCustomerVO.getCustomerFaxNumber(), (Object)parsedCustomerVO.getCustomerFaxNumber());
            Assertions.assertEquals((Object)this.mockCustomerVO.getCustomerBirthDate(), (Object)parsedCustomerVO.getCustomerBirthDate());
            Assertions.assertEquals((Object)this.mockCustomerVO.getCustomerTaxExemptIndicator(), (Object)parsedCustomerVO.getCustomerTaxExemptIndicator());
            Assertions.assertEquals((Object)this.mockCustomerVO.getCustomerCreditLimitAmount(), (Object)parsedCustomerVO.getCustomerCreditLimitAmount());
            Assertions.assertEquals((Object)this.mockCustomerVO.getCustomerCreditApprovedByName(), (Object)parsedCustomerVO.getCustomerCreditApprovedByName());
            Assertions.assertEquals((Object)this.mockCustomerVO.getCustomerEmailAddress(), (Object)parsedCustomerVO.getCustomerEmailAddress());
            Assertions.assertEquals((Object)this.mockedAddressVO1.getCustomerAddressName(), (Object)addressVO1.getCustomerAddressName());
            Assertions.assertEquals((Object)this.mockedAddressVO1.getCustomerLine1StreetAddress(), (Object)addressVO1.getCustomerLine1StreetAddress());
            Assertions.assertEquals((Object)this.mockedAddressVO1.getCustomerLine2StreetAddress(), (Object)addressVO1.getCustomerLine2StreetAddress());
            Assertions.assertEquals((Object)this.mockedAddressVO1.getCustomerCityName(), (Object)addressVO1.getCustomerCityName());
            Assertions.assertEquals((Object)this.mockedAddressVO1.getCustomerStateCode(), (Object)addressVO1.getCustomerStateCode());
            Assertions.assertEquals((Object)this.mockedAddressVO1.getCustomerZipCode(), (Object)addressVO1.getCustomerZipCode());
            Assertions.assertEquals((Object)this.mockedAddressVO1.getCustomerCountryCode(), (Object)addressVO1.getCustomerCountryCode());
            Assertions.assertEquals((Object)this.mockedAddressVO1.getCustomerEmailAddress(), (Object)addressVO1.getCustomerEmailAddress());
            Assertions.assertEquals((Object)this.mockedAddressVO1.getCustomerAddressTypeCode(), (Object)addressVO1.getCustomerAddressTypeCode());
            Assertions.assertEquals((Object)this.mockedAddressVO2.getCustomerAddressName(), (Object)addressVO2.getCustomerAddressName());
            Assertions.assertEquals((Object)this.mockedAddressVO2.getCustomerLine1StreetAddress(), (Object)addressVO2.getCustomerLine1StreetAddress());
            Assertions.assertEquals((Object)this.mockedAddressVO2.getCustomerLine2StreetAddress(), (Object)addressVO2.getCustomerLine2StreetAddress());
            Assertions.assertEquals((Object)this.mockedAddressVO2.getCustomerCityName(), (Object)addressVO2.getCustomerCityName());
            Assertions.assertEquals((Object)this.mockedAddressVO2.getCustomerStateCode(), (Object)addressVO2.getCustomerStateCode());
            Assertions.assertEquals((Object)this.mockedAddressVO2.getCustomerZipCode(), (Object)addressVO2.getCustomerZipCode());
            Assertions.assertEquals((Object)this.mockedAddressVO2.getCustomerCountryCode(), (Object)addressVO2.getCustomerCountryCode());
            Assertions.assertEquals((Object)this.mockedAddressVO2.getCustomerAddressInternationalProvinceName(), (Object)addressVO2.getCustomerAddressInternationalProvinceName());
            Assertions.assertEquals((Object)this.mockedAddressVO2.getCustomerInternationalMailCode(), (Object)addressVO2.getCustomerInternationalMailCode());
            Assertions.assertEquals((Object)this.mockedAddressVO2.getCustomerEmailAddress(), (Object)addressVO2.getCustomerEmailAddress());
            Assertions.assertEquals((Object)this.mockedAddressVO2.getCustomerAddressTypeCode(), (Object)addressVO2.getCustomerAddressTypeCode());
        }
    }

    private void mockTheCustomer() {
        Mockito.when((Object)this.mockCustomerVO.getCustomerName()).thenReturn((Object)"John's Plumbing");
        Mockito.when((Object)this.mockCustomerVO.getCustomerParentCompanyNumber()).thenReturn((Object)"ABB2");
        Mockito.when((Object)this.mockCustomerVO.getCustomerTypeCode()).thenReturn((Object)"08");
        Mockito.when((Object)this.mockCustomerVO.getCustomerLastActivityDate()).thenReturn((Object)"2009-03-09");
        Mockito.when((Object)this.mockCustomerVO.getCustomerTaxTypeCode()).thenReturn((Object)"SSN");
        Mockito.when((Object)this.mockCustomerVO.getCustomerTaxNbr()).thenReturn((Object)"019456789");
        Mockito.when((Object)this.mockCustomerVO.getCustomerActiveIndicator()).thenReturn((Object)"Y");
        Mockito.when((Object)this.mockCustomerVO.getCustomerPhoneNumber()).thenReturn((Object)"530-752-5873");
        Mockito.when((Object)this.mockCustomerVO.getCustomer800PhoneNumber()).thenReturn((Object)"800-789-1234");
        Mockito.when((Object)this.mockCustomerVO.getCustomerContactName()).thenReturn((Object)"Sally Smith");
        Mockito.when((Object)this.mockCustomerVO.getCustomerContactPhoneNumber()).thenReturn((Object)"532-784-8748");
        Mockito.when((Object)this.mockCustomerVO.getCustomerFaxNumber()).thenReturn(null);
        Mockito.when((Object)this.mockCustomerVO.getCustomerBirthDate()).thenReturn((Object)"1964-05-02");
        Mockito.when((Object)this.mockCustomerVO.getCustomerTaxExemptIndicator()).thenReturn((Object)"N");
        Mockito.when((Object)this.mockCustomerVO.getCustomerCreditLimitAmount()).thenReturn((Object)"50000");
        Mockito.when((Object)this.mockCustomerVO.getCustomerCreditApprovedByName()).thenReturn((Object)"KHUNTLEY");
        Mockito.when((Object)this.mockCustomerVO.getCustomerEmailAddress()).thenReturn((Object)"Johnsplumbing@gmail.com");
        this.mockTheAddresses();
    }

    private void mockTheAddresses() {
        Mockito.when((Object)this.mockedAddressVO1.getCustomerAddressName()).thenReturn((Object)"Office");
        Mockito.when((Object)this.mockedAddressVO1.getCustomerLine1StreetAddress()).thenReturn((Object)"1 Shields Ave");
        Mockito.when((Object)this.mockedAddressVO1.getCustomerLine2StreetAddress()).thenReturn((Object)"2112 Dutton Hall");
        Mockito.when((Object)this.mockedAddressVO1.getCustomerCityName()).thenReturn((Object)"Davis");
        Mockito.when((Object)this.mockedAddressVO1.getCustomerStateCode()).thenReturn((Object)"CA");
        Mockito.when((Object)this.mockedAddressVO1.getCustomerZipCode()).thenReturn((Object)"95616");
        Mockito.when((Object)this.mockedAddressVO1.getCustomerCountryCode()).thenReturn((Object)"US");
        Mockito.when((Object)this.mockedAddressVO1.getCustomerEmailAddress()).thenReturn((Object)"Johnsplumbing@gmail.com");
        Mockito.when((Object)this.mockedAddressVO1.getCustomerAddressTypeCode()).thenReturn((Object)"P");
        Mockito.when((Object)this.mockedAddressVO2.getCustomerAddressName()).thenReturn((Object)"Foreign");
        Mockito.when((Object)this.mockedAddressVO2.getCustomerLine1StreetAddress()).thenReturn((Object)"PO Box 989602");
        Mockito.when((Object)this.mockedAddressVO2.getCustomerLine2StreetAddress()).thenReturn((Object)"");
        Mockito.when((Object)this.mockedAddressVO2.getCustomerCityName()).thenReturn((Object)"West Sacramento");
        Mockito.when((Object)this.mockedAddressVO2.getCustomerStateCode()).thenReturn((Object)"");
        Mockito.when((Object)this.mockedAddressVO2.getCustomerZipCode()).thenReturn((Object)"");
        Mockito.when((Object)this.mockedAddressVO2.getCustomerCountryCode()).thenReturn((Object)"CA");
        Mockito.when((Object)this.mockedAddressVO2.getCustomerAddressInternationalProvinceName()).thenReturn((Object)"Quebec");
        Mockito.when((Object)this.mockedAddressVO2.getCustomerInternationalMailCode()).thenReturn((Object)"123456");
        Mockito.when((Object)this.mockedAddressVO2.getCustomerEmailAddress()).thenReturn((Object)"john@gmail.com");
        Mockito.when((Object)this.mockedAddressVO2.getCustomerAddressTypeCode()).thenReturn((Object)"A");
    }
}

