/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.ar.batch.service.impl;

import java.sql.Date;
import java.time.Clock;
import java.time.Instant;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Map;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.kuali.kfs.kim.api.identity.PersonService;
import org.kuali.kfs.kim.api.services.KimApiServiceLocator;
import org.kuali.kfs.kim.impl.identity.Person;
import org.kuali.kfs.kns.document.MaintenanceDocument;
import org.kuali.kfs.kns.maintenance.Maintainable;
import org.kuali.kfs.krad.UserSession;
import org.kuali.kfs.krad.document.Document;
import org.kuali.kfs.krad.service.BusinessObjectService;
import org.kuali.kfs.krad.service.DocumentService;
import org.kuali.kfs.krad.util.GlobalVariables;
import org.kuali.kfs.module.ar.batch.service.impl.InvoiceRecurrenceServiceImpl;
import org.kuali.kfs.module.ar.businessobject.InvoiceRecurrence;
import org.kuali.kfs.module.ar.document.CustomerInvoiceDocument;
import org.kuali.kfs.sys.businessobject.DocumentHeader;
import org.mockito.ArgumentMatchers;
import org.mockito.Mock;
import org.mockito.MockedStatic;
import org.mockito.Mockito;
import org.mockito.Spy;
import org.mockito.junit.jupiter.MockitoExtension;
import org.mockito.verification.VerificationMode;
import org.springframework.test.util.ReflectionTestUtils;

@ExtendWith(value={MockitoExtension.class})
class InvoiceRecurrenceServiceImplTest {
    private static final String DEFAULT_USER = "khuntley";
    private static final String INVOICE_NUMBER = "InvoiceNumber 12345";
    @Mock(stubOnly=true)
    private BusinessObjectService boServiceMock;
    @Mock(stubOnly=true)
    private CustomerInvoiceDocument customerInvoiceDocumentMock;
    @Mock(stubOnly=true)
    private DocumentHeader documentHeaderMock;
    @Mock
    private DocumentService documentServiceMock;
    @Mock(stubOnly=true)
    private Maintainable newMaintainableMock;
    @Mock(stubOnly=true)
    private Maintainable oldMaintainableMock;
    @Mock(stubOnly=true)
    private MaintenanceDocument maintenanceDocumentMock;
    @Mock(stubOnly=true)
    private Person personMock;
    @Mock(stubOnly=true)
    private PersonService personServiceMock;
    @Mock(stubOnly=true)
    private UserSession userSessionMock;
    @Spy
    private Clock clockSpy;
    private InvoiceRecurrenceServiceImpl cut;

    InvoiceRecurrenceServiceImplTest() {
    }

    @BeforeEach
    void setup() {
        this.cut = new InvoiceRecurrenceServiceImpl();
        ReflectionTestUtils.setField((Object)this.cut, (String)"documentService", (Object)this.documentServiceMock);
        ReflectionTestUtils.setField((Object)this.cut, (String)"boService", (Object)this.boServiceMock);
    }

    @Test
    void processInvoiceRecurrence_beginSept1_endJan1_lastCreateSept15_currentOct1() {
        Instant currentDate = Instant.parse("2022-10-01T00:00:00Z");
        Mockito.when((Object)this.clockSpy.instant()).thenReturn((Object)currentDate);
        Mockito.when((Object)this.clockSpy.getZone()).thenReturn((Object)ZoneId.of("Z"));
        Date beginDate = Date.valueOf("2022-09-01");
        Date endDate = Date.valueOf("2023-01-01");
        Date lastCreateDate = Date.valueOf("2022-09-15");
        ArrayList<InvoiceRecurrence> invoiceRecurrences = new ArrayList<InvoiceRecurrence>();
        invoiceRecurrences.add(InvoiceRecurrenceServiceImplTest.generateInvoiceRecurrence(beginDate, endDate, lastCreateDate, true));
        ((DocumentService)Mockito.doReturn((Object)this.customerInvoiceDocumentMock).when((Object)this.documentServiceMock)).getByDocumentHeaderId(INVOICE_NUMBER);
        ((BusinessObjectService)Mockito.doReturn(invoiceRecurrences).when((Object)this.boServiceMock)).findMatchingOrderBy(InvoiceRecurrence.class, Map.of("active", Boolean.TRUE), "invoiceNumber", true);
        ((PersonService)Mockito.doReturn((Object)this.personMock).when((Object)this.personServiceMock)).getPersonByPrincipalName(DEFAULT_USER);
        try (MockedStatic globalVariablesMockedStatic = Mockito.mockStatic(GlobalVariables.class);
             MockedStatic kimApiServiceLocatorMockedStatic = Mockito.mockStatic(KimApiServiceLocator.class);
             MockedStatic clockMockedStatic = Mockito.mockStatic(Clock.class);){
            kimApiServiceLocatorMockedStatic.when(KimApiServiceLocator::getPersonService).thenReturn((Object)this.personServiceMock);
            globalVariablesMockedStatic.when(GlobalVariables::getUserSession).thenReturn((Object)this.userSessionMock);
            clockMockedStatic.when(Clock::systemDefaultZone).thenReturn((Object)this.clockSpy);
            boolean expected = this.cut.processInvoiceRecurrence();
            Assertions.assertTrue((boolean)expected);
            ((DocumentService)Mockito.verify((Object)this.documentServiceMock)).routeDocument((Document)ArgumentMatchers.eq((Object)this.customerInvoiceDocumentMock), ArgumentMatchers.anyString(), ArgumentMatchers.anyList());
        }
    }

    @Test
    void processInvoiceRecurrence_beginSept1_endJan1_lastCreateSept15_currentOct18() {
        Instant currentDate = Instant.parse("2022-10-18T00:00:00Z");
        Mockito.when((Object)this.clockSpy.instant()).thenReturn((Object)currentDate);
        Mockito.when((Object)this.clockSpy.getZone()).thenReturn((Object)ZoneId.of("Z"));
        Date beginDate = Date.valueOf("2022-09-01");
        Date endDate = Date.valueOf("2023-01-01");
        Date lastCreateDate = Date.valueOf("2022-09-15");
        ArrayList<InvoiceRecurrence> invoiceRecurrences = new ArrayList<InvoiceRecurrence>();
        invoiceRecurrences.add(InvoiceRecurrenceServiceImplTest.generateInvoiceRecurrence(beginDate, endDate, lastCreateDate, true));
        ((DocumentService)Mockito.doReturn((Object)this.customerInvoiceDocumentMock).when((Object)this.documentServiceMock)).getByDocumentHeaderId(INVOICE_NUMBER);
        ((BusinessObjectService)Mockito.doReturn(invoiceRecurrences).when((Object)this.boServiceMock)).findMatchingOrderBy(InvoiceRecurrence.class, Map.of("active", Boolean.TRUE), "invoiceNumber", true);
        ((PersonService)Mockito.doReturn((Object)this.personMock).when((Object)this.personServiceMock)).getPersonByPrincipalName(DEFAULT_USER);
        try (MockedStatic globalVariablesMockedStatic = Mockito.mockStatic(GlobalVariables.class);
             MockedStatic kimApiServiceLocatorMockedStatic = Mockito.mockStatic(KimApiServiceLocator.class);
             MockedStatic clockMockedStatic = Mockito.mockStatic(Clock.class);){
            kimApiServiceLocatorMockedStatic.when(KimApiServiceLocator::getPersonService).thenReturn((Object)this.personServiceMock);
            globalVariablesMockedStatic.when(GlobalVariables::getUserSession).thenReturn((Object)this.userSessionMock);
            clockMockedStatic.when(Clock::systemDefaultZone).thenReturn((Object)this.clockSpy);
            boolean expected = this.cut.processInvoiceRecurrence();
            Assertions.assertTrue((boolean)expected);
            ((DocumentService)Mockito.verify((Object)this.documentServiceMock)).routeDocument((Document)ArgumentMatchers.eq((Object)this.customerInvoiceDocumentMock), ArgumentMatchers.anyString(), ArgumentMatchers.anyList());
        }
    }

    @Test
    void processInvoiceRecurrence_beginSept1_endOct1_lastCreateSept15_currentOct18() {
        Instant currentDate = Instant.parse("2022-10-18T00:00:00Z");
        Mockito.when((Object)this.clockSpy.instant()).thenReturn((Object)currentDate);
        Mockito.when((Object)this.clockSpy.getZone()).thenReturn((Object)ZoneId.of("Z"));
        Date beginDate = Date.valueOf("2022-09-01");
        Date endDate = Date.valueOf("2022-10-01");
        Date lastCreateDate = Date.valueOf("2022-09-15");
        ArrayList<InvoiceRecurrence> invoiceRecurrences = new ArrayList<InvoiceRecurrence>();
        invoiceRecurrences.add(InvoiceRecurrenceServiceImplTest.generateInvoiceRecurrence(beginDate, endDate, lastCreateDate, true));
        ((BusinessObjectService)Mockito.doReturn(invoiceRecurrences).when((Object)this.boServiceMock)).findMatchingOrderBy(InvoiceRecurrence.class, Map.of("active", Boolean.TRUE), "invoiceNumber", true);
        ((PersonService)Mockito.doReturn((Object)this.personMock).when((Object)this.personServiceMock)).getPersonByPrincipalName(DEFAULT_USER);
        ((MaintenanceDocument)Mockito.doReturn((Object)this.oldMaintainableMock).when((Object)this.maintenanceDocumentMock)).getOldMaintainableObject();
        ((MaintenanceDocument)Mockito.doReturn((Object)this.newMaintainableMock).when((Object)this.maintenanceDocumentMock)).getNewMaintainableObject();
        ((MaintenanceDocument)Mockito.doReturn((Object)this.documentHeaderMock).when((Object)this.maintenanceDocumentMock)).getDocumentHeader();
        ((DocumentService)Mockito.doReturn((Object)this.maintenanceDocumentMock).when((Object)this.documentServiceMock)).getNewDocument(ArgumentMatchers.anyString());
        try (MockedStatic globalVariablesMockedStatic = Mockito.mockStatic(GlobalVariables.class);
             MockedStatic kimApiServiceLocatorMockedStatic = Mockito.mockStatic(KimApiServiceLocator.class);
             MockedStatic clockMockedStatic = Mockito.mockStatic(Clock.class);){
            kimApiServiceLocatorMockedStatic.when(KimApiServiceLocator::getPersonService).thenReturn((Object)this.personServiceMock);
            globalVariablesMockedStatic.when(GlobalVariables::getUserSession).thenReturn((Object)this.userSessionMock);
            clockMockedStatic.when(Clock::systemDefaultZone).thenReturn((Object)this.clockSpy);
            boolean expected = this.cut.processInvoiceRecurrence();
            Assertions.assertTrue((boolean)expected);
            ((DocumentService)Mockito.verify((Object)this.documentServiceMock)).routeDocument((Document)ArgumentMatchers.eq((Object)this.maintenanceDocumentMock), (String)ArgumentMatchers.eq(null), ArgumentMatchers.anyList());
        }
    }

    @Test
    void processInvoiceRecurrence_beginSept1_endJan1_lastCreateNull_currentOct18() {
        Instant currentDate = Instant.parse("2022-10-18T00:00:00Z");
        Mockito.when((Object)this.clockSpy.instant()).thenReturn((Object)currentDate);
        Mockito.when((Object)this.clockSpy.getZone()).thenReturn((Object)ZoneId.of("Z"));
        Date beginDate = Date.valueOf("2022-09-01");
        Date endDate = Date.valueOf("2023-01-01");
        ArrayList<InvoiceRecurrence> invoiceRecurrences = new ArrayList<InvoiceRecurrence>();
        invoiceRecurrences.add(InvoiceRecurrenceServiceImplTest.generateInvoiceRecurrence(beginDate, endDate, null, true));
        ((DocumentService)Mockito.doReturn((Object)this.customerInvoiceDocumentMock).when((Object)this.documentServiceMock)).getByDocumentHeaderId(INVOICE_NUMBER);
        ((BusinessObjectService)Mockito.doReturn(invoiceRecurrences).when((Object)this.boServiceMock)).findMatchingOrderBy(InvoiceRecurrence.class, Map.of("active", Boolean.TRUE), "invoiceNumber", true);
        ((PersonService)Mockito.doReturn((Object)this.personMock).when((Object)this.personServiceMock)).getPersonByPrincipalName(DEFAULT_USER);
        try (MockedStatic globalVariablesMockedStatic = Mockito.mockStatic(GlobalVariables.class);
             MockedStatic kimApiServiceLocatorMockedStatic = Mockito.mockStatic(KimApiServiceLocator.class);
             MockedStatic clockMockedStatic = Mockito.mockStatic(Clock.class);){
            kimApiServiceLocatorMockedStatic.when(KimApiServiceLocator::getPersonService).thenReturn((Object)this.personServiceMock);
            globalVariablesMockedStatic.when(GlobalVariables::getUserSession).thenReturn((Object)this.userSessionMock);
            clockMockedStatic.when(Clock::systemDefaultZone).thenReturn((Object)this.clockSpy);
            boolean expected = this.cut.processInvoiceRecurrence();
            Assertions.assertTrue((boolean)expected);
            ((DocumentService)Mockito.verify((Object)this.documentServiceMock)).routeDocument((Document)ArgumentMatchers.eq((Object)this.customerInvoiceDocumentMock), ArgumentMatchers.anyString(), ArgumentMatchers.anyList());
        }
    }

    @Test
    void processInvoiceRecurrence_beginSept1_endJan1_lastCreateOct1_currentOct18() {
        Instant currentDate = Instant.parse("2022-10-18T00:00:00Z");
        Mockito.when((Object)this.clockSpy.instant()).thenReturn((Object)currentDate);
        Mockito.when((Object)this.clockSpy.getZone()).thenReturn((Object)ZoneId.of("Z"));
        Date beginDate = Date.valueOf("2022-09-01");
        Date endDate = Date.valueOf("2023-01-01");
        Date lastCreateDate = Date.valueOf("2022-10-01");
        ArrayList<InvoiceRecurrence> invoiceRecurrences = new ArrayList<InvoiceRecurrence>();
        invoiceRecurrences.add(InvoiceRecurrenceServiceImplTest.generateInvoiceRecurrence(beginDate, endDate, lastCreateDate, false));
        ((BusinessObjectService)Mockito.doReturn(invoiceRecurrences).when((Object)this.boServiceMock)).findMatchingOrderBy(InvoiceRecurrence.class, Map.of("active", Boolean.TRUE), "invoiceNumber", true);
        try (MockedStatic globalVariablesMockedStatic = Mockito.mockStatic(GlobalVariables.class);
             MockedStatic kimApiServiceLocatorMockedStatic = Mockito.mockStatic(KimApiServiceLocator.class);
             MockedStatic clockMockedStatic = Mockito.mockStatic(Clock.class);){
            kimApiServiceLocatorMockedStatic.when(KimApiServiceLocator::getPersonService).thenReturn((Object)this.personServiceMock);
            globalVariablesMockedStatic.when(GlobalVariables::getUserSession).thenReturn((Object)this.userSessionMock);
            clockMockedStatic.when(Clock::systemDefaultZone).thenReturn((Object)this.clockSpy);
            boolean expected = this.cut.processInvoiceRecurrence();
            Assertions.assertTrue((boolean)expected);
            ((DocumentService)Mockito.verify((Object)this.documentServiceMock, (VerificationMode)Mockito.never())).routeDocument((Document)ArgumentMatchers.any(CustomerInvoiceDocument.class), ArgumentMatchers.anyString(), ArgumentMatchers.anyList());
        }
    }

    @Test
    void processInvoiceRecurrence_beginNov1_endJan1_lastCreateNull_currentOct18() {
        Instant currentDate = Instant.parse("2022-10-18T00:00:00Z");
        Mockito.when((Object)this.clockSpy.instant()).thenReturn((Object)currentDate);
        Mockito.when((Object)this.clockSpy.getZone()).thenReturn((Object)ZoneId.of("Z"));
        Date beginDate = Date.valueOf("2022-11-01");
        Date endDate = Date.valueOf("2023-01-01");
        ArrayList<InvoiceRecurrence> invoiceRecurrences = new ArrayList<InvoiceRecurrence>();
        invoiceRecurrences.add(InvoiceRecurrenceServiceImplTest.generateInvoiceRecurrence(beginDate, endDate, null, false));
        ((BusinessObjectService)Mockito.doReturn(invoiceRecurrences).when((Object)this.boServiceMock)).findMatchingOrderBy(InvoiceRecurrence.class, Map.of("active", Boolean.TRUE), "invoiceNumber", true);
        try (MockedStatic globalVariablesMockedStatic = Mockito.mockStatic(GlobalVariables.class);
             MockedStatic kimApiServiceLocatorMockedStatic = Mockito.mockStatic(KimApiServiceLocator.class);
             MockedStatic clockMockedStatic = Mockito.mockStatic(Clock.class);){
            kimApiServiceLocatorMockedStatic.when(KimApiServiceLocator::getPersonService).thenReturn((Object)this.personServiceMock);
            globalVariablesMockedStatic.when(GlobalVariables::getUserSession).thenReturn((Object)this.userSessionMock);
            clockMockedStatic.when(Clock::systemDefaultZone).thenReturn((Object)this.clockSpy);
            Assertions.assertTrue((boolean)this.cut.processInvoiceRecurrence());
            ((DocumentService)Mockito.verify((Object)this.documentServiceMock, (VerificationMode)Mockito.never())).routeDocument((Document)ArgumentMatchers.any(CustomerInvoiceDocument.class), ArgumentMatchers.anyString(), ArgumentMatchers.anyList());
        }
    }

    private static InvoiceRecurrence generateInvoiceRecurrence(Date beginDate, Date endDate, Date lastCreateDate, boolean shouldMock) {
        InvoiceRecurrence invoiceRecurrence = (InvoiceRecurrence)Mockito.spy(InvoiceRecurrence.class);
        invoiceRecurrence.setInvoiceNumber(INVOICE_NUMBER);
        invoiceRecurrence.setActive(true);
        invoiceRecurrence.setDocumentLastCreateDate(lastCreateDate);
        invoiceRecurrence.setDocumentRecurrenceBeginDate(beginDate);
        invoiceRecurrence.setDocumentRecurrenceEndDate(endDate);
        if (shouldMock) {
            ((InvoiceRecurrence)Mockito.doReturn((Object)DEFAULT_USER).when((Object)invoiceRecurrence)).getDocumentInitiatorUserPersonUserIdentifier();
        }
        return invoiceRecurrence;
    }
}

