/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.ar.businessobject;

import java.sql.Date;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.kuali.kfs.coa.businessobject.AccountingPeriod;
import org.kuali.kfs.coa.service.AccountingPeriodService;
import org.kuali.kfs.module.ar.ArConstants;
import org.kuali.kfs.module.ar.businessobject.BillingPeriod;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.jupiter.MockitoExtension;

@ExtendWith(value={MockitoExtension.class})
class BillingPeriodTest {
    private static final String ACCOUNTING_PERIOD_2013_12_END_DATE = "2013-06-30";
    private static final String ACCOUNTING_PERIOD_2014_05_END_DATE = "2014-11-30";
    private static final String ACCOUNTING_PERIOD_2014_09_END_DATE = "2014-03-31";
    private static final String ACCOUNTING_PERIOD_2014_10_END_DATE = "2014-04-30";
    private static final String ACCOUNTING_PERIOD_2014_12_END_DATE = "2014-06-30";
    private static final String ACCOUNTING_PERIOD_2015_03_END_DATE = "2014-09-30";
    private static final String ACCOUNTING_PERIOD_2015_06_END_DATE = "2014-12-31";
    private static final String ACCOUNTING_PERIOD_2015_08_END_DATE = "2015-02-28";
    private static final String ACCOUNTING_PERIOD_2015_09_END_DATE = "2015-03-31";
    private static final String ACCOUNTING_PERIOD_2015_10_END_DATE = "2015-04-30";
    private static final String ACCOUNTING_PERIOD_2015_12_END_DATE = "2015-06-30";
    private static final int FY2013 = 2013;
    private static final int FY2014 = 2014;
    private static final int FY2015 = 2015;
    private static final int FY2016 = 2016;

    BillingPeriodTest() {
    }

    @Test
    void determineBillingPeriodPriorTo_Monthly_nullLastBilled_1(@Mock(stubOnly=true) AccountingPeriodService accountingPeriodSvcMock, @Mock(stubOnly=true) AccountingPeriod accountingPeriodMock_2015_09, @Mock(stubOnly=true) AccountingPeriod accountingPeriodMock_2015_10) {
        Date awardStartDate = Date.valueOf("2014-07-01");
        Date currentDate = Date.valueOf("2015-04-21");
        Date expectedBillingPeriodStart = Date.valueOf("2014-07-01");
        Date expectedBillingPeriodEnd = Date.valueOf(ACCOUNTING_PERIOD_2015_09_END_DATE);
        Mockito.when((Object)accountingPeriodMock_2015_09.getUniversityFiscalPeriodEndDate()).thenReturn((Object)Date.valueOf(ACCOUNTING_PERIOD_2015_09_END_DATE));
        Mockito.when((Object)accountingPeriodSvcMock.getByPeriod("09", Integer.valueOf(2015))).thenReturn((Object)accountingPeriodMock_2015_09);
        Mockito.when((Object)accountingPeriodMock_2015_10.getUniversityFiscalPeriodCode()).thenReturn((Object)"10");
        Mockito.when((Object)accountingPeriodMock_2015_10.getUniversityFiscalYear()).thenReturn((Object)2015);
        Mockito.when((Object)accountingPeriodSvcMock.getByDate(currentDate)).thenReturn((Object)accountingPeriodMock_2015_10);
        BillingPeriod priorBillingPeriod = BillingPeriod.determineBillingPeriodPriorTo((Date)awardStartDate, (Date)currentDate, null, (ArConstants.BillingFrequencyValues)ArConstants.BillingFrequencyValues.MONTHLY, (AccountingPeriodService)accountingPeriodSvcMock);
        Assertions.assertEquals((Object)expectedBillingPeriodStart, (Object)priorBillingPeriod.getStartDate());
        Assertions.assertEquals((Object)expectedBillingPeriodEnd, (Object)priorBillingPeriod.getEndDate());
        Assertions.assertTrue((boolean)priorBillingPeriod.isBillable());
    }

    @Test
    void determineBillingPeriodPriorTo_Monthly_nullLastBilled_2(@Mock(stubOnly=true) AccountingPeriodService accountingPeriodSvcMock, @Mock(stubOnly=true) AccountingPeriod accountingPeriodMock_2015_08, @Mock(stubOnly=true) AccountingPeriod accountingPeriodMock_2015_09) {
        Date awardStartDate = Date.valueOf("2014-07-01");
        Date currentDate = Date.valueOf("2015-03-21");
        Date expectedBillingPeriodStart = Date.valueOf("2014-07-01");
        Date expectedBillingPeriodEnd = Date.valueOf(ACCOUNTING_PERIOD_2015_08_END_DATE);
        Mockito.when((Object)accountingPeriodMock_2015_08.getUniversityFiscalPeriodEndDate()).thenReturn((Object)Date.valueOf(ACCOUNTING_PERIOD_2015_08_END_DATE));
        Mockito.when((Object)accountingPeriodSvcMock.getByPeriod("08", Integer.valueOf(2015))).thenReturn((Object)accountingPeriodMock_2015_08);
        Mockito.when((Object)accountingPeriodMock_2015_09.getUniversityFiscalPeriodCode()).thenReturn((Object)"09");
        Mockito.when((Object)accountingPeriodMock_2015_09.getUniversityFiscalYear()).thenReturn((Object)2015);
        Mockito.when((Object)accountingPeriodSvcMock.getByDate(currentDate)).thenReturn((Object)accountingPeriodMock_2015_09);
        BillingPeriod priorBillingPeriod = BillingPeriod.determineBillingPeriodPriorTo((Date)awardStartDate, (Date)currentDate, null, (ArConstants.BillingFrequencyValues)ArConstants.BillingFrequencyValues.MONTHLY, (AccountingPeriodService)accountingPeriodSvcMock);
        Assertions.assertEquals((Object)expectedBillingPeriodStart, (Object)priorBillingPeriod.getStartDate());
        Assertions.assertEquals((Object)expectedBillingPeriodEnd, (Object)priorBillingPeriod.getEndDate());
        Assertions.assertTrue((boolean)priorBillingPeriod.isBillable());
    }

    @Test
    void determineBillingPeriodPriorTo_Monthly_LastBilledLastMonth(@Mock(stubOnly=true) AccountingPeriodService accountingPeriodSvcMock, @Mock(stubOnly=true) AccountingPeriod accountingPeriodMock_2015_11, @Mock(stubOnly=true) AccountingPeriod accountingPeriodMock_2015_10, @Mock(stubOnly=true) AccountingPeriod accountingPeriodMock_2015_09, @Mock(stubOnly=true) AccountingPeriod accountingPeriodMock_2015_08) {
        Date awardStartDate = Date.valueOf("2014-07-01");
        Date lastBilledDate = Date.valueOf(ACCOUNTING_PERIOD_2015_09_END_DATE);
        Date currentDate = Date.valueOf("2015-05-21");
        Date expectedBillingPeriodStart = Date.valueOf("2015-04-01");
        Date expectedBillingPeriodEnd = Date.valueOf(ACCOUNTING_PERIOD_2015_10_END_DATE);
        Mockito.when((Object)accountingPeriodSvcMock.getByDate(currentDate)).thenReturn((Object)accountingPeriodMock_2015_11);
        Mockito.when((Object)accountingPeriodSvcMock.getByDate(lastBilledDate)).thenReturn((Object)accountingPeriodMock_2015_09);
        Mockito.when((Object)accountingPeriodMock_2015_11.getUniversityFiscalPeriodCode()).thenReturn((Object)"11");
        Mockito.when((Object)accountingPeriodMock_2015_11.getUniversityFiscalYear()).thenReturn((Object)2015);
        Mockito.when((Object)accountingPeriodMock_2015_10.getUniversityFiscalPeriodCode()).thenReturn((Object)"10");
        Mockito.when((Object)accountingPeriodMock_2015_10.getUniversityFiscalPeriodEndDate()).thenReturn((Object)Date.valueOf(ACCOUNTING_PERIOD_2015_10_END_DATE));
        Mockito.when((Object)accountingPeriodSvcMock.getByPeriod("10", Integer.valueOf(2015))).thenReturn((Object)accountingPeriodMock_2015_10);
        Mockito.when((Object)accountingPeriodMock_2015_09.getUniversityFiscalPeriodCode()).thenReturn((Object)"09");
        Mockito.when((Object)accountingPeriodMock_2015_09.getUniversityFiscalYear()).thenReturn((Object)2015);
        Mockito.when((Object)accountingPeriodMock_2015_09.getUniversityFiscalPeriodEndDate()).thenReturn((Object)Date.valueOf(ACCOUNTING_PERIOD_2015_09_END_DATE));
        Mockito.when((Object)accountingPeriodMock_2015_08.getUniversityFiscalPeriodCode()).thenReturn((Object)"08");
        Mockito.when((Object)accountingPeriodSvcMock.getByPeriod("08", Integer.valueOf(2015))).thenReturn((Object)accountingPeriodMock_2015_08);
        BillingPeriod priorBillingPeriod = BillingPeriod.determineBillingPeriodPriorTo((Date)awardStartDate, (Date)currentDate, (Date)lastBilledDate, (ArConstants.BillingFrequencyValues)ArConstants.BillingFrequencyValues.MONTHLY, (AccountingPeriodService)accountingPeriodSvcMock);
        Assertions.assertEquals((Object)expectedBillingPeriodStart, (Object)priorBillingPeriod.getStartDate());
        Assertions.assertEquals((Object)expectedBillingPeriodEnd, (Object)priorBillingPeriod.getEndDate());
        Assertions.assertTrue((boolean)priorBillingPeriod.isBillable());
    }

    @Test
    void determineBillingPeriodPriorTo_Monthly_LastBilledTwoMonthsAgo(@Mock(stubOnly=true) AccountingPeriodService accountingPeriodSvcMock, @Mock(stubOnly=true) AccountingPeriod accountingPeriodMock_2015_11, @Mock(stubOnly=true) AccountingPeriod accountingPeriodMock_2015_10, @Mock(stubOnly=true) AccountingPeriod accountingPeriodMock_2015_08, @Mock(stubOnly=true) AccountingPeriod accountingPeriodMock_2015_07) {
        Date awardStartDate = Date.valueOf("2014-07-01");
        Date lastBilledDate = Date.valueOf(ACCOUNTING_PERIOD_2015_08_END_DATE);
        Date currentDate = Date.valueOf("2015-05-21");
        Date expectedBillingPeriodStart = Date.valueOf("2015-03-01");
        Date expectedBillingPeriodEnd = Date.valueOf(ACCOUNTING_PERIOD_2015_10_END_DATE);
        Mockito.when((Object)accountingPeriodSvcMock.getByDate(currentDate)).thenReturn((Object)accountingPeriodMock_2015_11);
        Mockito.when((Object)accountingPeriodSvcMock.getByDate(lastBilledDate)).thenReturn((Object)accountingPeriodMock_2015_08);
        Mockito.when((Object)accountingPeriodMock_2015_07.getUniversityFiscalPeriodCode()).thenReturn((Object)"07");
        Mockito.when((Object)accountingPeriodSvcMock.getByPeriod("07", Integer.valueOf(2015))).thenReturn((Object)accountingPeriodMock_2015_07);
        Mockito.when((Object)accountingPeriodMock_2015_08.getUniversityFiscalPeriodCode()).thenReturn((Object)"08");
        Mockito.when((Object)accountingPeriodMock_2015_08.getUniversityFiscalPeriodEndDate()).thenReturn((Object)Date.valueOf(ACCOUNTING_PERIOD_2015_08_END_DATE));
        Mockito.when((Object)accountingPeriodMock_2015_08.getUniversityFiscalYear()).thenReturn((Object)2015);
        Mockito.when((Object)accountingPeriodMock_2015_10.getUniversityFiscalPeriodCode()).thenReturn((Object)"10");
        Mockito.when((Object)accountingPeriodMock_2015_10.getUniversityFiscalPeriodEndDate()).thenReturn((Object)Date.valueOf(ACCOUNTING_PERIOD_2015_10_END_DATE));
        Mockito.when((Object)accountingPeriodSvcMock.getByPeriod("10", Integer.valueOf(2015))).thenReturn((Object)accountingPeriodMock_2015_10);
        Mockito.when((Object)accountingPeriodMock_2015_11.getUniversityFiscalPeriodCode()).thenReturn((Object)"11");
        Mockito.when((Object)accountingPeriodMock_2015_11.getUniversityFiscalYear()).thenReturn((Object)2015);
        BillingPeriod priorBillingPeriod = BillingPeriod.determineBillingPeriodPriorTo((Date)awardStartDate, (Date)currentDate, (Date)lastBilledDate, (ArConstants.BillingFrequencyValues)ArConstants.BillingFrequencyValues.MONTHLY, (AccountingPeriodService)accountingPeriodSvcMock);
        Assertions.assertEquals((Object)expectedBillingPeriodStart, (Object)priorBillingPeriod.getStartDate());
        Assertions.assertEquals((Object)expectedBillingPeriodEnd, (Object)priorBillingPeriod.getEndDate());
        Assertions.assertTrue((boolean)priorBillingPeriod.isBillable());
    }

    @Test
    void determineBillingPeriodPriorTo_Monthly_SpanCalendarYears(@Mock(stubOnly=true) AccountingPeriodService accountingPeriodSvcMock, @Mock(stubOnly=true) AccountingPeriod accountingPeriodMock_2015_09, @Mock(stubOnly=true) AccountingPeriod accountingPeriodMock_2015_10, @Mock(stubOnly=true) AccountingPeriod accountingPeriodMock_2014_11, @Mock(stubOnly=true) AccountingPeriod accountingPeriodMock_2014_12) {
        Date awardStartDate = Date.valueOf("2013-07-01");
        Date lastBilledDate = Date.valueOf(ACCOUNTING_PERIOD_2014_12_END_DATE);
        Date currentDate = Date.valueOf("2015-04-21");
        Date expectedBillingPeriodStart = Date.valueOf("2014-07-01");
        Date expectedBillingPeriodEnd = Date.valueOf(ACCOUNTING_PERIOD_2015_09_END_DATE);
        Mockito.when((Object)accountingPeriodMock_2015_09.getUniversityFiscalPeriodEndDate()).thenReturn((Object)Date.valueOf(ACCOUNTING_PERIOD_2015_09_END_DATE));
        Mockito.when((Object)accountingPeriodMock_2015_09.getUniversityFiscalPeriodCode()).thenReturn((Object)"09");
        Mockito.when((Object)accountingPeriodSvcMock.getByPeriod("09", Integer.valueOf(2015))).thenReturn((Object)accountingPeriodMock_2015_09);
        Mockito.when((Object)accountingPeriodMock_2015_10.getUniversityFiscalPeriodCode()).thenReturn((Object)"10");
        Mockito.when((Object)accountingPeriodMock_2015_10.getUniversityFiscalYear()).thenReturn((Object)2015);
        Mockito.when((Object)accountingPeriodSvcMock.getByDate(currentDate)).thenReturn((Object)accountingPeriodMock_2015_10);
        Mockito.when((Object)accountingPeriodMock_2014_11.getUniversityFiscalPeriodCode()).thenReturn((Object)"11");
        Mockito.when((Object)accountingPeriodSvcMock.getByPeriod("11", Integer.valueOf(2014))).thenReturn((Object)accountingPeriodMock_2014_11);
        Mockito.when((Object)accountingPeriodMock_2014_12.getUniversityFiscalPeriodEndDate()).thenReturn((Object)Date.valueOf(ACCOUNTING_PERIOD_2014_12_END_DATE));
        Mockito.when((Object)accountingPeriodMock_2014_12.getUniversityFiscalPeriodCode()).thenReturn((Object)"12");
        Mockito.when((Object)accountingPeriodMock_2014_12.getUniversityFiscalYear()).thenReturn((Object)2014);
        Mockito.when((Object)accountingPeriodSvcMock.getByDate(lastBilledDate)).thenReturn((Object)accountingPeriodMock_2014_12);
        BillingPeriod priorBillingPeriod = BillingPeriod.determineBillingPeriodPriorTo((Date)awardStartDate, (Date)currentDate, (Date)lastBilledDate, (ArConstants.BillingFrequencyValues)ArConstants.BillingFrequencyValues.MONTHLY, (AccountingPeriodService)accountingPeriodSvcMock);
        Assertions.assertEquals((Object)expectedBillingPeriodStart, (Object)priorBillingPeriod.getStartDate());
        Assertions.assertEquals((Object)expectedBillingPeriodEnd, (Object)priorBillingPeriod.getEndDate());
        Assertions.assertTrue((boolean)priorBillingPeriod.isBillable());
    }

    @Test
    void determineBillingPeriodPriorTo_Monthly_MayNotBillNow(@Mock(stubOnly=true) AccountingPeriodService accountingPeriodSvcMock, @Mock(stubOnly=true) AccountingPeriod accountingPeriodMock_2015_10, @Mock(stubOnly=true) AccountingPeriod accountingPeriodMock_2015_09) {
        Date awardStartDate = Date.valueOf("2014-07-01");
        Date currentDate = Date.valueOf("2015-04-21");
        Date lastBilledDate = Date.valueOf("2015-04-15");
        Mockito.when((Object)accountingPeriodMock_2015_09.getUniversityFiscalPeriodCode()).thenReturn((Object)"09");
        Mockito.when((Object)accountingPeriodSvcMock.getByPeriod("09", Integer.valueOf(2015))).thenReturn((Object)accountingPeriodMock_2015_09);
        Mockito.when((Object)accountingPeriodMock_2015_10.getUniversityFiscalPeriodCode()).thenReturn((Object)"10");
        Mockito.when((Object)accountingPeriodMock_2015_10.getUniversityFiscalYear()).thenReturn((Object)2015);
        Mockito.when((Object)accountingPeriodSvcMock.getByDate(currentDate)).thenReturn((Object)accountingPeriodMock_2015_10);
        Mockito.when((Object)accountingPeriodSvcMock.getByDate(lastBilledDate)).thenReturn((Object)accountingPeriodMock_2015_10);
        BillingPeriod priorBillingPeriod = BillingPeriod.determineBillingPeriodPriorTo((Date)awardStartDate, (Date)currentDate, (Date)lastBilledDate, (ArConstants.BillingFrequencyValues)ArConstants.BillingFrequencyValues.MONTHLY, (AccountingPeriodService)accountingPeriodSvcMock);
        Assertions.assertNull((Object)priorBillingPeriod.getStartDate());
        Assertions.assertNull((Object)priorBillingPeriod.getEndDate());
        Assertions.assertFalse((boolean)priorBillingPeriod.isBillable());
    }

    @Test
    void determineBillingPeriodPriorTo_Monthly_MayBillNowLastYear(@Mock(stubOnly=true) AccountingPeriodService accountingPeriodSvcMock, @Mock(stubOnly=true) AccountingPeriod accountingPeriodMock_2015_10, @Mock(stubOnly=true) AccountingPeriod accountingPeriodMock_2015_09, @Mock(stubOnly=true) AccountingPeriod accountingPeriodMock_2014_10, @Mock(stubOnly=true) AccountingPeriod accountingPeriodMock_2014_09) {
        Date awardStartDate = Date.valueOf("2014-03-01");
        Date currentDate = Date.valueOf("2015-04-21");
        Date lastBilledDate = Date.valueOf(ACCOUNTING_PERIOD_2014_10_END_DATE);
        Date expectedBillingPeriodStart = Date.valueOf("2014-05-01");
        Date expectedBillingPeriodEnd = Date.valueOf(ACCOUNTING_PERIOD_2015_09_END_DATE);
        Mockito.when((Object)accountingPeriodMock_2015_09.getUniversityFiscalPeriodEndDate()).thenReturn((Object)Date.valueOf(ACCOUNTING_PERIOD_2015_09_END_DATE));
        Mockito.when((Object)accountingPeriodMock_2015_09.getUniversityFiscalPeriodCode()).thenReturn((Object)"09");
        Mockito.when((Object)accountingPeriodSvcMock.getByPeriod("09", Integer.valueOf(2015))).thenReturn((Object)accountingPeriodMock_2015_09);
        Mockito.when((Object)accountingPeriodMock_2015_10.getUniversityFiscalPeriodCode()).thenReturn((Object)"10");
        Mockito.when((Object)accountingPeriodMock_2015_10.getUniversityFiscalYear()).thenReturn((Object)2015);
        Mockito.when((Object)accountingPeriodMock_2014_10.getUniversityFiscalPeriodEndDate()).thenReturn((Object)Date.valueOf(ACCOUNTING_PERIOD_2014_10_END_DATE));
        Mockito.when((Object)accountingPeriodMock_2014_10.getUniversityFiscalPeriodCode()).thenReturn((Object)"10");
        Mockito.when((Object)accountingPeriodMock_2014_10.getUniversityFiscalYear()).thenReturn((Object)2014);
        Mockito.when((Object)accountingPeriodMock_2014_09.getUniversityFiscalPeriodCode()).thenReturn((Object)"09");
        Mockito.when((Object)accountingPeriodSvcMock.getByPeriod("09", Integer.valueOf(2014))).thenReturn((Object)accountingPeriodMock_2014_09);
        Mockito.when((Object)accountingPeriodSvcMock.getByDate(currentDate)).thenReturn((Object)accountingPeriodMock_2015_10);
        Mockito.when((Object)accountingPeriodSvcMock.getByDate(lastBilledDate)).thenReturn((Object)accountingPeriodMock_2014_10);
        BillingPeriod priorBillingPeriod = BillingPeriod.determineBillingPeriodPriorTo((Date)awardStartDate, (Date)currentDate, (Date)lastBilledDate, (ArConstants.BillingFrequencyValues)ArConstants.BillingFrequencyValues.MONTHLY, (AccountingPeriodService)accountingPeriodSvcMock);
        Assertions.assertEquals((Object)expectedBillingPeriodStart, (Object)priorBillingPeriod.getStartDate());
        Assertions.assertEquals((Object)expectedBillingPeriodEnd, (Object)priorBillingPeriod.getEndDate());
        Assertions.assertTrue((boolean)priorBillingPeriod.isBillable());
    }

    @Test
    void determineBillingPeriodPriorTo_Monthly_BillAwardInFuture(@Mock(stubOnly=true) AccountingPeriodService accountingPeriodSvcMock, @Mock(stubOnly=true) AccountingPeriod accountingPeriodMock_2015_10, @Mock(stubOnly=true) AccountingPeriod accountingPeriodMock_2015_09, @Mock(stubOnly=true) AccountingPeriod accountingPeriodMock_2015_08) {
        Date awardStartDate = Date.valueOf("2015-07-01");
        Date currentDate = Date.valueOf("2015-04-21");
        Date previousPeriodEndDate = Date.valueOf(ACCOUNTING_PERIOD_2015_09_END_DATE);
        Date expectedBillingPeriodStart = Date.valueOf("2015-03-01");
        Date expectedBillingPeriodEnd = Date.valueOf(ACCOUNTING_PERIOD_2015_09_END_DATE);
        Mockito.when((Object)accountingPeriodSvcMock.getByDate(currentDate)).thenReturn((Object)accountingPeriodMock_2015_10);
        Mockito.when((Object)accountingPeriodSvcMock.getByDate(previousPeriodEndDate)).thenReturn((Object)accountingPeriodMock_2015_09);
        Mockito.when((Object)accountingPeriodMock_2015_08.getUniversityFiscalPeriodEndDate()).thenReturn((Object)Date.valueOf(ACCOUNTING_PERIOD_2015_08_END_DATE));
        Mockito.when((Object)accountingPeriodSvcMock.getByPeriod("08", Integer.valueOf(2015))).thenReturn((Object)accountingPeriodMock_2015_08);
        Mockito.when((Object)accountingPeriodMock_2015_09.getUniversityFiscalPeriodEndDate()).thenReturn((Object)Date.valueOf(ACCOUNTING_PERIOD_2015_09_END_DATE));
        Mockito.when((Object)accountingPeriodMock_2015_09.getUniversityFiscalPeriodCode()).thenReturn((Object)"09");
        Mockito.when((Object)accountingPeriodMock_2015_09.getUniversityFiscalYear()).thenReturn((Object)2015);
        Mockito.when((Object)accountingPeriodSvcMock.getByPeriod("09", Integer.valueOf(2015))).thenReturn((Object)accountingPeriodMock_2015_09);
        Mockito.when((Object)accountingPeriodMock_2015_10.getUniversityFiscalPeriodCode()).thenReturn((Object)"10");
        Mockito.when((Object)accountingPeriodMock_2015_10.getUniversityFiscalYear()).thenReturn((Object)2015);
        BillingPeriod priorBillingPeriod = BillingPeriod.determineBillingPeriodPriorTo((Date)awardStartDate, (Date)currentDate, null, (ArConstants.BillingFrequencyValues)ArConstants.BillingFrequencyValues.MONTHLY, (AccountingPeriodService)accountingPeriodSvcMock);
        Assertions.assertEquals((Object)expectedBillingPeriodStart, (Object)priorBillingPeriod.getStartDate());
        Assertions.assertEquals((Object)expectedBillingPeriodEnd, (Object)priorBillingPeriod.getEndDate());
        Assertions.assertTrue((boolean)priorBillingPeriod.isBillable());
    }

    @Test
    void determineBillingPeriodPriorTo_Predetermined_nullLastBilled_1(@Mock(stubOnly=true) AccountingPeriodService accountingPeriodSvcMock, @Mock(stubOnly=true) AccountingPeriod accountingPeriodMock_2015_10, @Mock(stubOnly=true) AccountingPeriod accountingPeriodMock_2015_09) {
        Date awardStartDate = Date.valueOf("2014-07-01");
        Date currentDate = Date.valueOf("2015-04-21");
        Date expectedBillingPeriodStart = Date.valueOf("2014-07-01");
        Date expectedBillingPeriodEnd = Date.valueOf(ACCOUNTING_PERIOD_2015_09_END_DATE);
        Mockito.when((Object)accountingPeriodMock_2015_09.getUniversityFiscalPeriodEndDate()).thenReturn((Object)Date.valueOf(ACCOUNTING_PERIOD_2015_09_END_DATE));
        Mockito.when((Object)accountingPeriodSvcMock.getByPeriod("09", Integer.valueOf(2015))).thenReturn((Object)accountingPeriodMock_2015_09);
        Mockito.when((Object)accountingPeriodMock_2015_10.getUniversityFiscalPeriodCode()).thenReturn((Object)"10");
        Mockito.when((Object)accountingPeriodMock_2015_10.getUniversityFiscalYear()).thenReturn((Object)2015);
        Mockito.when((Object)accountingPeriodSvcMock.getByDate(currentDate)).thenReturn((Object)accountingPeriodMock_2015_10);
        BillingPeriod priorBillingPeriod = BillingPeriod.determineBillingPeriodPriorTo((Date)awardStartDate, (Date)currentDate, null, (ArConstants.BillingFrequencyValues)ArConstants.BillingFrequencyValues.PREDETERMINED_BILLING, (AccountingPeriodService)accountingPeriodSvcMock);
        Assertions.assertEquals((Object)expectedBillingPeriodStart, (Object)priorBillingPeriod.getStartDate());
        Assertions.assertEquals((Object)expectedBillingPeriodEnd, (Object)priorBillingPeriod.getEndDate());
        Assertions.assertTrue((boolean)priorBillingPeriod.isBillable());
    }

    @Test
    void determineBillingPeriodPriorTo_Predetermined_nullLastBilled_2(@Mock(stubOnly=true) AccountingPeriodService accountingPeriodSvcMock, @Mock(stubOnly=true) AccountingPeriod accountingPeriodMock_2015_09, @Mock(stubOnly=true) AccountingPeriod accountingPeriodMock_2015_08) {
        Date awardStartDate = Date.valueOf("2014-07-01");
        Date currentDate = Date.valueOf("2015-03-21");
        Date expectedBillingPeriodStart = Date.valueOf("2014-07-01");
        Date expectedBillingPeriodEnd = Date.valueOf(ACCOUNTING_PERIOD_2015_08_END_DATE);
        Mockito.when((Object)accountingPeriodMock_2015_09.getUniversityFiscalPeriodCode()).thenReturn((Object)"09");
        Mockito.when((Object)accountingPeriodMock_2015_09.getUniversityFiscalYear()).thenReturn((Object)2015);
        Mockito.when((Object)accountingPeriodMock_2015_08.getUniversityFiscalPeriodEndDate()).thenReturn((Object)Date.valueOf(ACCOUNTING_PERIOD_2015_08_END_DATE));
        Mockito.when((Object)accountingPeriodSvcMock.getByPeriod("08", Integer.valueOf(2015))).thenReturn((Object)accountingPeriodMock_2015_08);
        Mockito.when((Object)accountingPeriodSvcMock.getByDate(currentDate)).thenReturn((Object)accountingPeriodMock_2015_09);
        BillingPeriod priorBillingPeriod = BillingPeriod.determineBillingPeriodPriorTo((Date)awardStartDate, (Date)currentDate, null, (ArConstants.BillingFrequencyValues)ArConstants.BillingFrequencyValues.PREDETERMINED_BILLING, (AccountingPeriodService)accountingPeriodSvcMock);
        Assertions.assertEquals((Object)expectedBillingPeriodStart, (Object)priorBillingPeriod.getStartDate());
        Assertions.assertEquals((Object)expectedBillingPeriodEnd, (Object)priorBillingPeriod.getEndDate());
        Assertions.assertTrue((boolean)priorBillingPeriod.isBillable());
    }

    @Test
    void determineBillingPeriodPriorTo_Predetermined_LastBilledLastMonth(@Mock(stubOnly=true) AccountingPeriodService accountingPeriodSvcMock, @Mock(stubOnly=true) AccountingPeriod accountingPeriodMock_2015_11, @Mock(stubOnly=true) AccountingPeriod accountingPeriodMock_2015_10, @Mock(stubOnly=true) AccountingPeriod accountingPeriodMock_2015_09, @Mock(stubOnly=true) AccountingPeriod accountingPeriodMock_2015_08) {
        Date awardStartDate = Date.valueOf("2014-07-01");
        Date lastBilledDate = Date.valueOf(ACCOUNTING_PERIOD_2015_09_END_DATE);
        Date currentDate = Date.valueOf("2015-05-21");
        Date expectedBillingPeriodStart = Date.valueOf("2015-04-01");
        Date expectedBillingPeriodEnd = Date.valueOf(ACCOUNTING_PERIOD_2015_10_END_DATE);
        Mockito.when((Object)accountingPeriodSvcMock.getByDate(currentDate)).thenReturn((Object)accountingPeriodMock_2015_11);
        Mockito.when((Object)accountingPeriodSvcMock.getByDate(lastBilledDate)).thenReturn((Object)accountingPeriodMock_2015_09);
        Mockito.when((Object)accountingPeriodMock_2015_11.getUniversityFiscalPeriodCode()).thenReturn((Object)"11");
        Mockito.when((Object)accountingPeriodMock_2015_11.getUniversityFiscalYear()).thenReturn((Object)2015);
        Mockito.when((Object)accountingPeriodMock_2015_10.getUniversityFiscalPeriodCode()).thenReturn((Object)"10");
        Mockito.when((Object)accountingPeriodMock_2015_10.getUniversityFiscalPeriodEndDate()).thenReturn((Object)Date.valueOf(ACCOUNTING_PERIOD_2015_10_END_DATE));
        Mockito.when((Object)accountingPeriodSvcMock.getByPeriod("10", Integer.valueOf(2015))).thenReturn((Object)accountingPeriodMock_2015_10);
        Mockito.when((Object)accountingPeriodMock_2015_09.getUniversityFiscalPeriodCode()).thenReturn((Object)"09");
        Mockito.when((Object)accountingPeriodMock_2015_09.getUniversityFiscalYear()).thenReturn((Object)2015);
        Mockito.when((Object)accountingPeriodMock_2015_09.getUniversityFiscalPeriodEndDate()).thenReturn((Object)Date.valueOf(ACCOUNTING_PERIOD_2015_09_END_DATE));
        Mockito.when((Object)accountingPeriodMock_2015_08.getUniversityFiscalPeriodCode()).thenReturn((Object)"08");
        Mockito.when((Object)accountingPeriodSvcMock.getByPeriod("08", Integer.valueOf(2015))).thenReturn((Object)accountingPeriodMock_2015_08);
        BillingPeriod priorBillingPeriod = BillingPeriod.determineBillingPeriodPriorTo((Date)awardStartDate, (Date)currentDate, (Date)lastBilledDate, (ArConstants.BillingFrequencyValues)ArConstants.BillingFrequencyValues.PREDETERMINED_BILLING, (AccountingPeriodService)accountingPeriodSvcMock);
        Assertions.assertEquals((Object)expectedBillingPeriodStart, (Object)priorBillingPeriod.getStartDate());
        Assertions.assertEquals((Object)expectedBillingPeriodEnd, (Object)priorBillingPeriod.getEndDate());
        Assertions.assertTrue((boolean)priorBillingPeriod.isBillable());
    }

    @Test
    void determineBillingPeriodPriorTo_Predetermined_LastBilledTwoMonthsAgo(@Mock(stubOnly=true) AccountingPeriodService accountingPeriodSvcMock, @Mock(stubOnly=true) AccountingPeriod accountingPeriodMock_2015_11, @Mock(stubOnly=true) AccountingPeriod accountingPeriodMock_2015_10, @Mock(stubOnly=true) AccountingPeriod accountingPeriodMock_2015_08, @Mock(stubOnly=true) AccountingPeriod accountingPeriodMock_2015_07) {
        Date awardStartDate = Date.valueOf("2014-07-01");
        Date lastBilledDate = Date.valueOf(ACCOUNTING_PERIOD_2015_08_END_DATE);
        Date currentDate = Date.valueOf("2015-05-21");
        Date expectedBillingPeriodStart = Date.valueOf("2015-03-01");
        Date expectedBillingPeriodEnd = Date.valueOf(ACCOUNTING_PERIOD_2015_10_END_DATE);
        Mockito.when((Object)accountingPeriodSvcMock.getByDate(currentDate)).thenReturn((Object)accountingPeriodMock_2015_11);
        Mockito.when((Object)accountingPeriodSvcMock.getByDate(lastBilledDate)).thenReturn((Object)accountingPeriodMock_2015_08);
        Mockito.when((Object)accountingPeriodMock_2015_07.getUniversityFiscalPeriodCode()).thenReturn((Object)"07");
        Mockito.when((Object)accountingPeriodSvcMock.getByPeriod("07", Integer.valueOf(2015))).thenReturn((Object)accountingPeriodMock_2015_07);
        Mockito.when((Object)accountingPeriodMock_2015_08.getUniversityFiscalPeriodCode()).thenReturn((Object)"08");
        Mockito.when((Object)accountingPeriodMock_2015_08.getUniversityFiscalPeriodEndDate()).thenReturn((Object)Date.valueOf(ACCOUNTING_PERIOD_2015_08_END_DATE));
        Mockito.when((Object)accountingPeriodMock_2015_08.getUniversityFiscalYear()).thenReturn((Object)2015);
        Mockito.when((Object)accountingPeriodMock_2015_10.getUniversityFiscalPeriodCode()).thenReturn((Object)"10");
        Mockito.when((Object)accountingPeriodMock_2015_10.getUniversityFiscalPeriodEndDate()).thenReturn((Object)Date.valueOf(ACCOUNTING_PERIOD_2015_10_END_DATE));
        Mockito.when((Object)accountingPeriodSvcMock.getByPeriod("10", Integer.valueOf(2015))).thenReturn((Object)accountingPeriodMock_2015_10);
        Mockito.when((Object)accountingPeriodMock_2015_11.getUniversityFiscalPeriodCode()).thenReturn((Object)"11");
        Mockito.when((Object)accountingPeriodMock_2015_11.getUniversityFiscalYear()).thenReturn((Object)2015);
        BillingPeriod priorBillingPeriod = BillingPeriod.determineBillingPeriodPriorTo((Date)awardStartDate, (Date)currentDate, (Date)lastBilledDate, (ArConstants.BillingFrequencyValues)ArConstants.BillingFrequencyValues.PREDETERMINED_BILLING, (AccountingPeriodService)accountingPeriodSvcMock);
        Assertions.assertEquals((Object)expectedBillingPeriodStart, (Object)priorBillingPeriod.getStartDate());
        Assertions.assertEquals((Object)expectedBillingPeriodEnd, (Object)priorBillingPeriod.getEndDate());
        Assertions.assertTrue((boolean)priorBillingPeriod.isBillable());
    }

    @Test
    void determineBillingPeriodPriorTo_Predetermined_SpanCalendarYears(@Mock(stubOnly=true) AccountingPeriodService accountingPeriodSvcMock, @Mock(stubOnly=true) AccountingPeriod accountingPeriodMock_2015_09, @Mock(stubOnly=true) AccountingPeriod accountingPeriodMock_2015_10, @Mock(stubOnly=true) AccountingPeriod accountingPeriodMock_2014_11, @Mock(stubOnly=true) AccountingPeriod accountingPeriodMock_2014_12) {
        Date awardStartDate = Date.valueOf("2013-07-01");
        Date lastBilledDate = Date.valueOf(ACCOUNTING_PERIOD_2014_12_END_DATE);
        Date currentDate = Date.valueOf("2015-04-21");
        Date expectedBillingPeriodStart = Date.valueOf("2014-07-01");
        Date expectedBillingPeriodEnd = Date.valueOf(ACCOUNTING_PERIOD_2015_09_END_DATE);
        Mockito.when((Object)accountingPeriodMock_2015_09.getUniversityFiscalPeriodEndDate()).thenReturn((Object)Date.valueOf(ACCOUNTING_PERIOD_2015_09_END_DATE));
        Mockito.when((Object)accountingPeriodMock_2015_09.getUniversityFiscalPeriodCode()).thenReturn((Object)"09");
        Mockito.when((Object)accountingPeriodSvcMock.getByPeriod("09", Integer.valueOf(2015))).thenReturn((Object)accountingPeriodMock_2015_09);
        Mockito.when((Object)accountingPeriodMock_2015_10.getUniversityFiscalPeriodCode()).thenReturn((Object)"10");
        Mockito.when((Object)accountingPeriodMock_2015_10.getUniversityFiscalYear()).thenReturn((Object)2015);
        Mockito.when((Object)accountingPeriodSvcMock.getByDate(currentDate)).thenReturn((Object)accountingPeriodMock_2015_10);
        Mockito.when((Object)accountingPeriodMock_2014_11.getUniversityFiscalPeriodCode()).thenReturn((Object)"11");
        Mockito.when((Object)accountingPeriodSvcMock.getByPeriod("11", Integer.valueOf(2014))).thenReturn((Object)accountingPeriodMock_2014_11);
        Mockito.when((Object)accountingPeriodMock_2014_12.getUniversityFiscalPeriodEndDate()).thenReturn((Object)Date.valueOf(ACCOUNTING_PERIOD_2014_12_END_DATE));
        Mockito.when((Object)accountingPeriodMock_2014_12.getUniversityFiscalPeriodCode()).thenReturn((Object)"12");
        Mockito.when((Object)accountingPeriodMock_2014_12.getUniversityFiscalYear()).thenReturn((Object)2014);
        Mockito.when((Object)accountingPeriodSvcMock.getByDate(lastBilledDate)).thenReturn((Object)accountingPeriodMock_2014_12);
        BillingPeriod priorBillingPeriod = BillingPeriod.determineBillingPeriodPriorTo((Date)awardStartDate, (Date)currentDate, (Date)lastBilledDate, (ArConstants.BillingFrequencyValues)ArConstants.BillingFrequencyValues.PREDETERMINED_BILLING, (AccountingPeriodService)accountingPeriodSvcMock);
        Assertions.assertEquals((Object)expectedBillingPeriodStart, (Object)priorBillingPeriod.getStartDate());
        Assertions.assertEquals((Object)expectedBillingPeriodEnd, (Object)priorBillingPeriod.getEndDate());
        Assertions.assertTrue((boolean)priorBillingPeriod.isBillable());
    }

    @Test
    void determineBillingPeriodPriorTo_Predetermined_MayNotBillNow(@Mock(stubOnly=true) AccountingPeriodService accountingPeriodSvcMock, @Mock(stubOnly=true) AccountingPeriod accountingPeriodMock_2015_10, @Mock(stubOnly=true) AccountingPeriod accountingPeriodMock_2015_09) {
        Date awardStartDate = Date.valueOf("2014-07-01");
        Date currentDate = Date.valueOf("2015-04-21");
        Date lastBilledDate = Date.valueOf("2015-04-15");
        Mockito.when((Object)accountingPeriodMock_2015_09.getUniversityFiscalPeriodCode()).thenReturn((Object)"09");
        Mockito.when((Object)accountingPeriodSvcMock.getByPeriod("09", Integer.valueOf(2015))).thenReturn((Object)accountingPeriodMock_2015_09);
        Mockito.when((Object)accountingPeriodMock_2015_10.getUniversityFiscalPeriodCode()).thenReturn((Object)"10");
        Mockito.when((Object)accountingPeriodMock_2015_10.getUniversityFiscalYear()).thenReturn((Object)2015);
        Mockito.when((Object)accountingPeriodSvcMock.getByDate(currentDate)).thenReturn((Object)accountingPeriodMock_2015_10);
        Mockito.when((Object)accountingPeriodMock_2015_10.getUniversityFiscalPeriodCode()).thenReturn((Object)"10");
        Mockito.when((Object)accountingPeriodMock_2015_10.getUniversityFiscalYear()).thenReturn((Object)2015);
        Mockito.when((Object)accountingPeriodSvcMock.getByDate(lastBilledDate)).thenReturn((Object)accountingPeriodMock_2015_10);
        BillingPeriod priorBillingPeriod = BillingPeriod.determineBillingPeriodPriorTo((Date)awardStartDate, (Date)currentDate, (Date)lastBilledDate, (ArConstants.BillingFrequencyValues)ArConstants.BillingFrequencyValues.PREDETERMINED_BILLING, (AccountingPeriodService)accountingPeriodSvcMock);
        Assertions.assertNull((Object)priorBillingPeriod.getStartDate());
        Assertions.assertNull((Object)priorBillingPeriod.getEndDate());
        Assertions.assertFalse((boolean)priorBillingPeriod.isBillable());
    }

    @Test
    void determineBillingPeriodPriorTo_Predetermined_MayBillNowLastYear(@Mock(stubOnly=true) AccountingPeriodService accountingPeriodSvcMock, @Mock(stubOnly=true) AccountingPeriod accountingPeriodMock_2015_10, @Mock(stubOnly=true) AccountingPeriod accountingPeriodMock_2015_09, @Mock(stubOnly=true) AccountingPeriod accountingPeriodMock_2014_10, @Mock(stubOnly=true) AccountingPeriod accountingPeriodMock_2014_09) {
        Date awardStartDate = Date.valueOf("2014-03-01");
        Date currentDate = Date.valueOf("2015-04-21");
        Date lastBilledDate = Date.valueOf(ACCOUNTING_PERIOD_2014_10_END_DATE);
        Date expectedBillingPeriodStart = Date.valueOf("2014-05-01");
        Date expectedBillingPeriodEnd = Date.valueOf(ACCOUNTING_PERIOD_2015_09_END_DATE);
        Mockito.when((Object)accountingPeriodMock_2015_09.getUniversityFiscalPeriodEndDate()).thenReturn((Object)Date.valueOf(ACCOUNTING_PERIOD_2015_09_END_DATE));
        Mockito.when((Object)accountingPeriodMock_2015_09.getUniversityFiscalPeriodCode()).thenReturn((Object)"09");
        Mockito.when((Object)accountingPeriodSvcMock.getByPeriod("09", Integer.valueOf(2015))).thenReturn((Object)accountingPeriodMock_2015_09);
        Mockito.when((Object)accountingPeriodMock_2015_10.getUniversityFiscalPeriodCode()).thenReturn((Object)"10");
        Mockito.when((Object)accountingPeriodMock_2015_10.getUniversityFiscalYear()).thenReturn((Object)2015);
        Mockito.when((Object)accountingPeriodMock_2014_10.getUniversityFiscalPeriodEndDate()).thenReturn((Object)Date.valueOf(ACCOUNTING_PERIOD_2014_10_END_DATE));
        Mockito.when((Object)accountingPeriodMock_2014_10.getUniversityFiscalPeriodCode()).thenReturn((Object)"10");
        Mockito.when((Object)accountingPeriodMock_2014_10.getUniversityFiscalYear()).thenReturn((Object)2014);
        Mockito.when((Object)accountingPeriodMock_2014_09.getUniversityFiscalPeriodCode()).thenReturn((Object)"09");
        Mockito.when((Object)accountingPeriodSvcMock.getByPeriod("09", Integer.valueOf(2014))).thenReturn((Object)accountingPeriodMock_2014_09);
        Mockito.when((Object)accountingPeriodSvcMock.getByDate(currentDate)).thenReturn((Object)accountingPeriodMock_2015_10);
        Mockito.when((Object)accountingPeriodSvcMock.getByDate(lastBilledDate)).thenReturn((Object)accountingPeriodMock_2014_10);
        BillingPeriod priorBillingPeriod = BillingPeriod.determineBillingPeriodPriorTo((Date)awardStartDate, (Date)currentDate, (Date)lastBilledDate, (ArConstants.BillingFrequencyValues)ArConstants.BillingFrequencyValues.PREDETERMINED_BILLING, (AccountingPeriodService)accountingPeriodSvcMock);
        Assertions.assertEquals((Object)expectedBillingPeriodStart, (Object)priorBillingPeriod.getStartDate());
        Assertions.assertEquals((Object)expectedBillingPeriodEnd, (Object)priorBillingPeriod.getEndDate());
        Assertions.assertTrue((boolean)priorBillingPeriod.isBillable());
    }

    @Test
    void determineBillingPeriodPriorTo_Milestone_nullLastBilled_1(@Mock(stubOnly=true) AccountingPeriodService accountingPeriodSvcMock, @Mock(stubOnly=true) AccountingPeriod accountingPeriodMock_2015_10, @Mock(stubOnly=true) AccountingPeriod accountingPeriodMock_2015_09) {
        Date awardStartDate = Date.valueOf("2014-07-01");
        Date currentDate = Date.valueOf("2015-04-21");
        Date expectedBillingPeriodStart = Date.valueOf("2014-07-01");
        Date expectedBillingPeriodEnd = Date.valueOf(ACCOUNTING_PERIOD_2015_09_END_DATE);
        Mockito.when((Object)accountingPeriodMock_2015_09.getUniversityFiscalPeriodEndDate()).thenReturn((Object)Date.valueOf(ACCOUNTING_PERIOD_2015_09_END_DATE));
        Mockito.when((Object)accountingPeriodSvcMock.getByPeriod("09", Integer.valueOf(2015))).thenReturn((Object)accountingPeriodMock_2015_09);
        Mockito.when((Object)accountingPeriodMock_2015_10.getUniversityFiscalPeriodCode()).thenReturn((Object)"10");
        Mockito.when((Object)accountingPeriodMock_2015_10.getUniversityFiscalYear()).thenReturn((Object)2015);
        Mockito.when((Object)accountingPeriodSvcMock.getByDate(currentDate)).thenReturn((Object)accountingPeriodMock_2015_10);
        BillingPeriod priorBillingPeriod = BillingPeriod.determineBillingPeriodPriorTo((Date)awardStartDate, (Date)currentDate, null, (ArConstants.BillingFrequencyValues)ArConstants.BillingFrequencyValues.MILESTONE, (AccountingPeriodService)accountingPeriodSvcMock);
        Assertions.assertEquals((Object)expectedBillingPeriodStart, (Object)priorBillingPeriod.getStartDate());
        Assertions.assertEquals((Object)expectedBillingPeriodEnd, (Object)priorBillingPeriod.getEndDate());
        Assertions.assertTrue((boolean)priorBillingPeriod.isBillable());
    }

    @Test
    void determineBillingPeriodPriorTo_Milestone_nullLastBilled_2(@Mock(stubOnly=true) AccountingPeriodService accountingPeriodSvcMock, @Mock(stubOnly=true) AccountingPeriod accountingPeriodMock_2015_09, @Mock(stubOnly=true) AccountingPeriod accountingPeriodMock_2015_08) {
        Date awardStartDate = Date.valueOf("2014-07-01");
        Date currentDate = Date.valueOf("2015-03-21");
        Date expectedBillingPeriodStart = Date.valueOf("2014-07-01");
        Date expectedBillingPeriodEnd = Date.valueOf(ACCOUNTING_PERIOD_2015_08_END_DATE);
        Mockito.when((Object)accountingPeriodMock_2015_08.getUniversityFiscalPeriodEndDate()).thenReturn((Object)Date.valueOf(ACCOUNTING_PERIOD_2015_08_END_DATE));
        Mockito.when((Object)accountingPeriodSvcMock.getByPeriod("08", Integer.valueOf(2015))).thenReturn((Object)accountingPeriodMock_2015_08);
        Mockito.when((Object)accountingPeriodMock_2015_09.getUniversityFiscalPeriodCode()).thenReturn((Object)"09");
        Mockito.when((Object)accountingPeriodMock_2015_09.getUniversityFiscalYear()).thenReturn((Object)2015);
        Mockito.when((Object)accountingPeriodSvcMock.getByDate(currentDate)).thenReturn((Object)accountingPeriodMock_2015_09);
        BillingPeriod priorBillingPeriod = BillingPeriod.determineBillingPeriodPriorTo((Date)awardStartDate, (Date)currentDate, null, (ArConstants.BillingFrequencyValues)ArConstants.BillingFrequencyValues.MILESTONE, (AccountingPeriodService)accountingPeriodSvcMock);
        Assertions.assertEquals((Object)expectedBillingPeriodStart, (Object)priorBillingPeriod.getStartDate());
        Assertions.assertEquals((Object)expectedBillingPeriodEnd, (Object)priorBillingPeriod.getEndDate());
        Assertions.assertTrue((boolean)priorBillingPeriod.isBillable());
    }

    @Test
    void determineBillingPeriodPriorTo_Milestone_LastBilledLastMonth(@Mock(stubOnly=true) AccountingPeriodService accountingPeriodSvcMock, @Mock(stubOnly=true) AccountingPeriod accountingPeriodMock_2015_11, @Mock(stubOnly=true) AccountingPeriod accountingPeriodMock_2015_10, @Mock(stubOnly=true) AccountingPeriod accountingPeriodMock_2015_09, @Mock(stubOnly=true) AccountingPeriod accountingPeriodMock_2015_08) {
        Date awardStartDate = Date.valueOf("2014-07-01");
        Date lastBilledDate = Date.valueOf(ACCOUNTING_PERIOD_2015_09_END_DATE);
        Date currentDate = Date.valueOf("2015-05-21");
        Date expectedBillingPeriodStart = Date.valueOf("2015-04-01");
        Date expectedBillingPeriodEnd = Date.valueOf(ACCOUNTING_PERIOD_2015_10_END_DATE);
        Mockito.when((Object)accountingPeriodSvcMock.getByDate(currentDate)).thenReturn((Object)accountingPeriodMock_2015_11);
        Mockito.when((Object)accountingPeriodSvcMock.getByDate(lastBilledDate)).thenReturn((Object)accountingPeriodMock_2015_09);
        Mockito.when((Object)accountingPeriodMock_2015_11.getUniversityFiscalPeriodCode()).thenReturn((Object)"11");
        Mockito.when((Object)accountingPeriodMock_2015_11.getUniversityFiscalYear()).thenReturn((Object)2015);
        Mockito.when((Object)accountingPeriodMock_2015_10.getUniversityFiscalPeriodCode()).thenReturn((Object)"10");
        Mockito.when((Object)accountingPeriodMock_2015_10.getUniversityFiscalPeriodEndDate()).thenReturn((Object)Date.valueOf(ACCOUNTING_PERIOD_2015_10_END_DATE));
        Mockito.when((Object)accountingPeriodSvcMock.getByPeriod("10", Integer.valueOf(2015))).thenReturn((Object)accountingPeriodMock_2015_10);
        Mockito.when((Object)accountingPeriodMock_2015_09.getUniversityFiscalPeriodCode()).thenReturn((Object)"09");
        Mockito.when((Object)accountingPeriodMock_2015_09.getUniversityFiscalYear()).thenReturn((Object)2015);
        Mockito.when((Object)accountingPeriodMock_2015_09.getUniversityFiscalPeriodEndDate()).thenReturn((Object)Date.valueOf(ACCOUNTING_PERIOD_2015_09_END_DATE));
        Mockito.when((Object)accountingPeriodMock_2015_08.getUniversityFiscalPeriodCode()).thenReturn((Object)"08");
        Mockito.when((Object)accountingPeriodSvcMock.getByPeriod("08", Integer.valueOf(2015))).thenReturn((Object)accountingPeriodMock_2015_08);
        BillingPeriod priorBillingPeriod = BillingPeriod.determineBillingPeriodPriorTo((Date)awardStartDate, (Date)currentDate, (Date)lastBilledDate, (ArConstants.BillingFrequencyValues)ArConstants.BillingFrequencyValues.MILESTONE, (AccountingPeriodService)accountingPeriodSvcMock);
        Assertions.assertEquals((Object)expectedBillingPeriodStart, (Object)priorBillingPeriod.getStartDate());
        Assertions.assertEquals((Object)expectedBillingPeriodEnd, (Object)priorBillingPeriod.getEndDate());
        Assertions.assertTrue((boolean)priorBillingPeriod.isBillable());
    }

    @Test
    void determineBillingPeriodPriorTo_Milestone_LastBilledTwoMonthsAgo(@Mock(stubOnly=true) AccountingPeriodService accountingPeriodSvcMock, @Mock(stubOnly=true) AccountingPeriod accountingPeriodMock_2015_11, @Mock(stubOnly=true) AccountingPeriod accountingPeriodMock_2015_10, @Mock(stubOnly=true) AccountingPeriod accountingPeriodMock_2015_08, @Mock(stubOnly=true) AccountingPeriod accountingPeriodMock_2015_07) {
        Date awardStartDate = Date.valueOf("2014-07-01");
        Date lastBilledDate = Date.valueOf(ACCOUNTING_PERIOD_2015_08_END_DATE);
        Date currentDate = Date.valueOf("2015-05-21");
        Date expectedBillingPeriodStart = Date.valueOf("2015-03-01");
        Date expectedBillingPeriodEnd = Date.valueOf(ACCOUNTING_PERIOD_2015_10_END_DATE);
        Mockito.when((Object)accountingPeriodSvcMock.getByDate(currentDate)).thenReturn((Object)accountingPeriodMock_2015_11);
        Mockito.when((Object)accountingPeriodSvcMock.getByDate(lastBilledDate)).thenReturn((Object)accountingPeriodMock_2015_08);
        Mockito.when((Object)accountingPeriodMock_2015_07.getUniversityFiscalPeriodCode()).thenReturn((Object)"07");
        Mockito.when((Object)accountingPeriodSvcMock.getByPeriod("07", Integer.valueOf(2015))).thenReturn((Object)accountingPeriodMock_2015_07);
        Mockito.when((Object)accountingPeriodMock_2015_08.getUniversityFiscalPeriodCode()).thenReturn((Object)"08");
        Mockito.when((Object)accountingPeriodMock_2015_08.getUniversityFiscalPeriodEndDate()).thenReturn((Object)Date.valueOf(ACCOUNTING_PERIOD_2015_08_END_DATE));
        Mockito.when((Object)accountingPeriodMock_2015_08.getUniversityFiscalYear()).thenReturn((Object)2015);
        Mockito.when((Object)accountingPeriodMock_2015_10.getUniversityFiscalPeriodCode()).thenReturn((Object)"10");
        Mockito.when((Object)accountingPeriodMock_2015_10.getUniversityFiscalPeriodEndDate()).thenReturn((Object)Date.valueOf(ACCOUNTING_PERIOD_2015_10_END_DATE));
        Mockito.when((Object)accountingPeriodSvcMock.getByPeriod("10", Integer.valueOf(2015))).thenReturn((Object)accountingPeriodMock_2015_10);
        Mockito.when((Object)accountingPeriodMock_2015_11.getUniversityFiscalPeriodCode()).thenReturn((Object)"11");
        Mockito.when((Object)accountingPeriodMock_2015_11.getUniversityFiscalYear()).thenReturn((Object)2015);
        BillingPeriod priorBillingPeriod = BillingPeriod.determineBillingPeriodPriorTo((Date)awardStartDate, (Date)currentDate, (Date)lastBilledDate, (ArConstants.BillingFrequencyValues)ArConstants.BillingFrequencyValues.MILESTONE, (AccountingPeriodService)accountingPeriodSvcMock);
        Assertions.assertEquals((Object)expectedBillingPeriodStart, (Object)priorBillingPeriod.getStartDate());
        Assertions.assertEquals((Object)expectedBillingPeriodEnd, (Object)priorBillingPeriod.getEndDate());
        Assertions.assertTrue((boolean)priorBillingPeriod.isBillable());
    }

    @Test
    void determineBillingPeriodPriorTo_Milestone_SpanCalendarYears(@Mock(stubOnly=true) AccountingPeriodService accountingPeriodSvcMock, @Mock(stubOnly=true) AccountingPeriod accountingPeriodMock_2015_09, @Mock(stubOnly=true) AccountingPeriod accountingPeriodMock_2015_10, @Mock(stubOnly=true) AccountingPeriod accountingPeriodMock_2014_11, @Mock(stubOnly=true) AccountingPeriod accountingPeriodMock_2014_12) {
        Date awardStartDate = Date.valueOf("2013-07-01");
        Date lastBilledDate = Date.valueOf(ACCOUNTING_PERIOD_2014_12_END_DATE);
        Date currentDate = Date.valueOf("2015-04-21");
        Date expectedBillingPeriodStart = Date.valueOf("2014-07-01");
        Date expectedBillingPeriodEnd = Date.valueOf(ACCOUNTING_PERIOD_2015_09_END_DATE);
        Mockito.when((Object)accountingPeriodMock_2015_09.getUniversityFiscalPeriodEndDate()).thenReturn((Object)Date.valueOf(ACCOUNTING_PERIOD_2015_09_END_DATE));
        Mockito.when((Object)accountingPeriodMock_2015_09.getUniversityFiscalPeriodCode()).thenReturn((Object)"09");
        Mockito.when((Object)accountingPeriodSvcMock.getByPeriod("09", Integer.valueOf(2015))).thenReturn((Object)accountingPeriodMock_2015_09);
        Mockito.when((Object)accountingPeriodMock_2015_10.getUniversityFiscalPeriodCode()).thenReturn((Object)"10");
        Mockito.when((Object)accountingPeriodMock_2015_10.getUniversityFiscalYear()).thenReturn((Object)2015);
        Mockito.when((Object)accountingPeriodSvcMock.getByDate(currentDate)).thenReturn((Object)accountingPeriodMock_2015_10);
        Mockito.when((Object)accountingPeriodMock_2014_11.getUniversityFiscalPeriodCode()).thenReturn((Object)"11");
        Mockito.when((Object)accountingPeriodSvcMock.getByPeriod("11", Integer.valueOf(2014))).thenReturn((Object)accountingPeriodMock_2014_11);
        Mockito.when((Object)accountingPeriodMock_2014_12.getUniversityFiscalPeriodEndDate()).thenReturn((Object)Date.valueOf(ACCOUNTING_PERIOD_2014_12_END_DATE));
        Mockito.when((Object)accountingPeriodMock_2014_12.getUniversityFiscalPeriodCode()).thenReturn((Object)"12");
        Mockito.when((Object)accountingPeriodMock_2014_12.getUniversityFiscalYear()).thenReturn((Object)2014);
        Mockito.when((Object)accountingPeriodSvcMock.getByDate(lastBilledDate)).thenReturn((Object)accountingPeriodMock_2014_12);
        BillingPeriod priorBillingPeriod = BillingPeriod.determineBillingPeriodPriorTo((Date)awardStartDate, (Date)currentDate, (Date)lastBilledDate, (ArConstants.BillingFrequencyValues)ArConstants.BillingFrequencyValues.MILESTONE, (AccountingPeriodService)accountingPeriodSvcMock);
        Assertions.assertEquals((Object)expectedBillingPeriodStart, (Object)priorBillingPeriod.getStartDate());
        Assertions.assertEquals((Object)expectedBillingPeriodEnd, (Object)priorBillingPeriod.getEndDate());
        Assertions.assertTrue((boolean)priorBillingPeriod.isBillable());
    }

    @Test
    void determineBillingPeriodPriorTo_Milestone_MayNotBillNow(@Mock(stubOnly=true) AccountingPeriodService accountingPeriodSvcMock, @Mock(stubOnly=true) AccountingPeriod accountingPeriodMock_2015_10, @Mock(stubOnly=true) AccountingPeriod accountingPeriodMock_2015_09) {
        Date awardStartDate = Date.valueOf("2014-07-01");
        Date currentDate = Date.valueOf("2015-04-21");
        Date lastBilledDate = Date.valueOf("2015-04-15");
        Mockito.when((Object)accountingPeriodMock_2015_09.getUniversityFiscalPeriodCode()).thenReturn((Object)"09");
        Mockito.when((Object)accountingPeriodSvcMock.getByPeriod("09", Integer.valueOf(2015))).thenReturn((Object)accountingPeriodMock_2015_09);
        Mockito.when((Object)accountingPeriodMock_2015_10.getUniversityFiscalPeriodCode()).thenReturn((Object)"10");
        Mockito.when((Object)accountingPeriodMock_2015_10.getUniversityFiscalYear()).thenReturn((Object)2015);
        Mockito.when((Object)accountingPeriodSvcMock.getByDate(currentDate)).thenReturn((Object)accountingPeriodMock_2015_10);
        Mockito.when((Object)accountingPeriodSvcMock.getByDate(lastBilledDate)).thenReturn((Object)accountingPeriodMock_2015_10);
        BillingPeriod priorBillingPeriod = BillingPeriod.determineBillingPeriodPriorTo((Date)awardStartDate, (Date)currentDate, (Date)lastBilledDate, (ArConstants.BillingFrequencyValues)ArConstants.BillingFrequencyValues.MILESTONE, (AccountingPeriodService)accountingPeriodSvcMock);
        Assertions.assertNull((Object)priorBillingPeriod.getStartDate());
        Assertions.assertNull((Object)priorBillingPeriod.getEndDate());
        Assertions.assertFalse((boolean)priorBillingPeriod.isBillable());
    }

    @Test
    void determineBillingPeriodPriorTo_Milestone_MayBillNowLastYear(@Mock(stubOnly=true) AccountingPeriodService accountingPeriodSvcMock, @Mock(stubOnly=true) AccountingPeriod accountingPeriodMock_2015_10, @Mock(stubOnly=true) AccountingPeriod accountingPeriodMock_2015_09, @Mock(stubOnly=true) AccountingPeriod accountingPeriodMock_2014_10, @Mock(stubOnly=true) AccountingPeriod accountingPeriodMock_2014_09) {
        Date awardStartDate = Date.valueOf("2014-03-01");
        Date currentDate = Date.valueOf("2015-04-21");
        Date lastBilledDate = Date.valueOf(ACCOUNTING_PERIOD_2014_10_END_DATE);
        Date expectedBillingPeriodStart = Date.valueOf("2014-05-01");
        Date expectedBillingPeriodEnd = Date.valueOf(ACCOUNTING_PERIOD_2015_09_END_DATE);
        Mockito.when((Object)accountingPeriodMock_2015_09.getUniversityFiscalPeriodEndDate()).thenReturn((Object)Date.valueOf(ACCOUNTING_PERIOD_2015_09_END_DATE));
        Mockito.when((Object)accountingPeriodMock_2015_09.getUniversityFiscalPeriodCode()).thenReturn((Object)"09");
        Mockito.when((Object)accountingPeriodSvcMock.getByPeriod("09", Integer.valueOf(2015))).thenReturn((Object)accountingPeriodMock_2015_09);
        Mockito.when((Object)accountingPeriodMock_2015_10.getUniversityFiscalPeriodCode()).thenReturn((Object)"10");
        Mockito.when((Object)accountingPeriodMock_2015_10.getUniversityFiscalYear()).thenReturn((Object)2015);
        Mockito.when((Object)accountingPeriodMock_2014_10.getUniversityFiscalPeriodEndDate()).thenReturn((Object)Date.valueOf(ACCOUNTING_PERIOD_2014_10_END_DATE));
        Mockito.when((Object)accountingPeriodMock_2014_10.getUniversityFiscalPeriodCode()).thenReturn((Object)"10");
        Mockito.when((Object)accountingPeriodMock_2014_10.getUniversityFiscalYear()).thenReturn((Object)2014);
        Mockito.when((Object)accountingPeriodMock_2014_09.getUniversityFiscalPeriodCode()).thenReturn((Object)"09");
        Mockito.when((Object)accountingPeriodSvcMock.getByPeriod("09", Integer.valueOf(2014))).thenReturn((Object)accountingPeriodMock_2014_09);
        Mockito.when((Object)accountingPeriodSvcMock.getByDate(currentDate)).thenReturn((Object)accountingPeriodMock_2015_10);
        Mockito.when((Object)accountingPeriodSvcMock.getByDate(lastBilledDate)).thenReturn((Object)accountingPeriodMock_2014_10);
        BillingPeriod priorBillingPeriod = BillingPeriod.determineBillingPeriodPriorTo((Date)awardStartDate, (Date)currentDate, (Date)lastBilledDate, (ArConstants.BillingFrequencyValues)ArConstants.BillingFrequencyValues.MILESTONE, (AccountingPeriodService)accountingPeriodSvcMock);
        Assertions.assertEquals((Object)expectedBillingPeriodStart, (Object)priorBillingPeriod.getStartDate());
        Assertions.assertEquals((Object)expectedBillingPeriodEnd, (Object)priorBillingPeriod.getEndDate());
        Assertions.assertTrue((boolean)priorBillingPeriod.isBillable());
    }

    @Test
    void determineBillingPeriodPriorTo_Quarterly_nullLastBilled_1(@Mock(stubOnly=true) AccountingPeriodService accountingPeriodSvcMock, @Mock(stubOnly=true) AccountingPeriod accountingPeriodMock_2015_10, @Mock(stubOnly=true) AccountingPeriod accountingPeriodMock_2015_09) {
        Date awardStartDate = Date.valueOf("2014-07-01");
        Date currentDate = Date.valueOf("2015-04-21");
        Date expectedBillingPeriodStart = Date.valueOf("2014-07-01");
        Date expectedBillingPeriodEnd = Date.valueOf(ACCOUNTING_PERIOD_2015_09_END_DATE);
        Mockito.when((Object)accountingPeriodMock_2015_09.getUniversityFiscalPeriodEndDate()).thenReturn((Object)Date.valueOf(ACCOUNTING_PERIOD_2015_09_END_DATE));
        Mockito.when((Object)accountingPeriodSvcMock.getByPeriod("09", Integer.valueOf(2015))).thenReturn((Object)accountingPeriodMock_2015_09);
        Mockito.when((Object)accountingPeriodMock_2015_10.getUniversityFiscalPeriodCode()).thenReturn((Object)"10");
        Mockito.when((Object)accountingPeriodMock_2015_10.getUniversityFiscalYear()).thenReturn((Object)2015);
        Mockito.when((Object)accountingPeriodSvcMock.getByDate(currentDate)).thenReturn((Object)accountingPeriodMock_2015_10);
        BillingPeriod priorBillingPeriod = BillingPeriod.determineBillingPeriodPriorTo((Date)awardStartDate, (Date)currentDate, null, (ArConstants.BillingFrequencyValues)ArConstants.BillingFrequencyValues.QUARTERLY, (AccountingPeriodService)accountingPeriodSvcMock);
        Assertions.assertEquals((Object)expectedBillingPeriodStart, (Object)priorBillingPeriod.getStartDate());
        Assertions.assertEquals((Object)expectedBillingPeriodEnd, (Object)priorBillingPeriod.getEndDate());
        Assertions.assertTrue((boolean)priorBillingPeriod.isBillable());
    }

    @Test
    void determineBillingPeriodPriorTo_Quarterly_nullLastBilled_2(@Mock(stubOnly=true) AccountingPeriodService accountingPeriodSvcMock, @Mock(stubOnly=true) AccountingPeriod accountingPeriodMock_2016_02, @Mock(stubOnly=true) AccountingPeriod accountingPeriodMock_2015_12) {
        Date awardStartDate = Date.valueOf("2014-07-01");
        Date currentDate = Date.valueOf("2015-08-21");
        Date expectedBillingPeriodStart = Date.valueOf("2014-07-01");
        Date expectedBillingPeriodEnd = Date.valueOf(ACCOUNTING_PERIOD_2015_12_END_DATE);
        Mockito.when((Object)accountingPeriodMock_2016_02.getUniversityFiscalPeriodCode()).thenReturn((Object)"02");
        Mockito.when((Object)accountingPeriodMock_2016_02.getUniversityFiscalYear()).thenReturn((Object)2016);
        Mockito.when((Object)accountingPeriodSvcMock.getByDate(currentDate)).thenReturn((Object)accountingPeriodMock_2016_02);
        Mockito.when((Object)accountingPeriodMock_2015_12.getUniversityFiscalPeriodEndDate()).thenReturn((Object)Date.valueOf(ACCOUNTING_PERIOD_2015_12_END_DATE));
        Mockito.when((Object)accountingPeriodSvcMock.getByPeriod("12", Integer.valueOf(2015))).thenReturn((Object)accountingPeriodMock_2015_12);
        BillingPeriod priorBillingPeriod = BillingPeriod.determineBillingPeriodPriorTo((Date)awardStartDate, (Date)currentDate, null, (ArConstants.BillingFrequencyValues)ArConstants.BillingFrequencyValues.QUARTERLY, (AccountingPeriodService)accountingPeriodSvcMock);
        Assertions.assertEquals((Object)expectedBillingPeriodStart, (Object)priorBillingPeriod.getStartDate());
        Assertions.assertEquals((Object)expectedBillingPeriodEnd, (Object)priorBillingPeriod.getEndDate());
        Assertions.assertTrue((boolean)priorBillingPeriod.isBillable());
    }

    @Test
    void determineBillingPeriodPriorTo_Quarterly_MayNotBillNow(@Mock(stubOnly=true) AccountingPeriodService accountingPeriodSvcMock, @Mock(stubOnly=true) AccountingPeriod accountingPeriodMock_2015_10, @Mock(stubOnly=true) AccountingPeriod accountingPeriodMock_2015_09) {
        Date awardStartDate = Date.valueOf("2014-07-01");
        Date currentDate = Date.valueOf("2015-04-21");
        Date lastBilledDate = Date.valueOf(ACCOUNTING_PERIOD_2015_09_END_DATE);
        Mockito.when((Object)accountingPeriodMock_2015_09.getUniversityFiscalPeriodCode()).thenReturn((Object)"09");
        Mockito.when((Object)accountingPeriodSvcMock.getByPeriod("09", Integer.valueOf(2015))).thenReturn((Object)accountingPeriodMock_2015_09);
        Mockito.when((Object)accountingPeriodMock_2015_10.getUniversityFiscalPeriodCode()).thenReturn((Object)"10");
        Mockito.when((Object)accountingPeriodMock_2015_10.getUniversityFiscalYear()).thenReturn((Object)2015);
        Mockito.when((Object)accountingPeriodSvcMock.getByDate(currentDate)).thenReturn((Object)accountingPeriodMock_2015_10);
        Mockito.when((Object)accountingPeriodMock_2015_10.getUniversityFiscalPeriodCode()).thenReturn((Object)"10");
        Mockito.when((Object)accountingPeriodMock_2015_10.getUniversityFiscalYear()).thenReturn((Object)2015);
        Mockito.when((Object)accountingPeriodSvcMock.getByDate(lastBilledDate)).thenReturn((Object)accountingPeriodMock_2015_10);
        BillingPeriod priorBillingPeriod = BillingPeriod.determineBillingPeriodPriorTo((Date)awardStartDate, (Date)currentDate, (Date)lastBilledDate, (ArConstants.BillingFrequencyValues)ArConstants.BillingFrequencyValues.QUARTERLY, (AccountingPeriodService)accountingPeriodSvcMock);
        Assertions.assertNull((Object)priorBillingPeriod.getStartDate());
        Assertions.assertNull((Object)priorBillingPeriod.getEndDate());
        Assertions.assertFalse((boolean)priorBillingPeriod.isBillable());
    }

    @Test
    void determineBillingPeriodPriorTo_Quarterly_LastBilledEarlierQuarter(@Mock(stubOnly=true) AccountingPeriodService accountingPeriodSvcMock, @Mock(stubOnly=true) AccountingPeriod accountingPeriodMock_2015_09, @Mock(stubOnly=true) AccountingPeriod accountingPeriodMock_2015_10, @Mock(stubOnly=true) AccountingPeriod accountingPeriodMock_2015_12, @Mock(stubOnly=true) AccountingPeriod accountingPeriodMock_2016_02) {
        Date awardStartDate = Date.valueOf("2014-07-01");
        Date currentDate = Date.valueOf("2015-08-21");
        Date lastBilledDate = Date.valueOf(ACCOUNTING_PERIOD_2015_09_END_DATE);
        Date expectedBillingPeriodStart = Date.valueOf("2015-04-01");
        Date expectedBillingPeriodEnd = Date.valueOf(ACCOUNTING_PERIOD_2015_12_END_DATE);
        Mockito.when((Object)accountingPeriodMock_2015_09.getUniversityFiscalPeriodEndDate()).thenReturn((Object)Date.valueOf(ACCOUNTING_PERIOD_2015_09_END_DATE));
        Mockito.when((Object)accountingPeriodMock_2015_09.getUniversityFiscalPeriodCode()).thenReturn((Object)"09");
        Mockito.when((Object)accountingPeriodSvcMock.getByPeriod("09", Integer.valueOf(2015))).thenReturn((Object)accountingPeriodMock_2015_09);
        Mockito.when((Object)accountingPeriodMock_2015_12.getUniversityFiscalPeriodEndDate()).thenReturn((Object)Date.valueOf(ACCOUNTING_PERIOD_2015_12_END_DATE));
        Mockito.when((Object)accountingPeriodMock_2015_12.getUniversityFiscalPeriodCode()).thenReturn((Object)"12");
        Mockito.when((Object)accountingPeriodSvcMock.getByPeriod("12", Integer.valueOf(2015))).thenReturn((Object)accountingPeriodMock_2015_12);
        Mockito.when((Object)accountingPeriodMock_2016_02.getUniversityFiscalPeriodCode()).thenReturn((Object)"02");
        Mockito.when((Object)accountingPeriodMock_2016_02.getUniversityFiscalYear()).thenReturn((Object)2016);
        Mockito.when((Object)accountingPeriodSvcMock.getByDate(currentDate)).thenReturn((Object)accountingPeriodMock_2016_02);
        Mockito.when((Object)accountingPeriodMock_2015_10.getUniversityFiscalPeriodCode()).thenReturn((Object)"10");
        Mockito.when((Object)accountingPeriodMock_2015_10.getUniversityFiscalYear()).thenReturn((Object)2015);
        Mockito.when((Object)accountingPeriodSvcMock.getByDate(lastBilledDate)).thenReturn((Object)accountingPeriodMock_2015_10);
        BillingPeriod priorBillingPeriod = BillingPeriod.determineBillingPeriodPriorTo((Date)awardStartDate, (Date)currentDate, (Date)lastBilledDate, (ArConstants.BillingFrequencyValues)ArConstants.BillingFrequencyValues.QUARTERLY, (AccountingPeriodService)accountingPeriodSvcMock);
        Assertions.assertEquals((Object)expectedBillingPeriodStart, (Object)priorBillingPeriod.getStartDate());
        Assertions.assertEquals((Object)expectedBillingPeriodEnd, (Object)priorBillingPeriod.getEndDate());
        Assertions.assertTrue((boolean)priorBillingPeriod.isBillable());
    }

    @Test
    void determineBillingPeriodPriorTo_Quarterly_LastBilledPreviousQuarter(@Mock(stubOnly=true) AccountingPeriodService accountingPeriodSvcMock, @Mock(stubOnly=true) AccountingPeriod accountingPeriodMock_2015_10, @Mock(stubOnly=true) AccountingPeriod accountingPeriodMock_2015_09, @Mock(stubOnly=true) AccountingPeriod accountingPeriodMock_2015_06) {
        Date awardStartDate = Date.valueOf("2014-07-01");
        Date currentDate = Date.valueOf("2015-04-21");
        Date lastBilledDate = Date.valueOf(ACCOUNTING_PERIOD_2015_09_END_DATE);
        Date expectedBillingPeriodStart = Date.valueOf("2015-01-01");
        Date expectedBillingPeriodEnd = Date.valueOf(ACCOUNTING_PERIOD_2015_09_END_DATE);
        Mockito.when((Object)accountingPeriodMock_2015_06.getUniversityFiscalPeriodEndDate()).thenReturn((Object)Date.valueOf(ACCOUNTING_PERIOD_2015_06_END_DATE));
        Mockito.when((Object)accountingPeriodMock_2015_06.getUniversityFiscalPeriodCode()).thenReturn((Object)"06");
        Mockito.when((Object)accountingPeriodSvcMock.getByPeriod("06", Integer.valueOf(2015))).thenReturn((Object)accountingPeriodMock_2015_06);
        Mockito.when((Object)accountingPeriodMock_2015_10.getUniversityFiscalPeriodCode()).thenReturn((Object)"10");
        Mockito.when((Object)accountingPeriodMock_2015_10.getUniversityFiscalYear()).thenReturn((Object)2015);
        Mockito.when((Object)accountingPeriodSvcMock.getByDate(currentDate)).thenReturn((Object)accountingPeriodMock_2015_10);
        Mockito.when((Object)accountingPeriodMock_2015_09.getUniversityFiscalPeriodEndDate()).thenReturn((Object)Date.valueOf(ACCOUNTING_PERIOD_2015_09_END_DATE));
        Mockito.when((Object)accountingPeriodMock_2015_09.getUniversityFiscalPeriodCode()).thenReturn((Object)"09");
        Mockito.when((Object)accountingPeriodMock_2015_09.getUniversityFiscalYear()).thenReturn((Object)2015);
        Mockito.when((Object)accountingPeriodSvcMock.getByPeriod("09", Integer.valueOf(2015))).thenReturn((Object)accountingPeriodMock_2015_09);
        Mockito.when((Object)accountingPeriodSvcMock.getByDate(lastBilledDate)).thenReturn((Object)accountingPeriodMock_2015_09);
        BillingPeriod priorBillingPeriod = BillingPeriod.determineBillingPeriodPriorTo((Date)awardStartDate, (Date)currentDate, (Date)lastBilledDate, (ArConstants.BillingFrequencyValues)ArConstants.BillingFrequencyValues.QUARTERLY, (AccountingPeriodService)accountingPeriodSvcMock);
        Assertions.assertEquals((Object)expectedBillingPeriodStart, (Object)priorBillingPeriod.getStartDate());
        Assertions.assertEquals((Object)expectedBillingPeriodEnd, (Object)priorBillingPeriod.getEndDate());
        Assertions.assertTrue((boolean)priorBillingPeriod.isBillable());
    }

    @Test
    void determineBillingPeriodPriorTo_Quarterly_BillAwardInFuture(@Mock(stubOnly=true) AccountingPeriodService accountingPeriodSvcMock, @Mock(stubOnly=true) AccountingPeriod accountingPeriodMock_2015_10, @Mock(stubOnly=true) AccountingPeriod accountingPeriodMock_2015_09, @Mock(stubOnly=true) AccountingPeriod accountingPeriodMock_2015_06) {
        Date awardStartDate = Date.valueOf("2015-07-01");
        Date currentDate = Date.valueOf("2015-04-21");
        Date previousPeriodEndDate = Date.valueOf(ACCOUNTING_PERIOD_2015_09_END_DATE);
        Date expectedBillingPeriodStart = Date.valueOf("2015-01-01");
        Date expectedBillingPeriodEnd = Date.valueOf(ACCOUNTING_PERIOD_2015_09_END_DATE);
        Mockito.when((Object)accountingPeriodMock_2015_06.getUniversityFiscalPeriodEndDate()).thenReturn((Object)Date.valueOf(ACCOUNTING_PERIOD_2015_06_END_DATE));
        Mockito.when((Object)accountingPeriodSvcMock.getByPeriod("06", Integer.valueOf(2015))).thenReturn((Object)accountingPeriodMock_2015_06);
        Mockito.when((Object)accountingPeriodMock_2015_10.getUniversityFiscalPeriodCode()).thenReturn((Object)"10");
        Mockito.when((Object)accountingPeriodMock_2015_10.getUniversityFiscalYear()).thenReturn((Object)2015);
        Mockito.when((Object)accountingPeriodSvcMock.getByDate(currentDate)).thenReturn((Object)accountingPeriodMock_2015_10);
        Mockito.when((Object)accountingPeriodMock_2015_09.getUniversityFiscalPeriodEndDate()).thenReturn((Object)Date.valueOf(ACCOUNTING_PERIOD_2015_09_END_DATE));
        Mockito.when((Object)accountingPeriodMock_2015_09.getUniversityFiscalPeriodCode()).thenReturn((Object)"09");
        Mockito.when((Object)accountingPeriodMock_2015_09.getUniversityFiscalYear()).thenReturn((Object)2015);
        Mockito.when((Object)accountingPeriodSvcMock.getByPeriod("09", Integer.valueOf(2015))).thenReturn((Object)accountingPeriodMock_2015_09);
        Mockito.when((Object)accountingPeriodSvcMock.getByDate(previousPeriodEndDate)).thenReturn((Object)accountingPeriodMock_2015_09);
        BillingPeriod priorBillingPeriod = BillingPeriod.determineBillingPeriodPriorTo((Date)awardStartDate, (Date)currentDate, null, (ArConstants.BillingFrequencyValues)ArConstants.BillingFrequencyValues.QUARTERLY, (AccountingPeriodService)accountingPeriodSvcMock);
        Assertions.assertEquals((Object)expectedBillingPeriodStart, (Object)priorBillingPeriod.getStartDate());
        Assertions.assertEquals((Object)expectedBillingPeriodEnd, (Object)priorBillingPeriod.getEndDate());
        Assertions.assertTrue((boolean)priorBillingPeriod.isBillable());
    }

    @Test
    void determineBillingPeriodPriorTo_Quarterly_BilledLastCalendarYear(@Mock(stubOnly=true) AccountingPeriodService accountingPeriodSvcMock, @Mock(stubOnly=true) AccountingPeriod accountingPeriodMock_2015_10, @Mock(stubOnly=true) AccountingPeriod accountingPeriodMock_2015_09, @Mock(stubOnly=true) AccountingPeriod accountingPeriodMock_2015_05, @Mock(stubOnly=true) AccountingPeriod accountingPeriodMock_2015_03) {
        Date awardStartDate = Date.valueOf("2014-07-01");
        Date currentDate = Date.valueOf("2015-04-21");
        Date lastBilledDate = Date.valueOf(ACCOUNTING_PERIOD_2015_03_END_DATE);
        Date expectedBillingPeriodStart = Date.valueOf("2014-10-01");
        Date expectedBillingPeriodEnd = Date.valueOf(ACCOUNTING_PERIOD_2015_09_END_DATE);
        Mockito.when((Object)accountingPeriodMock_2015_03.getUniversityFiscalPeriodEndDate()).thenReturn((Object)Date.valueOf(ACCOUNTING_PERIOD_2015_03_END_DATE));
        Mockito.when((Object)accountingPeriodMock_2015_03.getUniversityFiscalPeriodCode()).thenReturn((Object)"03");
        Mockito.when((Object)accountingPeriodSvcMock.getByPeriod("03", Integer.valueOf(2015))).thenReturn((Object)accountingPeriodMock_2015_03);
        Mockito.when((Object)accountingPeriodMock_2015_09.getUniversityFiscalPeriodEndDate()).thenReturn((Object)Date.valueOf(ACCOUNTING_PERIOD_2015_09_END_DATE));
        Mockito.when((Object)accountingPeriodMock_2015_09.getUniversityFiscalPeriodCode()).thenReturn((Object)"09");
        Mockito.when((Object)accountingPeriodSvcMock.getByPeriod("09", Integer.valueOf(2015))).thenReturn((Object)accountingPeriodMock_2015_09);
        Mockito.when((Object)accountingPeriodMock_2015_10.getUniversityFiscalPeriodCode()).thenReturn((Object)"10");
        Mockito.when((Object)accountingPeriodMock_2015_10.getUniversityFiscalYear()).thenReturn((Object)2015);
        Mockito.when((Object)accountingPeriodSvcMock.getByDate(currentDate)).thenReturn((Object)accountingPeriodMock_2015_10);
        Mockito.when((Object)accountingPeriodMock_2015_05.getUniversityFiscalPeriodCode()).thenReturn((Object)"05");
        Mockito.when((Object)accountingPeriodMock_2015_05.getUniversityFiscalYear()).thenReturn((Object)2015);
        Mockito.when((Object)accountingPeriodSvcMock.getByDate(lastBilledDate)).thenReturn((Object)accountingPeriodMock_2015_05);
        BillingPeriod priorBillingPeriod = BillingPeriod.determineBillingPeriodPriorTo((Date)awardStartDate, (Date)currentDate, (Date)lastBilledDate, (ArConstants.BillingFrequencyValues)ArConstants.BillingFrequencyValues.QUARTERLY, (AccountingPeriodService)accountingPeriodSvcMock);
        Assertions.assertEquals((Object)expectedBillingPeriodStart, (Object)priorBillingPeriod.getStartDate());
        Assertions.assertEquals((Object)expectedBillingPeriodEnd, (Object)priorBillingPeriod.getEndDate());
        Assertions.assertTrue((boolean)priorBillingPeriod.isBillable());
    }

    @Test
    void determineBillingPeriodPriorTo_Quarterly_BilledLastFiscalYear(@Mock(stubOnly=true) AccountingPeriodService accountingPeriodSvcMock, @Mock(stubOnly=true) AccountingPeriod accountingPeriodMock_2014_09, @Mock(stubOnly=true) AccountingPeriod accountingPeriodMock_2015_09, @Mock(stubOnly=true) AccountingPeriod accountingPeriodMock_2015_10, @Mock(stubOnly=true) AccountingPeriod accountingPeriodMock_2014_12) {
        Date awardStartDate = Date.valueOf("2013-07-01");
        Date currentDate = Date.valueOf("2015-04-21");
        Date lastBilledDate = Date.valueOf(ACCOUNTING_PERIOD_2014_09_END_DATE);
        Date expectedBillingPeriodStart = Date.valueOf("2014-04-01");
        Date expectedBillingPeriodEnd = Date.valueOf(ACCOUNTING_PERIOD_2015_09_END_DATE);
        Mockito.when((Object)accountingPeriodMock_2014_09.getUniversityFiscalPeriodEndDate()).thenReturn((Object)Date.valueOf(ACCOUNTING_PERIOD_2014_09_END_DATE));
        Mockito.when((Object)accountingPeriodMock_2014_09.getUniversityFiscalPeriodCode()).thenReturn((Object)"09");
        Mockito.when((Object)accountingPeriodSvcMock.getByPeriod("09", Integer.valueOf(2014))).thenReturn((Object)accountingPeriodMock_2014_09);
        Mockito.when((Object)accountingPeriodMock_2015_09.getUniversityFiscalPeriodEndDate()).thenReturn((Object)Date.valueOf(ACCOUNTING_PERIOD_2015_09_END_DATE));
        Mockito.when((Object)accountingPeriodMock_2015_09.getUniversityFiscalPeriodCode()).thenReturn((Object)"09");
        Mockito.when((Object)accountingPeriodSvcMock.getByPeriod("09", Integer.valueOf(2015))).thenReturn((Object)accountingPeriodMock_2015_09);
        Mockito.when((Object)accountingPeriodMock_2015_10.getUniversityFiscalPeriodCode()).thenReturn((Object)"10");
        Mockito.when((Object)accountingPeriodMock_2015_10.getUniversityFiscalYear()).thenReturn((Object)2015);
        Mockito.when((Object)accountingPeriodSvcMock.getByDate(currentDate)).thenReturn((Object)accountingPeriodMock_2015_10);
        Mockito.when((Object)accountingPeriodMock_2014_12.getUniversityFiscalPeriodCode()).thenReturn((Object)"12");
        Mockito.when((Object)accountingPeriodMock_2014_12.getUniversityFiscalYear()).thenReturn((Object)2014);
        Mockito.when((Object)accountingPeriodSvcMock.getByDate(lastBilledDate)).thenReturn((Object)accountingPeriodMock_2014_12);
        BillingPeriod priorBillingPeriod = BillingPeriod.determineBillingPeriodPriorTo((Date)awardStartDate, (Date)currentDate, (Date)lastBilledDate, (ArConstants.BillingFrequencyValues)ArConstants.BillingFrequencyValues.QUARTERLY, (AccountingPeriodService)accountingPeriodSvcMock);
        Assertions.assertEquals((Object)expectedBillingPeriodStart, (Object)priorBillingPeriod.getStartDate());
        Assertions.assertEquals((Object)expectedBillingPeriodEnd, (Object)priorBillingPeriod.getEndDate());
        Assertions.assertTrue((boolean)priorBillingPeriod.isBillable());
    }

    @Test
    void determineBillingPeriodPriorTo_SemiAnnual_nullLastBilled1(@Mock(stubOnly=true) AccountingPeriodService accountingPeriodSvcMock, @Mock(stubOnly=true) AccountingPeriod accountingPeriodMock_2015_10, @Mock(stubOnly=true) AccountingPeriod accountingPeriodMock_2015_06, @Mock(stubOnly=true) AccountingPeriod accountingPeriodMock_2014_09) {
        Date awardStartDate = Date.valueOf("2014-07-01");
        Date currentDate = Date.valueOf("2015-04-21");
        Date expectedBillingPeriodStart = Date.valueOf("2014-07-01");
        Date expectedBillingPeriodEnd = Date.valueOf(ACCOUNTING_PERIOD_2015_06_END_DATE);
        Mockito.when((Object)accountingPeriodMock_2015_06.getUniversityFiscalPeriodEndDate()).thenReturn((Object)Date.valueOf(ACCOUNTING_PERIOD_2015_06_END_DATE));
        Mockito.when((Object)accountingPeriodSvcMock.getByPeriod("06", Integer.valueOf(2015))).thenReturn((Object)accountingPeriodMock_2015_06);
        Mockito.when((Object)accountingPeriodSvcMock.getByDate(currentDate)).thenReturn((Object)accountingPeriodMock_2014_09);
        Mockito.when((Object)accountingPeriodMock_2015_10.getUniversityFiscalPeriodCode()).thenReturn((Object)"10");
        Mockito.when((Object)accountingPeriodMock_2015_10.getUniversityFiscalYear()).thenReturn((Object)2015);
        Mockito.when((Object)accountingPeriodSvcMock.getByDate(currentDate)).thenReturn((Object)accountingPeriodMock_2015_10);
        BillingPeriod priorBillingPeriod = BillingPeriod.determineBillingPeriodPriorTo((Date)awardStartDate, (Date)currentDate, null, (ArConstants.BillingFrequencyValues)ArConstants.BillingFrequencyValues.SEMI_ANNUALLY, (AccountingPeriodService)accountingPeriodSvcMock);
        Assertions.assertEquals((Object)expectedBillingPeriodStart, (Object)priorBillingPeriod.getStartDate());
        Assertions.assertEquals((Object)expectedBillingPeriodEnd, (Object)priorBillingPeriod.getEndDate());
        Assertions.assertTrue((boolean)priorBillingPeriod.isBillable());
    }

    @Test
    void determineBillingPeriodPriorTo_SemiAnnual_nullLastBilled2(@Mock(stubOnly=true) AccountingPeriodService accountingPeriodSvcMock, @Mock(stubOnly=true) AccountingPeriod accountingPeriodMock_2016_02, @Mock(stubOnly=true) AccountingPeriod accountingPeriodMock_2015_12) {
        Date awardStartDate = Date.valueOf("2014-07-01");
        Date currentDate = Date.valueOf("2015-08-21");
        Date expectedBillingPeriodStart = Date.valueOf("2014-07-01");
        Date expectedBillingPeriodEnd = Date.valueOf(ACCOUNTING_PERIOD_2015_12_END_DATE);
        Mockito.when((Object)accountingPeriodMock_2015_12.getUniversityFiscalPeriodEndDate()).thenReturn((Object)Date.valueOf(ACCOUNTING_PERIOD_2015_12_END_DATE));
        Mockito.when((Object)accountingPeriodSvcMock.getByPeriod("12", Integer.valueOf(2015))).thenReturn((Object)accountingPeriodMock_2015_12);
        Mockito.when((Object)accountingPeriodMock_2016_02.getUniversityFiscalPeriodCode()).thenReturn((Object)"02");
        Mockito.when((Object)accountingPeriodMock_2016_02.getUniversityFiscalYear()).thenReturn((Object)2016);
        Mockito.when((Object)accountingPeriodSvcMock.getByDate(currentDate)).thenReturn((Object)accountingPeriodMock_2016_02);
        BillingPeriod priorBillingPeriod = BillingPeriod.determineBillingPeriodPriorTo((Date)awardStartDate, (Date)currentDate, null, (ArConstants.BillingFrequencyValues)ArConstants.BillingFrequencyValues.SEMI_ANNUALLY, (AccountingPeriodService)accountingPeriodSvcMock);
        Assertions.assertEquals((Object)expectedBillingPeriodStart, (Object)priorBillingPeriod.getStartDate());
        Assertions.assertEquals((Object)expectedBillingPeriodEnd, (Object)priorBillingPeriod.getEndDate());
        Assertions.assertTrue((boolean)priorBillingPeriod.isBillable());
    }

    @Test
    void determineBillingPeriodPriorTo_SemiAnnual_MayNotBillNow(@Mock(stubOnly=true) AccountingPeriodService accountingPeriodSvcMock, @Mock(stubOnly=true) AccountingPeriod accountingPeriodMock_2015_10, @Mock(stubOnly=true) AccountingPeriod accountingPeriodMock_2015_06) {
        Date awardStartDate = Date.valueOf("2014-07-01");
        Date currentDate = Date.valueOf("2015-04-21");
        Date lastBilledDate = Date.valueOf(ACCOUNTING_PERIOD_2015_06_END_DATE);
        Mockito.when((Object)accountingPeriodMock_2015_06.getUniversityFiscalPeriodCode()).thenReturn((Object)"06");
        Mockito.when((Object)accountingPeriodSvcMock.getByPeriod("06", Integer.valueOf(2015))).thenReturn((Object)accountingPeriodMock_2015_06);
        Mockito.when((Object)accountingPeriodMock_2015_10.getUniversityFiscalPeriodCode()).thenReturn((Object)"10");
        Mockito.when((Object)accountingPeriodMock_2015_10.getUniversityFiscalYear()).thenReturn((Object)2015);
        Mockito.when((Object)accountingPeriodSvcMock.getByDate(currentDate)).thenReturn((Object)accountingPeriodMock_2015_10);
        Mockito.when((Object)accountingPeriodMock_2015_10.getUniversityFiscalPeriodCode()).thenReturn((Object)"10");
        Mockito.when((Object)accountingPeriodMock_2015_10.getUniversityFiscalYear()).thenReturn((Object)2015);
        Mockito.when((Object)accountingPeriodSvcMock.getByDate(lastBilledDate)).thenReturn((Object)accountingPeriodMock_2015_10);
        BillingPeriod priorBillingPeriod = BillingPeriod.determineBillingPeriodPriorTo((Date)awardStartDate, (Date)currentDate, (Date)lastBilledDate, (ArConstants.BillingFrequencyValues)ArConstants.BillingFrequencyValues.SEMI_ANNUALLY, (AccountingPeriodService)accountingPeriodSvcMock);
        Assertions.assertNull((Object)priorBillingPeriod.getStartDate());
        Assertions.assertNull((Object)priorBillingPeriod.getEndDate());
        Assertions.assertFalse((boolean)priorBillingPeriod.isBillable());
    }

    @Test
    void determineBillingPeriodPriorTo_SemiAnnual_LastBilledPreviousSemiAnnual(@Mock(stubOnly=true) AccountingPeriodService accountingPeriodSvcMock, @Mock(stubOnly=true) AccountingPeriod accountingPeriodMock_2015_06, @Mock(stubOnly=true) AccountingPeriod accountingPeriodMock_2015_12, @Mock(stubOnly=true) AccountingPeriod accountingPeriodMock_2015_10, @Mock(stubOnly=true) AccountingPeriod accountingPeriodMock_2016_02) {
        Date awardStartDate = Date.valueOf("2014-07-01");
        Date currentDate = Date.valueOf("2015-08-21");
        Date lastBilledDate = Date.valueOf(ACCOUNTING_PERIOD_2015_06_END_DATE);
        Date expectedBillingPeriodStart = Date.valueOf("2015-01-01");
        Date expectedBillingPeriodEnd = Date.valueOf(ACCOUNTING_PERIOD_2015_12_END_DATE);
        Mockito.when((Object)accountingPeriodMock_2015_06.getUniversityFiscalPeriodEndDate()).thenReturn((Object)Date.valueOf(ACCOUNTING_PERIOD_2015_06_END_DATE));
        Mockito.when((Object)accountingPeriodMock_2015_06.getUniversityFiscalPeriodCode()).thenReturn((Object)"06");
        Mockito.when((Object)accountingPeriodSvcMock.getByPeriod("06", Integer.valueOf(2015))).thenReturn((Object)accountingPeriodMock_2015_06);
        Mockito.when((Object)accountingPeriodMock_2015_12.getUniversityFiscalPeriodEndDate()).thenReturn((Object)Date.valueOf(ACCOUNTING_PERIOD_2015_12_END_DATE));
        Mockito.when((Object)accountingPeriodMock_2015_12.getUniversityFiscalPeriodCode()).thenReturn((Object)"12");
        Mockito.when((Object)accountingPeriodSvcMock.getByPeriod("12", Integer.valueOf(2015))).thenReturn((Object)accountingPeriodMock_2015_12);
        Mockito.when((Object)accountingPeriodMock_2016_02.getUniversityFiscalPeriodCode()).thenReturn((Object)"02");
        Mockito.when((Object)accountingPeriodMock_2016_02.getUniversityFiscalYear()).thenReturn((Object)2016);
        Mockito.when((Object)accountingPeriodSvcMock.getByDate(currentDate)).thenReturn((Object)accountingPeriodMock_2016_02);
        Mockito.when((Object)accountingPeriodMock_2015_10.getUniversityFiscalPeriodCode()).thenReturn((Object)"10");
        Mockito.when((Object)accountingPeriodMock_2015_10.getUniversityFiscalYear()).thenReturn((Object)2015);
        Mockito.when((Object)accountingPeriodSvcMock.getByDate(lastBilledDate)).thenReturn((Object)accountingPeriodMock_2015_10);
        BillingPeriod priorBillingPeriod = BillingPeriod.determineBillingPeriodPriorTo((Date)awardStartDate, (Date)currentDate, (Date)lastBilledDate, (ArConstants.BillingFrequencyValues)ArConstants.BillingFrequencyValues.SEMI_ANNUALLY, (AccountingPeriodService)accountingPeriodSvcMock);
        Assertions.assertEquals((Object)expectedBillingPeriodStart, (Object)priorBillingPeriod.getStartDate());
        Assertions.assertEquals((Object)expectedBillingPeriodEnd, (Object)priorBillingPeriod.getEndDate());
        Assertions.assertTrue((boolean)priorBillingPeriod.isBillable());
    }

    @Test
    void determineBillingPeriodPriorTo_SemiAnnual_LastBilledEarlierSemiAnnual(@Mock(stubOnly=true) AccountingPeriodService accountingPeriodSvcMock, @Mock(stubOnly=true) AccountingPeriod accountingPeriodMock_2015_10, @Mock(stubOnly=true) AccountingPeriod accountingPeriodMock_2015_05, @Mock(stubOnly=true) AccountingPeriod accountingPeriodMock_2015_06, @Mock(stubOnly=true) AccountingPeriod accountingPeriodMock_2014_12) {
        Date awardStartDate = Date.valueOf("2013-07-01");
        Date currentDate = Date.valueOf("2015-04-21");
        Date lastBilledDate = Date.valueOf(ACCOUNTING_PERIOD_2014_12_END_DATE);
        Date expectedBillingPeriodStart = Date.valueOf("2014-07-01");
        Date expectedBillingPeriodEnd = Date.valueOf(ACCOUNTING_PERIOD_2015_06_END_DATE);
        Mockito.when((Object)accountingPeriodMock_2014_12.getUniversityFiscalPeriodEndDate()).thenReturn((Object)Date.valueOf(ACCOUNTING_PERIOD_2014_12_END_DATE));
        Mockito.when((Object)accountingPeriodMock_2014_12.getUniversityFiscalPeriodCode()).thenReturn((Object)"12");
        Mockito.when((Object)accountingPeriodSvcMock.getByPeriod("12", Integer.valueOf(2014))).thenReturn((Object)accountingPeriodMock_2014_12);
        Mockito.when((Object)accountingPeriodMock_2015_06.getUniversityFiscalPeriodEndDate()).thenReturn((Object)Date.valueOf(ACCOUNTING_PERIOD_2015_06_END_DATE));
        Mockito.when((Object)accountingPeriodMock_2015_06.getUniversityFiscalPeriodCode()).thenReturn((Object)"06");
        Mockito.when((Object)accountingPeriodSvcMock.getByPeriod("06", Integer.valueOf(2015))).thenReturn((Object)accountingPeriodMock_2015_06);
        Mockito.when((Object)accountingPeriodMock_2015_10.getUniversityFiscalPeriodCode()).thenReturn((Object)"10");
        Mockito.when((Object)accountingPeriodMock_2015_10.getUniversityFiscalYear()).thenReturn((Object)2015);
        Mockito.when((Object)accountingPeriodSvcMock.getByDate(currentDate)).thenReturn((Object)accountingPeriodMock_2015_10);
        Mockito.when((Object)accountingPeriodMock_2015_05.getUniversityFiscalPeriodCode()).thenReturn((Object)"05");
        Mockito.when((Object)accountingPeriodMock_2015_05.getUniversityFiscalYear()).thenReturn((Object)2015);
        Mockito.when((Object)accountingPeriodSvcMock.getByDate(lastBilledDate)).thenReturn((Object)accountingPeriodMock_2015_05);
        BillingPeriod priorBillingPeriod = BillingPeriod.determineBillingPeriodPriorTo((Date)awardStartDate, (Date)currentDate, (Date)lastBilledDate, (ArConstants.BillingFrequencyValues)ArConstants.BillingFrequencyValues.SEMI_ANNUALLY, (AccountingPeriodService)accountingPeriodSvcMock);
        Assertions.assertEquals((Object)expectedBillingPeriodStart, (Object)priorBillingPeriod.getStartDate());
        Assertions.assertEquals((Object)expectedBillingPeriodEnd, (Object)priorBillingPeriod.getEndDate());
        Assertions.assertTrue((boolean)priorBillingPeriod.isBillable());
    }

    @Test
    void determineBillingPeriodPriorTo_SemiAnnual_BillAwardInFuture(@Mock(stubOnly=true) AccountingPeriodService accountingPeriodSvcMock, @Mock(stubOnly=true) AccountingPeriod accountingPeriodMock_2015_10, @Mock(stubOnly=true) AccountingPeriod accountingPeriodMock_2015_06, @Mock(stubOnly=true) AccountingPeriod accountingPeriodMock_2014_12) {
        Date awardStartDate = Date.valueOf("2015-07-01");
        Date currentDate = Date.valueOf("2015-04-21");
        Date previousPeriodEndDate = Date.valueOf(ACCOUNTING_PERIOD_2015_06_END_DATE);
        Date expectedBillingPeriodStart = Date.valueOf("2014-07-01");
        Date expectedBillingPeriodEnd = Date.valueOf(ACCOUNTING_PERIOD_2015_06_END_DATE);
        Mockito.when((Object)accountingPeriodMock_2014_12.getUniversityFiscalPeriodEndDate()).thenReturn((Object)Date.valueOf(ACCOUNTING_PERIOD_2014_12_END_DATE));
        Mockito.when((Object)accountingPeriodSvcMock.getByPeriod("12", Integer.valueOf(2014))).thenReturn((Object)accountingPeriodMock_2014_12);
        Mockito.when((Object)accountingPeriodMock_2015_10.getUniversityFiscalPeriodCode()).thenReturn((Object)"10");
        Mockito.when((Object)accountingPeriodMock_2015_10.getUniversityFiscalYear()).thenReturn((Object)2015);
        Mockito.when((Object)accountingPeriodSvcMock.getByDate(currentDate)).thenReturn((Object)accountingPeriodMock_2015_10);
        Mockito.when((Object)accountingPeriodMock_2015_06.getUniversityFiscalPeriodEndDate()).thenReturn((Object)Date.valueOf(ACCOUNTING_PERIOD_2015_06_END_DATE));
        Mockito.when((Object)accountingPeriodMock_2015_06.getUniversityFiscalPeriodCode()).thenReturn((Object)"06");
        Mockito.when((Object)accountingPeriodMock_2015_06.getUniversityFiscalYear()).thenReturn((Object)2015);
        Mockito.when((Object)accountingPeriodSvcMock.getByPeriod("06", Integer.valueOf(2015))).thenReturn((Object)accountingPeriodMock_2015_06);
        Mockito.when((Object)accountingPeriodSvcMock.getByDate(previousPeriodEndDate)).thenReturn((Object)accountingPeriodMock_2015_06);
        BillingPeriod priorBillingPeriod = BillingPeriod.determineBillingPeriodPriorTo((Date)awardStartDate, (Date)currentDate, null, (ArConstants.BillingFrequencyValues)ArConstants.BillingFrequencyValues.SEMI_ANNUALLY, (AccountingPeriodService)accountingPeriodSvcMock);
        Assertions.assertEquals((Object)expectedBillingPeriodStart, (Object)priorBillingPeriod.getStartDate());
        Assertions.assertEquals((Object)expectedBillingPeriodEnd, (Object)priorBillingPeriod.getEndDate());
        Assertions.assertTrue((boolean)priorBillingPeriod.isBillable());
    }

    @Test
    void determineBillingPeriodPriorTo_Annual_nullLastBilled1(@Mock(stubOnly=true) AccountingPeriodService accountingPeriodSvcMock, @Mock(stubOnly=true) AccountingPeriod accountingPeriodMock_2016_02, @Mock(stubOnly=true) AccountingPeriod accountingPeriodMock_2015_12) {
        Date awardStartDate = Date.valueOf("2014-07-01");
        Date currentDate = Date.valueOf("2015-08-21");
        Date expectedBillingPeriodStart = Date.valueOf("2014-07-01");
        Date expectedBillingPeriodEnd = Date.valueOf(ACCOUNTING_PERIOD_2015_12_END_DATE);
        Mockito.when((Object)accountingPeriodMock_2015_12.getUniversityFiscalPeriodEndDate()).thenReturn((Object)Date.valueOf(ACCOUNTING_PERIOD_2015_12_END_DATE));
        Mockito.when((Object)accountingPeriodSvcMock.getByPeriod("12", Integer.valueOf(2015))).thenReturn((Object)accountingPeriodMock_2015_12);
        Mockito.when((Object)accountingPeriodMock_2016_02.getUniversityFiscalPeriodCode()).thenReturn((Object)"02");
        Mockito.when((Object)accountingPeriodMock_2016_02.getUniversityFiscalYear()).thenReturn((Object)2016);
        Mockito.when((Object)accountingPeriodSvcMock.getByDate(currentDate)).thenReturn((Object)accountingPeriodMock_2016_02);
        BillingPeriod priorBillingPeriod = BillingPeriod.determineBillingPeriodPriorTo((Date)awardStartDate, (Date)currentDate, null, (ArConstants.BillingFrequencyValues)ArConstants.BillingFrequencyValues.ANNUALLY, (AccountingPeriodService)accountingPeriodSvcMock);
        Assertions.assertEquals((Object)expectedBillingPeriodStart, (Object)priorBillingPeriod.getStartDate());
        Assertions.assertEquals((Object)expectedBillingPeriodEnd, (Object)priorBillingPeriod.getEndDate());
        Assertions.assertTrue((boolean)priorBillingPeriod.isBillable());
    }

    @Test
    void determineBillingPeriodPriorTo_Annual_MayNotBillNow(@Mock(stubOnly=true) AccountingPeriodService accountingPeriodSvcMock, @Mock(stubOnly=true) AccountingPeriod accountingPeriodMock_2015_12, @Mock(stubOnly=true) AccountingPeriod accountingPeriodMock_2015_04) {
        Date awardStartDate = Date.valueOf("2013-07-01");
        Date currentDate = Date.valueOf("2015-06-21");
        Date lastBilledDate = Date.valueOf(ACCOUNTING_PERIOD_2014_12_END_DATE);
        Mockito.when((Object)accountingPeriodMock_2015_12.getUniversityFiscalYear()).thenReturn((Object)2015);
        Mockito.when((Object)accountingPeriodSvcMock.getByDate(currentDate)).thenReturn((Object)accountingPeriodMock_2015_12);
        Mockito.when((Object)accountingPeriodMock_2015_04.getUniversityFiscalYear()).thenReturn((Object)2015);
        Mockito.when((Object)accountingPeriodSvcMock.getByDate(lastBilledDate)).thenReturn((Object)accountingPeriodMock_2015_04);
        BillingPeriod priorBillingPeriod = BillingPeriod.determineBillingPeriodPriorTo((Date)awardStartDate, (Date)currentDate, (Date)lastBilledDate, (ArConstants.BillingFrequencyValues)ArConstants.BillingFrequencyValues.ANNUALLY, (AccountingPeriodService)accountingPeriodSvcMock);
        Assertions.assertNull((Object)priorBillingPeriod.getStartDate());
        Assertions.assertNull((Object)priorBillingPeriod.getEndDate());
        Assertions.assertFalse((boolean)priorBillingPeriod.isBillable());
    }

    @Test
    void determineBillingPeriodPriorTo_Annual_LastBilledPreviousAnnual(@Mock(stubOnly=true) AccountingPeriodService accountingPeriodSvcMock, @Mock(stubOnly=true) AccountingPeriod accountingPeriodMock_2015_10, @Mock(stubOnly=true) AccountingPeriod accountingPeriodMock_2016_02, @Mock(stubOnly=true) AccountingPeriod accountingPeriodMock_2015_12, @Mock(stubOnly=true) AccountingPeriod accountingPeriodMock_2014_12) {
        Date awardStartDate = Date.valueOf("2013-07-01");
        Date currentDate = Date.valueOf("2015-08-21");
        Date lastBilledDate = Date.valueOf("2015-04-20");
        Date expectedBillingPeriodStart = Date.valueOf("2014-07-01");
        Date expectedBillingPeriodEnd = Date.valueOf(ACCOUNTING_PERIOD_2015_12_END_DATE);
        Mockito.when((Object)accountingPeriodMock_2014_12.getUniversityFiscalPeriodEndDate()).thenReturn((Object)Date.valueOf(ACCOUNTING_PERIOD_2014_12_END_DATE));
        Mockito.when((Object)accountingPeriodMock_2014_12.getUniversityFiscalPeriodCode()).thenReturn((Object)"12");
        Mockito.when((Object)accountingPeriodSvcMock.getByPeriod("12", Integer.valueOf(2014))).thenReturn((Object)accountingPeriodMock_2014_12);
        Mockito.when((Object)accountingPeriodMock_2015_12.getUniversityFiscalPeriodEndDate()).thenReturn((Object)Date.valueOf(ACCOUNTING_PERIOD_2015_12_END_DATE));
        Mockito.when((Object)accountingPeriodMock_2015_12.getUniversityFiscalPeriodCode()).thenReturn((Object)"12");
        Mockito.when((Object)accountingPeriodSvcMock.getByPeriod("12", Integer.valueOf(2015))).thenReturn((Object)accountingPeriodMock_2015_12);
        Mockito.when((Object)accountingPeriodMock_2016_02.getUniversityFiscalPeriodCode()).thenReturn((Object)"02");
        Mockito.when((Object)accountingPeriodMock_2016_02.getUniversityFiscalYear()).thenReturn((Object)2016);
        Mockito.when((Object)accountingPeriodSvcMock.getByDate(currentDate)).thenReturn((Object)accountingPeriodMock_2016_02);
        Mockito.when((Object)accountingPeriodMock_2015_10.getUniversityFiscalPeriodCode()).thenReturn((Object)"10");
        Mockito.when((Object)accountingPeriodMock_2015_10.getUniversityFiscalYear()).thenReturn((Object)2015);
        Mockito.when((Object)accountingPeriodSvcMock.getByDate(lastBilledDate)).thenReturn((Object)accountingPeriodMock_2015_10);
        BillingPeriod priorBillingPeriod = BillingPeriod.determineBillingPeriodPriorTo((Date)awardStartDate, (Date)currentDate, (Date)lastBilledDate, (ArConstants.BillingFrequencyValues)ArConstants.BillingFrequencyValues.ANNUALLY, (AccountingPeriodService)accountingPeriodSvcMock);
        Assertions.assertEquals((Object)expectedBillingPeriodStart, (Object)priorBillingPeriod.getStartDate());
        Assertions.assertEquals((Object)expectedBillingPeriodEnd, (Object)priorBillingPeriod.getEndDate());
        Assertions.assertTrue((boolean)priorBillingPeriod.isBillable());
    }

    @Test
    void determineBillingPeriodPriorTo_Annual_LastBilledEarlierAnnual(@Mock(stubOnly=true) AccountingPeriodService accountingPeriodSvcMock, @Mock(stubOnly=true) AccountingPeriod accountingPeriodMock_2016_02, @Mock(stubOnly=true) AccountingPeriod accountingPeriodMock_2014_05, @Mock(stubOnly=true) AccountingPeriod accountingPeriodMock_2015_12, @Mock(stubOnly=true) AccountingPeriod accountingPeriodMock_2013_12) {
        Date awardStartDate = Date.valueOf("2012-07-01");
        Date currentDate = Date.valueOf("2015-08-21");
        Date lastBilledDate = Date.valueOf(ACCOUNTING_PERIOD_2013_12_END_DATE);
        Date expectedBillingPeriodStart = Date.valueOf("2013-07-01");
        Date expectedBillingPeriodEnd = Date.valueOf(ACCOUNTING_PERIOD_2015_12_END_DATE);
        Mockito.when((Object)accountingPeriodMock_2013_12.getUniversityFiscalPeriodEndDate()).thenReturn((Object)Date.valueOf(ACCOUNTING_PERIOD_2013_12_END_DATE));
        Mockito.when((Object)accountingPeriodMock_2013_12.getUniversityFiscalPeriodCode()).thenReturn((Object)"12");
        Mockito.when((Object)accountingPeriodSvcMock.getByPeriod("12", Integer.valueOf(2013))).thenReturn((Object)accountingPeriodMock_2013_12);
        Mockito.when((Object)accountingPeriodMock_2015_12.getUniversityFiscalPeriodEndDate()).thenReturn((Object)Date.valueOf(ACCOUNTING_PERIOD_2015_12_END_DATE));
        Mockito.when((Object)accountingPeriodMock_2015_12.getUniversityFiscalPeriodCode()).thenReturn((Object)"12");
        Mockito.when((Object)accountingPeriodSvcMock.getByPeriod("12", Integer.valueOf(2015))).thenReturn((Object)accountingPeriodMock_2015_12);
        Mockito.when((Object)accountingPeriodMock_2016_02.getUniversityFiscalPeriodCode()).thenReturn((Object)"02");
        Mockito.when((Object)accountingPeriodMock_2016_02.getUniversityFiscalYear()).thenReturn((Object)2016);
        Mockito.when((Object)accountingPeriodSvcMock.getByDate(currentDate)).thenReturn((Object)accountingPeriodMock_2016_02);
        Mockito.when((Object)accountingPeriodMock_2014_05.getUniversityFiscalPeriodCode()).thenReturn((Object)"05");
        Mockito.when((Object)accountingPeriodMock_2014_05.getUniversityFiscalYear()).thenReturn((Object)2014);
        Mockito.when((Object)accountingPeriodSvcMock.getByDate(lastBilledDate)).thenReturn((Object)accountingPeriodMock_2014_05);
        BillingPeriod priorBillingPeriod = BillingPeriod.determineBillingPeriodPriorTo((Date)awardStartDate, (Date)currentDate, (Date)lastBilledDate, (ArConstants.BillingFrequencyValues)ArConstants.BillingFrequencyValues.ANNUALLY, (AccountingPeriodService)accountingPeriodSvcMock);
        Assertions.assertEquals((Object)expectedBillingPeriodStart, (Object)priorBillingPeriod.getStartDate());
        Assertions.assertEquals((Object)expectedBillingPeriodEnd, (Object)priorBillingPeriod.getEndDate());
        Assertions.assertTrue((boolean)priorBillingPeriod.isBillable());
    }

    @Test
    void determineBillingPeriodPriorTo_Annual_BillAwardInFuture(@Mock(stubOnly=true) AccountingPeriodService accountingPeriodSvcMock, @Mock(stubOnly=true) AccountingPeriod accountingPeriodMock_2015_10, @Mock(stubOnly=true) AccountingPeriod accountingPeriodMock_2014_12, @Mock(stubOnly=true) AccountingPeriod accountingPeriodMock_2013_12) {
        Date awardStartDate = Date.valueOf("2015-07-01");
        Date currentDate = Date.valueOf("2015-04-21");
        Date previousPeriodEndDate = Date.valueOf(ACCOUNTING_PERIOD_2014_12_END_DATE);
        Date expectedBillingPeriodStart = Date.valueOf("2013-07-01");
        Date expectedBillingPeriodEnd = Date.valueOf(ACCOUNTING_PERIOD_2014_12_END_DATE);
        Mockito.when((Object)accountingPeriodMock_2013_12.getUniversityFiscalPeriodEndDate()).thenReturn((Object)Date.valueOf(ACCOUNTING_PERIOD_2013_12_END_DATE));
        Mockito.when((Object)accountingPeriodSvcMock.getByPeriod("12", Integer.valueOf(2013))).thenReturn((Object)accountingPeriodMock_2013_12);
        Mockito.when((Object)accountingPeriodMock_2015_10.getUniversityFiscalPeriodCode()).thenReturn((Object)"10");
        Mockito.when((Object)accountingPeriodMock_2015_10.getUniversityFiscalYear()).thenReturn((Object)2015);
        Mockito.when((Object)accountingPeriodSvcMock.getByDate(currentDate)).thenReturn((Object)accountingPeriodMock_2015_10);
        Mockito.when((Object)accountingPeriodMock_2014_12.getUniversityFiscalPeriodEndDate()).thenReturn((Object)Date.valueOf(ACCOUNTING_PERIOD_2014_12_END_DATE));
        Mockito.when((Object)accountingPeriodMock_2014_12.getUniversityFiscalPeriodCode()).thenReturn((Object)"12");
        Mockito.when((Object)accountingPeriodMock_2014_12.getUniversityFiscalYear()).thenReturn((Object)2014);
        Mockito.when((Object)accountingPeriodSvcMock.getByPeriod("12", Integer.valueOf(2014))).thenReturn((Object)accountingPeriodMock_2014_12);
        Mockito.when((Object)accountingPeriodSvcMock.getByDate(previousPeriodEndDate)).thenReturn((Object)accountingPeriodMock_2014_12);
        BillingPeriod priorBillingPeriod = BillingPeriod.determineBillingPeriodPriorTo((Date)awardStartDate, (Date)currentDate, null, (ArConstants.BillingFrequencyValues)ArConstants.BillingFrequencyValues.ANNUALLY, (AccountingPeriodService)accountingPeriodSvcMock);
        Assertions.assertEquals((Object)expectedBillingPeriodStart, (Object)priorBillingPeriod.getStartDate());
        Assertions.assertEquals((Object)expectedBillingPeriodEnd, (Object)priorBillingPeriod.getEndDate());
        Assertions.assertTrue((boolean)priorBillingPeriod.isBillable());
    }

    @Test
    void determineBillingPeriodPriorTo_LOC_nullLastBilled_1(@Mock(stubOnly=true) AccountingPeriodService accountingPeriodSvcMock, @Mock(stubOnly=true) AccountingPeriod accountingPeriodMock_2015_09, @Mock(stubOnly=true) AccountingPeriod accountingPeriodMock_2015_10) {
        Date awardStartDate = Date.valueOf("2014-07-01");
        Date currentDate = Date.valueOf("2015-04-20");
        Date expectedBillingPeriodStart = Date.valueOf("2014-07-01");
        Date expectedBillingPeriodEnd = Date.valueOf(ACCOUNTING_PERIOD_2015_09_END_DATE);
        Mockito.when((Object)accountingPeriodMock_2015_09.getUniversityFiscalPeriodEndDate()).thenReturn((Object)Date.valueOf(ACCOUNTING_PERIOD_2015_09_END_DATE));
        Mockito.when((Object)accountingPeriodSvcMock.getByPeriod("09", Integer.valueOf(2015))).thenReturn((Object)accountingPeriodMock_2015_09);
        Mockito.when((Object)accountingPeriodMock_2015_10.getUniversityFiscalPeriodCode()).thenReturn((Object)"10");
        Mockito.when((Object)accountingPeriodMock_2015_10.getUniversityFiscalYear()).thenReturn((Object)2015);
        Mockito.when((Object)accountingPeriodSvcMock.getByDate(currentDate)).thenReturn((Object)accountingPeriodMock_2015_10);
        BillingPeriod priorBillingPeriod = BillingPeriod.determineBillingPeriodPriorTo((Date)awardStartDate, (Date)currentDate, null, (ArConstants.BillingFrequencyValues)ArConstants.BillingFrequencyValues.LETTER_OF_CREDIT, (AccountingPeriodService)accountingPeriodSvcMock);
        Assertions.assertEquals((Object)expectedBillingPeriodStart, (Object)priorBillingPeriod.getStartDate());
        Assertions.assertEquals((Object)expectedBillingPeriodEnd, (Object)priorBillingPeriod.getEndDate());
        Assertions.assertTrue((boolean)priorBillingPeriod.isBillable());
    }

    @Test
    void determineBillingPeriodPriorTo_LOC_nullLastBilled_2(@Mock(stubOnly=true) AccountingPeriodService accountingPeriodSvcMock, @Mock(stubOnly=true) AccountingPeriod accountingPeriodMock_2015_09, @Mock(stubOnly=true) AccountingPeriod accountingPeriodMock_2015_10) {
        Date awardStartDate = Date.valueOf("2014-08-01");
        Date currentDate = Date.valueOf("2015-04-20");
        Date expectedBillingPeriodStart = Date.valueOf("2014-08-01");
        Date expectedBillingPeriodEnd = Date.valueOf(ACCOUNTING_PERIOD_2015_09_END_DATE);
        Mockito.when((Object)accountingPeriodMock_2015_09.getUniversityFiscalPeriodEndDate()).thenReturn((Object)Date.valueOf(ACCOUNTING_PERIOD_2015_09_END_DATE));
        Mockito.when((Object)accountingPeriodSvcMock.getByPeriod("09", Integer.valueOf(2015))).thenReturn((Object)accountingPeriodMock_2015_09);
        Mockito.when((Object)accountingPeriodMock_2015_10.getUniversityFiscalPeriodCode()).thenReturn((Object)"10");
        Mockito.when((Object)accountingPeriodMock_2015_10.getUniversityFiscalYear()).thenReturn((Object)2015);
        Mockito.when((Object)accountingPeriodSvcMock.getByDate(currentDate)).thenReturn((Object)accountingPeriodMock_2015_10);
        BillingPeriod priorBillingPeriod = BillingPeriod.determineBillingPeriodPriorTo((Date)awardStartDate, (Date)currentDate, null, (ArConstants.BillingFrequencyValues)ArConstants.BillingFrequencyValues.LETTER_OF_CREDIT, (AccountingPeriodService)accountingPeriodSvcMock);
        Assertions.assertEquals((Object)expectedBillingPeriodStart, (Object)priorBillingPeriod.getStartDate());
        Assertions.assertEquals((Object)expectedBillingPeriodEnd, (Object)priorBillingPeriod.getEndDate());
        Assertions.assertTrue((boolean)priorBillingPeriod.isBillable());
    }

    @Test
    void determineBillingPeriodPriorTo_LOC_BillSingleDay(@Mock(stubOnly=true) AccountingPeriodService accountingPeriodSvcMock, @Mock(stubOnly=true) AccountingPeriod accountingPeriodMock_2015_08, @Mock(stubOnly=true) AccountingPeriod accountingPeriodMock_2015_09, @Mock(stubOnly=true) AccountingPeriod accountingPeriodMock_2015_10, @Mock(stubOnly=true) AccountingPeriod accountingPeriodMock_2015_11) {
        Date awardStartDate = Date.valueOf("2014-07-01");
        Date currentDate = Date.valueOf("2015-05-21");
        Date lastBilledDate = Date.valueOf(ACCOUNTING_PERIOD_2015_09_END_DATE);
        Date expectedBillingPeriodStart = Date.valueOf("2015-04-01");
        Date expectedBillingPeriodEnd = Date.valueOf(ACCOUNTING_PERIOD_2015_10_END_DATE);
        Mockito.when((Object)accountingPeriodMock_2015_08.getUniversityFiscalPeriodCode()).thenReturn((Object)"08");
        Mockito.when((Object)accountingPeriodSvcMock.getByPeriod("08", Integer.valueOf(2015))).thenReturn((Object)accountingPeriodMock_2015_08);
        Mockito.when((Object)accountingPeriodMock_2015_09.getUniversityFiscalPeriodCode()).thenReturn((Object)"09");
        Mockito.when((Object)accountingPeriodMock_2015_09.getUniversityFiscalYear()).thenReturn((Object)2015);
        Mockito.when((Object)accountingPeriodMock_2015_09.getUniversityFiscalPeriodEndDate()).thenReturn((Object)Date.valueOf(ACCOUNTING_PERIOD_2015_09_END_DATE));
        Mockito.when((Object)accountingPeriodSvcMock.getByDate(lastBilledDate)).thenReturn((Object)accountingPeriodMock_2015_09);
        Mockito.when((Object)accountingPeriodMock_2015_10.getUniversityFiscalPeriodCode()).thenReturn((Object)"10");
        Mockito.when((Object)accountingPeriodMock_2015_10.getUniversityFiscalPeriodEndDate()).thenReturn((Object)Date.valueOf(ACCOUNTING_PERIOD_2015_10_END_DATE));
        Mockito.when((Object)accountingPeriodSvcMock.getByPeriod("10", Integer.valueOf(2015))).thenReturn((Object)accountingPeriodMock_2015_10);
        Mockito.when((Object)accountingPeriodMock_2015_11.getUniversityFiscalPeriodCode()).thenReturn((Object)"11");
        Mockito.when((Object)accountingPeriodMock_2015_11.getUniversityFiscalYear()).thenReturn((Object)2015);
        Mockito.when((Object)accountingPeriodSvcMock.getByDate(currentDate)).thenReturn((Object)accountingPeriodMock_2015_11);
        BillingPeriod priorBillingPeriod = BillingPeriod.determineBillingPeriodPriorTo((Date)awardStartDate, (Date)currentDate, (Date)lastBilledDate, (ArConstants.BillingFrequencyValues)ArConstants.BillingFrequencyValues.LETTER_OF_CREDIT, (AccountingPeriodService)accountingPeriodSvcMock);
        Assertions.assertEquals((Object)expectedBillingPeriodStart, (Object)priorBillingPeriod.getStartDate());
        Assertions.assertEquals((Object)expectedBillingPeriodEnd, (Object)priorBillingPeriod.getEndDate());
        Assertions.assertTrue((boolean)priorBillingPeriod.isBillable());
    }

    @Test
    void determineBillingPeriodPriorTo_LOC_BillSeveralMonths(@Mock(stubOnly=true) AccountingPeriodService accountingPeriodSvcMock, @Mock(stubOnly=true) AccountingPeriod accountingPeriodMock_2014_04, @Mock(stubOnly=true) AccountingPeriod accountingPeriodMock_2014_05, @Mock(stubOnly=true) AccountingPeriod accountingPeriodMock_2015_10, @Mock(stubOnly=true) AccountingPeriod accountingPeriodMock_2015_11) {
        Date awardStartDate = Date.valueOf("2014-07-01");
        Date currentDate = Date.valueOf("2015-05-21");
        Date lastBilledDate = Date.valueOf(ACCOUNTING_PERIOD_2014_05_END_DATE);
        Date expectedBillingPeriodStart = Date.valueOf("2014-12-01");
        Date expectedBillingPeriodEnd = Date.valueOf(ACCOUNTING_PERIOD_2015_10_END_DATE);
        Mockito.when((Object)accountingPeriodSvcMock.getByPeriod("04", Integer.valueOf(2014))).thenReturn((Object)accountingPeriodMock_2014_04);
        Mockito.when((Object)accountingPeriodMock_2014_05.getUniversityFiscalPeriodCode()).thenReturn((Object)"05");
        Mockito.when((Object)accountingPeriodMock_2014_05.getUniversityFiscalYear()).thenReturn((Object)2014);
        Mockito.when((Object)accountingPeriodMock_2014_05.getUniversityFiscalPeriodEndDate()).thenReturn((Object)Date.valueOf(ACCOUNTING_PERIOD_2014_05_END_DATE));
        Mockito.when((Object)accountingPeriodSvcMock.getByDate(lastBilledDate)).thenReturn((Object)accountingPeriodMock_2014_05);
        Mockito.when((Object)accountingPeriodMock_2015_10.getUniversityFiscalPeriodCode()).thenReturn((Object)"10");
        Mockito.when((Object)accountingPeriodMock_2015_10.getUniversityFiscalPeriodEndDate()).thenReturn((Object)Date.valueOf(ACCOUNTING_PERIOD_2015_10_END_DATE));
        Mockito.when((Object)accountingPeriodSvcMock.getByPeriod("10", Integer.valueOf(2015))).thenReturn((Object)accountingPeriodMock_2015_10);
        Mockito.when((Object)accountingPeriodMock_2015_11.getUniversityFiscalPeriodCode()).thenReturn((Object)"11");
        Mockito.when((Object)accountingPeriodMock_2015_11.getUniversityFiscalYear()).thenReturn((Object)2015);
        Mockito.when((Object)accountingPeriodSvcMock.getByDate(currentDate)).thenReturn((Object)accountingPeriodMock_2015_11);
        BillingPeriod priorBillingPeriod = BillingPeriod.determineBillingPeriodPriorTo((Date)awardStartDate, (Date)currentDate, (Date)lastBilledDate, (ArConstants.BillingFrequencyValues)ArConstants.BillingFrequencyValues.LETTER_OF_CREDIT, (AccountingPeriodService)accountingPeriodSvcMock);
        Assertions.assertEquals((Object)expectedBillingPeriodStart, (Object)priorBillingPeriod.getStartDate());
        Assertions.assertEquals((Object)expectedBillingPeriodEnd, (Object)priorBillingPeriod.getEndDate());
        Assertions.assertTrue((boolean)priorBillingPeriod.isBillable());
    }

    @Test
    void determineBillingPeriodPriorTo_LOC_BillAcrossFiscalYears(@Mock(stubOnly=true) AccountingPeriodService accountingPeriodSvcMock, @Mock(stubOnly=true) AccountingPeriod accountingPeriodMock_2014_11, @Mock(stubOnly=true) AccountingPeriod accountingPeriodMock_2014_12, @Mock(stubOnly=true) AccountingPeriod accountingPeriodMock_2015_10, @Mock(stubOnly=true) AccountingPeriod accountingPeriodMock_2015_11) {
        Date awardStartDate = Date.valueOf("2014-07-01");
        Date currentDate = Date.valueOf("2015-05-21");
        Date lastBilledDate = Date.valueOf(ACCOUNTING_PERIOD_2014_12_END_DATE);
        Date expectedBillingPeriodStart = Date.valueOf("2014-07-01");
        Date expectedBillingPeriodEnd = Date.valueOf(ACCOUNTING_PERIOD_2015_10_END_DATE);
        Mockito.when((Object)accountingPeriodSvcMock.getByPeriod("11", Integer.valueOf(2014))).thenReturn((Object)accountingPeriodMock_2014_11);
        Mockito.when((Object)accountingPeriodMock_2014_12.getUniversityFiscalPeriodCode()).thenReturn((Object)"12");
        Mockito.when((Object)accountingPeriodMock_2014_12.getUniversityFiscalYear()).thenReturn((Object)2014);
        Mockito.when((Object)accountingPeriodMock_2014_12.getUniversityFiscalPeriodEndDate()).thenReturn((Object)Date.valueOf(ACCOUNTING_PERIOD_2014_12_END_DATE));
        Mockito.when((Object)accountingPeriodSvcMock.getByDate(lastBilledDate)).thenReturn((Object)accountingPeriodMock_2014_12);
        Mockito.when((Object)accountingPeriodMock_2015_10.getUniversityFiscalPeriodCode()).thenReturn((Object)"10");
        Mockito.when((Object)accountingPeriodMock_2015_10.getUniversityFiscalPeriodEndDate()).thenReturn((Object)Date.valueOf(ACCOUNTING_PERIOD_2015_10_END_DATE));
        Mockito.when((Object)accountingPeriodSvcMock.getByPeriod("10", Integer.valueOf(2015))).thenReturn((Object)accountingPeriodMock_2015_10);
        Mockito.when((Object)accountingPeriodMock_2015_11.getUniversityFiscalPeriodCode()).thenReturn((Object)"11");
        Mockito.when((Object)accountingPeriodMock_2015_11.getUniversityFiscalYear()).thenReturn((Object)2015);
        Mockito.when((Object)accountingPeriodSvcMock.getByDate(currentDate)).thenReturn((Object)accountingPeriodMock_2015_11);
        BillingPeriod priorBillingPeriod = BillingPeriod.determineBillingPeriodPriorTo((Date)awardStartDate, (Date)currentDate, (Date)lastBilledDate, (ArConstants.BillingFrequencyValues)ArConstants.BillingFrequencyValues.LETTER_OF_CREDIT, (AccountingPeriodService)accountingPeriodSvcMock);
        Assertions.assertEquals((Object)expectedBillingPeriodStart, (Object)priorBillingPeriod.getStartDate());
        Assertions.assertEquals((Object)expectedBillingPeriodEnd, (Object)priorBillingPeriod.getEndDate());
        Assertions.assertTrue((boolean)priorBillingPeriod.isBillable());
    }

    @Test
    void determineBillingPeriodPriorTo_LOC_MayNotBillNow(@Mock(stubOnly=true) AccountingPeriodService accountingPeriodSvcMock, @Mock(stubOnly=true) AccountingPeriod accountingPeriodMock_2015_09, @Mock(stubOnly=true) AccountingPeriod accountingPeriodMock_2015_10) {
        Date awardStartDate = Date.valueOf("2014-07-01");
        Date currentDate = Date.valueOf("2015-04-21");
        Date lastBilledDate = Date.valueOf(ACCOUNTING_PERIOD_2015_10_END_DATE);
        Mockito.when((Object)accountingPeriodMock_2015_09.getUniversityFiscalPeriodCode()).thenReturn((Object)"09");
        Mockito.when((Object)accountingPeriodSvcMock.getByPeriod("09", Integer.valueOf(2015))).thenReturn((Object)accountingPeriodMock_2015_09);
        Mockito.when((Object)accountingPeriodMock_2015_10.getUniversityFiscalPeriodCode()).thenReturn((Object)"10");
        Mockito.when((Object)accountingPeriodMock_2015_10.getUniversityFiscalYear()).thenReturn((Object)2015);
        Mockito.when((Object)accountingPeriodSvcMock.getByDate(lastBilledDate)).thenReturn((Object)accountingPeriodMock_2015_10);
        Mockito.when((Object)accountingPeriodSvcMock.getByDate(currentDate)).thenReturn((Object)accountingPeriodMock_2015_10);
        BillingPeriod priorBillingPeriod = BillingPeriod.determineBillingPeriodPriorTo((Date)awardStartDate, (Date)currentDate, (Date)lastBilledDate, (ArConstants.BillingFrequencyValues)ArConstants.BillingFrequencyValues.LETTER_OF_CREDIT, (AccountingPeriodService)accountingPeriodSvcMock);
        Assertions.assertNull((Object)priorBillingPeriod.getStartDate());
        Assertions.assertNull((Object)priorBillingPeriod.getEndDate());
        Assertions.assertFalse((boolean)priorBillingPeriod.isBillable());
    }

    @Test
    void canThisBeBilled_LOC_LastBilledDateIsNull(@Mock(stubOnly=true) AccountingPeriodService accountingPeriodSvcMock) {
        Date awardStartDate = Date.valueOf("2015-01-01");
        Date currentDate = Date.valueOf("2015-04-21");
        BillingPeriod billingPeriod = new BillingPeriod(ArConstants.BillingFrequencyValues.LETTER_OF_CREDIT, awardStartDate, currentDate, null, accountingPeriodSvcMock);
        Assertions.assertTrue((boolean)billingPeriod.canThisBeBilled());
    }

    @Test
    void canThisBeBilled_LOC_LastBilledDateIsToday(@Mock(stubOnly=true) AccountingPeriodService accountingPeriodSvcMock, @Mock(stubOnly=true) AccountingPeriod accountingPeriodMock_2015_09, @Mock(stubOnly=true) AccountingPeriod accountingPeriodMock_2015_10) {
        Date awardStartDate = Date.valueOf("2015-01-01");
        Date lastBilledDate = Date.valueOf(ACCOUNTING_PERIOD_2015_10_END_DATE);
        Date currentDate = Date.valueOf(ACCOUNTING_PERIOD_2015_10_END_DATE);
        Mockito.when((Object)accountingPeriodMock_2015_09.getUniversityFiscalPeriodCode()).thenReturn((Object)"09");
        Mockito.when((Object)accountingPeriodSvcMock.getByPeriod("09", Integer.valueOf(2015))).thenReturn((Object)accountingPeriodMock_2015_09);
        Mockito.when((Object)accountingPeriodMock_2015_10.getUniversityFiscalPeriodCode()).thenReturn((Object)"10");
        Mockito.when((Object)accountingPeriodMock_2015_10.getUniversityFiscalYear()).thenReturn((Object)2015);
        Mockito.when((Object)accountingPeriodSvcMock.getByDate(lastBilledDate)).thenReturn((Object)accountingPeriodMock_2015_10);
        Mockito.when((Object)accountingPeriodSvcMock.getByDate(currentDate)).thenReturn((Object)accountingPeriodMock_2015_10);
        BillingPeriod billingPeriod = new BillingPeriod(ArConstants.BillingFrequencyValues.LETTER_OF_CREDIT, awardStartDate, currentDate, lastBilledDate, accountingPeriodSvcMock);
        Assertions.assertFalse((boolean)billingPeriod.canThisBeBilled());
    }

    @Test
    void canThisBeBilled_LOC_LastBilledDateIsYesterday(@Mock(stubOnly=true) AccountingPeriodService accountingPeriodSvcMock, @Mock(stubOnly=true) AccountingPeriod accountingPeriodMock_2015_09, @Mock(stubOnly=true) AccountingPeriod accountingPeriodMock_2015_10, @Mock(stubOnly=true) AccountingPeriod accountingPeriodMock_2015_11) {
        Date awardStartDate = Date.valueOf("2015-01-01");
        Date lastBilledDate = Date.valueOf(ACCOUNTING_PERIOD_2015_10_END_DATE);
        Date currentDate = Date.valueOf("2015-05-01");
        Mockito.when((Object)accountingPeriodMock_2015_09.getUniversityFiscalPeriodCode()).thenReturn((Object)"09");
        Mockito.when((Object)accountingPeriodSvcMock.getByPeriod("09", Integer.valueOf(2015))).thenReturn((Object)accountingPeriodMock_2015_09);
        Mockito.when((Object)accountingPeriodMock_2015_10.getUniversityFiscalPeriodCode()).thenReturn((Object)"10");
        Mockito.when((Object)accountingPeriodMock_2015_10.getUniversityFiscalYear()).thenReturn((Object)2015);
        Mockito.when((Object)accountingPeriodSvcMock.getByPeriod("10", Integer.valueOf(2015))).thenReturn((Object)accountingPeriodMock_2015_10);
        Mockito.when((Object)accountingPeriodSvcMock.getByDate(lastBilledDate)).thenReturn((Object)accountingPeriodMock_2015_10);
        Mockito.when((Object)accountingPeriodMock_2015_11.getUniversityFiscalPeriodCode()).thenReturn((Object)"11");
        Mockito.when((Object)accountingPeriodMock_2015_11.getUniversityFiscalYear()).thenReturn((Object)2015);
        Mockito.when((Object)accountingPeriodSvcMock.getByDate(currentDate)).thenReturn((Object)accountingPeriodMock_2015_11);
        BillingPeriod billingPeriod = new BillingPeriod(ArConstants.BillingFrequencyValues.LETTER_OF_CREDIT, awardStartDate, currentDate, lastBilledDate, accountingPeriodSvcMock);
        Assertions.assertTrue((boolean)billingPeriod.canThisBeBilled());
    }

    @Test
    void canThisBeBilled_LOC_LastBilledDateIsBeforeToday(@Mock(stubOnly=true) AccountingPeriodService accountingPeriodSvcMock, @Mock(stubOnly=true) AccountingPeriod accountingPeriodMock_2015_09, @Mock(stubOnly=true) AccountingPeriod accountingPeriodMock_2015_10, @Mock(stubOnly=true) AccountingPeriod accountingPeriodMock_2015_11) {
        Date awardStartDate = Date.valueOf("2015-01-01");
        Date lastBilledDate = Date.valueOf(ACCOUNTING_PERIOD_2015_10_END_DATE);
        Date currentDate = Date.valueOf("2015-05-21");
        Mockito.when((Object)accountingPeriodMock_2015_09.getUniversityFiscalPeriodCode()).thenReturn((Object)"09");
        Mockito.when((Object)accountingPeriodSvcMock.getByPeriod("09", Integer.valueOf(2015))).thenReturn((Object)accountingPeriodMock_2015_09);
        Mockito.when((Object)accountingPeriodMock_2015_10.getUniversityFiscalPeriodCode()).thenReturn((Object)"10");
        Mockito.when((Object)accountingPeriodMock_2015_10.getUniversityFiscalYear()).thenReturn((Object)2015);
        Mockito.when((Object)accountingPeriodSvcMock.getByPeriod("10", Integer.valueOf(2015))).thenReturn((Object)accountingPeriodMock_2015_10);
        Mockito.when((Object)accountingPeriodSvcMock.getByDate(lastBilledDate)).thenReturn((Object)accountingPeriodMock_2015_10);
        Mockito.when((Object)accountingPeriodMock_2015_11.getUniversityFiscalPeriodCode()).thenReturn((Object)"11");
        Mockito.when((Object)accountingPeriodMock_2015_11.getUniversityFiscalYear()).thenReturn((Object)2015);
        Mockito.when((Object)accountingPeriodSvcMock.getByDate(currentDate)).thenReturn((Object)accountingPeriodMock_2015_11);
        BillingPeriod billingPeriod = new BillingPeriod(ArConstants.BillingFrequencyValues.LETTER_OF_CREDIT, awardStartDate, currentDate, lastBilledDate, accountingPeriodSvcMock);
        Assertions.assertTrue((boolean)billingPeriod.canThisBeBilled());
    }
}

