/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.ar.businessobject;

import java.sql.Date;
import java.time.LocalDate;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.kuali.kfs.core.api.util.type.KualiDecimal;
import org.kuali.kfs.module.ar.businessobject.Milestone;

class MilestoneBuilderTest {
    private Milestone.MilestoneBuilder cut;

    MilestoneBuilderTest() {
    }

    @BeforeEach
    void setUp() {
        this.cut = new Milestone.MilestoneBuilder().setProposalNumber("1").setChartOfAccountsCode("BL").setAccountNumber("1031400").setMilestoneExpectedCompletionDate(Date.valueOf(LocalDate.now().minusDays(1L))).setActive(true).setMilestoneNumber("1").setMilestoneDescription("milestone 1").setMilestoneAmount(new KualiDecimal(100.0)).setMilestoneActualCompletionDate(Date.valueOf(LocalDate.now()));
    }

    @Test
    void milestoneBuilder_build_allFieldsPopulated_valid() {
        Milestone milestone = this.cut.build();
        Assertions.assertNotNull((Object)milestone);
    }

    @Test
    void milestoneBuilder_build_onlyRequiredFieldsPopulated_valid() {
        this.cut.setMilestoneDescription("");
        this.cut.setMilestoneAmount(null);
        this.cut.setMilestoneActualCompletionDate(null);
        Milestone milestone = this.cut.build();
        Assertions.assertNotNull((Object)milestone);
    }

    @Test
    void milestoneBuilder_build_MissingProposalNumber_validateThrowsException() {
        this.cut.setProposalNumber("");
        Exception e = (Exception)Assertions.assertThrows(IllegalStateException.class, () -> this.cut.build());
        Assertions.assertEquals((Object)"Proposal Number is required.", (Object)e.getMessage());
    }

    @Test
    void milestoneBuilder_build_MissingChartOfAccountsCode_validateThrowsException() {
        this.cut.setChartOfAccountsCode("");
        Exception e = (Exception)Assertions.assertThrows(IllegalStateException.class, () -> this.cut.build());
        Assertions.assertEquals((Object)"Chart of Accounts Code is required.", (Object)e.getMessage());
    }

    @Test
    void milestoneBuilder_build_MissingAccountNumber_validateThrowsException() {
        this.cut.setAccountNumber("");
        Exception e = (Exception)Assertions.assertThrows(IllegalStateException.class, () -> this.cut.build());
        Assertions.assertEquals((Object)"Account Number is required.", (Object)e.getMessage());
    }

    @Test
    void milestoneBuilder_build_MissingMilestoneNumber_validateThrowsException() {
        this.cut.setMilestoneNumber("");
        Exception e = (Exception)Assertions.assertThrows(IllegalStateException.class, () -> this.cut.build());
        Assertions.assertEquals((Object)"Milestone Number is required.", (Object)e.getMessage());
    }

    @Test
    void milestoneBuilder_build_MissingMilestoneExpectedCompletionDate_validateThrowsException() {
        this.cut.setMilestoneExpectedCompletionDate(null);
        Exception e = (Exception)Assertions.assertThrows(IllegalStateException.class, () -> this.cut.build());
        Assertions.assertEquals((Object)"Milestone Expected Completion Date is required.", (Object)e.getMessage());
    }
}

