/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.ar.businessobject.actions;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.kuali.kfs.datadictionary.Action;
import org.kuali.kfs.datadictionary.ActionType;
import org.kuali.kfs.datadictionary.legacy.BusinessObjectDictionaryService;
import org.kuali.kfs.kim.impl.identity.Person;
import org.kuali.kfs.kns.datadictionary.BusinessObjectEntry;
import org.kuali.kfs.kns.service.BusinessObjectMetaDataService;
import org.kuali.kfs.krad.bo.BusinessObjectBase;
import org.kuali.kfs.krad.util.UrlFactory;
import org.kuali.kfs.module.ar.businessobject.Customer;
import org.kuali.kfs.module.ar.businessobject.CustomerOpenItemReportDetail;
import org.kuali.kfs.module.ar.businessobject.actions.CustomerActionsProvider;
import org.kuali.kfs.module.ar.businessobject.admin.CustomerAdminService;
import org.mockito.ArgumentMatchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.jupiter.MockitoExtension;

@ExtendWith(value={MockitoExtension.class})
class CustomerActionsProviderTest {
    private final CustomerActionsProvider cut = new CustomerActionsProvider();

    CustomerActionsProviderTest() {
    }

    void setup(BusinessObjectDictionaryService businessObjectDictionaryServiceMock, BusinessObjectMetaDataService businessObjectMetaDataServiceMock) {
        this.cut.setBusinessObjectDictionaryService(businessObjectDictionaryServiceMock);
        this.cut.setBusinessObjectMetaDataService(businessObjectMetaDataServiceMock);
    }

    @Test
    void getActionLinks_reportAllowed_includesReport(@Mock(stubOnly=true) CustomerAdminService customerAdminServiceMock, @Mock(stubOnly=true) BusinessObjectDictionaryService businessObjectDictionaryServiceMock, @Mock(stubOnly=true) BusinessObjectMetaDataService businessObjectMetaDataServiceMock, @Mock BusinessObjectEntry businessObjectEntryMock) {
        this.setup(businessObjectDictionaryServiceMock, businessObjectMetaDataServiceMock);
        Mockito.when((Object)businessObjectDictionaryServiceMock.getBusinessObjectAdminService((Class)ArgumentMatchers.eq(Customer.class))).thenReturn((Object)customerAdminServiceMock);
        Mockito.when((Object)businessObjectDictionaryServiceMock.getBusinessObjectEntry((String)ArgumentMatchers.any())).thenReturn((Object)businessObjectEntryMock);
        Person user = (Person)Mockito.mock(Person.class);
        Customer customer = new Customer();
        customer.setCustomerNumber("1234");
        customer.setCustomerName("Ada Lovelace");
        Mockito.when((Object)customerAdminServiceMock.allowsReport((Person)ArgumentMatchers.eq((Object)user))).thenReturn((Object)true);
        List actions = this.cut.getActionLinks((BusinessObjectBase)customer, user);
        Action expected = new Action("Report", "GET", CustomerActionsProviderTest.generateExpectedUrl());
        boolean expectedReportActionExists = actions.stream().anyMatch(action -> action.equals((Object)expected));
        Assertions.assertTrue((boolean)expectedReportActionExists);
    }

    private static String generateExpectedUrl() {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("businessObjectClassName", CustomerOpenItemReportDetail.class.getName());
        params.put("returnLocation", "");
        params.put("lookupableImplServiceName", "arCustomerOpenItemReportLookupable");
        params.put("methodToCall", "search");
        params.put("customerNumber", "1234");
        params.put("reportName", "Customer History Report");
        params.put("customerName", "Ada Lovelace");
        params.put("docFormKey", "88888888");
        return UrlFactory.parameterizeUrl((String)"arCustomerOpenItemReportLookup.do", params);
    }

    @Test
    void getActionLinks_reportDenied_omitsReport(@Mock(stubOnly=true) CustomerAdminService customerAdminServiceMock, @Mock(stubOnly=true) BusinessObjectDictionaryService businessObjectDictionaryServiceMock, @Mock(stubOnly=true) BusinessObjectMetaDataService businessObjectMetaDataServiceMock, @Mock BusinessObjectEntry businessObjectEntryMock) {
        this.setup(businessObjectDictionaryServiceMock, businessObjectMetaDataServiceMock);
        Mockito.when((Object)businessObjectDictionaryServiceMock.getBusinessObjectAdminService((Class)ArgumentMatchers.eq(Customer.class))).thenReturn((Object)customerAdminServiceMock);
        Mockito.when((Object)businessObjectDictionaryServiceMock.getBusinessObjectEntry((String)ArgumentMatchers.any())).thenReturn((Object)businessObjectEntryMock);
        Person user = (Person)Mockito.mock(Person.class);
        Customer customer = new Customer();
        Mockito.when((Object)customerAdminServiceMock.allowsReport((Person)ArgumentMatchers.eq((Object)user))).thenReturn((Object)false);
        List actions = this.cut.getActionLinks((BusinessObjectBase)customer, user);
        boolean hasReportAction = actions.stream().anyMatch(action -> action.getLabel().equals("Report"));
        Assertions.assertFalse((boolean)hasReportAction);
    }

    @Test
    void getActionLinks_supportsSuperEditAction(@Mock(stubOnly=true) CustomerAdminService customerAdminServiceMock, @Mock(stubOnly=true) BusinessObjectDictionaryService businessObjectDictionaryServiceMock, @Mock(stubOnly=true) BusinessObjectMetaDataService businessObjectMetaDataServiceMock, @Mock BusinessObjectEntry businessObjectEntryMock) {
        this.setup(businessObjectDictionaryServiceMock, businessObjectMetaDataServiceMock);
        Mockito.when((Object)businessObjectDictionaryServiceMock.getBusinessObjectAdminService((Class)ArgumentMatchers.eq(Customer.class))).thenReturn((Object)customerAdminServiceMock);
        Mockito.when((Object)businessObjectDictionaryServiceMock.getBusinessObjectEntry((String)ArgumentMatchers.any())).thenReturn((Object)businessObjectEntryMock);
        Person user = (Person)Mockito.mock(Person.class);
        Customer customer = new Customer();
        Mockito.when((Object)businessObjectMetaDataServiceMock.listPrimaryKeyFieldNames((Class)ArgumentMatchers.any())).thenReturn(Collections.emptyList());
        Mockito.when((Object)businessObjectEntryMock.supportsAction(ActionType.EDIT)).thenReturn((Object)true);
        Mockito.when((Object)customerAdminServiceMock.allowsEdit((BusinessObjectBase)ArgumentMatchers.eq((Object)customer), (Person)ArgumentMatchers.eq((Object)user))).thenReturn((Object)true);
        List actions = this.cut.getActionLinks((BusinessObjectBase)customer, user);
        boolean hasEditAction = actions.stream().anyMatch(action -> action.getLabel().equals("Edit"));
        Assertions.assertTrue((boolean)hasEditAction);
    }

    @Test
    void getActionLinks_supportsSuperCopyAction(@Mock(stubOnly=true) CustomerAdminService customerAdminServiceMock, @Mock(stubOnly=true) BusinessObjectDictionaryService businessObjectDictionaryServiceMock, @Mock(stubOnly=true) BusinessObjectMetaDataService businessObjectMetaDataServiceMock, @Mock BusinessObjectEntry businessObjectEntryMock) {
        this.setup(businessObjectDictionaryServiceMock, businessObjectMetaDataServiceMock);
        Mockito.when((Object)businessObjectDictionaryServiceMock.getBusinessObjectAdminService((Class)ArgumentMatchers.eq(Customer.class))).thenReturn((Object)customerAdminServiceMock);
        Mockito.when((Object)businessObjectDictionaryServiceMock.getBusinessObjectEntry((String)ArgumentMatchers.any())).thenReturn((Object)businessObjectEntryMock);
        Person user = (Person)Mockito.mock(Person.class);
        Customer customer = new Customer();
        Mockito.when((Object)businessObjectMetaDataServiceMock.listPrimaryKeyFieldNames((Class)ArgumentMatchers.any())).thenReturn(Collections.emptyList());
        Mockito.when((Object)businessObjectEntryMock.supportsAction(ActionType.EDIT)).thenReturn((Object)true);
        Mockito.when((Object)businessObjectEntryMock.supportsAction(ActionType.COPY)).thenReturn((Object)true);
        Mockito.when((Object)customerAdminServiceMock.allowsCopy((BusinessObjectBase)ArgumentMatchers.eq((Object)customer), (Person)ArgumentMatchers.eq((Object)user))).thenReturn((Object)true);
        List actions = this.cut.getActionLinks((BusinessObjectBase)customer, user);
        boolean hasEditAction = actions.stream().anyMatch(action -> action.getLabel().equals("Copy"));
        Assertions.assertTrue((boolean)hasEditAction);
    }
}

