/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.ar.businessobject.actions;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.kuali.kfs.datadictionary.Action;
import org.kuali.kfs.datadictionary.ActionType;
import org.kuali.kfs.datadictionary.BusinessObjectAdminService;
import org.kuali.kfs.datadictionary.legacy.BusinessObjectDictionaryService;
import org.kuali.kfs.kim.impl.identity.Person;
import org.kuali.kfs.kns.datadictionary.BusinessObjectEntry;
import org.kuali.kfs.kns.lookup.HtmlData;
import org.kuali.kfs.kns.service.BusinessObjectAuthorizationService;
import org.kuali.kfs.kns.service.BusinessObjectMetaDataService;
import org.kuali.kfs.krad.bo.BusinessObjectBase;
import org.kuali.kfs.krad.datadictionary.AttributeDefinition;
import org.kuali.kfs.krad.service.KualiModuleService;
import org.kuali.kfs.krad.service.ModuleService;
import org.kuali.kfs.module.ar.businessobject.InvoiceTemplate;
import org.kuali.kfs.module.ar.businessobject.actions.TemplateActionsProvider;
import org.kuali.kfs.sys.FinancialSystemModuleConfiguration;
import org.mockito.ArgumentMatchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.jupiter.MockitoExtension;

@ExtendWith(value={MockitoExtension.class})
class TemplateActionsProviderTest {
    private final TemplateActionsProvider cut = new TemplateActionsProvider();

    TemplateActionsProviderTest() {
    }

    @Test
    void getActionLinks_canEditAndCopy_fileMissing_includesEditCopyAndUpload(@Mock(stubOnly=true) BusinessObjectAdminService businessObjectAdminServiceMock, @Mock(stubOnly=true) BusinessObjectAuthorizationService businessObjectAuthorizationServiceMock, @Mock(stubOnly=true) BusinessObjectDictionaryService businessObjectDictionaryServiceMock, @Mock(stubOnly=true) BusinessObjectMetaDataService businessObjectMetaDataServiceMock, @Mock(stubOnly=true) KualiModuleService kualiModuleSvcMock, @Mock(stubOnly=true) FinancialSystemModuleConfiguration moduleConfigMock, @Mock(stubOnly=true) BusinessObjectEntry businessObjectEntryMock, @Mock(stubOnly=true) ModuleService moduleSvcMock) {
        Mockito.when((Object)businessObjectDictionaryServiceMock.getBusinessObjectAdminService((Class)ArgumentMatchers.any(Class.class))).thenReturn((Object)businessObjectAdminServiceMock);
        Mockito.when((Object)businessObjectDictionaryServiceMock.getBusinessObjectEntry((String)ArgumentMatchers.any())).thenReturn((Object)businessObjectEntryMock);
        Mockito.when((Object)businessObjectEntryMock.getAttributeDefinition(ArgumentMatchers.anyString())).thenReturn((Object)new AttributeDefinition());
        Mockito.when((Object)kualiModuleSvcMock.getModuleServiceByNamespaceCode("KFS-AR")).thenReturn((Object)moduleSvcMock);
        Mockito.when((Object)moduleSvcMock.getModuleConfiguration()).thenReturn((Object)moduleConfigMock);
        HashMap<String, String> templateFileDirectories = new HashMap<String, String>();
        templateFileDirectories.put("templates.directory", "src/test/resources/org/kuali/kfs/module/ar/templates");
        Mockito.when((Object)moduleConfigMock.getTemplateFileDirectories()).thenReturn(templateFileDirectories);
        HtmlData.AnchorHtmlData anchorData = new HtmlData.AnchorHtmlData();
        anchorData.setHref("inquiry.do");
        this.cut.setBusinessObjectAuthorizationService(businessObjectAuthorizationServiceMock);
        this.cut.setBusinessObjectDictionaryService(businessObjectDictionaryServiceMock);
        this.cut.setBusinessObjectMetaDataService(businessObjectMetaDataServiceMock);
        this.cut.setKualiModuleService(kualiModuleSvcMock);
        this.cut.setBaseUrl("arAccountsReceivableInvoiceTemplateUpload.do");
        this.cut.setTemplateCodeKey("invoiceTemplateCode");
        List<String> pkNames = Collections.singletonList("invoiceTemplateCode");
        Mockito.when((Object)businessObjectMetaDataServiceMock.listPrimaryKeyFieldNames((Class)ArgumentMatchers.any())).thenReturn(pkNames);
        InvoiceTemplate invoiceTemplate = new InvoiceTemplate();
        invoiceTemplate.setInvoiceTemplateCode("IT");
        invoiceTemplate.setFilename("missing");
        Mockito.when((Object)businessObjectAdminServiceMock.allowsEdit((BusinessObjectBase)ArgumentMatchers.any(), (Person)ArgumentMatchers.any())).thenReturn((Object)true);
        Mockito.when((Object)businessObjectEntryMock.supportsAction(ActionType.EDIT)).thenReturn((Object)true);
        Mockito.when((Object)businessObjectAdminServiceMock.allowsCopy((BusinessObjectBase)ArgumentMatchers.any(), (Person)ArgumentMatchers.any())).thenReturn((Object)true);
        Mockito.when((Object)businessObjectEntryMock.supportsAction(ActionType.COPY)).thenReturn((Object)true);
        List actions = this.cut.getActionLinks((BusinessObjectBase)invoiceTemplate, (Person)Mockito.mock(Person.class));
        Assertions.assertEquals((int)3, (int)actions.size());
        Action editAction = (Action)actions.get(0);
        Action expectedEditAction = new Action("Edit", "GET", "maintenance.do?businessObjectClassName=org.kuali.kfs.module.ar.businessobject.InvoiceTemplate&methodToCall=edit&invoiceTemplateCode=IT");
        Assertions.assertEquals((Object)expectedEditAction, (Object)editAction);
        Action copyAction = (Action)actions.get(1);
        Action expectedCopyAction = new Action("Copy", "GET", "maintenance.do?businessObjectClassName=org.kuali.kfs.module.ar.businessobject.InvoiceTemplate&methodToCall=copy&invoiceTemplateCode=IT");
        Assertions.assertEquals((Object)expectedCopyAction, (Object)copyAction);
        Action uploadAction = (Action)actions.get(2);
        Action expectedUploadAction = new Action("Upload", "GET", "arAccountsReceivableInvoiceTemplateUpload.do?methodToCall=start&invoiceTemplateCode=IT");
        Assertions.assertEquals((Object)expectedUploadAction, (Object)uploadAction);
    }

    @Test
    void getActionLinks_canEditAndCopy_fileExists_includesEditCopyUploadAndDownload(@Mock(stubOnly=true) BusinessObjectAdminService businessObjectAdminServiceMock, @Mock(stubOnly=true) BusinessObjectAuthorizationService businessObjectAuthorizationServiceMock, @Mock(stubOnly=true) BusinessObjectDictionaryService businessObjectDictionaryServiceMock, @Mock(stubOnly=true) BusinessObjectMetaDataService businessObjectMetaDataServiceMock, @Mock(stubOnly=true) KualiModuleService kualiModuleSvcMock, @Mock(stubOnly=true) FinancialSystemModuleConfiguration moduleConfigMock, @Mock(stubOnly=true) BusinessObjectEntry businessObjectEntryMock, @Mock(stubOnly=true) ModuleService moduleSvcMock) {
        Mockito.when((Object)businessObjectDictionaryServiceMock.getBusinessObjectAdminService((Class)ArgumentMatchers.any(Class.class))).thenReturn((Object)businessObjectAdminServiceMock);
        Mockito.when((Object)businessObjectDictionaryServiceMock.getBusinessObjectEntry((String)ArgumentMatchers.any())).thenReturn((Object)businessObjectEntryMock);
        Mockito.when((Object)businessObjectEntryMock.getAttributeDefinition(ArgumentMatchers.anyString())).thenReturn((Object)new AttributeDefinition());
        Mockito.when((Object)kualiModuleSvcMock.getModuleServiceByNamespaceCode("KFS-AR")).thenReturn((Object)moduleSvcMock);
        Mockito.when((Object)moduleSvcMock.getModuleConfiguration()).thenReturn((Object)moduleConfigMock);
        HashMap<String, String> templateFileDirectories = new HashMap<String, String>();
        templateFileDirectories.put("templates.directory", "src/test/resources/org/kuali/kfs/module/ar/templates");
        Mockito.when((Object)moduleConfigMock.getTemplateFileDirectories()).thenReturn(templateFileDirectories);
        HtmlData.AnchorHtmlData anchorData = new HtmlData.AnchorHtmlData();
        anchorData.setHref("inquiry.do");
        this.cut.setBusinessObjectAuthorizationService(businessObjectAuthorizationServiceMock);
        this.cut.setBusinessObjectDictionaryService(businessObjectDictionaryServiceMock);
        this.cut.setBusinessObjectMetaDataService(businessObjectMetaDataServiceMock);
        this.cut.setKualiModuleService(kualiModuleSvcMock);
        this.cut.setBaseUrl("arAccountsReceivableInvoiceTemplateUpload.do");
        this.cut.setTemplateCodeKey("invoiceTemplateCode");
        List<String> pkNames = Collections.singletonList("invoiceTemplateCode");
        Mockito.when((Object)businessObjectMetaDataServiceMock.listPrimaryKeyFieldNames((Class)ArgumentMatchers.any())).thenReturn(pkNames);
        InvoiceTemplate invoiceTemplate = new InvoiceTemplate();
        invoiceTemplate.setInvoiceTemplateCode("IT");
        invoiceTemplate.setFilename("dummyTemplate");
        Mockito.when((Object)businessObjectAdminServiceMock.allowsEdit((BusinessObjectBase)ArgumentMatchers.any(), (Person)ArgumentMatchers.any())).thenReturn((Object)true);
        Mockito.when((Object)businessObjectEntryMock.supportsAction(ActionType.EDIT)).thenReturn((Object)true);
        Mockito.when((Object)businessObjectAdminServiceMock.allowsCopy((BusinessObjectBase)ArgumentMatchers.any(), (Person)ArgumentMatchers.any())).thenReturn((Object)true);
        Mockito.when((Object)businessObjectEntryMock.supportsAction(ActionType.COPY)).thenReturn((Object)true);
        List actions = this.cut.getActionLinks((BusinessObjectBase)invoiceTemplate, (Person)Mockito.mock(Person.class));
        Assertions.assertEquals((int)4, (int)actions.size());
        Action editAction = (Action)actions.get(0);
        Action expectedEditAction = new Action("Edit", "GET", "maintenance.do?businessObjectClassName=org.kuali.kfs.module.ar.businessobject.InvoiceTemplate&methodToCall=edit&invoiceTemplateCode=IT");
        Assertions.assertEquals((Object)expectedEditAction, (Object)editAction);
        Action copyAction = (Action)actions.get(1);
        Action expectedCopyAction = new Action("Copy", "GET", "maintenance.do?businessObjectClassName=org.kuali.kfs.module.ar.businessobject.InvoiceTemplate&methodToCall=copy&invoiceTemplateCode=IT");
        Assertions.assertEquals((Object)expectedCopyAction, (Object)copyAction);
        Action uploadAction = (Action)actions.get(2);
        Action expectedUploadAction = new Action("Upload", "GET", "arAccountsReceivableInvoiceTemplateUpload.do?methodToCall=start&invoiceTemplateCode=IT");
        Assertions.assertEquals((Object)expectedUploadAction, (Object)uploadAction);
        Action downloadAction = (Action)actions.get(2);
        Action expectedDownloadAction = new Action("Upload", "GET", "arAccountsReceivableInvoiceTemplateUpload.do?methodToCall=start&invoiceTemplateCode=IT");
        Assertions.assertEquals((Object)expectedDownloadAction, (Object)downloadAction);
    }

    @Test
    void getActionLinks_noPermissionToEditOrCopy_noLinks(@Mock(stubOnly=true) BusinessObjectAdminService businessObjectAdminServiceMock, @Mock(stubOnly=true) BusinessObjectAuthorizationService businessObjectAuthorizationServiceMock, @Mock(stubOnly=true) BusinessObjectDictionaryService businessObjectDictionaryServiceMock, @Mock(stubOnly=true) BusinessObjectMetaDataService businessObjectMetaDataServiceMock, @Mock(stubOnly=true) KualiModuleService kualiModuleSvcMock, @Mock(stubOnly=true) BusinessObjectEntry businessObjectEntryMock) {
        Mockito.when((Object)businessObjectDictionaryServiceMock.getBusinessObjectAdminService((Class)ArgumentMatchers.any(Class.class))).thenReturn((Object)businessObjectAdminServiceMock);
        Mockito.when((Object)businessObjectDictionaryServiceMock.getBusinessObjectEntry((String)ArgumentMatchers.any())).thenReturn((Object)businessObjectEntryMock);
        HtmlData.AnchorHtmlData anchorData = new HtmlData.AnchorHtmlData();
        anchorData.setHref("inquiry.do");
        this.cut.setBusinessObjectAuthorizationService(businessObjectAuthorizationServiceMock);
        this.cut.setBusinessObjectDictionaryService(businessObjectDictionaryServiceMock);
        this.cut.setBusinessObjectMetaDataService(businessObjectMetaDataServiceMock);
        this.cut.setKualiModuleService(kualiModuleSvcMock);
        this.cut.setBaseUrl("arAccountsReceivableInvoiceTemplateUpload.do");
        this.cut.setTemplateCodeKey("invoiceTemplateCode");
        InvoiceTemplate invoiceTemplate = new InvoiceTemplate();
        invoiceTemplate.setInvoiceTemplateCode("IT");
        List actions = this.cut.getActionLinks((BusinessObjectBase)invoiceTemplate, (Person)Mockito.mock(Person.class));
        Assertions.assertEquals((int)0, (int)actions.size());
    }
}

