/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.ar.businessobject.admin;

import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.kuali.kfs.kim.api.permission.PermissionService;
import org.kuali.kfs.kim.impl.identity.Person;
import org.kuali.kfs.krad.bo.BusinessObjectBase;
import org.kuali.kfs.module.ar.businessobject.Customer;
import org.kuali.kfs.module.ar.businessobject.admin.CustomerAdminService;
import org.mockito.ArgumentMatchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.jupiter.MockitoExtension;

@ExtendWith(value={MockitoExtension.class})
class CustomerAdminServiceTest {
    private final CustomerAdminService cut = new CustomerAdminService();

    CustomerAdminServiceTest() {
    }

    @Test
    void allowsCopy_returnsFalse(@Mock(stubOnly=true) PermissionService permissionServiceMock, @Mock(stubOnly=true) Person userMock) {
        this.cut.setPermissionService(permissionServiceMock);
        Customer customer = new Customer();
        Assertions.assertFalse((boolean)this.cut.allowsCopy((BusinessObjectBase)customer, userMock));
    }

    @Test
    void allowsReport_permissionGranted_returnsTrue(@Mock(stubOnly=true) PermissionService permissionServiceMock, @Mock(stubOnly=true) Person userMock) {
        this.cut.setPermissionService(permissionServiceMock);
        Mockito.when((Object)userMock.getPrincipalId()).thenReturn((Object)"1234");
        Mockito.when((Object)permissionServiceMock.isAuthorizedByTemplate((String)ArgumentMatchers.eq((Object)"1234"), (String)ArgumentMatchers.eq((Object)"KFS-SYS"), (String)ArgumentMatchers.eq((Object)"Use Screen"), ArgumentMatchers.anyMap(), ArgumentMatchers.anyMap())).thenReturn((Object)true);
        Assertions.assertTrue((boolean)this.cut.allowsReport(userMock));
    }

    @Test
    void allowsReport_permissionDenied_returnsFalse(@Mock(stubOnly=true) PermissionService permissionServiceMock, @Mock(stubOnly=true) Person userMock) {
        this.cut.setPermissionService(permissionServiceMock);
        Mockito.when((Object)userMock.getPrincipalId()).thenReturn((Object)"1234");
        Mockito.when((Object)permissionServiceMock.isAuthorizedByTemplate((String)ArgumentMatchers.eq((Object)"1234"), (String)ArgumentMatchers.eq((Object)"KFS-SYS"), (String)ArgumentMatchers.eq((Object)"Use Screen"), ArgumentMatchers.anyMap(), ArgumentMatchers.anyMap())).thenReturn((Object)false);
        Assertions.assertFalse((boolean)this.cut.allowsReport(userMock));
    }
}

