/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.ar.businessobject.admin;

import java.util.Map;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.kuali.kfs.datadictionary.legacy.DocumentDictionaryService;
import org.kuali.kfs.kim.api.permission.PermissionService;
import org.kuali.kfs.kim.impl.identity.Person;
import org.kuali.kfs.krad.bo.BusinessObjectBase;
import org.kuali.kfs.krad.service.KRADServiceLocatorWeb;
import org.kuali.kfs.krad.service.KualiModuleService;
import org.kuali.kfs.module.ar.businessobject.OrganizationAccountingDefault;
import org.kuali.kfs.module.ar.businessobject.admin.OrganizationAccountingDefaultAdminService;
import org.mockito.ArgumentMatchers;
import org.mockito.Mock;
import org.mockito.MockedStatic;
import org.mockito.Mockito;
import org.mockito.junit.jupiter.MockitoExtension;

@ExtendWith(value={MockitoExtension.class})
class OrganizationAccountingDefaultAdminServiceTest {
    private final OrganizationAccountingDefaultAdminService cut = new OrganizationAccountingDefaultAdminService();
    private OrganizationAccountingDefault organizationAccountingDefault;
    @Mock
    private DocumentDictionaryService documentDictionaryServiceMock;
    @Mock
    private PermissionService permissionServiceMock;
    @Mock
    private Person personMock;

    OrganizationAccountingDefaultAdminServiceTest() {
    }

    @BeforeEach
    void setUp() {
        this.cut.setDocumentDictionaryService(this.documentDictionaryServiceMock);
        this.cut.setPermissionService(this.permissionServiceMock);
        this.organizationAccountingDefault = new OrganizationAccountingDefault();
        this.organizationAccountingDefault.setChartOfAccountsCode("BL");
        this.organizationAccountingDefault.setOrganizationCode("PSY");
    }

    @Test
    void allowsEdit_createMaintainPermissionTrue_returnsTrue() {
        Mockito.when((Object)this.personMock.getPrincipalId()).thenReturn((Object)"khuntley");
        try (MockedStatic theStaticMock = Mockito.mockStatic(KRADServiceLocatorWeb.class);){
            KualiModuleService kualiModuleServiceMock = (KualiModuleService)Mockito.mock(KualiModuleService.class);
            theStaticMock.when(KRADServiceLocatorWeb::getKualiModuleService).thenReturn((Object)kualiModuleServiceMock);
            Map roleQualifications = this.cut.buildRoleQualifications((Object)this.organizationAccountingDefault, this.personMock.getPrincipalId());
            Mockito.when((Object)this.permissionServiceMock.isAuthorizedByTemplate(ArgumentMatchers.anyString(), ArgumentMatchers.anyString(), ArgumentMatchers.anyString(), ArgumentMatchers.anyMap(), (Map)ArgumentMatchers.eq((Object)roleQualifications))).thenReturn((Object)true);
            Assertions.assertTrue((boolean)this.cut.allowsEdit((BusinessObjectBase)this.organizationAccountingDefault, this.personMock));
        }
    }

    @Test
    void allowsEdit_createMaintainPermissionFalse_returnsFalse() {
        Mockito.when((Object)this.personMock.getPrincipalId()).thenReturn((Object)"khuntley");
        try (MockedStatic theStaticMock = Mockito.mockStatic(KRADServiceLocatorWeb.class);){
            KualiModuleService kualiModuleServiceMock = (KualiModuleService)Mockito.mock(KualiModuleService.class);
            theStaticMock.when(KRADServiceLocatorWeb::getKualiModuleService).thenReturn((Object)kualiModuleServiceMock);
            Map roleQualifications = this.cut.buildRoleQualifications((Object)this.organizationAccountingDefault, this.personMock.getPrincipalId());
            Mockito.when((Object)this.permissionServiceMock.isAuthorizedByTemplate(ArgumentMatchers.anyString(), ArgumentMatchers.anyString(), ArgumentMatchers.anyString(), ArgumentMatchers.anyMap(), (Map)ArgumentMatchers.eq((Object)roleQualifications))).thenReturn((Object)false);
            Assertions.assertFalse((boolean)this.cut.allowsEdit((BusinessObjectBase)this.organizationAccountingDefault, this.personMock));
        }
    }
}

