/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.ar.businessobject.lookup;

import java.sql.Date;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.junit.jupiter.api.parallel.Execution;
import org.junit.jupiter.api.parallel.ExecutionMode;
import org.kuali.kfs.core.api.config.property.ConfigurationService;
import org.kuali.kfs.core.api.util.type.KualiDecimal;
import org.kuali.kfs.datadictionary.legacy.BusinessObjectDictionaryService;
import org.kuali.kfs.integration.cg.ContractsAndGrantsBillingAgency;
import org.kuali.kfs.integration.cg.ContractsAndGrantsBillingAward;
import org.kuali.kfs.kew.api.WorkflowDocument;
import org.kuali.kfs.kns.datadictionary.BusinessObjectEntry;
import org.kuali.kfs.kns.service.BusinessObjectMetaDataService;
import org.kuali.kfs.kns.service.KNSServiceLocator;
import org.kuali.kfs.kns.util.FieldUtils;
import org.kuali.kfs.kns.web.struts.form.LookupForm;
import org.kuali.kfs.krad.service.BusinessObjectService;
import org.kuali.kfs.krad.service.KualiModuleService;
import org.kuali.kfs.krad.service.ModuleService;
import org.kuali.kfs.module.ar.businessobject.AccountsReceivableDocumentHeader;
import org.kuali.kfs.module.ar.businessobject.ContractsGrantsAgingOpenInvoicesReport;
import org.kuali.kfs.module.ar.businessobject.CustomerInvoiceDetail;
import org.kuali.kfs.module.ar.businessobject.InvoiceGeneralDetail;
import org.kuali.kfs.module.ar.businessobject.lookup.ContractsGrantsAgingOpenInvoicesReportLookupableHelperServiceImpl;
import org.kuali.kfs.module.ar.document.ContractsGrantsInvoiceDocument;
import org.kuali.kfs.module.ar.document.service.ContractsGrantsAgingOpenInvoicesReportService;
import org.kuali.kfs.module.ar.document.service.CustomerInvoiceDocumentService;
import org.kuali.kfs.module.ar.document.service.impl.ContractsGrantsAgingOpenInvoicesReportServiceImpl;
import org.kuali.kfs.module.ar.document.service.impl.CustomerInvoiceDocumentServiceImpl;
import org.kuali.kfs.module.ar.report.service.ContractsGrantsAgingReportService;
import org.kuali.kfs.module.ar.report.service.ContractsGrantsReportHelperService;
import org.kuali.kfs.module.ar.report.service.impl.ContractsGrantsReportHelperServiceImpl;
import org.kuali.kfs.module.ar.web.struts.ContractsGrantsAgingOpenInvoicesReportForm;
import org.kuali.kfs.sys.businessobject.DocumentHeader;
import org.mockito.ArgumentMatchers;
import org.mockito.Mock;
import org.mockito.MockedStatic;
import org.mockito.Mockito;
import org.mockito.junit.jupiter.MockitoExtension;

@Execution(value=ExecutionMode.SAME_THREAD)
@ExtendWith(value={MockitoExtension.class})
class ContractsGrantsAgingOpenInvoicesReportLookupableHelperServiceImplTest {
    private static final String CHART_CODE = "BL";
    private static final String ORG_CODE = "UGCS";
    private static final String CUSTOMER_NAME = "WOODS CORPORATION";
    private static final String CUSTOMER_NUMBER = "ABB2";
    private Map<String, String> fieldValues;
    @Mock(stubOnly=true)
    private BusinessObjectDictionaryService businessObjectDictionarySvcMock;
    @Mock(stubOnly=true)
    private BusinessObjectMetaDataService businessObjectMetaDataSvcMock;
    private ContractsGrantsAgingOpenInvoicesReportLookupableHelperServiceImpl cut;

    ContractsGrantsAgingOpenInvoicesReportLookupableHelperServiceImplTest() {
    }

    @BeforeEach
    void setUp(@Mock(stubOnly=true) BusinessObjectEntry businessObjectEntryMock) {
        FieldUtils.setBusinessObjectDictionaryService((BusinessObjectDictionaryService)this.businessObjectDictionarySvcMock);
        Mockito.when((Object)businessObjectEntryMock.hasLookupDefinition()).thenReturn((Object)false);
        Mockito.when((Object)this.businessObjectDictionarySvcMock.getBusinessObjectEntry(ContractsGrantsAgingOpenInvoicesReport.class.getName())).thenReturn((Object)businessObjectEntryMock);
        Mockito.when((Object)this.businessObjectMetaDataSvcMock.isLookupable(ContractsGrantsAgingOpenInvoicesReport.class)).thenReturn((Object)true);
        Mockito.when((Object)this.businessObjectMetaDataSvcMock.isLookupable(ContractsGrantsAgingOpenInvoicesReport.class)).thenReturn((Object)true);
        ArrayList lookupFieldAttributeList = new ArrayList();
        Mockito.when((Object)this.businessObjectMetaDataSvcMock.getLookupableFieldNames(ContractsGrantsAgingOpenInvoicesReport.class)).thenReturn(lookupFieldAttributeList);
        this.setupFieldValues();
    }

    @AfterEach
    void cleanUpAfterOurselfSoSubsequentTestsDoNotReuseOurMocking() {
        FieldUtils.setBusinessObjectDictionaryService(null);
    }

    private void setupFieldValues() {
        this.fieldValues = new LinkedHashMap<String, String>();
        SimpleDateFormat dateFormat = new SimpleDateFormat("MM/dd/yyyy", Locale.US);
        this.fieldValues.put("backLocation", null);
        this.fieldValues.put("reportRunDate", dateFormat.format(new java.util.Date()));
        this.fieldValues.put("organizationCode", ORG_CODE);
        this.fieldValues.put("billingChartCode", CHART_CODE);
        this.fieldValues.put("docFormKey", null);
        this.fieldValues.put("customerNumber", CUSTOMER_NUMBER);
        this.fieldValues.put("customerName", CUSTOMER_NAME);
        this.fieldValues.put("businessObjectClassName", ContractsGrantsAgingOpenInvoicesReport.class.getName());
    }

    private void setupCut(BusinessObjectService businessObjectSvcMock, ConfigurationService configurationSvcMock, ContractsGrantsAgingReportService contractsGrantsAgingReportSvcMock, KualiModuleService kualiModuleSvcMock) {
        ContractsGrantsAgingOpenInvoicesReportServiceImpl contractsGrantsAgingOpenInvoicesReportService = new ContractsGrantsAgingOpenInvoicesReportServiceImpl();
        contractsGrantsAgingOpenInvoicesReportService.setContractsGrantsAgingReportService(contractsGrantsAgingReportSvcMock);
        contractsGrantsAgingOpenInvoicesReportService.setCustomerInvoiceDocumentService((CustomerInvoiceDocumentService)new CustomerInvoiceDocumentServiceImpl());
        contractsGrantsAgingOpenInvoicesReportService.setKualiModuleService(kualiModuleSvcMock);
        ContractsGrantsReportHelperServiceImpl contractsGrantsReportHelperService = new ContractsGrantsReportHelperServiceImpl();
        contractsGrantsReportHelperService.setConfigurationService(configurationSvcMock);
        this.cut = new ContractsGrantsAgingOpenInvoicesReportLookupableHelperServiceImpl();
        this.cut.setBusinessObjectDictionaryService(this.businessObjectDictionarySvcMock);
        this.cut.setBusinessObjectService(businessObjectSvcMock);
        this.cut.setBusinessObjectMetaDataService(this.businessObjectMetaDataSvcMock);
        this.cut.setContractsGrantsAgingOpenInvoicesReportService((ContractsGrantsAgingOpenInvoicesReportService)contractsGrantsAgingOpenInvoicesReportService);
        this.cut.setContractsGrantsReportHelperService((ContractsGrantsReportHelperService)contractsGrantsReportHelperService);
        this.cut.setBusinessObjectClass(ContractsGrantsAgingOpenInvoicesReport.class);
        LinkedHashMap<String, String[]> parameters = new LinkedHashMap<String, String[]>();
        parameters.put("customerNumber", new String[]{CUSTOMER_NUMBER});
        parameters.put("customerName", new String[]{CUSTOMER_NAME});
        this.cut.setParameters(parameters);
    }

    private static void setupContractsAndGrantsServiceFiltering(ContractsGrantsAgingReportService contractsGrantsAgingReportSvcMock, ContractsGrantsInvoiceDocument contractsGrantsInvoiceDocumentMock) throws ParseException {
        LinkedHashMap<String, String> fieldValues = new LinkedHashMap<String, String>();
        fieldValues.put("customerNumber", CUSTOMER_NUMBER);
        fieldValues.put("customerName", CUSTOMER_NAME);
        ArrayList<ContractsGrantsInvoiceDocument> contractsGrantsInvoiceDocuments = new ArrayList<ContractsGrantsInvoiceDocument>();
        contractsGrantsInvoiceDocuments.add(contractsGrantsInvoiceDocumentMock);
        LinkedHashMap<String, ArrayList<ContractsGrantsInvoiceDocument>> invoiceMap = new LinkedHashMap<String, ArrayList<ContractsGrantsInvoiceDocument>>();
        invoiceMap.put("ABB2-WOODS CORPORATION", contractsGrantsInvoiceDocuments);
        Mockito.when((Object)contractsGrantsAgingReportSvcMock.filterContractsGrantsAgingReport(fieldValues, null, null)).thenReturn(invoiceMap);
    }

    @Test
    void getSearchResults(@Mock(stubOnly=true) BusinessObjectService businessObjectSvcMock, @Mock(stubOnly=true) ConfigurationService configurationSvcMock, @Mock(stubOnly=true) ContractsAndGrantsBillingAgency agencyMock, @Mock(stubOnly=true) ContractsAndGrantsBillingAward awardMock, @Mock(stubOnly=true) ContractsGrantsAgingReportService contractsGrantsAgingReportSvcMock, @Mock(stubOnly=true) ContractsGrantsInvoiceDocument contractsGrantsInvoiceDocumentMock, @Mock(stubOnly=true) CustomerInvoiceDetail customerInvoiceDetailMock, @Mock(stubOnly=true) InvoiceGeneralDetail invoiceGeneralDetailMock, @Mock(stubOnly=true) KualiModuleService kualiModuleSvcMock, @Mock(stubOnly=true) ModuleService moduleSvcMock, @Mock(stubOnly=true) WorkflowDocument workflowDocumentMock) throws Exception {
        Mockito.when((Object)awardMock.getProposalNumber()).thenReturn((Object)"11");
        Mockito.when((Object)agencyMock.getAgencyNumber()).thenReturn((Object)"11505");
        Mockito.when((Object)workflowDocumentMock.getDocumentTypeName()).thenReturn((Object)"CINV");
        DocumentHeader documentHeader = new DocumentHeader();
        documentHeader.setFinancialDocumentStatusCode("A");
        documentHeader.setFinancialDocumentTotalAmount(new KualiDecimal(1000.0));
        documentHeader.setWorkflowDocument(workflowDocumentMock);
        Mockito.when((Object)contractsGrantsInvoiceDocumentMock.getDocumentHeader()).thenReturn((Object)documentHeader);
        AccountsReceivableDocumentHeader accountsReceivableDocumentHeader = new AccountsReceivableDocumentHeader();
        accountsReceivableDocumentHeader.setCustomerNumber(CUSTOMER_NUMBER);
        Mockito.when((Object)contractsGrantsInvoiceDocumentMock.getAccountsReceivableDocumentHeader()).thenReturn((Object)accountsReceivableDocumentHeader);
        Mockito.when((Object)contractsGrantsInvoiceDocumentMock.getDocumentHeader()).thenReturn((Object)documentHeader);
        Mockito.when((Object)contractsGrantsInvoiceDocumentMock.getBillingDate()).thenReturn((Object)Date.valueOf(LocalDate.now()));
        Mockito.when((Object)contractsGrantsInvoiceDocumentMock.getInvoiceDueDate()).thenReturn((Object)Date.valueOf(LocalDate.now().plusDays(30L)));
        Mockito.when((Object)contractsGrantsInvoiceDocumentMock.getDocumentNumber()).thenReturn((Object)"1");
        String proposalNumber = awardMock.getProposalNumber();
        Mockito.when((Object)invoiceGeneralDetailMock.getProposalNumber()).thenReturn((Object)proposalNumber);
        Mockito.when((Object)contractsGrantsInvoiceDocumentMock.getInvoiceGeneralDetail()).thenReturn((Object)invoiceGeneralDetailMock);
        ArrayList<CustomerInvoiceDetail> customerInvoiceDetails = new ArrayList<CustomerInvoiceDetail>();
        Mockito.when((Object)customerInvoiceDetailMock.getAccountNumber()).thenReturn((Object)"1031400");
        customerInvoiceDetails.add(customerInvoiceDetailMock);
        Mockito.when((Object)contractsGrantsInvoiceDocumentMock.getSourceAccountingLines()).thenReturn(customerInvoiceDetails);
        try (MockedStatic knsServiceLocatorMockedStatic = Mockito.mockStatic(KNSServiceLocator.class);){
            knsServiceLocatorMockedStatic.when(KNSServiceLocator::getBusinessObjectDictionaryService).thenReturn((Object)this.businessObjectDictionarySvcMock);
            ContractsGrantsAgingOpenInvoicesReportLookupableHelperServiceImplTest.setupContractsAndGrantsServiceFiltering(contractsGrantsAgingReportSvcMock, contractsGrantsInvoiceDocumentMock);
            this.setupCut(businessObjectSvcMock, configurationSvcMock, contractsGrantsAgingReportSvcMock, kualiModuleSvcMock);
            HashMap<String, String> args = new HashMap<String, String>();
            args.put("customerNumber", CUSTOMER_NUMBER);
            Mockito.when((Object)((ContractsAndGrantsBillingAgency)moduleSvcMock.getExternalizableBusinessObject(ContractsAndGrantsBillingAgency.class, args))).thenReturn((Object)agencyMock);
            Mockito.when((Object)kualiModuleSvcMock.getResponsibleModuleService(ContractsAndGrantsBillingAgency.class)).thenReturn((Object)moduleSvcMock);
            List searchResults = this.cut.getSearchResults(this.fieldValues);
            Assertions.assertNotNull((Object)searchResults, (String)"search results not null");
            Assertions.assertEquals((int)1, (int)searchResults.size());
            ContractsGrantsAgingOpenInvoicesReport contractsGrantsAgingOpenInvoicesReport = (ContractsGrantsAgingOpenInvoicesReport)searchResults.get(0);
            Assertions.assertEquals((Object)"No", (Object)contractsGrantsAgingOpenInvoicesReport.getFinalInvoice());
            Assertions.assertEquals((Object)agencyMock.getAgencyNumber(), (Object)contractsGrantsAgingOpenInvoicesReport.getAgencyNumber());
            Assertions.assertEquals((Object)"CINV", (Object)contractsGrantsAgingOpenInvoicesReport.getDocumentType());
            Assertions.assertEquals((Object)"1", (Object)contractsGrantsAgingOpenInvoicesReport.getDocumentNumber());
            Assertions.assertEquals((Object)"", (Object)contractsGrantsAgingOpenInvoicesReport.getDocumentDescription());
            Assertions.assertEquals((Object)awardMock.getProposalNumber(), (Object)contractsGrantsAgingOpenInvoicesReport.getProposalNumber());
            Assertions.assertEquals((Object)"1031400", (Object)contractsGrantsAgingOpenInvoicesReport.getAccountNumber());
            Assertions.assertEquals((Object)contractsGrantsInvoiceDocumentMock.getBillingDate(), (Object)contractsGrantsAgingOpenInvoicesReport.getBillingDate());
            Assertions.assertEquals((Object)contractsGrantsInvoiceDocumentMock.getInvoiceDueDate(), (Object)contractsGrantsAgingOpenInvoicesReport.getDueApprovedDate());
            Assertions.assertEquals((Object)new KualiDecimal(0.0), (Object)contractsGrantsAgingOpenInvoicesReport.getUnpaidUnappliedAmount());
            Assertions.assertEquals((Object)new KualiDecimal(1000.0), (Object)contractsGrantsAgingOpenInvoicesReport.getDocumentPaymentAmount());
        }
    }

    @Test
    void getSearchResults_NoInvoiceFound(@Mock(stubOnly=true) BusinessObjectService businessObjectSvcMock, @Mock(stubOnly=true) ConfigurationService configurationSvcMock, @Mock(stubOnly=true) ContractsGrantsAgingReportService contractsGrantsAgingReportSvcMock, @Mock(stubOnly=true) KualiModuleService kualiModuleSvcMock) throws Exception {
        try (MockedStatic knsServiceLocatorMockedStatic = Mockito.mockStatic(KNSServiceLocator.class);){
            knsServiceLocatorMockedStatic.when(KNSServiceLocator::getBusinessObjectDictionaryService).thenReturn((Object)this.businessObjectDictionarySvcMock);
            this.setupCut(businessObjectSvcMock, configurationSvcMock, contractsGrantsAgingReportSvcMock, kualiModuleSvcMock);
            Mockito.when((Object)contractsGrantsAgingReportSvcMock.filterContractsGrantsAgingReport(ArgumentMatchers.anyMap(), (Date)ArgumentMatchers.eq(null), (Date)ArgumentMatchers.eq(null))).thenReturn(Collections.emptyMap());
            List searchResults = this.cut.getSearchResults(this.fieldValues);
            Assertions.assertNotNull((Object)searchResults, (String)"search results not null");
            Assertions.assertEquals((int)0, (int)searchResults.size());
        }
    }

    @Test
    void performLookup(@Mock(stubOnly=true) BusinessObjectService businessObjectSvcMock, @Mock(stubOnly=true) ConfigurationService configurationSvcMock, @Mock(stubOnly=true) ContractsAndGrantsBillingAgency agencyMock, @Mock(stubOnly=true) ContractsAndGrantsBillingAward awardMock, @Mock(stubOnly=true) ContractsGrantsAgingReportService contractsGrantsAgingReportSvcMock, @Mock(stubOnly=true) ContractsGrantsInvoiceDocument contractsGrantsInvoiceDocumentMock, @Mock(stubOnly=true) CustomerInvoiceDetail customerInvoiceDetailMock, @Mock(stubOnly=true) InvoiceGeneralDetail invoiceGeneralDetailMock, @Mock(stubOnly=true) KualiModuleService kualiModuleSvcMock, @Mock(stubOnly=true) ModuleService moduleSvcMock, @Mock(stubOnly=true) WorkflowDocument workflowDocumentMock) throws Exception {
        Mockito.when((Object)awardMock.getProposalNumber()).thenReturn((Object)"11");
        Mockito.when((Object)agencyMock.getAgencyNumber()).thenReturn((Object)"11505");
        Mockito.when((Object)workflowDocumentMock.getDocumentTypeName()).thenReturn((Object)"CINV");
        DocumentHeader documentHeader = new DocumentHeader();
        documentHeader.setFinancialDocumentStatusCode("A");
        documentHeader.setFinancialDocumentTotalAmount(new KualiDecimal(1000.0));
        documentHeader.setWorkflowDocument(workflowDocumentMock);
        Mockito.when((Object)contractsGrantsInvoiceDocumentMock.getDocumentHeader()).thenReturn((Object)documentHeader);
        AccountsReceivableDocumentHeader accountsReceivableDocumentHeader = new AccountsReceivableDocumentHeader();
        accountsReceivableDocumentHeader.setCustomerNumber(CUSTOMER_NUMBER);
        Mockito.when((Object)contractsGrantsInvoiceDocumentMock.getAccountsReceivableDocumentHeader()).thenReturn((Object)accountsReceivableDocumentHeader);
        Mockito.when((Object)contractsGrantsInvoiceDocumentMock.getDocumentHeader()).thenReturn((Object)documentHeader);
        Mockito.when((Object)contractsGrantsInvoiceDocumentMock.getBillingDate()).thenReturn((Object)Date.valueOf(LocalDate.now()));
        Mockito.when((Object)contractsGrantsInvoiceDocumentMock.getInvoiceDueDate()).thenReturn((Object)Date.valueOf(LocalDate.now().plusDays(30L)));
        Mockito.when((Object)contractsGrantsInvoiceDocumentMock.getDocumentNumber()).thenReturn((Object)"1");
        String proposalNumber = awardMock.getProposalNumber();
        Mockito.when((Object)invoiceGeneralDetailMock.getProposalNumber()).thenReturn((Object)proposalNumber);
        Mockito.when((Object)contractsGrantsInvoiceDocumentMock.getInvoiceGeneralDetail()).thenReturn((Object)invoiceGeneralDetailMock);
        ArrayList<CustomerInvoiceDetail> customerInvoiceDetails = new ArrayList<CustomerInvoiceDetail>();
        Mockito.when((Object)customerInvoiceDetailMock.getAccountNumber()).thenReturn((Object)"1031400");
        customerInvoiceDetails.add(customerInvoiceDetailMock);
        Mockito.when((Object)contractsGrantsInvoiceDocumentMock.getSourceAccountingLines()).thenReturn(customerInvoiceDetails);
        try (MockedStatic knsServiceLocatorMockedStatic = Mockito.mockStatic(KNSServiceLocator.class);){
            knsServiceLocatorMockedStatic.when(KNSServiceLocator::getBusinessObjectDictionaryService).thenReturn((Object)this.businessObjectDictionarySvcMock);
            ContractsGrantsAgingOpenInvoicesReportLookupableHelperServiceImplTest.setupContractsAndGrantsServiceFiltering(contractsGrantsAgingReportSvcMock, contractsGrantsInvoiceDocumentMock);
            this.setupCut(businessObjectSvcMock, configurationSvcMock, contractsGrantsAgingReportSvcMock, kualiModuleSvcMock);
            HashMap<String, String> args = new HashMap<String, String>();
            args.put("customerNumber", CUSTOMER_NUMBER);
            Mockito.when((Object)((ContractsAndGrantsBillingAgency)moduleSvcMock.getExternalizableBusinessObject(ContractsAndGrantsBillingAgency.class, args))).thenReturn((Object)agencyMock);
            Mockito.when((Object)kualiModuleSvcMock.getResponsibleModuleService(ContractsAndGrantsBillingAgency.class)).thenReturn((Object)moduleSvcMock);
            ContractsGrantsAgingOpenInvoicesReportForm agingOpenInvoicesReportForm = new ContractsGrantsAgingOpenInvoicesReportForm();
            agingOpenInvoicesReportForm.setFieldsForLookup(this.fieldValues);
            Collection lookupResults = this.cut.performLookup((LookupForm)agingOpenInvoicesReportForm, new ArrayList(), true);
            Assertions.assertNotNull((Object)lookupResults);
            Assertions.assertEquals((int)1, (int)lookupResults.size());
            ContractsGrantsAgingOpenInvoicesReport contractsGrantsAgingOpenInvoicesReport = (ContractsGrantsAgingOpenInvoicesReport)lookupResults.iterator().next();
            Assertions.assertEquals((Object)"No", (Object)contractsGrantsAgingOpenInvoicesReport.getFinalInvoice());
            Assertions.assertEquals((Object)agencyMock.getAgencyNumber(), (Object)contractsGrantsAgingOpenInvoicesReport.getAgencyNumber());
            Assertions.assertEquals((Object)"CINV", (Object)contractsGrantsAgingOpenInvoicesReport.getDocumentType());
            Assertions.assertEquals((Object)"1", (Object)contractsGrantsAgingOpenInvoicesReport.getDocumentNumber());
            Assertions.assertEquals((Object)"", (Object)contractsGrantsAgingOpenInvoicesReport.getDocumentDescription());
            Assertions.assertEquals((Object)awardMock.getProposalNumber(), (Object)contractsGrantsAgingOpenInvoicesReport.getProposalNumber());
            Assertions.assertEquals((Object)"1031400", (Object)contractsGrantsAgingOpenInvoicesReport.getAccountNumber());
            Assertions.assertEquals((Object)contractsGrantsInvoiceDocumentMock.getBillingDate(), (Object)contractsGrantsAgingOpenInvoicesReport.getBillingDate());
            Assertions.assertEquals((Object)contractsGrantsInvoiceDocumentMock.getInvoiceDueDate(), (Object)contractsGrantsAgingOpenInvoicesReport.getDueApprovedDate());
            Assertions.assertEquals((Object)new KualiDecimal(0.0), (Object)contractsGrantsAgingOpenInvoicesReport.getUnpaidUnappliedAmount());
            Assertions.assertEquals((Object)new KualiDecimal(1000.0), (Object)contractsGrantsAgingOpenInvoicesReport.getDocumentPaymentAmount());
        }
    }

    @Test
    void performLookup_NoInvoiceFound(@Mock(stubOnly=true) BusinessObjectService businessObjectSvcMock, @Mock(stubOnly=true) ConfigurationService configurationSvcMock, @Mock(stubOnly=true) ContractsGrantsAgingReportService contractsGrantsAgingReportSvcMock, @Mock(stubOnly=true) KualiModuleService kualiModuleSvcMock) throws Exception {
        try (MockedStatic knsServiceLocatorMockedStatic = Mockito.mockStatic(KNSServiceLocator.class);){
            knsServiceLocatorMockedStatic.when(KNSServiceLocator::getBusinessObjectDictionaryService).thenReturn((Object)this.businessObjectDictionarySvcMock);
            this.setupCut(businessObjectSvcMock, configurationSvcMock, contractsGrantsAgingReportSvcMock, kualiModuleSvcMock);
            Mockito.when((Object)contractsGrantsAgingReportSvcMock.filterContractsGrantsAgingReport(ArgumentMatchers.anyMap(), (Date)ArgumentMatchers.eq(null), (Date)ArgumentMatchers.eq(null))).thenReturn(Collections.emptyMap());
            ContractsGrantsAgingOpenInvoicesReportForm agingOpenInvoicesReportForm = new ContractsGrantsAgingOpenInvoicesReportForm();
            agingOpenInvoicesReportForm.setFieldsForLookup(Collections.emptyMap());
            Collection lookupResults = this.cut.performLookup((LookupForm)agingOpenInvoicesReportForm, new ArrayList(), true);
            Assertions.assertNotNull((Object)lookupResults);
            Assertions.assertEquals((int)0, (int)lookupResults.size());
        }
    }
}

