/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.ar.businessobject.lookup;

import java.sql.Date;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.junit.jupiter.api.parallel.Execution;
import org.junit.jupiter.api.parallel.ExecutionMode;
import org.kuali.kfs.core.api.datetime.DateTimeService;
import org.kuali.kfs.core.api.util.type.AbstractKualiDecimal;
import org.kuali.kfs.core.api.util.type.KualiDecimal;
import org.kuali.kfs.coreservice.framework.parameter.ParameterService;
import org.kuali.kfs.datadictionary.legacy.BusinessObjectDictionaryService;
import org.kuali.kfs.datadictionary.legacy.DataDictionaryService;
import org.kuali.kfs.integration.cg.ContractsAndGrantsBillingAgency;
import org.kuali.kfs.kns.datadictionary.BusinessObjectEntry;
import org.kuali.kfs.kns.service.BusinessObjectMetaDataService;
import org.kuali.kfs.kns.util.FieldUtils;
import org.kuali.kfs.kns.web.struts.form.LookupForm;
import org.kuali.kfs.krad.service.BusinessObjectService;
import org.kuali.kfs.krad.service.KualiModuleService;
import org.kuali.kfs.krad.service.ModuleService;
import org.kuali.kfs.module.ar.businessobject.ContractsAndGrantsAgingReport;
import org.kuali.kfs.module.ar.businessobject.CustomerAgingReportDetail;
import org.kuali.kfs.module.ar.businessobject.lookup.ContractsGrantsAgingReportLookupableHelperServiceImpl;
import org.kuali.kfs.module.ar.document.ContractsGrantsInvoiceDocument;
import org.kuali.kfs.module.ar.document.CustomerInvoiceDocument;
import org.kuali.kfs.module.ar.document.service.CustomerCreditMemoDocumentService;
import org.kuali.kfs.module.ar.document.service.CustomerInvoiceDocumentService;
import org.kuali.kfs.module.ar.report.service.ContractsGrantsAgingReportService;
import org.kuali.kfs.module.ar.report.service.CustomerAgingReportService;
import org.kuali.kfs.module.ar.web.struts.ContractsGrantsAgingReportForm;
import org.mockito.ArgumentMatchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.jupiter.MockitoExtension;
import org.springframework.test.util.ReflectionTestUtils;

@Execution(value=ExecutionMode.SAME_THREAD)
@ExtendWith(value={MockitoExtension.class})
class ContractsGrantsAgingReportLookupableHelperServiceImplTest {
    private static final String CUSTOMER_NUMBER = "ABB2";
    private static final String CUSTOMER_NAME = "WOODS CORPORATION";
    private ContractsGrantsAgingReportLookupableHelperServiceImpl cut;

    ContractsGrantsAgingReportLookupableHelperServiceImplTest() {
    }

    @BeforeAll
    static void defendAgainstMockingHeldInStaticFieldsFromPreviousTestClasses() {
        ReflectionTestUtils.setField(FieldUtils.class, (String)"businessObjectMetaDataService", null);
    }

    void setupCut(BusinessObjectDictionaryService businessObjectDictionarySvcMock, BusinessObjectMetaDataService businessObjectMetaDataSvcMock, BusinessObjectService businessObjectSvcMock, ContractsGrantsAgingReportService contractsGrantsAgingReportSvcMock, CustomerAgingReportService customerAgingReportSvcMock, CustomerCreditMemoDocumentService customerCreditMemoDocumentSvcMock, CustomerInvoiceDocumentService customerInvoiceDocumentSvdMock, DataDictionaryService dataDictionarySvcMock, DateTimeService dateTimeSvcMock, KualiModuleService kualiModuleSvcMock, ParameterService parameterSvcMock) throws Exception {
        this.cut = new ContractsGrantsAgingReportLookupableHelperServiceImpl();
        this.cut.setBusinessObjectDictionaryService(businessObjectDictionarySvcMock);
        this.cut.setBusinessObjectService(businessObjectSvcMock);
        this.cut.setBusinessObjectMetaDataService(businessObjectMetaDataSvcMock);
        this.cut.setContractsGrantsAgingReportService(contractsGrantsAgingReportSvcMock);
        this.cut.setCustomerAgingReportService(customerAgingReportSvcMock);
        this.cut.setCustomerCreditMemoDocumentService(customerCreditMemoDocumentSvcMock);
        this.cut.setCustomerInvoiceDocumentService(customerInvoiceDocumentSvdMock);
        this.cut.setDataDictionaryService(dataDictionarySvcMock);
        this.cut.setDateTimeService(dateTimeSvcMock);
        this.cut.setModuleService(kualiModuleSvcMock);
        this.cut.setParameterService(parameterSvcMock);
        this.cut.setBusinessObjectClass(ContractsAndGrantsAgingReport.class);
        this.cut.afterPropertiesSet();
    }

    @AfterEach
    void cleanUpAfterOurselfSoSubsequentTestsDoNotReuseOurMocking() {
        FieldUtils.setBusinessObjectDictionaryService(null);
        ReflectionTestUtils.setField(FieldUtils.class, (String)"businessObjectMetaDataService", null);
        FieldUtils.setDataDictionaryService(null);
    }

    private static Map<String, String> setupFieldValues(String reportRunDate) {
        LinkedHashMap<String, String> fieldValues = new LinkedHashMap<String, String>();
        fieldValues.put("backLocation", null);
        fieldValues.put("reportRunDate", reportRunDate);
        fieldValues.put("docFormKey", null);
        fieldValues.put("businessObjectClassName", ContractsAndGrantsAgingReport.class.getName());
        return fieldValues;
    }

    private static void setupContractsGrantsAgingOpenInvoicesReportService(ContractsGrantsAgingReportService contractsGrantsAgingReportSvcMock, ContractsGrantsInvoiceDocument contractsGrantsInvoiceDocumentMock, Map<String, String> fieldValues) throws ParseException {
        ArrayList<ContractsGrantsInvoiceDocument> contractsGrantsInvoiceDocuments = new ArrayList<ContractsGrantsInvoiceDocument>();
        contractsGrantsInvoiceDocuments.add(contractsGrantsInvoiceDocumentMock);
        LinkedHashMap<String, ArrayList<ContractsGrantsInvoiceDocument>> invoiceMap = new LinkedHashMap<String, ArrayList<ContractsGrantsInvoiceDocument>>();
        invoiceMap.put("ABB2-WOODS CORPORATION", contractsGrantsInvoiceDocuments);
        Mockito.when((Object)contractsGrantsAgingReportSvcMock.filterContractsGrantsAgingReport((Map)ArgumentMatchers.eq(fieldValues), (Date)ArgumentMatchers.eq(null), (Date)ArgumentMatchers.any(Date.class))).thenReturn(invoiceMap);
    }

    @Test
    void getSearchResults(@Mock(stubOnly=true) BusinessObjectDictionaryService businessObjectDictionarySvcMock, @Mock(stubOnly=true) BusinessObjectEntry businessObjectEntryMock, @Mock(stubOnly=true) BusinessObjectMetaDataService businessObjectMetaDataSvcMock, @Mock(stubOnly=true) BusinessObjectService businessObjectSvcMock, @Mock(stubOnly=true) ContractsAndGrantsBillingAgency agencyMock, @Mock(stubOnly=true) ContractsGrantsAgingReportService contractsGrantsAgingReportSvcMock, @Mock(stubOnly=true) ContractsGrantsInvoiceDocument contractsGrantsInvoiceDocumentMock, @Mock(stubOnly=true) CustomerAgingReportService customerAgingReportSvcMock, @Mock(stubOnly=true) CustomerCreditMemoDocumentService customerCreditMemoDocumentSvcMock, @Mock(stubOnly=true) CustomerInvoiceDocumentService customerInvoiceDocumentSvdMock, @Mock(stubOnly=true) DataDictionaryService dataDictionarySvcMock, @Mock(stubOnly=true) DateTimeService dateTimeSvcMock, @Mock(stubOnly=true) KualiModuleService kualiModuleSvcMock, @Mock(stubOnly=true) ModuleService moduleSvcMock, @Mock(stubOnly=true) ParameterService parameterSvcMock) throws Exception {
        Mockito.when((Object)agencyMock.getAgencyNumber()).thenReturn((Object)"11505");
        Mockito.when((Object)agencyMock.getReportingName()).thenReturn((Object)"US AIR FORCE");
        Mockito.when((Object)contractsGrantsInvoiceDocumentMock.getBillingDate()).thenReturn((Object)Date.valueOf(LocalDate.now()));
        SimpleDateFormat dateFormat = new SimpleDateFormat("MM/dd/yyyy", Locale.US);
        java.util.Date today = new java.util.Date();
        String reportRunDate = dateFormat.format(today);
        Mockito.when((Object)dateTimeSvcMock.convertToDate(reportRunDate)).thenReturn((Object)today);
        Mockito.when((Object)dateTimeSvcMock.getCurrentDate()).thenReturn((Object)Calendar.getInstance().getTime());
        Map<String, String> fieldValues = ContractsGrantsAgingReportLookupableHelperServiceImplTest.setupFieldValues(reportRunDate);
        ContractsGrantsAgingReportLookupableHelperServiceImplTest.setupContractsGrantsAgingOpenInvoicesReportService(contractsGrantsAgingReportSvcMock, contractsGrantsInvoiceDocumentMock, fieldValues);
        FieldUtils.setBusinessObjectDictionaryService((BusinessObjectDictionaryService)businessObjectDictionarySvcMock);
        FieldUtils.setDataDictionaryService((DataDictionaryService)dataDictionarySvcMock);
        Mockito.when((Object)businessObjectEntryMock.hasLookupDefinition()).thenReturn((Object)false);
        Mockito.when((Object)businessObjectDictionarySvcMock.getBusinessObjectEntry(ContractsAndGrantsAgingReport.class.getName())).thenReturn((Object)businessObjectEntryMock);
        Mockito.when((Object)businessObjectMetaDataSvcMock.isLookupable(ContractsAndGrantsAgingReport.class)).thenReturn((Object)true);
        Mockito.when((Object)parameterSvcMock.getParameterValueAsString(CustomerAgingReportDetail.class, "LAST_TWO_BUCKETS")).thenReturn((Object)"120");
        HashMap<String, String> args = new HashMap<String, String>();
        args.put("customerNumber", CUSTOMER_NUMBER);
        Mockito.when((Object)((ContractsAndGrantsBillingAgency)moduleSvcMock.getExternalizableBusinessObject(ContractsAndGrantsBillingAgency.class, args))).thenReturn((Object)agencyMock);
        Mockito.when((Object)kualiModuleSvcMock.getResponsibleModuleService(ContractsAndGrantsBillingAgency.class)).thenReturn((Object)moduleSvcMock);
        Mockito.when((Object)customerInvoiceDocumentSvdMock.getOpenAmountForCustomerInvoiceDocument((CustomerInvoiceDocument)contractsGrantsInvoiceDocumentMock)).thenReturn((Object)new KualiDecimal(800.0));
        this.setupCut(businessObjectDictionarySvcMock, businessObjectMetaDataSvcMock, businessObjectSvcMock, contractsGrantsAgingReportSvcMock, customerAgingReportSvcMock, customerCreditMemoDocumentSvcMock, customerInvoiceDocumentSvdMock, dataDictionarySvcMock, dateTimeSvcMock, kualiModuleSvcMock, parameterSvcMock);
        KualiDecimal test0to30total = new KualiDecimal("0.00");
        KualiDecimal test31to60total = new KualiDecimal("0.00");
        KualiDecimal test61to90total = new KualiDecimal("0.00");
        KualiDecimal test91toSYSPRtotal = new KualiDecimal("0.00");
        KualiDecimal testSYSPRplus1orMoretotal = new KualiDecimal("0.00");
        List searchResults = this.cut.getSearchResults(fieldValues);
        Assertions.assertNotNull((Object)searchResults, (String)"search results not null");
        for (Object result : searchResults) {
            ContractsAndGrantsAgingReport detail = (ContractsAndGrantsAgingReport)result;
            test0to30total = (KualiDecimal)test0to30total.add((AbstractKualiDecimal)detail.getUnpaidBalance0to30());
            test31to60total = (KualiDecimal)test31to60total.add((AbstractKualiDecimal)detail.getUnpaidBalance31to60());
            test61to90total = (KualiDecimal)test61to90total.add((AbstractKualiDecimal)detail.getUnpaidBalance61to90());
            test91toSYSPRtotal = (KualiDecimal)test91toSYSPRtotal.add((AbstractKualiDecimal)detail.getUnpaidBalance91toSYSPR());
            testSYSPRplus1orMoretotal = (KualiDecimal)testSYSPRplus1orMoretotal.add((AbstractKualiDecimal)detail.getUnpaidBalanceSYSPRplus1orMore());
        }
        Assertions.assertEquals((Object)this.cut.getTotal0to30(), (Object)test0to30total);
        Assertions.assertEquals((Object)this.cut.getTotal31to60(), (Object)test31to60total);
        Assertions.assertEquals((Object)this.cut.getTotal61to90(), (Object)test61to90total);
        Assertions.assertEquals((Object)this.cut.getTotal91toSYSPR(), (Object)test91toSYSPRtotal);
        Assertions.assertEquals((Object)this.cut.getTotalSYSPRplus1orMore(), (Object)testSYSPRplus1orMoretotal);
        Assertions.assertEquals((int)1, (int)searchResults.size());
        ContractsAndGrantsAgingReport contractsAndGrantsAgingReport = (ContractsAndGrantsAgingReport)searchResults.get(0);
        Assertions.assertEquals((Object)"Processing Organization", (Object)contractsAndGrantsAgingReport.getReportOption());
        Assertions.assertEquals((Object)CUSTOMER_NAME, (Object)contractsAndGrantsAgingReport.getCustomerName());
        Assertions.assertEquals((Object)CUSTOMER_NUMBER, (Object)contractsAndGrantsAgingReport.getCustomerNumber());
        Assertions.assertEquals((Object)"US AIR FORCE", (Object)contractsAndGrantsAgingReport.getReportingName());
        Assertions.assertEquals((Object)agencyMock.getAgencyNumber(), (Object)contractsAndGrantsAgingReport.getAgencyNumber());
        Assertions.assertEquals((Object)new KualiDecimal(800.0), (Object)contractsAndGrantsAgingReport.getUnpaidBalance0to30());
        Assertions.assertEquals((Object)new KualiDecimal(0.0), (Object)contractsAndGrantsAgingReport.getUnpaidBalance31to60());
        Assertions.assertEquals((Object)new KualiDecimal(0.0), (Object)contractsAndGrantsAgingReport.getUnpaidBalance61to90());
        Assertions.assertEquals((Object)new KualiDecimal(0.0), (Object)contractsAndGrantsAgingReport.getUnpaidBalance91toSYSPR());
        Assertions.assertEquals((Object)new KualiDecimal(0.0), (Object)contractsAndGrantsAgingReport.getUnpaidBalanceSYSPRplus1orMore());
        Assertions.assertEquals((Object)new KualiDecimal(800.0), (Object)contractsAndGrantsAgingReport.getTotalOpenInvoices());
        Assertions.assertEquals((Object)new KualiDecimal(0.0), (Object)contractsAndGrantsAgingReport.getTotalCredits());
        Assertions.assertEquals((Object)new KualiDecimal(0.0), (Object)contractsAndGrantsAgingReport.getTotalWriteOff());
        Assertions.assertEquals((Object)"KFS-AR", (Object)contractsAndGrantsAgingReport.getUserLookupRoleNamespaceCode());
        Assertions.assertEquals((Object)"CGB Collector", (Object)contractsAndGrantsAgingReport.getUserLookupRoleName());
    }

    @Test
    void getSearchResults_NoInvoicesFound(@Mock(stubOnly=true) BusinessObjectDictionaryService businessObjectDictionarySvcMock, @Mock(stubOnly=true) BusinessObjectEntry businessObjectEntryMock, @Mock(stubOnly=true) BusinessObjectMetaDataService businessObjectMetaDataSvcMock, @Mock(stubOnly=true) BusinessObjectService businessObjectSvcMock, @Mock(stubOnly=true) ContractsGrantsAgingReportService contractsGrantsAgingReportSvcMock, @Mock(stubOnly=true) CustomerAgingReportService customerAgingReportSvcMock, @Mock(stubOnly=true) CustomerCreditMemoDocumentService customerCreditMemoDocumentSvcMock, @Mock(stubOnly=true) CustomerInvoiceDocumentService customerInvoiceDocumentSvdMock, @Mock(stubOnly=true) DataDictionaryService dataDictionarySvcMock, @Mock(stubOnly=true) DateTimeService dateTimeSvcMock, @Mock(stubOnly=true) KualiModuleService kualiModuleSvcMock, @Mock(stubOnly=true) ParameterService parameterSvcMock) throws Exception {
        SimpleDateFormat dateFormat = new SimpleDateFormat("MM/dd/yyyy", Locale.US);
        java.util.Date today = new java.util.Date();
        String reportRunDate = dateFormat.format(today);
        Mockito.when((Object)dateTimeSvcMock.getCurrentDate()).thenReturn((Object)Calendar.getInstance().getTime());
        ContractsGrantsAgingReportLookupableHelperServiceImplTest.setupFieldValues(reportRunDate);
        FieldUtils.setBusinessObjectDictionaryService((BusinessObjectDictionaryService)businessObjectDictionarySvcMock);
        FieldUtils.setDataDictionaryService((DataDictionaryService)dataDictionarySvcMock);
        Mockito.when((Object)businessObjectEntryMock.hasLookupDefinition()).thenReturn((Object)false);
        Mockito.when((Object)businessObjectDictionarySvcMock.getBusinessObjectEntry(ContractsAndGrantsAgingReport.class.getName())).thenReturn((Object)businessObjectEntryMock);
        Mockito.when((Object)businessObjectMetaDataSvcMock.isLookupable(ContractsAndGrantsAgingReport.class)).thenReturn((Object)true);
        Mockito.when((Object)parameterSvcMock.getParameterValueAsString(CustomerAgingReportDetail.class, "LAST_TWO_BUCKETS")).thenReturn((Object)"120");
        this.setupCut(businessObjectDictionarySvcMock, businessObjectMetaDataSvcMock, businessObjectSvcMock, contractsGrantsAgingReportSvcMock, customerAgingReportSvcMock, customerCreditMemoDocumentSvcMock, customerInvoiceDocumentSvdMock, dataDictionarySvcMock, dateTimeSvcMock, kualiModuleSvcMock, parameterSvcMock);
        List searchResults = this.cut.getSearchResults(Collections.emptyMap());
        Assertions.assertNotNull((Object)searchResults, (String)"search results not null");
        Assertions.assertEquals((int)0, (int)searchResults.size());
    }

    @Test
    void performLookup(@Mock(stubOnly=true) BusinessObjectDictionaryService businessObjectDictionarySvcMock, @Mock(stubOnly=true) BusinessObjectEntry businessObjectEntryMock, @Mock(stubOnly=true) BusinessObjectMetaDataService businessObjectMetaDataSvcMock, @Mock(stubOnly=true) BusinessObjectService businessObjectSvcMock, @Mock(stubOnly=true) ContractsAndGrantsBillingAgency agencyMock, @Mock(stubOnly=true) ContractsGrantsAgingReportService contractsGrantsAgingReportSvcMock, @Mock(stubOnly=true) ContractsGrantsInvoiceDocument contractsGrantsInvoiceDocumentMock, @Mock(stubOnly=true) CustomerAgingReportService customerAgingReportSvcMock, @Mock(stubOnly=true) CustomerCreditMemoDocumentService customerCreditMemoDocumentSvcMock, @Mock(stubOnly=true) CustomerInvoiceDocumentService customerInvoiceDocumentSvdMock, @Mock(stubOnly=true) DataDictionaryService dataDictionarySvcMock, @Mock(stubOnly=true) DateTimeService dateTimeSvcMock, @Mock(stubOnly=true) KualiModuleService kualiModuleSvcMock, @Mock(stubOnly=true) ModuleService moduleSvcMock, @Mock(stubOnly=true) ParameterService parameterSvcMock) throws Exception {
        Mockito.when((Object)agencyMock.getAgencyNumber()).thenReturn((Object)"11505");
        Mockito.when((Object)agencyMock.getReportingName()).thenReturn((Object)"US AIR FORCE");
        Mockito.when((Object)contractsGrantsInvoiceDocumentMock.getBillingDate()).thenReturn((Object)Date.valueOf(LocalDate.now()));
        SimpleDateFormat dateFormat = new SimpleDateFormat("MM/dd/yyyy", Locale.US);
        java.util.Date today = new java.util.Date();
        String reportRunDate = dateFormat.format(today);
        Mockito.when((Object)dateTimeSvcMock.convertToDate(reportRunDate)).thenReturn((Object)today);
        Mockito.when((Object)dateTimeSvcMock.getCurrentDate()).thenReturn((Object)Calendar.getInstance().getTime());
        Map<String, String> fieldValues = ContractsGrantsAgingReportLookupableHelperServiceImplTest.setupFieldValues(reportRunDate);
        ContractsGrantsAgingReportLookupableHelperServiceImplTest.setupContractsGrantsAgingOpenInvoicesReportService(contractsGrantsAgingReportSvcMock, contractsGrantsInvoiceDocumentMock, fieldValues);
        FieldUtils.setBusinessObjectDictionaryService((BusinessObjectDictionaryService)businessObjectDictionarySvcMock);
        FieldUtils.setDataDictionaryService((DataDictionaryService)dataDictionarySvcMock);
        Mockito.when((Object)businessObjectEntryMock.hasLookupDefinition()).thenReturn((Object)false);
        Mockito.when((Object)businessObjectDictionarySvcMock.getBusinessObjectEntry(ContractsAndGrantsAgingReport.class.getName())).thenReturn((Object)businessObjectEntryMock);
        Mockito.when((Object)businessObjectMetaDataSvcMock.isLookupable(ContractsAndGrantsAgingReport.class)).thenReturn((Object)true);
        Mockito.when((Object)parameterSvcMock.getParameterValueAsString(CustomerAgingReportDetail.class, "LAST_TWO_BUCKETS")).thenReturn((Object)"120");
        HashMap<String, String> args = new HashMap<String, String>();
        args.put("customerNumber", CUSTOMER_NUMBER);
        Mockito.when((Object)((ContractsAndGrantsBillingAgency)moduleSvcMock.getExternalizableBusinessObject(ContractsAndGrantsBillingAgency.class, args))).thenReturn((Object)agencyMock);
        Mockito.when((Object)kualiModuleSvcMock.getResponsibleModuleService(ContractsAndGrantsBillingAgency.class)).thenReturn((Object)moduleSvcMock);
        Mockito.when((Object)customerInvoiceDocumentSvdMock.getOpenAmountForCustomerInvoiceDocument((CustomerInvoiceDocument)contractsGrantsInvoiceDocumentMock)).thenReturn((Object)new KualiDecimal(800.0));
        this.setupCut(businessObjectDictionarySvcMock, businessObjectMetaDataSvcMock, businessObjectSvcMock, contractsGrantsAgingReportSvcMock, customerAgingReportSvcMock, customerCreditMemoDocumentSvcMock, customerInvoiceDocumentSvdMock, dataDictionarySvcMock, dateTimeSvcMock, kualiModuleSvcMock, parameterSvcMock);
        ContractsGrantsAgingReportForm contractsGrantsAgingReportForm = new ContractsGrantsAgingReportForm();
        contractsGrantsAgingReportForm.setFieldsForLookup(fieldValues);
        Collection lookupResults = this.cut.performLookup((LookupForm)contractsGrantsAgingReportForm, new ArrayList(), false);
        Assertions.assertNotNull((Object)lookupResults, (String)"lookup list not null");
        Assertions.assertEquals((int)1, (int)lookupResults.size());
        ContractsAndGrantsAgingReport contractsAndGrantsAgingReport = (ContractsAndGrantsAgingReport)lookupResults.iterator().next();
        Assertions.assertEquals((Object)"Processing Organization", (Object)contractsAndGrantsAgingReport.getReportOption());
        Assertions.assertEquals((Object)CUSTOMER_NAME, (Object)contractsAndGrantsAgingReport.getCustomerName());
        Assertions.assertEquals((Object)CUSTOMER_NUMBER, (Object)contractsAndGrantsAgingReport.getCustomerNumber());
        Assertions.assertEquals((Object)"US AIR FORCE", (Object)contractsAndGrantsAgingReport.getReportingName());
        Assertions.assertEquals((Object)agencyMock.getAgencyNumber(), (Object)contractsAndGrantsAgingReport.getAgencyNumber());
        Assertions.assertEquals((Object)new KualiDecimal(800.0), (Object)contractsAndGrantsAgingReport.getUnpaidBalance0to30());
        Assertions.assertEquals((Object)new KualiDecimal(0.0), (Object)contractsAndGrantsAgingReport.getUnpaidBalance31to60());
        Assertions.assertEquals((Object)new KualiDecimal(0.0), (Object)contractsAndGrantsAgingReport.getUnpaidBalance61to90());
        Assertions.assertEquals((Object)new KualiDecimal(0.0), (Object)contractsAndGrantsAgingReport.getUnpaidBalance91toSYSPR());
        Assertions.assertEquals((Object)new KualiDecimal(0.0), (Object)contractsAndGrantsAgingReport.getUnpaidBalanceSYSPRplus1orMore());
        Assertions.assertEquals((Object)new KualiDecimal(800.0), (Object)contractsAndGrantsAgingReport.getTotalOpenInvoices());
        Assertions.assertEquals((Object)new KualiDecimal(0.0), (Object)contractsAndGrantsAgingReport.getTotalCredits());
        Assertions.assertEquals((Object)new KualiDecimal(0.0), (Object)contractsAndGrantsAgingReport.getTotalWriteOff());
        Assertions.assertEquals((Object)"KFS-AR", (Object)contractsAndGrantsAgingReport.getUserLookupRoleNamespaceCode());
        Assertions.assertEquals((Object)"CGB Collector", (Object)contractsAndGrantsAgingReport.getUserLookupRoleName());
    }

    @Test
    void performLookup_NoInvoicesFound(@Mock(stubOnly=true) BusinessObjectDictionaryService businessObjectDictionarySvcMock, @Mock(stubOnly=true) BusinessObjectEntry businessObjectEntryMock, @Mock(stubOnly=true) BusinessObjectMetaDataService businessObjectMetaDataSvcMock, @Mock(stubOnly=true) BusinessObjectService businessObjectSvcMock, @Mock(stubOnly=true) ContractsGrantsAgingReportService contractsGrantsAgingReportSvcMock, @Mock(stubOnly=true) CustomerAgingReportService customerAgingReportSvcMock, @Mock(stubOnly=true) CustomerCreditMemoDocumentService customerCreditMemoDocumentSvcMock, @Mock(stubOnly=true) CustomerInvoiceDocumentService customerInvoiceDocumentSvdMock, @Mock(stubOnly=true) DataDictionaryService dataDictionarySvcMock, @Mock(stubOnly=true) DateTimeService dateTimeSvcMock, @Mock(stubOnly=true) KualiModuleService kualiModuleSvcMock, @Mock(stubOnly=true) ParameterService parameterSvcMock) throws Exception {
        SimpleDateFormat dateFormat = new SimpleDateFormat("MM/dd/yyyy", Locale.US);
        java.util.Date today = new java.util.Date();
        String reportRunDate = dateFormat.format(today);
        Mockito.when((Object)dateTimeSvcMock.getCurrentDate()).thenReturn((Object)Calendar.getInstance().getTime());
        ContractsGrantsAgingReportLookupableHelperServiceImplTest.setupFieldValues(reportRunDate);
        FieldUtils.setBusinessObjectDictionaryService((BusinessObjectDictionaryService)businessObjectDictionarySvcMock);
        FieldUtils.setDataDictionaryService((DataDictionaryService)dataDictionarySvcMock);
        Mockito.when((Object)businessObjectEntryMock.hasLookupDefinition()).thenReturn((Object)false);
        Mockito.when((Object)businessObjectDictionarySvcMock.getBusinessObjectEntry(ContractsAndGrantsAgingReport.class.getName())).thenReturn((Object)businessObjectEntryMock);
        Mockito.when((Object)businessObjectMetaDataSvcMock.isLookupable(ContractsAndGrantsAgingReport.class)).thenReturn((Object)true);
        Mockito.when((Object)parameterSvcMock.getParameterValueAsString(CustomerAgingReportDetail.class, "LAST_TWO_BUCKETS")).thenReturn((Object)"120");
        this.setupCut(businessObjectDictionarySvcMock, businessObjectMetaDataSvcMock, businessObjectSvcMock, contractsGrantsAgingReportSvcMock, customerAgingReportSvcMock, customerCreditMemoDocumentSvcMock, customerInvoiceDocumentSvdMock, dataDictionarySvcMock, dateTimeSvcMock, kualiModuleSvcMock, parameterSvcMock);
        ContractsGrantsAgingReportForm contractsGrantsAgingReportForm = new ContractsGrantsAgingReportForm();
        contractsGrantsAgingReportForm.setFieldsForLookup(Collections.emptyMap());
        Collection lookupResults = this.cut.performLookup((LookupForm)contractsGrantsAgingReportForm, new ArrayList(), false);
        Assertions.assertNotNull((Object)lookupResults, (String)"lookup list not null");
        Assertions.assertEquals((int)0, (int)lookupResults.size());
    }
}

