/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.ar.businessobject.lookup;

import org.kuali.kfs.coa.businessobject.defaultvalue.CurrentUserChartValueFinder;
import org.kuali.kfs.coa.businessobject.defaultvalue.CurrentUserOrgValueFinder;
import org.kuali.kfs.module.ar.businessobject.InvoiceTemplate;
import org.kuali.kfs.module.ar.document.ContractsGrantsInvoiceDocument;
import org.kuali.kfs.module.ar.document.service.ContractsGrantsInvoiceDocumentService;
import org.kuali.kfs.sys.ConfigureContext;
import org.kuali.kfs.sys.context.KualiIntegTestBase;
import org.kuali.kfs.sys.context.SpringContext;
import org.kuali.kfs.sys.fixture.UserNameFixture;

@ConfigureContext(session=UserNameFixture.khuntley)
public class InvoiceTemplateIntegTest
extends KualiIntegTestBase {
    public static final String TYPE_CODE = "1115";
    public static final String TYPE_DESCRIPTION = "Federal SF-1115";
    public static final boolean ACTIVE = true;
    private InvoiceTemplate invoiceTemplate;

    protected void setUp() throws Exception {
        super.setUp();
        this.invoiceTemplate = new InvoiceTemplate();
        this.invoiceTemplate.setInvoiceTemplateCode(TYPE_CODE);
        this.invoiceTemplate.setInvoiceTemplateDescription(TYPE_DESCRIPTION);
        this.invoiceTemplate.setActive(true);
    }

    public void testIsTemplateValidForContractsGrantsInvoiceDocument() {
        ContractsGrantsInvoiceDocumentService contractsGrantsInvoiceDocumentService = (ContractsGrantsInvoiceDocumentService)SpringContext.getBean(ContractsGrantsInvoiceDocumentService.class);
        String billByChartOfAccountCode = new CurrentUserChartValueFinder().getDefaultValue();
        String billedByOrganizationCode = new CurrentUserOrgValueFinder().getDefaultValue();
        ContractsGrantsInvoiceDocument contractsGrantsInvoiceDocument = new ContractsGrantsInvoiceDocument();
        contractsGrantsInvoiceDocument.setBillByChartOfAccountCode(billByChartOfAccountCode);
        contractsGrantsInvoiceDocument.setBilledByOrganizationCode(billedByOrganizationCode);
        InvoiceTemplateIntegTest.assertFalse((boolean)contractsGrantsInvoiceDocumentService.isTemplateValidForContractsGrantsInvoiceDocument(this.invoiceTemplate, contractsGrantsInvoiceDocument));
        this.invoiceTemplate.setBillByChartOfAccountCode(billByChartOfAccountCode);
        this.invoiceTemplate.setBilledByOrganizationCode(billedByOrganizationCode);
        InvoiceTemplateIntegTest.assertTrue((boolean)contractsGrantsInvoiceDocumentService.isTemplateValidForContractsGrantsInvoiceDocument(this.invoiceTemplate, contractsGrantsInvoiceDocument));
    }
}

