/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.ar.document;

import java.time.LocalDate;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.CsvSource;
import org.kuali.kfs.module.ar.document.CustomerInvoiceRecurrenceUtils;

public class CustomerInvoiceRecurrenceUtilsTest {
    @ParameterizedTest(name="Given beginDate 2012-10-07, endDate {0}, and intervalCode {1}, then {2} recurrencesshould be valid.")
    @CsvSource(value={"2013-10-07, M, 13", "2013-10-15, M, 13", "2013-11-06, M, 13", "2013-10-07, Q, 5", "2013-11-07, Q, 5", "2013-12-07, Q, 5", "2014-01-06, Q, 5"})
    void isRecurrenceTotalValid_validRecurrenceValues(String endDateString, String intervalCode, int totalRecurrenceNumber) {
        LocalDate recurrenceBeginDate = LocalDate.parse("2012-10-07");
        LocalDate recurrenceEndDate = LocalDate.parse(endDateString);
        boolean isValid = CustomerInvoiceRecurrenceUtils.isRecurrenceTotalValid((LocalDate)recurrenceBeginDate, (LocalDate)recurrenceEndDate, (String)intervalCode, (int)totalRecurrenceNumber);
        Assertions.assertEquals((Object)true, (Object)isValid);
    }

    @ParameterizedTest(name="Given beginDate 2012-10-07, endDate {0}, and interval {1}, {2} recurrences should not be valid")
    @CsvSource(value={"2013-10-06, M, 13", "2013-11-07, M, 13", "2013-10-06, Q, 5", "2014-01-07, Q, 5"})
    void isRecurrenceTotalValid_invalidRecurrenceValues(String endDateString, String intervalCode, int totalRecurrences) {
        LocalDate recurrenceBeginDate = LocalDate.parse("2012-10-07");
        LocalDate recurrenceEndDate = LocalDate.parse(endDateString);
        boolean isValid = CustomerInvoiceRecurrenceUtils.isRecurrenceTotalValid((LocalDate)recurrenceBeginDate, (LocalDate)recurrenceEndDate, (String)intervalCode, (int)totalRecurrences);
        Assertions.assertEquals((Object)false, (Object)isValid);
    }

    @ParameterizedTest(name="Given beginDate 2012-10-07, endDate {0}, and intervalCode {1}, then the number of recurrences should be {1}")
    @CsvSource(value={"2013-10-07, M, 13", "2013-10-15, M, 13", "2013-11-06, M, 13", "2013-10-07, Q, 5", "2013-11-07, Q, 5", "2013-12-07, Q, 5", "2014-01-06, Q, 5"})
    void calculateTotalRecurrences_validRecurrenceValues(String endDateString, String intervalCode, int expectedRecurrences) {
        LocalDate recurrenceBeginDate = LocalDate.parse("2012-10-07");
        LocalDate recurrenceEndDate = LocalDate.parse(endDateString);
        int totalRecurrences = CustomerInvoiceRecurrenceUtils.calculateTotalRecurrences((LocalDate)recurrenceBeginDate, (LocalDate)recurrenceEndDate, (String)intervalCode);
        Assertions.assertEquals((int)expectedRecurrences, (int)totalRecurrences);
    }

    @ParameterizedTest(name="Given beginDate 2012-10-07, intervalCode {0}, and num recurrences {1}, then the end dateshould be {2}")
    @CsvSource(value={"M, 1, 2012-10-07", "M, 12, 2013-09-07", "M, 13, 2013-10-07", "Q, 1, 2012-10-07", "Q, 4, 2013-07-07", "Q, 5, 2013-10-07"})
    void calculateEndDateByTotalRecurrences_validEndDateValues(String intervalCode, int totalRecurrences, String endDateString) {
        LocalDate recurrenceBeginDate = LocalDate.parse("2012-10-07");
        LocalDate expectedEndDate = LocalDate.parse(endDateString);
        LocalDate calculatedEndDate = CustomerInvoiceRecurrenceUtils.calculateEndDateByTotalRecurrences((LocalDate)recurrenceBeginDate, (String)intervalCode, (int)totalRecurrences);
        Assertions.assertEquals((Object)expectedEndDate, (Object)calculatedEndDate);
    }
}

