/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.ar.document;

import java.util.List;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.kuali.kfs.integration.cg.ContractsAndGrantsBillingAward;
import org.kuali.kfs.krad.service.DocumentService;
import org.kuali.kfs.module.ar.businessobject.FinalBilledIndicatorEntry;
import org.kuali.kfs.module.ar.businessobject.InvoiceGeneralDetail;
import org.kuali.kfs.module.ar.document.ContractsGrantsInvoiceDocument;
import org.kuali.kfs.module.ar.document.FinalBilledIndicatorDocument;
import org.kuali.kfs.module.ar.document.service.ContractsGrantsInvoiceDocumentService;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.jupiter.MockitoExtension;

@ExtendWith(value={MockitoExtension.class})
class FinalBilledIndicatorDocumentTest {
    @Mock
    private ContractsGrantsInvoiceDocument contractsGrantsInvoiceDocumentMock;
    @Mock
    private ContractsGrantsInvoiceDocumentService contractsGrantsInvoiceDocumentSvcMock;
    @Mock
    private DocumentService documentSvcMock;
    private FinalBilledIndicatorDocument cut;

    FinalBilledIndicatorDocumentTest() {
    }

    @BeforeEach
    void setUp() {
        this.cut = new FinalBilledIndicatorDocument();
        this.cut.setDocumentService(this.documentSvcMock);
        this.cut.setContractsGrantsInvoiceDocumentService(this.contractsGrantsInvoiceDocumentSvcMock);
    }

    @Test
    void updateContractsGrantsInvoiceDocument() {
        ContractsAndGrantsBillingAward awardMock = (ContractsAndGrantsBillingAward)Mockito.mock(ContractsAndGrantsBillingAward.class);
        InvoiceGeneralDetail invoiceGeneralDetail = new InvoiceGeneralDetail();
        invoiceGeneralDetail.setAward(awardMock);
        invoiceGeneralDetail.setFinalBillIndicator(true);
        Mockito.when((Object)this.contractsGrantsInvoiceDocumentMock.getInvoiceGeneralDetail()).thenReturn((Object)invoiceGeneralDetail);
        FinalBilledIndicatorEntry entry = new FinalBilledIndicatorEntry();
        entry.setInvoiceDocumentNumber(this.contractsGrantsInvoiceDocumentMock.getDocumentNumber());
        this.cut.setInvoiceEntries(List.of(entry));
        Mockito.when((Object)this.documentSvcMock.getByDocumentHeaderId(entry.getInvoiceDocumentNumber())).thenReturn((Object)this.contractsGrantsInvoiceDocumentMock);
        this.cut.updateContractsGrantsInvoiceDocument();
        Assertions.assertFalse((boolean)this.contractsGrantsInvoiceDocumentMock.getInvoiceGeneralDetail().isFinalBillIndicator());
        ((ContractsGrantsInvoiceDocumentService)Mockito.verify((Object)this.contractsGrantsInvoiceDocumentSvcMock)).updateUnfinalizationToAwardAccount(this.contractsGrantsInvoiceDocumentMock.getAccountDetails(), this.contractsGrantsInvoiceDocumentMock.getInvoiceGeneralDetail().getProposalNumber());
    }
}

