/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.ar.document;

import java.util.List;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.junit.jupiter.api.parallel.Execution;
import org.junit.jupiter.api.parallel.ExecutionMode;
import org.kuali.kfs.core.api.util.type.AbstractKualiDecimal;
import org.kuali.kfs.core.api.util.type.KualiDecimal;
import org.kuali.kfs.krad.service.DocumentHeaderService;
import org.kuali.kfs.krad.service.DocumentService;
import org.kuali.kfs.krad.service.KRADServiceLocatorWeb;
import org.kuali.kfs.module.ar.businessobject.InvoicePaidApplied;
import org.kuali.kfs.module.ar.businessobject.NonAppliedHolding;
import org.kuali.kfs.module.ar.document.PaymentApplicationAdjustmentDocument;
import org.kuali.kfs.module.ar.document.PaymentApplicationDocument;
import org.mockito.ArgumentMatchers;
import org.mockito.Mock;
import org.mockito.MockedStatic;
import org.mockito.Mockito;
import org.mockito.junit.jupiter.MockitoExtension;

@Execution(value=ExecutionMode.SAME_THREAD)
@ExtendWith(value={MockitoExtension.class})
class PaymentApplicationAdjustmentDocumentTest {
    private PaymentApplicationAdjustmentDocument cutSpy;

    PaymentApplicationAdjustmentDocumentTest() {
    }

    @BeforeEach
    void setUp() {
        try (MockedStatic kradServiceLocatorWebStaticMock = Mockito.mockStatic(KRADServiceLocatorWeb.class);){
            DocumentHeaderService documentHeaderServiceMock = (DocumentHeaderService)Mockito.mock(DocumentHeaderService.class);
            kradServiceLocatorWebStaticMock.when(KRADServiceLocatorWeb::getDocumentHeaderService).thenReturn((Object)documentHeaderServiceMock);
            this.cutSpy = (PaymentApplicationAdjustmentDocument)Mockito.spy((Object)new PaymentApplicationAdjustmentDocument());
        }
    }

    @Test
    void setter_illegalArg_null() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> this.cutSpy.setAdjusteeDocumentNumber(null));
    }

    @Test
    void setter_illegalArg_empty() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> this.cutSpy.setAdjusteeDocumentNumber(""));
    }

    @Test
    void setter_illegalArg_blank() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> this.cutSpy.setAdjusteeDocumentNumber("    "));
    }

    @Test
    void setter_validArg() {
        String expected = "ABC123";
        this.cutSpy.setAdjusteeDocumentNumber("ABC123");
        Assertions.assertEquals((Object)"ABC123", (Object)this.cutSpy.getAdjusteeDocumentNumber());
    }

    @Test
    void nonAppliedHoldings_is_not_null_after_construction() {
        List actual = this.cutSpy.getNonAppliedHoldings();
        Assertions.assertNotNull((Object)actual);
        Assertions.assertTrue((boolean)actual.isEmpty());
    }

    @Test
    void nonAppliedHoldings_setter_does_not_allow_null() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> this.cutSpy.setNonAppliedHoldings(null));
    }

    @Test
    void nonAppliedHoldings_setter_overwrites_previous_contents() {
        List<NonAppliedHolding> initial = List.of((NonAppliedHolding)Mockito.mock(NonAppliedHolding.class));
        List secondary = List.of();
        this.cutSpy.setNonAppliedHoldings(initial);
        this.cutSpy.setNonAppliedHoldings(secondary);
        List actual = this.cutSpy.getNonAppliedHoldings();
        Assertions.assertNotNull((Object)actual);
        Assertions.assertTrue((boolean)actual.isEmpty());
    }

    @Test
    void invoicePaidApplieds_is_not_null_after_construction() {
        List actual = this.cutSpy.getInvoicePaidApplieds();
        Assertions.assertNotNull((Object)actual);
        Assertions.assertTrue((boolean)actual.isEmpty());
    }

    @Test
    void invoicePaidApplieds_setter_does_not_allow_null() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> this.cutSpy.setInvoicePaidApplieds(null));
    }

    @Test
    void invoicePaidApplieds_setter_overwrites_previous_contents() {
        List<InvoicePaidApplied> initial = List.of((InvoicePaidApplied)Mockito.mock(InvoicePaidApplied.class));
        List secondary = List.of();
        this.cutSpy.setInvoicePaidApplieds(initial);
        this.cutSpy.setInvoicePaidApplieds(secondary);
        List actual = this.cutSpy.getInvoicePaidApplieds();
        Assertions.assertNotNull((Object)actual);
        Assertions.assertTrue((boolean)actual.isEmpty());
    }

    @Test
    void getTotalDollarAmount_app(@Mock(stubOnly=true) DocumentService documentServiceMock) {
        ((PaymentApplicationAdjustmentDocument)Mockito.doReturn((Object)documentServiceMock).when((Object)this.cutSpy)).getDocumentService();
        KualiDecimal rootAdjusteeTotalFromControl = new KualiDecimal("7");
        KualiDecimal rootAdjusteeNonArTotal = new KualiDecimal("3");
        PaymentApplicationDocument rootAdjusteeDocument = (PaymentApplicationDocument)Mockito.mock(PaymentApplicationDocument.class);
        Mockito.when((Object)rootAdjusteeDocument.getTotalFromControl()).thenReturn((Object)rootAdjusteeTotalFromControl);
        Mockito.when((Object)rootAdjusteeDocument.getNonArTotal()).thenReturn((Object)rootAdjusteeNonArTotal);
        Mockito.when((Object)documentServiceMock.getByDocumentHeaderId((String)ArgumentMatchers.any())).thenReturn((Object)rootAdjusteeDocument);
        KualiDecimal actual = this.cutSpy.getTotalDollarAmount();
        KualiDecimal expected = (KualiDecimal)rootAdjusteeTotalFromControl.subtract((AbstractKualiDecimal)rootAdjusteeNonArTotal);
        Assertions.assertEquals((Object)expected, (Object)actual);
    }

    @Test
    void getTotalDollarAmount_appa(@Mock(stubOnly=true) DocumentService documentServiceMock) {
        ((PaymentApplicationAdjustmentDocument)Mockito.doReturn((Object)documentServiceMock).when((Object)this.cutSpy)).getDocumentService();
        PaymentApplicationDocument rootAdjusteeDocument = (PaymentApplicationDocument)Mockito.mock(PaymentApplicationDocument.class);
        KualiDecimal rootAdjusteeTotalFromControl = new KualiDecimal("7");
        Mockito.when((Object)rootAdjusteeDocument.getTotalFromControl()).thenReturn((Object)rootAdjusteeTotalFromControl);
        KualiDecimal rootAdjusteeNonArTotal = new KualiDecimal("3");
        PaymentApplicationAdjustmentDocument adjusteeDocumentSpy = this.createLocalSpy();
        ((PaymentApplicationAdjustmentDocument)Mockito.doReturn((Object)documentServiceMock).when((Object)adjusteeDocumentSpy)).getDocumentService();
        KualiDecimal adjusteeNonArTotal = new KualiDecimal("3");
        Mockito.when((Object)adjusteeDocumentSpy.getNonArTotal()).thenReturn((Object)rootAdjusteeNonArTotal);
        String adjusteeDocumentNumber = "adjusteeDocumentNumber";
        this.cutSpy.setAdjusteeDocumentNumber("adjusteeDocumentNumber");
        Mockito.when((Object)documentServiceMock.getByDocumentHeaderId("adjusteeDocumentNumber")).thenReturn((Object)adjusteeDocumentSpy);
        Mockito.when((Object)documentServiceMock.getByDocumentHeaderId(null)).thenReturn((Object)rootAdjusteeDocument);
        KualiDecimal actual = this.cutSpy.getTotalDollarAmount();
        KualiDecimal expected = (KualiDecimal)rootAdjusteeTotalFromControl.subtract((AbstractKualiDecimal)adjusteeNonArTotal);
        Assertions.assertEquals((Object)expected, (Object)actual);
    }

    private PaymentApplicationAdjustmentDocument createLocalSpy() {
        PaymentApplicationAdjustmentDocument adjustableSpy;
        try (MockedStatic kradServiceLocatorWebStaticMock = Mockito.mockStatic(KRADServiceLocatorWeb.class);){
            DocumentHeaderService documentHeaderServiceMock = (DocumentHeaderService)Mockito.mock(DocumentHeaderService.class);
            kradServiceLocatorWebStaticMock.when(KRADServiceLocatorWeb::getDocumentHeaderService).thenReturn((Object)documentHeaderServiceMock);
            adjustableSpy = (PaymentApplicationAdjustmentDocument)Mockito.spy((Object)new PaymentApplicationAdjustmentDocument());
        }
        return adjustableSpy;
    }
}

