/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.ar.document.authorization;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.junit.jupiter.api.parallel.Execution;
import org.junit.jupiter.api.parallel.ExecutionMode;
import org.kuali.kfs.kew.api.WorkflowDocument;
import org.kuali.kfs.kew.impl.document.WorkflowDocumentImpl;
import org.kuali.kfs.krad.document.Document;
import org.kuali.kfs.module.ar.businessobject.CashControlDetail;
import org.kuali.kfs.module.ar.document.CashControlDocument;
import org.kuali.kfs.module.ar.document.PaymentApplicationDocument;
import org.kuali.kfs.module.ar.document.authorization.CashControlDocumentPresentationController;
import org.kuali.kfs.sys.businessobject.DocumentHeader;
import org.kuali.kfs.sys.businessobject.ElectronicPaymentClaim;
import org.kuali.kfs.sys.businessobject.GeneralLedgerPendingEntry;
import org.kuali.kfs.sys.document.authorization.FinancialSystemTransactionalDocumentPresentationControllerBase;
import org.kuali.kfs.sys.service.BankService;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.jupiter.MockitoExtension;

@Execution(value=ExecutionMode.SAME_THREAD)
@ExtendWith(value={MockitoExtension.class})
class CashControlDocumentPresentationControllerTest {
    private CashControlDocumentPresentationController cut;

    CashControlDocumentPresentationControllerTest() {
    }

    @BeforeEach
    void setup() {
        this.cut = new CashControlDocumentPresentationController();
    }

    @AfterEach
    void tearDown() {
        FinancialSystemTransactionalDocumentPresentationControllerBase.setBankService(null);
    }

    @Test
    void canApprove_NoAppDocs_True(@Mock(stubOnly=true) CashControlDocument cashControlDocMock, @Mock(stubOnly=true) CashControlDetail cashControlDetailMock1, @Mock(stubOnly=true) CashControlDetail cashControlDetailMock2) {
        List<CashControlDetail> cashControlDetails = Arrays.asList(cashControlDetailMock1, cashControlDetailMock2);
        Mockito.when((Object)cashControlDocMock.getCashControlDetails()).thenReturn(cashControlDetails);
        Mockito.when((Object)cashControlDocMock.getCashControlDetails()).thenReturn(new ArrayList());
        Assertions.assertFalse((boolean)this.cut.canApprove((Document)cashControlDocMock));
    }

    @Test
    void canApprove_ApprovedAppDocs_True(@Mock(stubOnly=true) CashControlDocument cashControlDocMock, @Mock(stubOnly=true) WorkflowDocumentImpl payAppWorkflowDocMock, @Mock(stubOnly=true) DocumentHeader payAppDocHeaderMock1, @Mock(stubOnly=true) PaymentApplicationDocument paymentApplicationDocMock1, @Mock(stubOnly=true) CashControlDetail cashControlDetailMock1, @Mock(stubOnly=true) DocumentHeader payAppDocHeaderMock2, @Mock(stubOnly=true) PaymentApplicationDocument paymentApplicationDocMock2, @Mock(stubOnly=true) CashControlDetail cashControlDetailMock2) {
        Mockito.when((Object)payAppDocHeaderMock1.getWorkflowDocument()).thenReturn((Object)payAppWorkflowDocMock);
        Mockito.when((Object)paymentApplicationDocMock1.getDocumentHeader()).thenReturn((Object)payAppDocHeaderMock1);
        Mockito.when((Object)cashControlDetailMock1.getReferenceFinancialDocument()).thenReturn((Object)paymentApplicationDocMock1);
        Mockito.when((Object)payAppDocHeaderMock2.getWorkflowDocument()).thenReturn((Object)payAppWorkflowDocMock);
        Mockito.when((Object)paymentApplicationDocMock2.getDocumentHeader()).thenReturn((Object)payAppDocHeaderMock2);
        Mockito.when((Object)cashControlDetailMock2.getReferenceFinancialDocument()).thenReturn((Object)paymentApplicationDocMock2);
        List<CashControlDetail> cashControlDetails = Arrays.asList(cashControlDetailMock1, cashControlDetailMock2);
        Mockito.when((Object)cashControlDocMock.getCashControlDetails()).thenReturn(cashControlDetails);
        Mockito.when((Object)payAppWorkflowDocMock.isApproved()).thenReturn((Object)true);
        Assertions.assertTrue((boolean)this.cut.canApprove((Document)cashControlDocMock));
    }

    @Test
    void canApprove_ProcessedAppDocs_True(@Mock(stubOnly=true) BankService bankSvcMock, @Mock(stubOnly=true) CashControlDocument cashControlDocMock, @Mock(stubOnly=true) WorkflowDocumentImpl payAppWorkflowDocMock, @Mock(stubOnly=true) DocumentHeader payAppDocHeaderMock1, @Mock(stubOnly=true) PaymentApplicationDocument paymentApplicationDocMock1, @Mock(stubOnly=true) CashControlDetail cashControlDetailMock1, @Mock(stubOnly=true) DocumentHeader payAppDocHeaderMock2, @Mock(stubOnly=true) PaymentApplicationDocument paymentApplicationDocMock2, @Mock(stubOnly=true) CashControlDetail cashControlDetailMock2) {
        Mockito.when((Object)payAppDocHeaderMock1.getWorkflowDocument()).thenReturn((Object)payAppWorkflowDocMock);
        Mockito.when((Object)paymentApplicationDocMock1.getDocumentHeader()).thenReturn((Object)payAppDocHeaderMock1);
        Mockito.when((Object)cashControlDetailMock1.getReferenceFinancialDocument()).thenReturn((Object)paymentApplicationDocMock1);
        Mockito.when((Object)payAppDocHeaderMock2.getWorkflowDocument()).thenReturn((Object)payAppWorkflowDocMock);
        Mockito.when((Object)paymentApplicationDocMock2.getDocumentHeader()).thenReturn((Object)payAppDocHeaderMock2);
        Mockito.when((Object)cashControlDetailMock2.getReferenceFinancialDocument()).thenReturn((Object)paymentApplicationDocMock2);
        List<CashControlDetail> cashControlDetails = Arrays.asList(cashControlDetailMock1, cashControlDetailMock2);
        Mockito.when((Object)cashControlDocMock.getCashControlDetails()).thenReturn(cashControlDetails);
        FinancialSystemTransactionalDocumentPresentationControllerBase.setBankService((BankService)bankSvcMock);
        Mockito.when((Object)payAppWorkflowDocMock.isProcessed()).thenReturn((Object)true);
        ((WorkflowDocumentImpl)Mockito.doCallRealMethod().when((Object)payAppWorkflowDocMock)).isApproved();
        Assertions.assertTrue((boolean)this.cut.canApprove((Document)cashControlDocMock));
    }

    @Test
    void canApprove_FinalAppDocs_True(@Mock(stubOnly=true) CashControlDocument cashControlDocMock, @Mock(stubOnly=true) WorkflowDocumentImpl payAppWorkflowDocMock, @Mock(stubOnly=true) DocumentHeader payAppDocHeaderMock1, @Mock(stubOnly=true) PaymentApplicationDocument paymentApplicationDocMock1, @Mock(stubOnly=true) CashControlDetail cashControlDetailMock1, @Mock(stubOnly=true) DocumentHeader payAppDocHeaderMock2, @Mock(stubOnly=true) PaymentApplicationDocument paymentApplicationDocMock2, @Mock(stubOnly=true) CashControlDetail cashControlDetailMock2) {
        Mockito.when((Object)payAppDocHeaderMock1.getWorkflowDocument()).thenReturn((Object)payAppWorkflowDocMock);
        Mockito.when((Object)paymentApplicationDocMock1.getDocumentHeader()).thenReturn((Object)payAppDocHeaderMock1);
        Mockito.when((Object)cashControlDetailMock1.getReferenceFinancialDocument()).thenReturn((Object)paymentApplicationDocMock1);
        Mockito.when((Object)payAppDocHeaderMock2.getWorkflowDocument()).thenReturn((Object)payAppWorkflowDocMock);
        Mockito.when((Object)paymentApplicationDocMock2.getDocumentHeader()).thenReturn((Object)payAppDocHeaderMock2);
        Mockito.when((Object)cashControlDetailMock2.getReferenceFinancialDocument()).thenReturn((Object)paymentApplicationDocMock2);
        List<CashControlDetail> cashControlDetails = Arrays.asList(cashControlDetailMock1, cashControlDetailMock2);
        Mockito.when((Object)cashControlDocMock.getCashControlDetails()).thenReturn(cashControlDetails);
        Mockito.when((Object)payAppWorkflowDocMock.isFinal()).thenReturn((Object)true);
        ((WorkflowDocumentImpl)Mockito.doCallRealMethod().when((Object)payAppWorkflowDocMock)).isApproved();
        Assertions.assertTrue((boolean)this.cut.canApprove((Document)cashControlDocMock));
    }

    @Test
    void canApprove_CanceledAppDocs_True(@Mock(stubOnly=true) CashControlDocument cashControlDocMock, @Mock(stubOnly=true) WorkflowDocumentImpl payAppWorkflowDocMock, @Mock(stubOnly=true) DocumentHeader payAppDocHeaderMock1, @Mock(stubOnly=true) PaymentApplicationDocument paymentApplicationDocMock1, @Mock(stubOnly=true) CashControlDetail cashControlDetailMock1, @Mock(stubOnly=true) DocumentHeader payAppDocHeaderMock2, @Mock(stubOnly=true) PaymentApplicationDocument paymentApplicationDocMock2, @Mock(stubOnly=true) CashControlDetail cashControlDetailMock2) {
        Mockito.when((Object)payAppDocHeaderMock1.getWorkflowDocument()).thenReturn((Object)payAppWorkflowDocMock);
        Mockito.when((Object)paymentApplicationDocMock1.getDocumentHeader()).thenReturn((Object)payAppDocHeaderMock1);
        Mockito.when((Object)cashControlDetailMock1.getReferenceFinancialDocument()).thenReturn((Object)paymentApplicationDocMock1);
        Mockito.when((Object)payAppDocHeaderMock2.getWorkflowDocument()).thenReturn((Object)payAppWorkflowDocMock);
        Mockito.when((Object)paymentApplicationDocMock2.getDocumentHeader()).thenReturn((Object)payAppDocHeaderMock2);
        Mockito.when((Object)cashControlDetailMock2.getReferenceFinancialDocument()).thenReturn((Object)paymentApplicationDocMock2);
        List<CashControlDetail> cashControlDetails = Arrays.asList(cashControlDetailMock1, cashControlDetailMock2);
        Mockito.when((Object)cashControlDocMock.getCashControlDetails()).thenReturn(cashControlDetails);
        Mockito.when((Object)payAppWorkflowDocMock.isCanceled()).thenReturn((Object)true);
        Assertions.assertFalse((boolean)this.cut.canApprove((Document)cashControlDocMock));
    }

    @Test
    void canApprove_DisapprovedAppDocs_True(@Mock(stubOnly=true) CashControlDocument cashControlDocMock, @Mock(stubOnly=true) WorkflowDocumentImpl payAppWorkflowDocMock, @Mock(stubOnly=true) DocumentHeader payAppDocHeaderMock1, @Mock(stubOnly=true) PaymentApplicationDocument paymentApplicationDocMock1, @Mock(stubOnly=true) CashControlDetail cashControlDetailMock1, @Mock(stubOnly=true) DocumentHeader payAppDocHeaderMock2, @Mock(stubOnly=true) PaymentApplicationDocument paymentApplicationDocMock2, @Mock(stubOnly=true) CashControlDetail cashControlDetailMock2) {
        Mockito.when((Object)payAppDocHeaderMock1.getWorkflowDocument()).thenReturn((Object)payAppWorkflowDocMock);
        Mockito.when((Object)paymentApplicationDocMock1.getDocumentHeader()).thenReturn((Object)payAppDocHeaderMock1);
        Mockito.when((Object)cashControlDetailMock1.getReferenceFinancialDocument()).thenReturn((Object)paymentApplicationDocMock1);
        Mockito.when((Object)payAppDocHeaderMock2.getWorkflowDocument()).thenReturn((Object)payAppWorkflowDocMock);
        Mockito.when((Object)paymentApplicationDocMock2.getDocumentHeader()).thenReturn((Object)payAppDocHeaderMock2);
        Mockito.when((Object)cashControlDetailMock2.getReferenceFinancialDocument()).thenReturn((Object)paymentApplicationDocMock2);
        List<CashControlDetail> cashControlDetails = Arrays.asList(cashControlDetailMock1, cashControlDetailMock2);
        Mockito.when((Object)cashControlDocMock.getCashControlDetails()).thenReturn(cashControlDetails);
        Mockito.when((Object)payAppWorkflowDocMock.isDisapproved()).thenReturn((Object)true);
        Assertions.assertFalse((boolean)this.cut.canApprove((Document)cashControlDocMock));
    }

    @Test
    void canApprove_ApprovedAndCanceledAppDocs_True(@Mock(stubOnly=true) CashControlDocument cashControlDocMock, @Mock(stubOnly=true) WorkflowDocumentImpl payAppWorkflowDocMock, @Mock(stubOnly=true) DocumentHeader payAppDocHeaderMock1, @Mock(stubOnly=true) PaymentApplicationDocument paymentApplicationDocMock1, @Mock(stubOnly=true) CashControlDetail cashControlDetailMock1, @Mock(stubOnly=true) DocumentHeader payAppDocHeaderMock2, @Mock(stubOnly=true) PaymentApplicationDocument paymentApplicationDocMock2, @Mock(stubOnly=true) CashControlDetail cashControlDetailMock2) {
        Mockito.when((Object)payAppDocHeaderMock1.getWorkflowDocument()).thenReturn((Object)payAppWorkflowDocMock);
        Mockito.when((Object)paymentApplicationDocMock1.getDocumentHeader()).thenReturn((Object)payAppDocHeaderMock1);
        Mockito.when((Object)cashControlDetailMock1.getReferenceFinancialDocument()).thenReturn((Object)paymentApplicationDocMock1);
        Mockito.when((Object)payAppDocHeaderMock2.getWorkflowDocument()).thenReturn((Object)payAppWorkflowDocMock);
        Mockito.when((Object)paymentApplicationDocMock2.getDocumentHeader()).thenReturn((Object)payAppDocHeaderMock2);
        Mockito.when((Object)cashControlDetailMock2.getReferenceFinancialDocument()).thenReturn((Object)paymentApplicationDocMock2);
        List<CashControlDetail> cashControlDetails = Arrays.asList(cashControlDetailMock1, cashControlDetailMock2);
        Mockito.when((Object)cashControlDocMock.getCashControlDetails()).thenReturn(cashControlDetails);
        Mockito.when((Object)payAppWorkflowDocMock.isApproved()).thenReturn((Object)true);
        Assertions.assertTrue((boolean)this.cut.canApprove((Document)cashControlDocMock));
    }

    @Test
    void canApprove_ApprovedAndDisapprovedAppDocs_True(@Mock(stubOnly=true) BankService bankSvcMock, @Mock(stubOnly=true) CashControlDocument cashControlDocMock, @Mock(stubOnly=true) WorkflowDocumentImpl payAppWorkflowDocMock, @Mock(stubOnly=true) DocumentHeader payAppDocHeaderMock1, @Mock(stubOnly=true) PaymentApplicationDocument paymentApplicationDocMock1, @Mock(stubOnly=true) CashControlDetail cashControlDetailMock1, @Mock(stubOnly=true) DocumentHeader payAppDocHeaderMock2, @Mock(stubOnly=true) PaymentApplicationDocument paymentApplicationDocMock2, @Mock(stubOnly=true) CashControlDetail cashControlDetailMock2) {
        Mockito.when((Object)payAppDocHeaderMock1.getWorkflowDocument()).thenReturn((Object)payAppWorkflowDocMock);
        Mockito.when((Object)paymentApplicationDocMock1.getDocumentHeader()).thenReturn((Object)payAppDocHeaderMock1);
        Mockito.when((Object)cashControlDetailMock1.getReferenceFinancialDocument()).thenReturn((Object)paymentApplicationDocMock1);
        Mockito.when((Object)payAppDocHeaderMock2.getWorkflowDocument()).thenReturn((Object)payAppWorkflowDocMock);
        Mockito.when((Object)paymentApplicationDocMock2.getDocumentHeader()).thenReturn((Object)payAppDocHeaderMock2);
        Mockito.when((Object)cashControlDetailMock2.getReferenceFinancialDocument()).thenReturn((Object)paymentApplicationDocMock2);
        List<CashControlDetail> cashControlDetails = Arrays.asList(cashControlDetailMock1, cashControlDetailMock2);
        Mockito.when((Object)cashControlDocMock.getCashControlDetails()).thenReturn(cashControlDetails);
        FinancialSystemTransactionalDocumentPresentationControllerBase.setBankService((BankService)bankSvcMock);
        Mockito.when((Object)payAppWorkflowDocMock.isApproved()).thenReturn((Object)true);
        Assertions.assertTrue((boolean)this.cut.canApprove((Document)cashControlDocMock));
    }

    @Test
    void canApprove_CanceledAndDisapprovedAppDocs_False(@Mock(stubOnly=true) CashControlDocument cashControlDocMock, @Mock(stubOnly=true) WorkflowDocumentImpl payAppWorkflowDocMock, @Mock(stubOnly=true) DocumentHeader payAppDocHeaderMock1, @Mock(stubOnly=true) PaymentApplicationDocument paymentApplicationDocMock1, @Mock(stubOnly=true) CashControlDetail cashControlDetailMock1, @Mock(stubOnly=true) DocumentHeader payAppDocHeaderMock2, @Mock(stubOnly=true) PaymentApplicationDocument paymentApplicationDocMock2, @Mock(stubOnly=true) CashControlDetail cashControlDetailMock2) {
        Mockito.when((Object)payAppDocHeaderMock1.getWorkflowDocument()).thenReturn((Object)payAppWorkflowDocMock);
        Mockito.when((Object)paymentApplicationDocMock1.getDocumentHeader()).thenReturn((Object)payAppDocHeaderMock1);
        Mockito.when((Object)cashControlDetailMock1.getReferenceFinancialDocument()).thenReturn((Object)paymentApplicationDocMock1);
        Mockito.when((Object)payAppDocHeaderMock2.getWorkflowDocument()).thenReturn((Object)payAppWorkflowDocMock);
        Mockito.when((Object)paymentApplicationDocMock2.getDocumentHeader()).thenReturn((Object)payAppDocHeaderMock2);
        Mockito.when((Object)cashControlDetailMock2.getReferenceFinancialDocument()).thenReturn((Object)paymentApplicationDocMock2);
        List<CashControlDetail> cashControlDetails = Arrays.asList(cashControlDetailMock1, cashControlDetailMock2);
        Mockito.when((Object)cashControlDocMock.getCashControlDetails()).thenReturn(cashControlDetails);
        Mockito.when((Object)payAppWorkflowDocMock.isCanceled()).thenReturn((Object)true);
        Assertions.assertFalse((boolean)this.cut.canApprove((Document)cashControlDocMock));
    }

    @Test
    void getEditModes_Initiated_NoClaims(@Mock(stubOnly=true) DocumentHeader cashControlDocHeaderMock, @Mock(stubOnly=true) BankService bankSvcMock, @Mock(stubOnly=true) CashControlDocument cashControlDocMock, @Mock(stubOnly=true) WorkflowDocument cashControlWorkflowDocMock) {
        Mockito.when((Object)cashControlDocHeaderMock.getWorkflowDocument()).thenReturn((Object)cashControlWorkflowDocMock);
        Mockito.when((Object)cashControlDocMock.getDocumentHeader()).thenReturn((Object)cashControlDocHeaderMock);
        FinancialSystemTransactionalDocumentPresentationControllerBase.setBankService((BankService)bankSvcMock);
        Mockito.when((Object)cashControlWorkflowDocMock.isInitiated()).thenReturn((Object)true);
        Set editModes = this.cut.getEditModes((Document)cashControlDocMock);
        Assertions.assertEquals((int)5, (int)editModes.size());
        Assertions.assertTrue((boolean)editModes.contains("amountTotaling"));
        Assertions.assertTrue((boolean)editModes.contains("editPaymentMedium"));
        Assertions.assertTrue((boolean)editModes.contains("editDetails"));
        Assertions.assertTrue((boolean)editModes.contains("editRefDocNbr"));
        Assertions.assertTrue((boolean)editModes.contains("editBankCode"));
    }

    @Test
    void getEditModes_Saved_NoClaims(@Mock(stubOnly=true) DocumentHeader cashControlDocHeaderMock, @Mock(stubOnly=true) BankService bankSvcMock, @Mock(stubOnly=true) CashControlDocument cashControlDocMock, @Mock(stubOnly=true) WorkflowDocument cashControlWorkflowDocMock) {
        Mockito.when((Object)cashControlDocHeaderMock.getWorkflowDocument()).thenReturn((Object)cashControlWorkflowDocMock);
        Mockito.when((Object)cashControlDocMock.getDocumentHeader()).thenReturn((Object)cashControlDocHeaderMock);
        FinancialSystemTransactionalDocumentPresentationControllerBase.setBankService((BankService)bankSvcMock);
        Mockito.when((Object)cashControlWorkflowDocMock.isSaved()).thenReturn((Object)true);
        Set editModes = this.cut.getEditModes((Document)cashControlDocMock);
        Assertions.assertEquals((int)5, (int)editModes.size());
        Assertions.assertTrue((boolean)editModes.contains("amountTotaling"));
        Assertions.assertTrue((boolean)editModes.contains("editPaymentMedium"));
        Assertions.assertTrue((boolean)editModes.contains("editDetails"));
        Assertions.assertTrue((boolean)editModes.contains("editRefDocNbr"));
        Assertions.assertTrue((boolean)editModes.contains("editBankCode"));
    }

    @Test
    void getEditModes_CompletionRequested_NoClaims(@Mock(stubOnly=true) DocumentHeader cashControlDocHeaderMock, @Mock(stubOnly=true) BankService bankSvcMock, @Mock(stubOnly=true) CashControlDocument cashControlDocMock, @Mock(stubOnly=true) WorkflowDocument cashControlWorkflowDocMock) {
        Mockito.when((Object)cashControlDocHeaderMock.getWorkflowDocument()).thenReturn((Object)cashControlWorkflowDocMock);
        Mockito.when((Object)cashControlDocMock.getDocumentHeader()).thenReturn((Object)cashControlDocHeaderMock);
        FinancialSystemTransactionalDocumentPresentationControllerBase.setBankService((BankService)bankSvcMock);
        Mockito.when((Object)cashControlWorkflowDocMock.isCompletionRequested()).thenReturn((Object)true);
        Set editModes = this.cut.getEditModes((Document)cashControlDocMock);
        Assertions.assertEquals((int)5, (int)editModes.size());
        Assertions.assertTrue((boolean)editModes.contains("amountTotaling"));
        Assertions.assertTrue((boolean)editModes.contains("editPaymentMedium"));
        Assertions.assertTrue((boolean)editModes.contains("editDetails"));
        Assertions.assertTrue((boolean)editModes.contains("editRefDocNbr"));
        Assertions.assertTrue((boolean)editModes.contains("editBankCode"));
    }

    @Test
    void getEditModes_Initiated_NoClaims_BankSpecEnabled(@Mock(stubOnly=true) DocumentHeader cashControlDocHeaderMock, @Mock(stubOnly=true) BankService bankSvcMock, @Mock(stubOnly=true) CashControlDocument cashControlDocMock, @Mock(stubOnly=true) WorkflowDocument cashControlWorkflowDocMock) {
        Mockito.when((Object)cashControlDocHeaderMock.getWorkflowDocument()).thenReturn((Object)cashControlWorkflowDocMock);
        Mockito.when((Object)cashControlDocMock.getDocumentHeader()).thenReturn((Object)cashControlDocHeaderMock);
        FinancialSystemTransactionalDocumentPresentationControllerBase.setBankService((BankService)bankSvcMock);
        Mockito.when((Object)bankSvcMock.isBankSpecificationEnabled()).thenReturn((Object)true);
        Mockito.when((Object)cashControlWorkflowDocMock.isInitiated()).thenReturn((Object)true);
        Set editModes = this.cut.getEditModes((Document)cashControlDocMock);
        Assertions.assertEquals((int)6, (int)editModes.size());
        Assertions.assertTrue((boolean)editModes.contains("amountTotaling"));
        Assertions.assertTrue((boolean)editModes.contains("editPaymentMedium"));
        Assertions.assertTrue((boolean)editModes.contains("editDetails"));
        Assertions.assertTrue((boolean)editModes.contains("editRefDocNbr"));
        Assertions.assertTrue((boolean)editModes.contains("editBankCode"));
        Assertions.assertTrue((boolean)editModes.contains("showBankCode"));
    }

    @Test
    void getEditModes_Saved_NoClaims_BankSpecEnabled(@Mock(stubOnly=true) DocumentHeader cashControlDocHeaderMock, @Mock(stubOnly=true) BankService bankSvcMock, @Mock(stubOnly=true) CashControlDocument cashControlDocMock, @Mock(stubOnly=true) WorkflowDocument cashControlWorkflowDocMock) {
        Mockito.when((Object)cashControlDocHeaderMock.getWorkflowDocument()).thenReturn((Object)cashControlWorkflowDocMock);
        Mockito.when((Object)cashControlDocMock.getDocumentHeader()).thenReturn((Object)cashControlDocHeaderMock);
        FinancialSystemTransactionalDocumentPresentationControllerBase.setBankService((BankService)bankSvcMock);
        Mockito.when((Object)bankSvcMock.isBankSpecificationEnabled()).thenReturn((Object)true);
        Mockito.when((Object)cashControlWorkflowDocMock.isSaved()).thenReturn((Object)true);
        Set editModes = this.cut.getEditModes((Document)cashControlDocMock);
        Assertions.assertEquals((int)6, (int)editModes.size());
        Assertions.assertTrue((boolean)editModes.contains("amountTotaling"));
        Assertions.assertTrue((boolean)editModes.contains("editPaymentMedium"));
        Assertions.assertTrue((boolean)editModes.contains("editDetails"));
        Assertions.assertTrue((boolean)editModes.contains("editRefDocNbr"));
        Assertions.assertTrue((boolean)editModes.contains("editBankCode"));
        Assertions.assertTrue((boolean)editModes.contains("showBankCode"));
    }

    @Test
    void getEditModes_CompletionRequested_NoClaims_BankSpecEnabled(@Mock(stubOnly=true) DocumentHeader cashControlDocHeaderMock, @Mock(stubOnly=true) BankService bankSvcMock, @Mock(stubOnly=true) CashControlDocument cashControlDocMock, @Mock(stubOnly=true) WorkflowDocument cashControlWorkflowDocMock) {
        Mockito.when((Object)cashControlDocHeaderMock.getWorkflowDocument()).thenReturn((Object)cashControlWorkflowDocMock);
        Mockito.when((Object)cashControlDocMock.getDocumentHeader()).thenReturn((Object)cashControlDocHeaderMock);
        FinancialSystemTransactionalDocumentPresentationControllerBase.setBankService((BankService)bankSvcMock);
        Mockito.when((Object)bankSvcMock.isBankSpecificationEnabled()).thenReturn((Object)true);
        Mockito.when((Object)cashControlWorkflowDocMock.isCompletionRequested()).thenReturn((Object)true);
        Set editModes = this.cut.getEditModes((Document)cashControlDocMock);
        Assertions.assertEquals((int)6, (int)editModes.size());
        Assertions.assertTrue((boolean)editModes.contains("amountTotaling"));
        Assertions.assertTrue((boolean)editModes.contains("editPaymentMedium"));
        Assertions.assertTrue((boolean)editModes.contains("editDetails"));
        Assertions.assertTrue((boolean)editModes.contains("editRefDocNbr"));
        Assertions.assertTrue((boolean)editModes.contains("editBankCode"));
        Assertions.assertTrue((boolean)editModes.contains("showBankCode"));
    }

    @Test
    void getEditModes_Initiated_HasClaims_NoBankCode(@Mock(stubOnly=true) DocumentHeader cashControlDocHeaderMock, @Mock(stubOnly=true) BankService bankSvcMock, @Mock(stubOnly=true) CashControlDocument cashControlDocMock, @Mock(stubOnly=true) WorkflowDocument cashControlWorkflowDocMock) {
        Mockito.when((Object)cashControlDocHeaderMock.getWorkflowDocument()).thenReturn((Object)cashControlWorkflowDocMock);
        Mockito.when((Object)cashControlDocMock.getDocumentHeader()).thenReturn((Object)cashControlDocHeaderMock);
        FinancialSystemTransactionalDocumentPresentationControllerBase.setBankService((BankService)bankSvcMock);
        List<ElectronicPaymentClaim> electronicPaymentClaims = Collections.singletonList(new ElectronicPaymentClaim());
        Mockito.when((Object)cashControlDocMock.getElectronicPaymentClaims()).thenReturn(electronicPaymentClaims);
        Mockito.when((Object)cashControlWorkflowDocMock.isInitiated()).thenReturn((Object)true);
        Set editModes = this.cut.getEditModes((Document)cashControlDocMock);
        Assertions.assertEquals((int)1, (int)editModes.size());
        Assertions.assertTrue((boolean)editModes.contains("amountTotaling"));
    }

    @Test
    void getEditModes_Saved_HasClaims_NoBankCode(@Mock(stubOnly=true) DocumentHeader cashControlDocHeaderMock, @Mock(stubOnly=true) BankService bankSvcMock, @Mock(stubOnly=true) CashControlDocument cashControlDocMock, @Mock(stubOnly=true) WorkflowDocument cashControlWorkflowDocMock) {
        Mockito.when((Object)cashControlDocHeaderMock.getWorkflowDocument()).thenReturn((Object)cashControlWorkflowDocMock);
        Mockito.when((Object)cashControlDocMock.getDocumentHeader()).thenReturn((Object)cashControlDocHeaderMock);
        FinancialSystemTransactionalDocumentPresentationControllerBase.setBankService((BankService)bankSvcMock);
        List<ElectronicPaymentClaim> electronicPaymentClaims = Collections.singletonList(new ElectronicPaymentClaim());
        Mockito.when((Object)cashControlDocMock.getElectronicPaymentClaims()).thenReturn(electronicPaymentClaims);
        Mockito.when((Object)cashControlWorkflowDocMock.isSaved()).thenReturn((Object)true);
        Set editModes = this.cut.getEditModes((Document)cashControlDocMock);
        Assertions.assertEquals((int)1, (int)editModes.size());
        Assertions.assertTrue((boolean)editModes.contains("amountTotaling"));
    }

    @Test
    void getEditModes_CompletionRequested_HasClaims_NoBankCode(@Mock(stubOnly=true) DocumentHeader cashControlDocHeaderMock, @Mock(stubOnly=true) BankService bankSvcMock, @Mock(stubOnly=true) CashControlDocument cashControlDocMock, @Mock(stubOnly=true) WorkflowDocument cashControlWorkflowDocMock) {
        Mockito.when((Object)cashControlDocHeaderMock.getWorkflowDocument()).thenReturn((Object)cashControlWorkflowDocMock);
        Mockito.when((Object)cashControlDocMock.getDocumentHeader()).thenReturn((Object)cashControlDocHeaderMock);
        FinancialSystemTransactionalDocumentPresentationControllerBase.setBankService((BankService)bankSvcMock);
        List<ElectronicPaymentClaim> electronicPaymentClaims = Collections.singletonList(new ElectronicPaymentClaim());
        Mockito.when((Object)cashControlDocMock.getElectronicPaymentClaims()).thenReturn(electronicPaymentClaims);
        Mockito.when((Object)cashControlWorkflowDocMock.isCompletionRequested()).thenReturn((Object)true);
        Set editModes = this.cut.getEditModes((Document)cashControlDocMock);
        Assertions.assertEquals((int)1, (int)editModes.size());
        Assertions.assertTrue((boolean)editModes.contains("amountTotaling"));
    }

    @Test
    void getEditModes_Initiated_HasClaims_WithBankCode(@Mock(stubOnly=true) DocumentHeader cashControlDocHeaderMock, @Mock(stubOnly=true) BankService bankSvcMock, @Mock(stubOnly=true) CashControlDocument cashControlDocMock, @Mock(stubOnly=true) WorkflowDocument cashControlWorkflowDocMock) {
        Mockito.when((Object)cashControlDocHeaderMock.getWorkflowDocument()).thenReturn((Object)cashControlWorkflowDocMock);
        Mockito.when((Object)cashControlDocMock.getDocumentHeader()).thenReturn((Object)cashControlDocHeaderMock);
        FinancialSystemTransactionalDocumentPresentationControllerBase.setBankService((BankService)bankSvcMock);
        List<ElectronicPaymentClaim> electronicPaymentClaims = Collections.singletonList(new ElectronicPaymentClaim());
        Mockito.when((Object)cashControlDocMock.getElectronicPaymentClaims()).thenReturn(electronicPaymentClaims);
        Mockito.when((Object)cashControlDocMock.getBankCode()).thenReturn((Object)"BANK");
        Mockito.when((Object)cashControlWorkflowDocMock.isInitiated()).thenReturn((Object)true);
        Set editModes = this.cut.getEditModes((Document)cashControlDocMock);
        Assertions.assertEquals((int)2, (int)editModes.size());
        Assertions.assertTrue((boolean)editModes.contains("amountTotaling"));
        Assertions.assertTrue((boolean)editModes.contains("showBankCode"));
    }

    @Test
    void getEditModes_Saved_HasClaims_WithBankCode(@Mock(stubOnly=true) DocumentHeader cashControlDocHeaderMock, @Mock(stubOnly=true) BankService bankSvcMock, @Mock(stubOnly=true) CashControlDocument cashControlDocMock, @Mock(stubOnly=true) WorkflowDocument cashControlWorkflowDocMock) {
        Mockito.when((Object)cashControlDocHeaderMock.getWorkflowDocument()).thenReturn((Object)cashControlWorkflowDocMock);
        Mockito.when((Object)cashControlDocMock.getDocumentHeader()).thenReturn((Object)cashControlDocHeaderMock);
        FinancialSystemTransactionalDocumentPresentationControllerBase.setBankService((BankService)bankSvcMock);
        List<ElectronicPaymentClaim> electronicPaymentClaims = Collections.singletonList(new ElectronicPaymentClaim());
        Mockito.when((Object)cashControlDocMock.getElectronicPaymentClaims()).thenReturn(electronicPaymentClaims);
        Mockito.when((Object)cashControlDocMock.getBankCode()).thenReturn((Object)"BANK");
        Mockito.when((Object)cashControlWorkflowDocMock.isSaved()).thenReturn((Object)true);
        Set editModes = this.cut.getEditModes((Document)cashControlDocMock);
        Assertions.assertEquals((int)2, (int)editModes.size());
        Assertions.assertTrue((boolean)editModes.contains("amountTotaling"));
        Assertions.assertTrue((boolean)editModes.contains("showBankCode"));
    }

    @Test
    void getEditModes_CompletionRequested_HasClaims_WithBankCode(@Mock(stubOnly=true) DocumentHeader cashControlDocHeaderMock, @Mock(stubOnly=true) BankService bankSvcMock, @Mock(stubOnly=true) CashControlDocument cashControlDocMock, @Mock(stubOnly=true) WorkflowDocument cashControlWorkflowDocMock) {
        Mockito.when((Object)cashControlDocHeaderMock.getWorkflowDocument()).thenReturn((Object)cashControlWorkflowDocMock);
        Mockito.when((Object)cashControlDocMock.getDocumentHeader()).thenReturn((Object)cashControlDocHeaderMock);
        FinancialSystemTransactionalDocumentPresentationControllerBase.setBankService((BankService)bankSvcMock);
        List<ElectronicPaymentClaim> electronicPaymentClaims = Collections.singletonList(new ElectronicPaymentClaim());
        Mockito.when((Object)cashControlDocMock.getElectronicPaymentClaims()).thenReturn(electronicPaymentClaims);
        Mockito.when((Object)cashControlDocMock.getBankCode()).thenReturn((Object)"BANK");
        Mockito.when((Object)cashControlWorkflowDocMock.isCompletionRequested()).thenReturn((Object)true);
        Set editModes = this.cut.getEditModes((Document)cashControlDocMock);
        Assertions.assertEquals((int)2, (int)editModes.size());
        Assertions.assertTrue((boolean)editModes.contains("amountTotaling"));
        Assertions.assertTrue((boolean)editModes.contains("showBankCode"));
    }

    @Test
    void getEditModes_Enroute_PaymentMediumCash(@Mock(stubOnly=true) DocumentHeader cashControlDocHeaderMock, @Mock(stubOnly=true) BankService bankSvcMock, @Mock(stubOnly=true) CashControlDocument cashControlDocMock, @Mock(stubOnly=true) WorkflowDocument cashControlWorkflowDocMock) {
        Mockito.when((Object)cashControlDocHeaderMock.getWorkflowDocument()).thenReturn((Object)cashControlWorkflowDocMock);
        Mockito.when((Object)cashControlDocMock.getDocumentHeader()).thenReturn((Object)cashControlDocHeaderMock);
        FinancialSystemTransactionalDocumentPresentationControllerBase.setBankService((BankService)bankSvcMock);
        Mockito.when((Object)cashControlDocMock.getCustomerPaymentMediumCode()).thenReturn((Object)"CA");
        Mockito.when((Object)cashControlWorkflowDocMock.isEnroute()).thenReturn((Object)true);
        Set editModes = this.cut.getEditModes((Document)cashControlDocMock);
        Assertions.assertEquals((int)2, (int)editModes.size());
        Assertions.assertTrue((boolean)editModes.contains("amountTotaling"));
        Assertions.assertTrue((boolean)editModes.contains("editPaymentAppDoc"));
    }

    @Test
    void getEditModes_Enroute_PaymentMediumNonCash_GLPEsEmpty(@Mock(stubOnly=true) DocumentHeader cashControlDocHeaderMock, @Mock(stubOnly=true) BankService bankSvcMock, @Mock(stubOnly=true) CashControlDocument cashControlDocMock, @Mock(stubOnly=true) WorkflowDocument cashControlWorkflowDocMock) {
        Mockito.when((Object)cashControlDocHeaderMock.getWorkflowDocument()).thenReturn((Object)cashControlWorkflowDocMock);
        Mockito.when((Object)cashControlDocMock.getDocumentHeader()).thenReturn((Object)cashControlDocHeaderMock);
        FinancialSystemTransactionalDocumentPresentationControllerBase.setBankService((BankService)bankSvcMock);
        Mockito.when((Object)cashControlWorkflowDocMock.isEnroute()).thenReturn((Object)true);
        Set editModes = this.cut.getEditModes((Document)cashControlDocMock);
        Assertions.assertEquals((int)1, (int)editModes.size());
        Assertions.assertTrue((boolean)editModes.contains("amountTotaling"));
    }

    @Test
    void getEditModes_Enroute_PaymentMediumNonCash_GLPEsNotEmpty(@Mock(stubOnly=true) DocumentHeader cashControlDocHeaderMock, @Mock(stubOnly=true) BankService bankSvcMock, @Mock(stubOnly=true) CashControlDocument cashControlDocMock, @Mock(stubOnly=true) WorkflowDocument cashControlWorkflowDocMock) {
        Mockito.when((Object)cashControlDocHeaderMock.getWorkflowDocument()).thenReturn((Object)cashControlWorkflowDocMock);
        Mockito.when((Object)cashControlDocMock.getDocumentHeader()).thenReturn((Object)cashControlDocHeaderMock);
        FinancialSystemTransactionalDocumentPresentationControllerBase.setBankService((BankService)bankSvcMock);
        List<GeneralLedgerPendingEntry> generalLedgerPendingEntries = Collections.singletonList(new GeneralLedgerPendingEntry());
        Mockito.when((Object)cashControlDocMock.getGeneralLedgerPendingEntries()).thenReturn(generalLedgerPendingEntries);
        Mockito.when((Object)cashControlWorkflowDocMock.isEnroute()).thenReturn((Object)true);
        Set editModes = this.cut.getEditModes((Document)cashControlDocMock);
        Assertions.assertEquals((int)2, (int)editModes.size());
        Assertions.assertTrue((boolean)editModes.contains("amountTotaling"));
        Assertions.assertTrue((boolean)editModes.contains("editPaymentAppDoc"));
    }

    @Test
    void getEditModes_Enroute_ApprovalRequested_PaymentMediumCash(@Mock(stubOnly=true) DocumentHeader cashControlDocHeaderMock, @Mock(stubOnly=true) BankService bankSvcMock, @Mock(stubOnly=true) CashControlDocument cashControlDocMock, @Mock(stubOnly=true) WorkflowDocument cashControlWorkflowDocMock) {
        Mockito.when((Object)cashControlDocHeaderMock.getWorkflowDocument()).thenReturn((Object)cashControlWorkflowDocMock);
        Mockito.when((Object)cashControlDocMock.getDocumentHeader()).thenReturn((Object)cashControlDocHeaderMock);
        FinancialSystemTransactionalDocumentPresentationControllerBase.setBankService((BankService)bankSvcMock);
        Mockito.when((Object)cashControlDocMock.getCustomerPaymentMediumCode()).thenReturn((Object)"CA");
        Mockito.when((Object)cashControlWorkflowDocMock.isEnroute()).thenReturn((Object)true);
        Mockito.when((Object)cashControlWorkflowDocMock.isApprovalRequested()).thenReturn((Object)true);
        Set editModes = this.cut.getEditModes((Document)cashControlDocMock);
        Assertions.assertEquals((int)5, (int)editModes.size());
        Assertions.assertTrue((boolean)editModes.contains("amountTotaling"));
        Assertions.assertTrue((boolean)editModes.contains("editPaymentAppDoc"));
        Assertions.assertTrue((boolean)editModes.contains("editPaymentMedium"));
        Assertions.assertTrue((boolean)editModes.contains("editRefDocNbr"));
        Assertions.assertTrue((boolean)editModes.contains("editBankCode"));
    }

    @Test
    void getEditModes_Enroute_ApprovalRequested_PaymentMediumNonCash_GLPEsEmpty_ApprovedAndDisapprovedApps(@Mock(stubOnly=true) DocumentHeader cashControlDocHeaderMock, @Mock(stubOnly=true) BankService bankSvcMock, @Mock(stubOnly=true) CashControlDocument cashControlDocMock, @Mock(stubOnly=true) WorkflowDocument cashControlWorkflowDocMock) {
        Mockito.when((Object)cashControlDocHeaderMock.getWorkflowDocument()).thenReturn((Object)cashControlWorkflowDocMock);
        Mockito.when((Object)cashControlDocMock.getDocumentHeader()).thenReturn((Object)cashControlDocHeaderMock);
        FinancialSystemTransactionalDocumentPresentationControllerBase.setBankService((BankService)bankSvcMock);
        Mockito.when((Object)cashControlWorkflowDocMock.isEnroute()).thenReturn((Object)true);
        Mockito.when((Object)cashControlWorkflowDocMock.isApprovalRequested()).thenReturn((Object)true);
        Set editModes = this.cut.getEditModes((Document)cashControlDocMock);
        Assertions.assertEquals((int)3, (int)editModes.size());
        Assertions.assertTrue((boolean)editModes.contains("amountTotaling"));
        Assertions.assertTrue((boolean)editModes.contains("editPaymentMedium"));
        Assertions.assertTrue((boolean)editModes.contains("editBankCode"));
    }

    @Test
    void getEditModes_Enroute_ApprovalRequested_PaymentMediumNonCash_GLPEsEmpty_EnrouteApp(@Mock(stubOnly=true) DocumentHeader cashControlDocHeaderMock, @Mock(stubOnly=true) BankService bankSvcMock, @Mock(stubOnly=true) CashControlDocument cashControlDocMock, @Mock(stubOnly=true) WorkflowDocument cashControlWorkflowDocMock) {
        Mockito.when((Object)cashControlDocHeaderMock.getWorkflowDocument()).thenReturn((Object)cashControlWorkflowDocMock);
        Mockito.when((Object)cashControlDocMock.getDocumentHeader()).thenReturn((Object)cashControlDocHeaderMock);
        FinancialSystemTransactionalDocumentPresentationControllerBase.setBankService((BankService)bankSvcMock);
        Mockito.when((Object)cashControlWorkflowDocMock.isEnroute()).thenReturn((Object)true);
        Mockito.when((Object)cashControlWorkflowDocMock.isApprovalRequested()).thenReturn((Object)true);
        Set editModes = this.cut.getEditModes((Document)cashControlDocMock);
        Assertions.assertEquals((int)3, (int)editModes.size());
        Assertions.assertTrue((boolean)editModes.contains("amountTotaling"));
        Assertions.assertTrue((boolean)editModes.contains("editPaymentMedium"));
        Assertions.assertTrue((boolean)editModes.contains("editBankCode"));
    }

    @Test
    void getEditModes_Enroute_ApprovalRequested_PaymentMediumNonCash_GLPEsNonEmpty_ApprovedAndDisapprovedApps(@Mock(stubOnly=true) DocumentHeader cashControlDocHeaderMock, @Mock(stubOnly=true) BankService bankSvcMock, @Mock(stubOnly=true) CashControlDocument cashControlDocMock, @Mock(stubOnly=true) WorkflowDocument cashControlWorkflowDocMock) {
        Mockito.when((Object)cashControlDocHeaderMock.getWorkflowDocument()).thenReturn((Object)cashControlWorkflowDocMock);
        Mockito.when((Object)cashControlDocMock.getDocumentHeader()).thenReturn((Object)cashControlDocHeaderMock);
        FinancialSystemTransactionalDocumentPresentationControllerBase.setBankService((BankService)bankSvcMock);
        ArrayList<GeneralLedgerPendingEntry> pendingEntries = new ArrayList<GeneralLedgerPendingEntry>();
        pendingEntries.add(new GeneralLedgerPendingEntry());
        Mockito.when((Object)cashControlDocMock.getGeneralLedgerPendingEntries()).thenReturn(pendingEntries);
        Mockito.when((Object)cashControlWorkflowDocMock.isEnroute()).thenReturn((Object)true);
        Mockito.when((Object)cashControlWorkflowDocMock.isApprovalRequested()).thenReturn((Object)true);
        Set editModes = this.cut.getEditModes((Document)cashControlDocMock);
        Assertions.assertEquals((int)4, (int)editModes.size());
        Assertions.assertTrue((boolean)editModes.contains("amountTotaling"));
        Assertions.assertTrue((boolean)editModes.contains("editPaymentAppDoc"));
        Assertions.assertTrue((boolean)editModes.contains("editPaymentMedium"));
        Assertions.assertTrue((boolean)editModes.contains("editBankCode"));
    }

    @Test
    public void getEditModes_Enroute_ApprovalRequested_PaymentMediumNonCash_GLPEsNonEmpty_EnrouteApp(@Mock(stubOnly=true) DocumentHeader cashControlDocHeaderMock, @Mock(stubOnly=true) BankService bankSvcMock, @Mock(stubOnly=true) CashControlDocument cashControlDocMock, @Mock(stubOnly=true) WorkflowDocument cashControlWorkflowDocMock) {
        Mockito.when((Object)cashControlDocHeaderMock.getWorkflowDocument()).thenReturn((Object)cashControlWorkflowDocMock);
        Mockito.when((Object)cashControlDocMock.getDocumentHeader()).thenReturn((Object)cashControlDocHeaderMock);
        FinancialSystemTransactionalDocumentPresentationControllerBase.setBankService((BankService)bankSvcMock);
        ArrayList<GeneralLedgerPendingEntry> pendingEntries = new ArrayList<GeneralLedgerPendingEntry>();
        pendingEntries.add(new GeneralLedgerPendingEntry());
        Mockito.when((Object)cashControlDocMock.getGeneralLedgerPendingEntries()).thenReturn(pendingEntries);
        Mockito.when((Object)cashControlWorkflowDocMock.isEnroute()).thenReturn((Object)true);
        Mockito.when((Object)cashControlWorkflowDocMock.isApprovalRequested()).thenReturn((Object)true);
        Set editModes = this.cut.getEditModes((Document)cashControlDocMock);
        Assertions.assertEquals((int)4, (int)editModes.size());
        Assertions.assertTrue((boolean)editModes.contains("amountTotaling"));
        Assertions.assertTrue((boolean)editModes.contains("editPaymentAppDoc"));
        Assertions.assertTrue((boolean)editModes.contains("editPaymentMedium"));
        Assertions.assertTrue((boolean)editModes.contains("editBankCode"));
    }
}

