/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.ar.document.authorization;

import java.util.Map;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.junit.jupiter.api.parallel.Execution;
import org.junit.jupiter.api.parallel.ExecutionMode;
import org.kuali.kfs.kim.api.permission.PermissionService;
import org.kuali.kfs.kns.datadictionary.MaintainableCollectionDefinition;
import org.kuali.kfs.krad.bo.DataObjectAuthorizerBase;
import org.kuali.kfs.module.ar.document.authorization.PredeterminedBillingScheduleMaintenanceDocumentAuthorizer;
import org.mockito.ArgumentMatchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.jupiter.MockitoExtension;

@Execution(value=ExecutionMode.SAME_THREAD)
@ExtendWith(value={MockitoExtension.class})
class PredeterminedBillingScheduleMaintenanceDocumentAuthorizerTest {
    private PredeterminedBillingScheduleMaintenanceDocumentAuthorizer cut;
    @Mock
    private PermissionService permissionSvcMock;

    PredeterminedBillingScheduleMaintenanceDocumentAuthorizerTest() {
    }

    @BeforeEach
    void setUp() {
        this.cut = new PredeterminedBillingScheduleMaintenanceDocumentAuthorizer();
        DataObjectAuthorizerBase.setPermissionService((PermissionService)this.permissionSvcMock);
    }

    @AfterEach
    void tearDown() {
        DataObjectAuthorizerBase.setPermissionService(null);
    }

    @Test
    void conditionallyHideBillCollectionEditing_DoHide() {
        MaintainableCollectionDefinition maintainableCollectionDefinition = new MaintainableCollectionDefinition();
        String wklykinsPrincipalId = "2191506168";
        Mockito.when((Object)this.permissionSvcMock.isAuthorizedByTemplate((String)ArgumentMatchers.eq((Object)"2191506168"), (String)ArgumentMatchers.eq((Object)"KFS-SYS"), (String)ArgumentMatchers.eq((Object)"Add Line"), (Map)ArgumentMatchers.any(), (Map)ArgumentMatchers.any())).thenReturn((Object)false);
        Assertions.assertTrue((boolean)maintainableCollectionDefinition.getIncludeAddLine());
        Assertions.assertTrue((boolean)maintainableCollectionDefinition.isIncludeMultipleLookupLine());
        this.cut.conditionallyHideBillCollectionEditing("2191506168", maintainableCollectionDefinition);
        Assertions.assertFalse((boolean)maintainableCollectionDefinition.getIncludeAddLine());
        Assertions.assertFalse((boolean)maintainableCollectionDefinition.isIncludeMultipleLookupLine());
    }

    @Test
    void conditionallyHideBillCollectionEditing_DoNotHide() {
        MaintainableCollectionDefinition maintainableCollectionDefinition = new MaintainableCollectionDefinition();
        String khuntleyPrincipalId = "6162502038";
        Mockito.when((Object)this.permissionSvcMock.isAuthorizedByTemplate((String)ArgumentMatchers.eq((Object)"6162502038"), (String)ArgumentMatchers.eq((Object)"KFS-SYS"), (String)ArgumentMatchers.eq((Object)"Add Line"), (Map)ArgumentMatchers.any(), (Map)ArgumentMatchers.any())).thenReturn((Object)true);
        Assertions.assertTrue((boolean)maintainableCollectionDefinition.getIncludeAddLine());
        Assertions.assertTrue((boolean)maintainableCollectionDefinition.isIncludeMultipleLookupLine());
        this.cut.conditionallyHideBillCollectionEditing("6162502038", maintainableCollectionDefinition);
        Assertions.assertTrue((boolean)maintainableCollectionDefinition.getIncludeAddLine());
        Assertions.assertTrue((boolean)maintainableCollectionDefinition.isIncludeMultipleLookupLine());
    }
}

