/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.ar.document.service.impl;

import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.kuali.kfs.kew.api.WorkflowDocument;
import org.kuali.kfs.krad.document.Document;
import org.kuali.kfs.krad.service.DocumentService;
import org.kuali.kfs.module.ar.document.CustomerInvoiceDocument;
import org.kuali.kfs.module.ar.document.dataaccess.CustomerInvoiceDocumentDao;
import org.kuali.kfs.module.ar.document.service.impl.CustomerInvoiceDocumentServiceImpl;
import org.kuali.kfs.sys.businessobject.DocumentHeader;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.jupiter.MockitoExtension;

@ExtendWith(value={MockitoExtension.class})
class CustomerInvoiceDocumentServiceImplTest {
    private CustomerInvoiceDocumentServiceImpl cut;
    @Mock
    private CustomerInvoiceDocumentDao customerInvoiceDocumentDaoMock;
    @Mock
    private DocumentService documentSvcMock;

    CustomerInvoiceDocumentServiceImplTest() {
    }

    @BeforeEach
    void setUp() {
        this.cut = new CustomerInvoiceDocumentServiceImpl();
        this.cut.setCustomerInvoiceDocumentDao(this.customerInvoiceDocumentDaoMock);
        this.cut.setDocumentService(this.documentSvcMock);
    }

    @Test
    void checkIfInvoiceNumberIsFinal_BlankInvoiceNumber() {
        Assertions.assertFalse((boolean)this.cut.checkIfInvoiceNumberIsFinal(""));
    }

    @Test
    void checkIfInvoiceNumberIsFinal_BadInvoiceNumber(@Mock(stubOnly=true) CustomerInvoiceDocumentDao customerInvoiceDocumentDaoMock) {
        Assertions.assertFalse((boolean)this.cut.checkIfInvoiceNumberIsFinal("DOES_NOT_EXIST"));
    }

    @Test
    void checkIfInvoiceNumberIsFinal_NullDocument(@Mock(stubOnly=true) CustomerInvoiceDocument customerInvoiceDocumentMock) {
        Mockito.when((Object)this.customerInvoiceDocumentDaoMock.getInvoiceByInvoiceDocumentNumber("1001")).thenReturn((Object)customerInvoiceDocumentMock);
        Mockito.when((Object)this.documentSvcMock.getByDocumentHeaderId("1001")).thenReturn(null);
        Assertions.assertFalse((boolean)this.cut.checkIfInvoiceNumberIsFinal("1001"));
    }

    @Test
    void checkIfInvoiceNumberIsFinal_NullDocumentHeader(@Mock(stubOnly=true) CustomerInvoiceDocument customerInvoiceDocumentMock, @Mock(stubOnly=true) Document documentMock) {
        Mockito.when((Object)this.customerInvoiceDocumentDaoMock.getInvoiceByInvoiceDocumentNumber("1002")).thenReturn((Object)customerInvoiceDocumentMock);
        Mockito.when((Object)this.documentSvcMock.getByDocumentHeaderId("1002")).thenReturn((Object)documentMock);
        Assertions.assertFalse((boolean)this.cut.checkIfInvoiceNumberIsFinal("1002"));
    }

    @Test
    void checkIfInvoiceNumberIsFinal_NullWorkflowDocument(@Mock(stubOnly=true) CustomerInvoiceDocument customerInvoiceDocumentMock, @Mock(stubOnly=true) Document documentMock, @Mock(stubOnly=true) DocumentHeader documentHeaderMock) {
        Mockito.when((Object)this.customerInvoiceDocumentDaoMock.getInvoiceByInvoiceDocumentNumber("1003")).thenReturn((Object)customerInvoiceDocumentMock);
        Mockito.when((Object)documentMock.getDocumentHeader()).thenReturn((Object)documentHeaderMock);
        Mockito.when((Object)this.documentSvcMock.getByDocumentHeaderId("1003")).thenReturn((Object)documentMock);
        Assertions.assertFalse((boolean)this.cut.checkIfInvoiceNumberIsFinal("1003"));
    }

    @Test
    void checkIfInvoiceNumberIsFinal_Enroute(@Mock(stubOnly=true) CustomerInvoiceDocument customerInvoiceDocumentMock, @Mock(stubOnly=true) Document documentMock, @Mock(stubOnly=true) DocumentHeader documentHeaderMock, @Mock(stubOnly=true) WorkflowDocument workflowDocumentMock) {
        Mockito.when((Object)this.customerInvoiceDocumentDaoMock.getInvoiceByInvoiceDocumentNumber("1004")).thenReturn((Object)customerInvoiceDocumentMock);
        Mockito.when((Object)documentHeaderMock.getWorkflowDocument()).thenReturn((Object)workflowDocumentMock);
        Mockito.when((Object)documentMock.getDocumentHeader()).thenReturn((Object)documentHeaderMock);
        Mockito.when((Object)this.documentSvcMock.getByDocumentHeaderId("1004")).thenReturn((Object)documentMock);
        Assertions.assertFalse((boolean)this.cut.checkIfInvoiceNumberIsFinal("1004"));
    }

    @Test
    void checkIfInvoiceNumberIsFinal_Approved(@Mock(stubOnly=true) CustomerInvoiceDocument customerInvoiceDocumentMock, @Mock(stubOnly=true) Document documentMock, @Mock(stubOnly=true) DocumentHeader documentHeaderMock, @Mock(stubOnly=true) WorkflowDocument workflowDocumentMock) {
        Mockito.when((Object)this.customerInvoiceDocumentDaoMock.getInvoiceByInvoiceDocumentNumber("1005")).thenReturn((Object)customerInvoiceDocumentMock);
        Mockito.when((Object)workflowDocumentMock.isApproved()).thenReturn((Object)true);
        Mockito.when((Object)documentHeaderMock.getWorkflowDocument()).thenReturn((Object)workflowDocumentMock);
        Mockito.when((Object)documentMock.getDocumentHeader()).thenReturn((Object)documentHeaderMock);
        Mockito.when((Object)this.documentSvcMock.getByDocumentHeaderId("1005")).thenReturn((Object)documentMock);
        Assertions.assertTrue((boolean)this.cut.checkIfInvoiceNumberIsFinal("1005"));
    }

    @Test
    void checkIfInvoiceNumberIsFinal_Processed(@Mock(stubOnly=true) CustomerInvoiceDocument customerInvoiceDocumentMock, @Mock(stubOnly=true) Document documentMock, @Mock(stubOnly=true) DocumentHeader documentHeaderMock, @Mock(stubOnly=true) WorkflowDocument workflowDocumentMock) {
        Mockito.when((Object)this.customerInvoiceDocumentDaoMock.getInvoiceByInvoiceDocumentNumber("1006")).thenReturn((Object)customerInvoiceDocumentMock);
        Mockito.when((Object)workflowDocumentMock.isProcessed()).thenReturn((Object)true);
        Mockito.when((Object)documentHeaderMock.getWorkflowDocument()).thenReturn((Object)workflowDocumentMock);
        Mockito.when((Object)documentMock.getDocumentHeader()).thenReturn((Object)documentHeaderMock);
        Mockito.when((Object)this.documentSvcMock.getByDocumentHeaderId("1006")).thenReturn((Object)documentMock);
        Assertions.assertTrue((boolean)this.cut.checkIfInvoiceNumberIsFinal("1006"));
    }
}

