/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.ar.document.service.impl;

import java.util.List;
import java.util.Map;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.kuali.kfs.core.api.util.type.KualiDecimal;
import org.kuali.kfs.kew.api.document.WorkflowDocumentService;
import org.kuali.kfs.kew.routeheader.DocumentRouteHeaderValue;
import org.kuali.kfs.krad.service.BusinessObjectService;
import org.kuali.kfs.module.ar.businessobject.InvoicePaidApplied;
import org.kuali.kfs.module.ar.document.CustomerInvoiceDocument;
import org.kuali.kfs.module.ar.document.service.impl.InvoicePaidAppliedServiceImpl;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.jupiter.MockitoExtension;

@ExtendWith(value={MockitoExtension.class})
class InvoicePaidAppliedServiceImplTest {
    private static final String INVOICE_DOC_NUMBER = "1";
    private static final String APP_DOC_NUMBER = "2";
    private static final KualiDecimal AMOUNT_250 = new KualiDecimal(250.0);
    private InvoicePaidAppliedServiceImpl cut;
    @Mock
    private BusinessObjectService businessObjectSvcMock;
    @Mock
    private CustomerInvoiceDocument customerInvoiceDocMock;
    @Mock
    private WorkflowDocumentService workflowDocumentSvcMock;

    InvoicePaidAppliedServiceImplTest() {
    }

    @BeforeEach
    void setUp() {
        this.cut = new InvoicePaidAppliedServiceImpl();
        this.cut.setBusinessObjectService(this.businessObjectSvcMock);
        this.cut.setWorkflowDocumentService(this.workflowDocumentSvcMock);
    }

    @Test
    void filterInvoice_returnsInvoicePaidApplied_notAdjusted_docNotCanceled() {
        InvoicePaidApplied notAdjustedInvoicePaidAppliedMock = (InvoicePaidApplied)Mockito.mock(InvoicePaidApplied.class);
        Mockito.when((Object)notAdjustedInvoicePaidAppliedMock.isAdjusted()).thenReturn((Object)false);
        Mockito.when((Object)notAdjustedInvoicePaidAppliedMock.getDocumentNumber()).thenReturn((Object)INVOICE_DOC_NUMBER);
        DocumentRouteHeaderValue documentRouteHeaderValueMock = (DocumentRouteHeaderValue)Mockito.mock(DocumentRouteHeaderValue.class);
        Mockito.when((Object)this.workflowDocumentSvcMock.getDocument(INVOICE_DOC_NUMBER)).thenReturn((Object)documentRouteHeaderValueMock);
        Assertions.assertEquals(List.of(notAdjustedInvoicePaidAppliedMock), (Object)this.cut.filterInvoicePaidAppliedsToOnlyActive(List.of(notAdjustedInvoicePaidAppliedMock)));
    }

    @Test
    void filterInvoice_doesNotReturnInvoicePaidApplied_notAdjusted_docCanceled() {
        InvoicePaidApplied notAdjustedInvoicePaidAppliedMock = (InvoicePaidApplied)Mockito.mock(InvoicePaidApplied.class);
        Mockito.when((Object)notAdjustedInvoicePaidAppliedMock.isAdjusted()).thenReturn((Object)false);
        Mockito.when((Object)notAdjustedInvoicePaidAppliedMock.getDocumentNumber()).thenReturn((Object)INVOICE_DOC_NUMBER);
        DocumentRouteHeaderValue documentRouteHeaderValueMock = (DocumentRouteHeaderValue)Mockito.mock(DocumentRouteHeaderValue.class);
        Mockito.when((Object)documentRouteHeaderValueMock.isCanceled()).thenReturn((Object)true);
        Mockito.when((Object)this.workflowDocumentSvcMock.getDocument(INVOICE_DOC_NUMBER)).thenReturn((Object)documentRouteHeaderValueMock);
        Assertions.assertTrue((boolean)this.cut.filterInvoicePaidAppliedsToOnlyActive(List.of(notAdjustedInvoicePaidAppliedMock)).isEmpty());
    }

    @Test
    void filterInvoice_doesNotReturnInvoicePaidApplied_isAdjusted() {
        InvoicePaidApplied notAdjustedInvoicePaidApplied = (InvoicePaidApplied)Mockito.mock(InvoicePaidApplied.class);
        Mockito.when((Object)notAdjustedInvoicePaidApplied.isAdjusted()).thenReturn((Object)true);
        Assertions.assertTrue((boolean)this.cut.filterInvoicePaidAppliedsToOnlyActive(List.of(notAdjustedInvoicePaidApplied)).isEmpty());
    }

    @Test
    void doesInvoiceHaveAppliedAmounts_noPaidApplieds_false() {
        Assertions.assertFalse((boolean)this.cut.doesInvoiceHaveAppliedAmounts(this.customerInvoiceDocMock));
    }

    @Test
    void doesInvoiceHaveAppliedAmounts_hasPaidApplieds_onlyDiscount_false() {
        this.setupInvoicePaidAppliedMocking(INVOICE_DOC_NUMBER, false, KualiDecimal.ZERO);
        Mockito.when((Object)this.workflowDocumentSvcMock.getDocument(INVOICE_DOC_NUMBER)).thenReturn((Object)((DocumentRouteHeaderValue)Mockito.mock(DocumentRouteHeaderValue.class)));
        Assertions.assertFalse((boolean)this.cut.doesInvoiceHaveAppliedAmounts(this.customerInvoiceDocMock));
    }

    private void setupInvoicePaidAppliedMocking(String invoicePaidAppliedDocNumber, boolean adjusted, KualiDecimal appliedAmount) {
        InvoicePaidApplied invoicePaidApplied = new InvoicePaidApplied();
        invoicePaidApplied.setDocumentNumber(invoicePaidAppliedDocNumber);
        invoicePaidApplied.setAdjusted(adjusted);
        invoicePaidApplied.setInvoiceItemAppliedAmount(appliedAmount);
        Mockito.when((Object)this.customerInvoiceDocMock.getDocumentNumber()).thenReturn((Object)INVOICE_DOC_NUMBER);
        Mockito.when((Object)this.businessObjectSvcMock.findMatching(InvoicePaidApplied.class, Map.of("financialDocumentReferenceInvoiceNumber", INVOICE_DOC_NUMBER))).thenReturn(List.of(invoicePaidApplied));
    }

    @Test
    void doesInvoiceHaveAppliedAmounts_hasPaidApplieds_adjusted_false() {
        this.setupInvoicePaidAppliedMocking(APP_DOC_NUMBER, true, KualiDecimal.ZERO);
        Assertions.assertFalse((boolean)this.cut.doesInvoiceHaveAppliedAmounts(this.customerInvoiceDocMock));
    }

    @Test
    void doesInvoiceHaveAppliedAmounts_hasPaidApplieds_notAdjusted_zeroAppliedAmount_false() {
        this.setupInvoicePaidAppliedMocking(APP_DOC_NUMBER, false, KualiDecimal.ZERO);
        Mockito.when((Object)this.workflowDocumentSvcMock.getDocument(APP_DOC_NUMBER)).thenReturn((Object)((DocumentRouteHeaderValue)Mockito.mock(DocumentRouteHeaderValue.class)));
        Assertions.assertFalse((boolean)this.cut.doesInvoiceHaveAppliedAmounts(this.customerInvoiceDocMock));
    }

    @Test
    void doesInvoiceHaveAppliedAmounts_hasPaidApplieds_notAdjusted_nonzeroAppliedAmount_true() {
        this.setupInvoicePaidAppliedMocking(APP_DOC_NUMBER, false, AMOUNT_250);
        Mockito.when((Object)this.workflowDocumentSvcMock.getDocument(APP_DOC_NUMBER)).thenReturn((Object)((DocumentRouteHeaderValue)Mockito.mock(DocumentRouteHeaderValue.class)));
        Assertions.assertTrue((boolean)this.cut.doesInvoiceHaveAppliedAmounts(this.customerInvoiceDocMock));
    }
}

