/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.ar.document.validation;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.junit.jupiter.api.parallel.Execution;
import org.junit.jupiter.api.parallel.ExecutionMode;
import org.kuali.kfs.core.api.util.type.KualiDecimal;
import org.kuali.kfs.integration.cg.ContractsAndGrantsBillingAward;
import org.kuali.kfs.integration.cg.ContractsAndGrantsBillingAwardAccount;
import org.kuali.kfs.kns.document.MaintenanceDocument;
import org.kuali.kfs.kns.service.DictionaryValidationService;
import org.kuali.kfs.krad.bo.PersistableBusinessObject;
import org.kuali.kfs.krad.datadictionary.validation.result.DictionaryValidationResult;
import org.kuali.kfs.krad.util.ErrorMessage;
import org.kuali.kfs.krad.util.GlobalVariables;
import org.kuali.kfs.module.ar.ArConstants;
import org.kuali.kfs.module.ar.businessobject.Bill;
import org.kuali.kfs.module.ar.businessobject.PredeterminedBillingSchedule;
import org.kuali.kfs.module.ar.document.service.PredeterminedBillingScheduleMaintenanceService;
import org.kuali.kfs.module.ar.document.validation.PredeterminedBillingScheduleRule;
import org.kuali.kfs.module.ar.service.impl.AccountsReceivableModuleBillingServiceImpl;
import org.mockito.ArgumentMatchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.Spy;
import org.mockito.junit.jupiter.MockitoExtension;
import org.springframework.util.AutoPopulatingList;

@Execution(value=ExecutionMode.SAME_THREAD)
@ExtendWith(value={MockitoExtension.class})
class PredeterminedBillingScheduleRuleTest {
    private static final String PROPOSAL_NUM = "1";
    private static final String CHART_CODE = "BL";
    private static final String ACCT_NUM = "1234567";
    @Spy
    private PredeterminedBillingScheduleRule cutSpy = new PredeterminedBillingScheduleRule();
    @Mock(stubOnly=true)
    private DictionaryValidationService dictionaryValidationSvcMock;
    @Mock(stubOnly=true)
    private PredeterminedBillingSchedule predeterminedBillingScheduleMock;

    PredeterminedBillingScheduleRuleTest() {
    }

    @BeforeEach
    void setUp() {
        GlobalVariables.getMessageMap().getErrorMessages().clear();
        this.cutSpy.newPredeterminedBillingScheduleCopy = this.predeterminedBillingScheduleMock;
        this.cutSpy.setDictionaryValidationService(this.dictionaryValidationSvcMock);
    }

    @AfterEach
    void tearDown() {
        this.cutSpy.setDictionaryValidationService(null);
        GlobalVariables.getMessageMap().getErrorMessages().clear();
    }

    private void setupBillMocks(Bill bill1Mock, Bill bill2Mock) {
        this.setupBill(bill1Mock, 1L, "test*1");
        this.setupBill(bill2Mock, 2L, "test*2");
        ArrayList<Bill> bills = new ArrayList<Bill>();
        bills.add(bill1Mock);
        bills.add(bill2Mock);
        Mockito.when((Object)this.predeterminedBillingScheduleMock.getBills()).thenReturn(bills);
    }

    private void setupBill(Bill billMock, long l, String s) {
        Mockito.when((Object)billMock.getBillIdentifier()).thenReturn((Object)l);
        Mockito.when((Object)billMock.getBillNumber()).thenReturn((Object)s);
        Mockito.when((Object)billMock.getEstimatedAmount()).thenReturn((Object)new KualiDecimal(1000.0));
        Mockito.when((Object)billMock.isActive()).thenReturn((Object)true);
    }

    @Test
    void processCustomAddCollectionLineBusinessRules_Valid(@Mock(stubOnly=true) Bill bill1Mock, @Mock(stubOnly=true) Bill bill2Mock, @Mock(stubOnly=true) Bill newBillMock) {
        Mockito.when((Object)bill1Mock.getBillNumber()).thenReturn((Object)"test*1");
        Mockito.when((Object)bill2Mock.getBillNumber()).thenReturn((Object)"test*2");
        ArrayList<Bill> bills = new ArrayList<Bill>();
        bills.add(bill1Mock);
        bills.add(bill2Mock);
        Mockito.when((Object)this.predeterminedBillingScheduleMock.getBills()).thenReturn(bills);
        Mockito.when((Object)newBillMock.getBillNumber()).thenReturn((Object)"test*3");
        Assertions.assertTrue((boolean)this.cutSpy.processCustomAddCollectionLineBusinessRules(null, "Bills", (PersistableBusinessObject)newBillMock));
        Assertions.assertEquals((int)0, (int)GlobalVariables.getMessageMap().getErrorCount());
    }

    @Test
    void processCustomAddCollectionLineBusinessRules_DuplicateBillNumber(@Mock(stubOnly=true) Bill bill1Mock, @Mock(stubOnly=true) Bill bill2Mock, @Mock(stubOnly=true) Bill newBillMock) {
        Mockito.when((Object)bill1Mock.getBillNumber()).thenReturn((Object)"test*1");
        ArrayList<Bill> bills = new ArrayList<Bill>();
        bills.add(bill1Mock);
        bills.add(bill2Mock);
        Mockito.when((Object)this.predeterminedBillingScheduleMock.getBills()).thenReturn(bills);
        Mockito.when((Object)newBillMock.getBillNumber()).thenReturn((Object)"test*1");
        Assertions.assertFalse((boolean)this.cutSpy.processCustomAddCollectionLineBusinessRules(null, "Bills", (PersistableBusinessObject)newBillMock));
        Assertions.assertEquals((int)1, (int)GlobalVariables.getMessageMap().getErrorCount());
        ErrorMessage errorMessage = (ErrorMessage)((AutoPopulatingList)GlobalVariables.getMessageMap().getErrorMessages().get("document.newMaintainableObject.Bills")).get(0);
        Assertions.assertEquals((Object)"error.duplicate.bill.number", (Object)errorMessage.getErrorKey());
        String[] messageParameters = errorMessage.getMessageParameters();
        Assertions.assertEquals((int)0, (int)messageParameters.length);
    }

    @Test
    void processCustomRouteDocumentBusinessRules_Valid(@Mock(stubOnly=true) Bill bill1Mock, @Mock(stubOnly=true) Bill bill2Mock, @Mock(stubOnly=true) AccountsReceivableModuleBillingServiceImpl accountsReceivableModuleBillingSvcMock, @Mock(stubOnly=true) ContractsAndGrantsBillingAward awardMock, @Mock(stubOnly=true) ContractsAndGrantsBillingAwardAccount awardAccountMock, @Mock(stubOnly=true) MaintenanceDocument predeterminedBillingScheduleMaintDocMock) {
        Mockito.when((Object)awardMock.getProposalNumber()).thenReturn((Object)PROPOSAL_NUM);
        Mockito.when((Object)awardMock.getBillingFrequencyCode()).thenReturn((Object)ArConstants.BillingFrequencyValues.PREDETERMINED_BILLING.getCode());
        Mockito.when((Object)awardMock.getAwardTotalAmount()).thenReturn((Object)new KualiDecimal(50000.0));
        Mockito.when((Object)awardMock.getActiveAwardAccounts()).thenReturn(Collections.singletonList(awardAccountMock));
        Mockito.when((Object)awardAccountMock.getChartOfAccountsCode()).thenReturn((Object)CHART_CODE);
        Mockito.when((Object)awardAccountMock.getAccountNumber()).thenReturn((Object)ACCT_NUM);
        Mockito.when((Object)this.predeterminedBillingScheduleMock.getAward()).thenReturn((Object)awardMock);
        Mockito.when((Object)this.predeterminedBillingScheduleMock.getProposalNumber()).thenReturn((Object)PROPOSAL_NUM);
        Mockito.when((Object)this.predeterminedBillingScheduleMock.getChartOfAccountsCode()).thenReturn((Object)CHART_CODE);
        Mockito.when((Object)this.predeterminedBillingScheduleMock.getAccountNumber()).thenReturn((Object)ACCT_NUM);
        Mockito.when((Object)bill1Mock.getBillNumber()).thenReturn((Object)"test*1");
        Mockito.when((Object)bill1Mock.getEstimatedAmount()).thenReturn((Object)new KualiDecimal(1000.0));
        Mockito.when((Object)bill1Mock.isActive()).thenReturn((Object)true);
        Mockito.when((Object)bill2Mock.getBillNumber()).thenReturn((Object)"test*2");
        Mockito.when((Object)bill2Mock.getEstimatedAmount()).thenReturn((Object)new KualiDecimal(1000.0));
        Mockito.when((Object)bill2Mock.isActive()).thenReturn((Object)true);
        ArrayList<Bill> bills = new ArrayList<Bill>();
        bills.add(bill1Mock);
        bills.add(bill2Mock);
        Mockito.when((Object)this.predeterminedBillingScheduleMock.getBills()).thenReturn(bills);
        Mockito.when((Object)accountsReceivableModuleBillingSvcMock.getBillsTotalAmountForOtherSchedules(PROPOSAL_NUM, CHART_CODE, ACCT_NUM)).thenReturn((Object)new KualiDecimal(48000.0));
        ((PredeterminedBillingScheduleRule)Mockito.doReturn((Object)accountsReceivableModuleBillingSvcMock).when((Object)this.cutSpy)).getAccountsReceivableModuleBillingService();
        Mockito.when((Object)this.dictionaryValidationSvcMock.validate(ArgumentMatchers.any(Bill.class))).thenReturn((Object)new DictionaryValidationResult());
        Assertions.assertTrue((boolean)this.cutSpy.processCustomRouteDocumentBusinessRules(predeterminedBillingScheduleMaintDocMock));
        Assertions.assertEquals((int)0, (int)GlobalVariables.getMessageMap().getErrorCount());
    }

    @Test
    void processCustomRouteDocumentBusinessRules_BillingFrequencyNoPredeterminedBilling(@Mock(stubOnly=true) Bill bill1Mock, @Mock(stubOnly=true) Bill bill2Mock, @Mock(stubOnly=true) AccountsReceivableModuleBillingServiceImpl accountsReceivableModuleBillingSvcMock, @Mock(stubOnly=true) ContractsAndGrantsBillingAward awardMock, @Mock(stubOnly=true) ContractsAndGrantsBillingAwardAccount awardAccountMock, @Mock(stubOnly=true) MaintenanceDocument predeterminedBillingScheduleMaintDocMock) {
        Mockito.when((Object)awardMock.getProposalNumber()).thenReturn((Object)PROPOSAL_NUM);
        Mockito.when((Object)awardMock.getBillingFrequencyCode()).thenReturn((Object)ArConstants.BillingFrequencyValues.PREDETERMINED_BILLING.getCode());
        Mockito.when((Object)awardMock.getAwardTotalAmount()).thenReturn((Object)new KualiDecimal(50000.0));
        Mockito.when((Object)awardMock.getActiveAwardAccounts()).thenReturn(Collections.singletonList(awardAccountMock));
        Mockito.when((Object)awardAccountMock.getChartOfAccountsCode()).thenReturn((Object)CHART_CODE);
        Mockito.when((Object)awardAccountMock.getAccountNumber()).thenReturn((Object)ACCT_NUM);
        Mockito.when((Object)this.predeterminedBillingScheduleMock.getAward()).thenReturn((Object)awardMock);
        Mockito.when((Object)this.predeterminedBillingScheduleMock.getProposalNumber()).thenReturn((Object)PROPOSAL_NUM);
        Mockito.when((Object)this.predeterminedBillingScheduleMock.getChartOfAccountsCode()).thenReturn((Object)CHART_CODE);
        Mockito.when((Object)this.predeterminedBillingScheduleMock.getAccountNumber()).thenReturn((Object)ACCT_NUM);
        Mockito.when((Object)bill1Mock.getBillNumber()).thenReturn((Object)"test*1");
        Mockito.when((Object)bill1Mock.getEstimatedAmount()).thenReturn((Object)new KualiDecimal(1000.0));
        Mockito.when((Object)bill1Mock.isActive()).thenReturn((Object)true);
        Mockito.when((Object)bill2Mock.getBillNumber()).thenReturn((Object)"test*2");
        Mockito.when((Object)bill2Mock.getEstimatedAmount()).thenReturn((Object)new KualiDecimal(1000.0));
        Mockito.when((Object)bill2Mock.isActive()).thenReturn((Object)true);
        ArrayList<Bill> bills = new ArrayList<Bill>();
        bills.add(bill1Mock);
        bills.add(bill2Mock);
        Mockito.when((Object)this.predeterminedBillingScheduleMock.getBills()).thenReturn(bills);
        Mockito.when((Object)accountsReceivableModuleBillingSvcMock.getBillsTotalAmountForOtherSchedules(PROPOSAL_NUM, CHART_CODE, ACCT_NUM)).thenReturn((Object)new KualiDecimal(48000.0));
        ((PredeterminedBillingScheduleRule)Mockito.doReturn((Object)accountsReceivableModuleBillingSvcMock).when((Object)this.cutSpy)).getAccountsReceivableModuleBillingService();
        Mockito.when((Object)this.dictionaryValidationSvcMock.validate(ArgumentMatchers.any(Bill.class))).thenReturn((Object)new DictionaryValidationResult());
        Mockito.when((Object)awardMock.getBillingFrequencyCode()).thenReturn((Object)ArConstants.BillingFrequencyValues.MILESTONE.getCode());
        Assertions.assertFalse((boolean)this.cutSpy.processCustomRouteDocumentBusinessRules(predeterminedBillingScheduleMaintDocMock));
        Assertions.assertEquals((int)1, (int)GlobalVariables.getMessageMap().getErrorCount());
        ErrorMessage errorMessage = (ErrorMessage)((AutoPopulatingList)GlobalVariables.getMessageMap().getErrorMessages().get("document.newMaintainableObject.proposalNumberForAwardAccountLookup")).get(0);
        Assertions.assertEquals((Object)"error.cg.award.predetermined.billing.schedule.incorrect.billing.frequency", (Object)errorMessage.getErrorKey());
        String[] messageParameters = errorMessage.getMessageParameters();
        Assertions.assertEquals((int)1, (int)messageParameters.length);
        Assertions.assertEquals((Object)PROPOSAL_NUM, (Object)messageParameters[0]);
    }

    @Test
    void processCustomRouteDocumentBusinessRules_DuplicateMilestoneNumbers_OneCopiedToInvoice(@Mock(stubOnly=true) Bill bill1Mock, @Mock(stubOnly=true) Bill bill2Mock, @Mock(stubOnly=true) AccountsReceivableModuleBillingServiceImpl accountsReceivableModuleBillingSvcMock, @Mock(stubOnly=true) ContractsAndGrantsBillingAward awardMock, @Mock(stubOnly=true) ContractsAndGrantsBillingAwardAccount awardAccountMock, @Mock(stubOnly=true) MaintenanceDocument predeterminedBillingScheduleMaintDocMock, @Mock(stubOnly=true) PredeterminedBillingScheduleMaintenanceService predeterminedBillingScheduleMaintenanceSvdMock) {
        Mockito.when((Object)awardMock.getProposalNumber()).thenReturn((Object)PROPOSAL_NUM);
        Mockito.when((Object)awardMock.getBillingFrequencyCode()).thenReturn((Object)ArConstants.BillingFrequencyValues.PREDETERMINED_BILLING.getCode());
        Mockito.when((Object)awardMock.getAwardTotalAmount()).thenReturn((Object)new KualiDecimal(50000.0));
        Mockito.when((Object)awardMock.getActiveAwardAccounts()).thenReturn(Collections.singletonList(awardAccountMock));
        Mockito.when((Object)awardAccountMock.getChartOfAccountsCode()).thenReturn((Object)CHART_CODE);
        Mockito.when((Object)awardAccountMock.getAccountNumber()).thenReturn((Object)ACCT_NUM);
        Mockito.when((Object)this.predeterminedBillingScheduleMock.getAward()).thenReturn((Object)awardMock);
        Mockito.when((Object)this.predeterminedBillingScheduleMock.getProposalNumber()).thenReturn((Object)PROPOSAL_NUM);
        Mockito.when((Object)this.predeterminedBillingScheduleMock.getChartOfAccountsCode()).thenReturn((Object)CHART_CODE);
        Mockito.when((Object)this.predeterminedBillingScheduleMock.getAccountNumber()).thenReturn((Object)ACCT_NUM);
        this.setupBillMocks(bill1Mock, bill2Mock);
        Mockito.when((Object)accountsReceivableModuleBillingSvcMock.getBillsTotalAmountForOtherSchedules(PROPOSAL_NUM, CHART_CODE, ACCT_NUM)).thenReturn((Object)new KualiDecimal(48000.0));
        ((PredeterminedBillingScheduleRule)Mockito.doReturn((Object)accountsReceivableModuleBillingSvcMock).when((Object)this.cutSpy)).getAccountsReceivableModuleBillingService();
        ((PredeterminedBillingScheduleRule)Mockito.doReturn((Object)predeterminedBillingScheduleMaintenanceSvdMock).when((Object)this.cutSpy)).getPredeterminedBillingScheduleMaintenanceService();
        Mockito.when((Object)this.dictionaryValidationSvcMock.validate(ArgumentMatchers.any(Bill.class))).thenReturn((Object)new DictionaryValidationResult());
        Mockito.when((Object)bill2Mock.getBillNumber()).thenReturn((Object)"test*1");
        Assertions.assertFalse((boolean)this.cutSpy.processCustomRouteDocumentBusinessRules(predeterminedBillingScheduleMaintDocMock));
        Assertions.assertEquals((int)2, (int)GlobalVariables.getMessageMap().getErrorCount());
        String errorPath = "bills[1].billNumber";
        ErrorMessage errorMessage = (ErrorMessage)((AutoPopulatingList)GlobalVariables.getMessageMap().getErrorMessages().get("document.newMaintainableObject.bills[1].billNumber")).get(0);
        Assertions.assertEquals((Object)"error.duplicate.bill.number", (Object)errorMessage.getErrorKey());
    }

    @Test
    void processCustomRouteDocumentBusinessRules_DuplicateMilestoneNumbers_NoneCopiedToInvoice(@Mock(stubOnly=true) Bill bill1Mock, @Mock(stubOnly=true) Bill bill2Mock, @Mock(stubOnly=true) AccountsReceivableModuleBillingServiceImpl accountsReceivableModuleBillingSvcMock, @Mock(stubOnly=true) ContractsAndGrantsBillingAward awardMock, @Mock(stubOnly=true) ContractsAndGrantsBillingAwardAccount awardAccountMock, @Mock(stubOnly=true) MaintenanceDocument predeterminedBillingScheduleMaintDocMock, @Mock(stubOnly=true) PredeterminedBillingScheduleMaintenanceService predeterminedBillingScheduleMaintenanceSvdMock) {
        Mockito.when((Object)awardMock.getProposalNumber()).thenReturn((Object)PROPOSAL_NUM);
        Mockito.when((Object)awardMock.getBillingFrequencyCode()).thenReturn((Object)ArConstants.BillingFrequencyValues.PREDETERMINED_BILLING.getCode());
        Mockito.when((Object)awardMock.getAwardTotalAmount()).thenReturn((Object)new KualiDecimal(50000.0));
        Mockito.when((Object)awardMock.getActiveAwardAccounts()).thenReturn(Collections.singletonList(awardAccountMock));
        Mockito.when((Object)awardAccountMock.getChartOfAccountsCode()).thenReturn((Object)CHART_CODE);
        Mockito.when((Object)awardAccountMock.getAccountNumber()).thenReturn((Object)ACCT_NUM);
        Mockito.when((Object)this.predeterminedBillingScheduleMock.getAward()).thenReturn((Object)awardMock);
        Mockito.when((Object)this.predeterminedBillingScheduleMock.getProposalNumber()).thenReturn((Object)PROPOSAL_NUM);
        Mockito.when((Object)this.predeterminedBillingScheduleMock.getChartOfAccountsCode()).thenReturn((Object)CHART_CODE);
        Mockito.when((Object)this.predeterminedBillingScheduleMock.getAccountNumber()).thenReturn((Object)ACCT_NUM);
        this.setupBillMocks(bill1Mock, bill2Mock);
        Mockito.when((Object)accountsReceivableModuleBillingSvcMock.getBillsTotalAmountForOtherSchedules(PROPOSAL_NUM, CHART_CODE, ACCT_NUM)).thenReturn((Object)new KualiDecimal(48000.0));
        ((PredeterminedBillingScheduleRule)Mockito.doReturn((Object)accountsReceivableModuleBillingSvcMock).when((Object)this.cutSpy)).getAccountsReceivableModuleBillingService();
        ((PredeterminedBillingScheduleRule)Mockito.doReturn((Object)predeterminedBillingScheduleMaintenanceSvdMock).when((Object)this.cutSpy)).getPredeterminedBillingScheduleMaintenanceService();
        Mockito.when((Object)this.dictionaryValidationSvcMock.validate(ArgumentMatchers.any(Bill.class))).thenReturn((Object)new DictionaryValidationResult());
        Mockito.when((Object)bill2Mock.getBillNumber()).thenReturn((Object)"test*1");
        Assertions.assertFalse((boolean)this.cutSpy.processCustomRouteDocumentBusinessRules(predeterminedBillingScheduleMaintDocMock));
        Assertions.assertEquals((int)2, (int)GlobalVariables.getMessageMap().getErrorCount());
        String errorPath = "bills[0].billNumber";
        ErrorMessage errorMessage = (ErrorMessage)((AutoPopulatingList)GlobalVariables.getMessageMap().getErrorMessages().get("document.newMaintainableObject." + errorPath)).get(0);
        Assertions.assertEquals((Object)"error.duplicate.bill.number", (Object)errorMessage.getErrorKey());
        errorPath = "bills[1].billNumber";
        errorMessage = (ErrorMessage)((AutoPopulatingList)GlobalVariables.getMessageMap().getErrorMessages().get("document.newMaintainableObject." + errorPath)).get(0);
        Assertions.assertEquals((Object)"error.duplicate.bill.number", (Object)errorMessage.getErrorKey());
    }

    @Test
    void processCustomRouteDocumentBusinessRules_MilestoneAmountGreaterThanAwardAmount_CurrentSchedule(@Mock(stubOnly=true) Bill bill1Mock, @Mock(stubOnly=true) Bill bill2Mock, @Mock(stubOnly=true) AccountsReceivableModuleBillingServiceImpl accountsReceivableModuleBillingSvcMock, @Mock(stubOnly=true) ContractsAndGrantsBillingAward awardMock, @Mock(stubOnly=true) ContractsAndGrantsBillingAwardAccount awardAccountMock, @Mock(stubOnly=true) MaintenanceDocument predeterminedBillingScheduleMaintDocMock) {
        Mockito.when((Object)awardMock.getProposalNumber()).thenReturn((Object)PROPOSAL_NUM);
        Mockito.when((Object)awardMock.getBillingFrequencyCode()).thenReturn((Object)ArConstants.BillingFrequencyValues.PREDETERMINED_BILLING.getCode());
        Mockito.when((Object)awardMock.getAwardTotalAmount()).thenReturn((Object)new KualiDecimal(50000.0));
        Mockito.when((Object)awardMock.getActiveAwardAccounts()).thenReturn(Collections.singletonList(awardAccountMock));
        Mockito.when((Object)awardAccountMock.getChartOfAccountsCode()).thenReturn((Object)CHART_CODE);
        Mockito.when((Object)awardAccountMock.getAccountNumber()).thenReturn((Object)ACCT_NUM);
        Mockito.when((Object)this.predeterminedBillingScheduleMock.getAward()).thenReturn((Object)awardMock);
        Mockito.when((Object)this.predeterminedBillingScheduleMock.getProposalNumber()).thenReturn((Object)PROPOSAL_NUM);
        Mockito.when((Object)this.predeterminedBillingScheduleMock.getChartOfAccountsCode()).thenReturn((Object)CHART_CODE);
        Mockito.when((Object)this.predeterminedBillingScheduleMock.getAccountNumber()).thenReturn((Object)ACCT_NUM);
        Mockito.when((Object)bill1Mock.getBillNumber()).thenReturn((Object)"test*1");
        Mockito.when((Object)bill1Mock.getEstimatedAmount()).thenReturn((Object)new KualiDecimal(1000.0));
        Mockito.when((Object)bill1Mock.isActive()).thenReturn((Object)true);
        Mockito.when((Object)bill2Mock.getBillNumber()).thenReturn((Object)"test*2");
        Mockito.when((Object)bill2Mock.getEstimatedAmount()).thenReturn((Object)new KualiDecimal(1000.0));
        Mockito.when((Object)bill2Mock.isActive()).thenReturn((Object)true);
        ArrayList<Bill> bills = new ArrayList<Bill>();
        bills.add(bill1Mock);
        bills.add(bill2Mock);
        Mockito.when((Object)this.predeterminedBillingScheduleMock.getBills()).thenReturn(bills);
        Mockito.when((Object)accountsReceivableModuleBillingSvcMock.getBillsTotalAmountForOtherSchedules(PROPOSAL_NUM, CHART_CODE, ACCT_NUM)).thenReturn((Object)new KualiDecimal(48000.0));
        ((PredeterminedBillingScheduleRule)Mockito.doReturn((Object)accountsReceivableModuleBillingSvcMock).when((Object)this.cutSpy)).getAccountsReceivableModuleBillingService();
        Mockito.when((Object)this.dictionaryValidationSvcMock.validate(ArgumentMatchers.any(Bill.class))).thenReturn((Object)new DictionaryValidationResult());
        Mockito.when((Object)accountsReceivableModuleBillingSvcMock.getBillsTotalAmountForOtherSchedules(PROPOSAL_NUM, CHART_CODE, ACCT_NUM)).thenReturn((Object)new KualiDecimal(1000.0));
        Mockito.when((Object)bill1Mock.getEstimatedAmount()).thenReturn((Object)new KualiDecimal(50000.0));
        Assertions.assertFalse((boolean)this.cutSpy.processCustomRouteDocumentBusinessRules(predeterminedBillingScheduleMaintDocMock));
        Assertions.assertEquals((int)1, (int)GlobalVariables.getMessageMap().getErrorCount());
        List errorMessages = (List)GlobalVariables.getMessageMap().getErrorMessages().get("document.newMaintainableObject.totalScheduledAccount");
        Assertions.assertNotNull((Object)errorMessages);
        Assertions.assertEquals((int)1, (int)errorMessages.size());
        ErrorMessage errorMessage = (ErrorMessage)errorMessages.get(0);
        Assertions.assertEquals((Object)"error.bill.total.exceeds.award.total", (Object)errorMessage.getErrorKey());
    }

    @Test
    void processCustomRouteDocumentBusinessRules_BillInactiveLargeAmount_CurrentSchedule(@Mock(stubOnly=true) Bill bill1Mock, @Mock(stubOnly=true) Bill bill2Mock, @Mock(stubOnly=true) AccountsReceivableModuleBillingServiceImpl accountsReceivableModuleBillingSvcMock, @Mock(stubOnly=true) ContractsAndGrantsBillingAward awardMock, @Mock(stubOnly=true) ContractsAndGrantsBillingAwardAccount awardAccountMock, @Mock(stubOnly=true) MaintenanceDocument predeterminedBillingScheduleMaintDocMock) {
        Mockito.when((Object)awardMock.getProposalNumber()).thenReturn((Object)PROPOSAL_NUM);
        Mockito.when((Object)awardMock.getBillingFrequencyCode()).thenReturn((Object)ArConstants.BillingFrequencyValues.PREDETERMINED_BILLING.getCode());
        Mockito.when((Object)awardMock.getAwardTotalAmount()).thenReturn((Object)new KualiDecimal(50000.0));
        Mockito.when((Object)awardMock.getActiveAwardAccounts()).thenReturn(Collections.singletonList(awardAccountMock));
        Mockito.when((Object)awardAccountMock.getChartOfAccountsCode()).thenReturn((Object)CHART_CODE);
        Mockito.when((Object)awardAccountMock.getAccountNumber()).thenReturn((Object)ACCT_NUM);
        Mockito.when((Object)this.predeterminedBillingScheduleMock.getAward()).thenReturn((Object)awardMock);
        Mockito.when((Object)this.predeterminedBillingScheduleMock.getProposalNumber()).thenReturn((Object)PROPOSAL_NUM);
        Mockito.when((Object)this.predeterminedBillingScheduleMock.getChartOfAccountsCode()).thenReturn((Object)CHART_CODE);
        Mockito.when((Object)this.predeterminedBillingScheduleMock.getAccountNumber()).thenReturn((Object)ACCT_NUM);
        Mockito.when((Object)bill1Mock.getBillNumber()).thenReturn((Object)"test*1");
        Mockito.when((Object)bill1Mock.isActive()).thenReturn((Object)true);
        Mockito.when((Object)bill2Mock.getBillNumber()).thenReturn((Object)"test*2");
        Mockito.when((Object)bill2Mock.getEstimatedAmount()).thenReturn((Object)new KualiDecimal(1000.0));
        Mockito.when((Object)bill2Mock.isActive()).thenReturn((Object)true);
        ArrayList<Bill> bills = new ArrayList<Bill>();
        bills.add(bill1Mock);
        bills.add(bill2Mock);
        Mockito.when((Object)this.predeterminedBillingScheduleMock.getBills()).thenReturn(bills);
        Mockito.when((Object)accountsReceivableModuleBillingSvcMock.getBillsTotalAmountForOtherSchedules(PROPOSAL_NUM, CHART_CODE, ACCT_NUM)).thenReturn((Object)new KualiDecimal(48000.0));
        ((PredeterminedBillingScheduleRule)Mockito.doReturn((Object)accountsReceivableModuleBillingSvcMock).when((Object)this.cutSpy)).getAccountsReceivableModuleBillingService();
        Mockito.when((Object)this.dictionaryValidationSvcMock.validate(ArgumentMatchers.any(Bill.class))).thenReturn((Object)new DictionaryValidationResult());
        Mockito.when((Object)accountsReceivableModuleBillingSvcMock.getBillsTotalAmountForOtherSchedules(PROPOSAL_NUM, CHART_CODE, ACCT_NUM)).thenReturn((Object)new KualiDecimal(1000.0));
        Mockito.when((Object)bill1Mock.isActive()).thenReturn((Object)false);
        Assertions.assertTrue((boolean)this.cutSpy.processCustomRouteDocumentBusinessRules(predeterminedBillingScheduleMaintDocMock));
        Assertions.assertEquals((int)0, (int)GlobalVariables.getMessageMap().getErrorCount());
    }

    @Test
    void processCustomRouteDocumentBusinessRules_MilestoneAmountGreaterThanAwardAmount_AllSchedules(@Mock(stubOnly=true) Bill bill1Mock, @Mock(stubOnly=true) Bill bill2Mock, @Mock(stubOnly=true) AccountsReceivableModuleBillingServiceImpl accountsReceivableModuleBillingSvcMock, @Mock(stubOnly=true) ContractsAndGrantsBillingAward awardMock, @Mock(stubOnly=true) ContractsAndGrantsBillingAwardAccount awardAccountMock, @Mock(stubOnly=true) MaintenanceDocument predeterminedBillingScheduleMaintDocMock) {
        Mockito.when((Object)awardMock.getProposalNumber()).thenReturn((Object)PROPOSAL_NUM);
        Mockito.when((Object)awardMock.getBillingFrequencyCode()).thenReturn((Object)ArConstants.BillingFrequencyValues.PREDETERMINED_BILLING.getCode());
        Mockito.when((Object)awardMock.getAwardTotalAmount()).thenReturn((Object)new KualiDecimal(50000.0));
        Mockito.when((Object)awardMock.getActiveAwardAccounts()).thenReturn(Collections.singletonList(awardAccountMock));
        Mockito.when((Object)awardAccountMock.getChartOfAccountsCode()).thenReturn((Object)CHART_CODE);
        Mockito.when((Object)awardAccountMock.getAccountNumber()).thenReturn((Object)ACCT_NUM);
        Mockito.when((Object)this.predeterminedBillingScheduleMock.getAward()).thenReturn((Object)awardMock);
        Mockito.when((Object)this.predeterminedBillingScheduleMock.getProposalNumber()).thenReturn((Object)PROPOSAL_NUM);
        Mockito.when((Object)this.predeterminedBillingScheduleMock.getChartOfAccountsCode()).thenReturn((Object)CHART_CODE);
        Mockito.when((Object)this.predeterminedBillingScheduleMock.getAccountNumber()).thenReturn((Object)ACCT_NUM);
        Mockito.when((Object)bill1Mock.getBillNumber()).thenReturn((Object)"test*1");
        Mockito.when((Object)bill1Mock.getEstimatedAmount()).thenReturn((Object)new KualiDecimal(1000.0));
        Mockito.when((Object)bill1Mock.isActive()).thenReturn((Object)true);
        Mockito.when((Object)bill2Mock.getBillNumber()).thenReturn((Object)"test*2");
        Mockito.when((Object)bill2Mock.getEstimatedAmount()).thenReturn((Object)new KualiDecimal(1000.0));
        Mockito.when((Object)bill2Mock.isActive()).thenReturn((Object)true);
        ArrayList<Bill> bills = new ArrayList<Bill>();
        bills.add(bill1Mock);
        bills.add(bill2Mock);
        Mockito.when((Object)this.predeterminedBillingScheduleMock.getBills()).thenReturn(bills);
        Mockito.when((Object)accountsReceivableModuleBillingSvcMock.getBillsTotalAmountForOtherSchedules(PROPOSAL_NUM, CHART_CODE, ACCT_NUM)).thenReturn((Object)new KualiDecimal(48000.0));
        ((PredeterminedBillingScheduleRule)Mockito.doReturn((Object)accountsReceivableModuleBillingSvcMock).when((Object)this.cutSpy)).getAccountsReceivableModuleBillingService();
        Mockito.when((Object)this.dictionaryValidationSvcMock.validate(ArgumentMatchers.any(Bill.class))).thenReturn((Object)new DictionaryValidationResult());
        Mockito.when((Object)bill1Mock.getEstimatedAmount()).thenReturn((Object)new KualiDecimal(5000.0));
        Assertions.assertFalse((boolean)this.cutSpy.processCustomRouteDocumentBusinessRules(predeterminedBillingScheduleMaintDocMock));
        Assertions.assertEquals((int)1, (int)GlobalVariables.getMessageMap().getErrorCount());
        List errorMessages = (List)GlobalVariables.getMessageMap().getErrorMessages().get("document.newMaintainableObject.totalScheduledAccount");
        Assertions.assertNotNull((Object)errorMessages);
        Assertions.assertEquals((int)1, (int)errorMessages.size());
        ErrorMessage errorMessage = (ErrorMessage)errorMessages.get(0);
        Assertions.assertEquals((Object)"error.bill.total.exceeds.award.total", (Object)errorMessage.getErrorKey());
    }

    @Test
    void processCustomRouteDocumentBusinessRules_BillInactiveLargeAmount_AllSchedules(@Mock(stubOnly=true) Bill bill1Mock, @Mock(stubOnly=true) Bill bill2Mock, @Mock(stubOnly=true) AccountsReceivableModuleBillingServiceImpl accountsReceivableModuleBillingSvcMock, @Mock(stubOnly=true) ContractsAndGrantsBillingAward awardMock, @Mock(stubOnly=true) ContractsAndGrantsBillingAwardAccount awardAccountMock, @Mock(stubOnly=true) MaintenanceDocument predeterminedBillingScheduleMaintDocMock) {
        Mockito.when((Object)awardMock.getProposalNumber()).thenReturn((Object)PROPOSAL_NUM);
        Mockito.when((Object)awardMock.getBillingFrequencyCode()).thenReturn((Object)ArConstants.BillingFrequencyValues.PREDETERMINED_BILLING.getCode());
        Mockito.when((Object)awardMock.getAwardTotalAmount()).thenReturn((Object)new KualiDecimal(50000.0));
        Mockito.when((Object)awardMock.getActiveAwardAccounts()).thenReturn(Collections.singletonList(awardAccountMock));
        Mockito.when((Object)awardAccountMock.getChartOfAccountsCode()).thenReturn((Object)CHART_CODE);
        Mockito.when((Object)awardAccountMock.getAccountNumber()).thenReturn((Object)ACCT_NUM);
        Mockito.when((Object)this.predeterminedBillingScheduleMock.getAward()).thenReturn((Object)awardMock);
        Mockito.when((Object)this.predeterminedBillingScheduleMock.getProposalNumber()).thenReturn((Object)PROPOSAL_NUM);
        Mockito.when((Object)this.predeterminedBillingScheduleMock.getChartOfAccountsCode()).thenReturn((Object)CHART_CODE);
        Mockito.when((Object)this.predeterminedBillingScheduleMock.getAccountNumber()).thenReturn((Object)ACCT_NUM);
        Mockito.when((Object)bill1Mock.getBillNumber()).thenReturn((Object)"test*1");
        Mockito.when((Object)bill1Mock.isActive()).thenReturn((Object)true);
        Mockito.when((Object)bill2Mock.getBillNumber()).thenReturn((Object)"test*2");
        Mockito.when((Object)bill2Mock.getEstimatedAmount()).thenReturn((Object)new KualiDecimal(1000.0));
        Mockito.when((Object)bill2Mock.isActive()).thenReturn((Object)true);
        ArrayList<Bill> bills = new ArrayList<Bill>();
        bills.add(bill1Mock);
        bills.add(bill2Mock);
        Mockito.when((Object)this.predeterminedBillingScheduleMock.getBills()).thenReturn(bills);
        Mockito.when((Object)accountsReceivableModuleBillingSvcMock.getBillsTotalAmountForOtherSchedules(PROPOSAL_NUM, CHART_CODE, ACCT_NUM)).thenReturn((Object)new KualiDecimal(48000.0));
        ((PredeterminedBillingScheduleRule)Mockito.doReturn((Object)accountsReceivableModuleBillingSvcMock).when((Object)this.cutSpy)).getAccountsReceivableModuleBillingService();
        Mockito.when((Object)this.dictionaryValidationSvcMock.validate(ArgumentMatchers.any(Bill.class))).thenReturn((Object)new DictionaryValidationResult());
        Mockito.when((Object)bill1Mock.isActive()).thenReturn((Object)false);
        Assertions.assertTrue((boolean)this.cutSpy.processCustomRouteDocumentBusinessRules(predeterminedBillingScheduleMaintDocMock));
        Assertions.assertEquals((int)0, (int)GlobalVariables.getMessageMap().getErrorCount());
    }

    @Test
    void processCustomRouteDocumentBusinessRules_billMissingEstimatedAmount_noGlobalErrors(@Mock(stubOnly=true) Bill bill1Mock, @Mock(stubOnly=true) Bill bill2Mock, @Mock(stubOnly=true) AccountsReceivableModuleBillingServiceImpl accountsReceivableModuleBillingSvcMock, @Mock(stubOnly=true) ContractsAndGrantsBillingAward awardMock, @Mock(stubOnly=true) ContractsAndGrantsBillingAwardAccount awardAccountMock, @Mock(stubOnly=true) MaintenanceDocument predeterminedBillingScheduleMaintDocMock) {
        Mockito.when((Object)awardMock.getProposalNumber()).thenReturn((Object)PROPOSAL_NUM);
        Mockito.when((Object)awardMock.getBillingFrequencyCode()).thenReturn((Object)ArConstants.BillingFrequencyValues.PREDETERMINED_BILLING.getCode());
        Mockito.when((Object)awardMock.getAwardTotalAmount()).thenReturn((Object)new KualiDecimal(50000.0));
        Mockito.when((Object)awardMock.getActiveAwardAccounts()).thenReturn(Collections.singletonList(awardAccountMock));
        Mockito.when((Object)awardAccountMock.getChartOfAccountsCode()).thenReturn((Object)CHART_CODE);
        Mockito.when((Object)awardAccountMock.getAccountNumber()).thenReturn((Object)ACCT_NUM);
        Mockito.when((Object)this.predeterminedBillingScheduleMock.getAward()).thenReturn((Object)awardMock);
        Mockito.when((Object)this.predeterminedBillingScheduleMock.getProposalNumber()).thenReturn((Object)PROPOSAL_NUM);
        Mockito.when((Object)this.predeterminedBillingScheduleMock.getChartOfAccountsCode()).thenReturn((Object)CHART_CODE);
        Mockito.when((Object)this.predeterminedBillingScheduleMock.getAccountNumber()).thenReturn((Object)ACCT_NUM);
        Mockito.when((Object)bill1Mock.getBillNumber()).thenReturn((Object)"test*1");
        Mockito.when((Object)bill1Mock.getEstimatedAmount()).thenReturn((Object)new KualiDecimal(1000.0));
        Mockito.when((Object)bill1Mock.isActive()).thenReturn((Object)true);
        Mockito.when((Object)bill2Mock.getBillNumber()).thenReturn((Object)"test*2");
        Mockito.when((Object)bill2Mock.getEstimatedAmount()).thenReturn((Object)new KualiDecimal(1000.0));
        Mockito.when((Object)bill2Mock.isActive()).thenReturn((Object)true);
        ArrayList<Bill> bills = new ArrayList<Bill>();
        bills.add(bill1Mock);
        bills.add(bill2Mock);
        Mockito.when((Object)this.predeterminedBillingScheduleMock.getBills()).thenReturn(bills);
        Mockito.when((Object)accountsReceivableModuleBillingSvcMock.getBillsTotalAmountForOtherSchedules(PROPOSAL_NUM, CHART_CODE, ACCT_NUM)).thenReturn((Object)new KualiDecimal(48000.0));
        ((PredeterminedBillingScheduleRule)Mockito.doReturn((Object)accountsReceivableModuleBillingSvcMock).when((Object)this.cutSpy)).getAccountsReceivableModuleBillingService();
        Mockito.when((Object)this.dictionaryValidationSvcMock.validate(ArgumentMatchers.any(Bill.class))).thenReturn((Object)new DictionaryValidationResult());
        Mockito.when((Object)bill1Mock.getEstimatedAmount()).thenReturn(null);
        Assertions.assertTrue((boolean)this.cutSpy.processCustomRouteDocumentBusinessRules(predeterminedBillingScheduleMaintDocMock));
        Assertions.assertEquals((int)0, (int)GlobalVariables.getMessageMap().getErrorCount());
    }

    @Test
    void processCustomRouteDocumentBusinessRules_ChartAccountDoesNotExistOnAward(@Mock(stubOnly=true) Bill bill1Mock, @Mock(stubOnly=true) Bill bill2Mock, @Mock(stubOnly=true) AccountsReceivableModuleBillingServiceImpl accountsReceivableModuleBillingSvcMock, @Mock(stubOnly=true) ContractsAndGrantsBillingAward awardMock, @Mock(stubOnly=true) ContractsAndGrantsBillingAwardAccount awardAccountMock, @Mock(stubOnly=true) MaintenanceDocument predeterminedBillingScheduleMaintDocMock) {
        Mockito.when((Object)awardMock.getProposalNumber()).thenReturn((Object)PROPOSAL_NUM);
        Mockito.when((Object)awardMock.getBillingFrequencyCode()).thenReturn((Object)ArConstants.BillingFrequencyValues.PREDETERMINED_BILLING.getCode());
        Mockito.when((Object)awardMock.getAwardTotalAmount()).thenReturn((Object)new KualiDecimal(50000.0));
        Mockito.when((Object)awardMock.getActiveAwardAccounts()).thenReturn(Collections.singletonList(awardAccountMock));
        Mockito.when((Object)awardAccountMock.getChartOfAccountsCode()).thenReturn((Object)CHART_CODE);
        Mockito.when((Object)awardAccountMock.getAccountNumber()).thenReturn((Object)ACCT_NUM);
        Mockito.when((Object)this.predeterminedBillingScheduleMock.getAward()).thenReturn((Object)awardMock);
        Mockito.when((Object)this.predeterminedBillingScheduleMock.getProposalNumber()).thenReturn((Object)PROPOSAL_NUM);
        Mockito.when((Object)this.predeterminedBillingScheduleMock.getChartOfAccountsCode()).thenReturn((Object)CHART_CODE);
        Mockito.when((Object)this.predeterminedBillingScheduleMock.getAccountNumber()).thenReturn((Object)ACCT_NUM);
        Mockito.when((Object)bill1Mock.getBillNumber()).thenReturn((Object)"test*1");
        Mockito.when((Object)bill1Mock.getEstimatedAmount()).thenReturn((Object)new KualiDecimal(1000.0));
        Mockito.when((Object)bill1Mock.isActive()).thenReturn((Object)true);
        Mockito.when((Object)bill2Mock.getBillNumber()).thenReturn((Object)"test*2");
        Mockito.when((Object)bill2Mock.getEstimatedAmount()).thenReturn((Object)new KualiDecimal(1000.0));
        Mockito.when((Object)bill2Mock.isActive()).thenReturn((Object)true);
        ArrayList<Bill> bills = new ArrayList<Bill>();
        bills.add(bill1Mock);
        bills.add(bill2Mock);
        Mockito.when((Object)this.predeterminedBillingScheduleMock.getBills()).thenReturn(bills);
        ((PredeterminedBillingScheduleRule)Mockito.doReturn((Object)accountsReceivableModuleBillingSvcMock).when((Object)this.cutSpy)).getAccountsReceivableModuleBillingService();
        Mockito.when((Object)this.dictionaryValidationSvcMock.validate(ArgumentMatchers.any(Bill.class))).thenReturn((Object)new DictionaryValidationResult());
        Mockito.when((Object)this.predeterminedBillingScheduleMock.getAccountNumber()).thenReturn((Object)"9876543");
        Mockito.when((Object)accountsReceivableModuleBillingSvcMock.getBillsTotalAmountForOtherSchedules(PROPOSAL_NUM, CHART_CODE, "9876543")).thenReturn((Object)KualiDecimal.ZERO);
        Assertions.assertFalse((boolean)this.cutSpy.processCustomRouteDocumentBusinessRules(predeterminedBillingScheduleMaintDocMock));
        Assertions.assertEquals((int)1, (int)GlobalVariables.getMessageMap().getErrorCount());
        List errorMessages = (List)GlobalVariables.getMessageMap().getErrorMessages().get("document.newMaintainableObject.accountNumber");
        Assertions.assertNotNull((Object)errorMessages);
        Assertions.assertEquals((int)1, (int)errorMessages.size());
        ErrorMessage errorMessage = (ErrorMessage)errorMessages.get(0);
        Assertions.assertEquals((Object)"error.predetermined.billing.schedule.account.does.not.exist.on.award", (Object)errorMessage.getErrorKey());
    }

    @Test
    void processCustomRouteDocumentBusinessRules_AwardDoesNotExist_NullAward(@Mock(stubOnly=true) Bill bill1Mock, @Mock(stubOnly=true) Bill bill2Mock, @Mock(stubOnly=true) ContractsAndGrantsBillingAward awardMock, @Mock(stubOnly=true) MaintenanceDocument predeterminedBillingScheduleMaintDocMock) {
        Mockito.when((Object)this.predeterminedBillingScheduleMock.getAward()).thenReturn((Object)awardMock);
        Mockito.when((Object)this.predeterminedBillingScheduleMock.getProposalNumber()).thenReturn((Object)PROPOSAL_NUM);
        Mockito.when((Object)bill1Mock.getBillNumber()).thenReturn((Object)"test*1");
        Mockito.when((Object)bill2Mock.getBillNumber()).thenReturn((Object)"test*2");
        ArrayList<Bill> bills = new ArrayList<Bill>();
        bills.add(bill1Mock);
        bills.add(bill2Mock);
        Mockito.when((Object)this.predeterminedBillingScheduleMock.getBills()).thenReturn(bills);
        Mockito.when((Object)this.dictionaryValidationSvcMock.validate(ArgumentMatchers.any(Bill.class))).thenReturn((Object)new DictionaryValidationResult());
        Mockito.when((Object)this.predeterminedBillingScheduleMock.getAward()).thenReturn(null);
        Assertions.assertFalse((boolean)this.cutSpy.processCustomRouteDocumentBusinessRules(predeterminedBillingScheduleMaintDocMock));
        Assertions.assertEquals((int)1, (int)GlobalVariables.getMessageMap().getErrorCount());
        List errorMessages = (List)GlobalVariables.getMessageMap().getErrorMessages().get("document.newMaintainableObject.proposalNumberForAwardAccountLookup");
        Assertions.assertNotNull((Object)errorMessages);
        Assertions.assertEquals((int)1, (int)errorMessages.size());
        ErrorMessage errorMessage = (ErrorMessage)errorMessages.get(0);
        Assertions.assertEquals((Object)"error.award.does.not.exist", (Object)errorMessage.getErrorKey());
        String[] messageParameters = errorMessage.getMessageParameters();
        Assertions.assertEquals((int)1, (int)messageParameters.length);
        Assertions.assertEquals((Object)PROPOSAL_NUM, (Object)messageParameters[0]);
    }

    @Test
    void processCustomRouteDocumentBusinessRules_AwardDoesNotExist_NullProposalNumber(@Mock(stubOnly=true) Bill bill1Mock, @Mock(stubOnly=true) Bill bill2Mock, @Mock(stubOnly=true) AccountsReceivableModuleBillingServiceImpl accountsReceivableModuleBillingSvcMock, @Mock(stubOnly=true) ContractsAndGrantsBillingAward awardMock, @Mock(stubOnly=true) ContractsAndGrantsBillingAwardAccount awardAccountMock, @Mock(stubOnly=true) MaintenanceDocument predeterminedBillingScheduleMaintDocMock) {
        Mockito.when((Object)awardMock.getProposalNumber()).thenReturn((Object)PROPOSAL_NUM);
        Mockito.when((Object)awardMock.getBillingFrequencyCode()).thenReturn((Object)ArConstants.BillingFrequencyValues.PREDETERMINED_BILLING.getCode());
        Mockito.when((Object)awardMock.getAwardTotalAmount()).thenReturn((Object)new KualiDecimal(50000.0));
        Mockito.when((Object)awardMock.getActiveAwardAccounts()).thenReturn(Collections.singletonList(awardAccountMock));
        Mockito.when((Object)awardAccountMock.getChartOfAccountsCode()).thenReturn((Object)CHART_CODE);
        Mockito.when((Object)awardAccountMock.getAccountNumber()).thenReturn((Object)ACCT_NUM);
        Mockito.when((Object)this.predeterminedBillingScheduleMock.getAward()).thenReturn((Object)awardMock);
        Mockito.when((Object)this.predeterminedBillingScheduleMock.getProposalNumber()).thenReturn((Object)PROPOSAL_NUM);
        Mockito.when((Object)this.predeterminedBillingScheduleMock.getChartOfAccountsCode()).thenReturn((Object)CHART_CODE);
        Mockito.when((Object)this.predeterminedBillingScheduleMock.getAccountNumber()).thenReturn((Object)ACCT_NUM);
        Mockito.when((Object)bill1Mock.getBillNumber()).thenReturn((Object)"test*1");
        Mockito.when((Object)bill1Mock.getEstimatedAmount()).thenReturn((Object)new KualiDecimal(1000.0));
        Mockito.when((Object)bill1Mock.isActive()).thenReturn((Object)true);
        Mockito.when((Object)bill2Mock.getBillNumber()).thenReturn((Object)"test*2");
        Mockito.when((Object)bill2Mock.getEstimatedAmount()).thenReturn((Object)new KualiDecimal(1000.0));
        Mockito.when((Object)bill2Mock.isActive()).thenReturn((Object)true);
        ArrayList<Bill> bills = new ArrayList<Bill>();
        bills.add(bill1Mock);
        bills.add(bill2Mock);
        Mockito.when((Object)this.predeterminedBillingScheduleMock.getBills()).thenReturn(bills);
        Mockito.when((Object)accountsReceivableModuleBillingSvcMock.getBillsTotalAmountForOtherSchedules(PROPOSAL_NUM, CHART_CODE, ACCT_NUM)).thenReturn((Object)new KualiDecimal(48000.0));
        ((PredeterminedBillingScheduleRule)Mockito.doReturn((Object)accountsReceivableModuleBillingSvcMock).when((Object)this.cutSpy)).getAccountsReceivableModuleBillingService();
        Mockito.when((Object)this.dictionaryValidationSvcMock.validate(ArgumentMatchers.any(Bill.class))).thenReturn((Object)new DictionaryValidationResult());
        Mockito.when((Object)awardMock.getProposalNumber()).thenReturn(null);
        Assertions.assertFalse((boolean)this.cutSpy.processCustomRouteDocumentBusinessRules(predeterminedBillingScheduleMaintDocMock));
        Assertions.assertEquals((int)1, (int)GlobalVariables.getMessageMap().getErrorCount());
        List errorMessages = (List)GlobalVariables.getMessageMap().getErrorMessages().get("document.newMaintainableObject.proposalNumberForAwardAccountLookup");
        Assertions.assertNotNull((Object)errorMessages);
        Assertions.assertEquals((int)1, (int)errorMessages.size());
        ErrorMessage errorMessage = (ErrorMessage)errorMessages.get(0);
        Assertions.assertEquals((Object)"error.award.does.not.exist", (Object)errorMessage.getErrorKey());
        String[] messageParameters = errorMessage.getMessageParameters();
        Assertions.assertEquals((int)1, (int)messageParameters.length);
        Assertions.assertEquals((Object)PROPOSAL_NUM, (Object)messageParameters[0]);
    }

    @Test
    void processCustomRouteDocumentBusinessRules_BillFailsDataDictionaryValidation(@Mock(stubOnly=true) Bill bill1Mock, @Mock(stubOnly=true) Bill bill2Mock, @Mock(stubOnly=true) AccountsReceivableModuleBillingServiceImpl accountsReceivableModuleBillingSvcMock, @Mock(stubOnly=true) ContractsAndGrantsBillingAward awardMock, @Mock(stubOnly=true) ContractsAndGrantsBillingAwardAccount awardAccountMock, @Mock(stubOnly=true) DictionaryValidationResult dictionaryValidationResultMock, @Mock(stubOnly=true) MaintenanceDocument predeterminedBillingScheduleMaintDocMock) {
        Mockito.when((Object)awardMock.getProposalNumber()).thenReturn((Object)PROPOSAL_NUM);
        Mockito.when((Object)awardMock.getBillingFrequencyCode()).thenReturn((Object)ArConstants.BillingFrequencyValues.PREDETERMINED_BILLING.getCode());
        Mockito.when((Object)awardMock.getAwardTotalAmount()).thenReturn((Object)new KualiDecimal(50000.0));
        Mockito.when((Object)awardMock.getActiveAwardAccounts()).thenReturn(Collections.singletonList(awardAccountMock));
        Mockito.when((Object)awardAccountMock.getChartOfAccountsCode()).thenReturn((Object)CHART_CODE);
        Mockito.when((Object)awardAccountMock.getAccountNumber()).thenReturn((Object)ACCT_NUM);
        Mockito.when((Object)this.predeterminedBillingScheduleMock.getAward()).thenReturn((Object)awardMock);
        Mockito.when((Object)this.predeterminedBillingScheduleMock.getProposalNumber()).thenReturn((Object)PROPOSAL_NUM);
        Mockito.when((Object)this.predeterminedBillingScheduleMock.getChartOfAccountsCode()).thenReturn((Object)CHART_CODE);
        Mockito.when((Object)this.predeterminedBillingScheduleMock.getAccountNumber()).thenReturn((Object)ACCT_NUM);
        Mockito.when((Object)bill1Mock.getBillNumber()).thenReturn((Object)"test*1");
        Mockito.when((Object)bill1Mock.getEstimatedAmount()).thenReturn((Object)new KualiDecimal(1000.0));
        Mockito.when((Object)bill1Mock.isActive()).thenReturn((Object)true);
        Mockito.when((Object)bill2Mock.getBillNumber()).thenReturn((Object)"test*2");
        Mockito.when((Object)bill2Mock.getEstimatedAmount()).thenReturn((Object)new KualiDecimal(1000.0));
        Mockito.when((Object)bill2Mock.isActive()).thenReturn((Object)true);
        ArrayList<Bill> bills = new ArrayList<Bill>();
        bills.add(bill1Mock);
        bills.add(bill2Mock);
        Mockito.when((Object)this.predeterminedBillingScheduleMock.getBills()).thenReturn(bills);
        Mockito.when((Object)accountsReceivableModuleBillingSvcMock.getBillsTotalAmountForOtherSchedules(PROPOSAL_NUM, CHART_CODE, ACCT_NUM)).thenReturn((Object)new KualiDecimal(48000.0));
        ((PredeterminedBillingScheduleRule)Mockito.doReturn((Object)accountsReceivableModuleBillingSvcMock).when((Object)this.cutSpy)).getAccountsReceivableModuleBillingService();
        Mockito.when((Object)dictionaryValidationResultMock.getNumberOfErrors()).thenReturn((Object)1);
        Mockito.when((Object)this.dictionaryValidationSvcMock.validate(ArgumentMatchers.any(Bill.class))).thenReturn((Object)dictionaryValidationResultMock);
        Assertions.assertFalse((boolean)this.cutSpy.processCustomRouteDocumentBusinessRules(predeterminedBillingScheduleMaintDocMock));
    }
}

