/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.ar.document.validation.impl;

import java.util.ArrayList;
import java.util.HashMap;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.junit.jupiter.api.parallel.Execution;
import org.junit.jupiter.api.parallel.ExecutionMode;
import org.kuali.kfs.core.api.util.type.KualiDecimal;
import org.kuali.kfs.kew.api.WorkflowDocument;
import org.kuali.kfs.kew.impl.document.WorkflowDocumentImpl;
import org.kuali.kfs.kns.service.DictionaryValidationService;
import org.kuali.kfs.krad.service.BusinessObjectService;
import org.kuali.kfs.krad.service.DocumentService;
import org.kuali.kfs.krad.util.ErrorMessage;
import org.kuali.kfs.krad.util.GlobalVariables;
import org.kuali.kfs.module.ar.businessobject.CashControlDetail;
import org.kuali.kfs.module.ar.businessobject.PaymentMedium;
import org.kuali.kfs.module.ar.document.CashControlDocument;
import org.kuali.kfs.module.ar.document.PaymentApplicationDocument;
import org.kuali.kfs.module.ar.document.validation.impl.CashControlDocumentRule;
import org.kuali.kfs.sys.businessobject.DocumentHeader;
import org.kuali.kfs.sys.context.IntegTestUtils;
import org.mockito.ArgumentMatchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.jupiter.MockitoExtension;
import org.springframework.util.AutoPopulatingList;

@Execution(value=ExecutionMode.SAME_THREAD)
@ExtendWith(value={MockitoExtension.class})
class CashControlDocumentRuleTest {
    private CashControlDocumentRule cut;
    @Mock(stubOnly=true)
    private BusinessObjectService businessObjectSvcMock;
    @Mock(stubOnly=true)
    private CashControlDocument cashControlDocMock;
    @Mock(stubOnly=true)
    private DictionaryValidationService dictionaryValidationSvcMock;
    @Mock(stubOnly=true)
    private DocumentService documentSvcMock;
    private static final KualiDecimal NEGATIVE_AMOUNT = new KualiDecimal(-1);
    private static final KualiDecimal POSITIVE_AMOUNT = new KualiDecimal(2);
    private static final String CUSTOMER_PAYMENT_MEDIUM_NOT_VALID_CODE = "MEH";

    CashControlDocumentRuleTest() {
    }

    @BeforeEach
    void setUp() throws Exception {
        this.cut = new CashControlDocumentRule();
        this.cut.setBusinessObjectService(this.businessObjectSvcMock);
        this.cut.setDictionaryValidationService(this.dictionaryValidationSvcMock);
        this.cut.setDocumentService(this.documentSvcMock);
        GlobalVariables.getMessageMap().clearErrorMessages();
    }

    @AfterEach
    void tearDown() {
        this.cut.setDictionaryValidationService(null);
    }

    @Test
    void validateCashControlDetails_ValidLineAmount_True() {
        CashControlDetail cashControlDetail = new CashControlDetail();
        cashControlDetail.setFinancialDocumentLineAmount(POSITIVE_AMOUNT);
        ArrayList<CashControlDetail> cashControlDetails = new ArrayList<CashControlDetail>();
        cashControlDetails.add(cashControlDetail);
        Mockito.when((Object)this.cashControlDocMock.getCashControlDetails()).thenReturn(cashControlDetails);
        Mockito.when((Object)this.cashControlDocMock.getCashControlDetail(ArgumentMatchers.anyInt())).thenAnswer(invocation -> cashControlDetails.get((Integer)invocation.getArgument(0)));
        Assertions.assertTrue((boolean)this.cut.validateCashControlDetails(this.cashControlDocMock), (String)("Document should have passed validation. " + GlobalVariables.getMessageMap()));
        Assertions.assertEquals((int)0, (int)GlobalVariables.getMessageMap().getErrorCount());
    }

    @Test
    void validateCashControlDetails_NegativeLineAmount_False() {
        CashControlDetail cashControlDetail = new CashControlDetail();
        cashControlDetail.setFinancialDocumentLineAmount(NEGATIVE_AMOUNT);
        ArrayList<CashControlDetail> cashControlDetails = new ArrayList<CashControlDetail>();
        cashControlDetails.add(cashControlDetail);
        Mockito.when((Object)this.cashControlDocMock.getCashControlDetails()).thenReturn(cashControlDetails);
        Mockito.when((Object)this.cashControlDocMock.getCashControlDetail(ArgumentMatchers.anyInt())).thenAnswer(invocation -> cashControlDetails.get((Integer)invocation.getArgument(0)));
        Assertions.assertFalse((boolean)this.cut.validateCashControlDetails(this.cashControlDocMock));
        Assertions.assertEquals((int)1, (int)GlobalVariables.getMessageMap().getErrorCount());
        ErrorMessage errorMessage = (ErrorMessage)((AutoPopulatingList)GlobalVariables.getMessageMap().getErrorMessages().get("document.cashControlDetail[0].financialDocumentLineAmount")).get(0);
        Assertions.assertEquals((Object)"error.ar.LineAmountCannotBeNegative", (Object)errorMessage.getErrorKey());
        Assertions.assertEquals((int)0, (int)errorMessage.getMessageParameters().length);
    }

    @Test
    void validateCashControlDetails_ZeroLineAmount_False() {
        CashControlDetail cashControlDetail = new CashControlDetail();
        cashControlDetail.setFinancialDocumentLineAmount(KualiDecimal.ZERO);
        ArrayList<CashControlDetail> cashControlDetails = new ArrayList<CashControlDetail>();
        cashControlDetails.add(cashControlDetail);
        Mockito.when((Object)this.cashControlDocMock.getCashControlDetails()).thenReturn(cashControlDetails);
        Mockito.when((Object)this.cashControlDocMock.getCashControlDetail(ArgumentMatchers.anyInt())).thenAnswer(invocation -> cashControlDetails.get((Integer)invocation.getArgument(0)));
        Assertions.assertFalse((boolean)this.cut.validateCashControlDetails(this.cashControlDocMock));
        Assertions.assertEquals((int)1, (int)GlobalVariables.getMessageMap().getErrorCount());
        ErrorMessage errorMessage = (ErrorMessage)((AutoPopulatingList)GlobalVariables.getMessageMap().getErrorMessages().get("document.cashControlDetail[0].financialDocumentLineAmount")).get(0);
        Assertions.assertEquals((Object)"error.ar.LineAmountCannotBeZero", (Object)errorMessage.getErrorKey());
        Assertions.assertEquals((int)0, (int)errorMessage.getMessageParameters().length);
    }

    @Test
    void validateCashControlDetails_ZeroLineAmount_CanceledPaymentApplication_True(@Mock(stubOnly=true) DocumentHeader documentHeaderMock, @Mock(stubOnly=true) PaymentApplicationDocument paymentApplicationDocMock, @Mock(stubOnly=true) WorkflowDocument workflowDocumentMock) {
        CashControlDetail cashControlDetail = new CashControlDetail();
        cashControlDetail.setFinancialDocumentLineAmount(KualiDecimal.ZERO);
        cashControlDetail.setReferenceFinancialDocument(paymentApplicationDocMock);
        ArrayList<CashControlDetail> cashControlDetails = new ArrayList<CashControlDetail>();
        cashControlDetails.add(cashControlDetail);
        Mockito.when((Object)this.cashControlDocMock.getCashControlDetails()).thenReturn(cashControlDetails);
        Mockito.when((Object)this.cashControlDocMock.getCashControlDetail(ArgumentMatchers.anyInt())).thenAnswer(invocation -> cashControlDetails.get((Integer)invocation.getArgument(0)));
        Mockito.when((Object)workflowDocumentMock.isCanceled()).thenReturn((Object)true);
        Mockito.when((Object)documentHeaderMock.getWorkflowDocument()).thenReturn((Object)workflowDocumentMock);
        Mockito.when((Object)paymentApplicationDocMock.getDocumentHeader()).thenReturn((Object)documentHeaderMock);
        Assertions.assertTrue((boolean)this.cut.validateCashControlDetails(this.cashControlDocMock));
        Assertions.assertEquals((int)0, (int)GlobalVariables.getMessageMap().getErrorCount());
    }

    @Test
    void validateCashControlDetails_ZeroLineAmount_DisapprovedPaymentApplication_True(@Mock(stubOnly=true) DocumentHeader documentHeaderMock, @Mock(stubOnly=true) PaymentApplicationDocument paymentApplicationDocMock, @Mock(stubOnly=true) WorkflowDocument workflowDocumentMock) {
        CashControlDetail cashControlDetail = new CashControlDetail();
        cashControlDetail.setFinancialDocumentLineAmount(KualiDecimal.ZERO);
        cashControlDetail.setReferenceFinancialDocument(paymentApplicationDocMock);
        ArrayList<CashControlDetail> cashControlDetails = new ArrayList<CashControlDetail>();
        cashControlDetails.add(cashControlDetail);
        Mockito.when((Object)this.cashControlDocMock.getCashControlDetails()).thenReturn(cashControlDetails);
        Mockito.when((Object)this.cashControlDocMock.getCashControlDetail(ArgumentMatchers.anyInt())).thenAnswer(invocation -> cashControlDetails.get((Integer)invocation.getArgument(0)));
        Mockito.when((Object)workflowDocumentMock.isDisapproved()).thenReturn((Object)true);
        Mockito.when((Object)documentHeaderMock.getWorkflowDocument()).thenReturn((Object)workflowDocumentMock);
        Mockito.when((Object)paymentApplicationDocMock.getDocumentHeader()).thenReturn((Object)documentHeaderMock);
        Assertions.assertTrue((boolean)this.cut.validateCashControlDetails(this.cashControlDocMock));
        Assertions.assertEquals((int)0, (int)GlobalVariables.getMessageMap().getErrorCount());
    }

    @Test
    void checkPaymentMedium_Valid_True(@Mock(stubOnly=true) PaymentMedium paymentMediumMock) {
        Mockito.when((Object)this.cashControlDocMock.getCustomerPaymentMediumCode()).thenReturn((Object)"CK");
        HashMap<String, String> criteria = new HashMap<String, String>();
        criteria.put("customerPaymentMediumCode", "CA");
        Mockito.when((Object)((PaymentMedium)this.businessObjectSvcMock.findByPrimaryKey(PaymentMedium.class, criteria))).thenReturn((Object)paymentMediumMock);
        Mockito.when((Object)this.cashControlDocMock.getCustomerPaymentMediumCode()).thenReturn((Object)"CA");
        Assertions.assertTrue((boolean)this.cut.checkPaymentMedium(this.cashControlDocMock), (String)("Business Rules should not have failed: " + IntegTestUtils.dumpMessageMapErrors()));
        Assertions.assertEquals((int)0, (int)GlobalVariables.getMessageMap().getErrorCount());
    }

    @Test
    void checkPaymentMedium_NotValid_False() {
        Mockito.when((Object)this.cashControlDocMock.getCustomerPaymentMediumCode()).thenReturn((Object)"CK");
        this.cashControlDocMock.setCustomerPaymentMediumCode(CUSTOMER_PAYMENT_MEDIUM_NOT_VALID_CODE);
        Assertions.assertFalse((boolean)this.cut.checkPaymentMedium(this.cashControlDocMock));
        Assertions.assertEquals((int)1, (int)GlobalVariables.getMessageMap().getErrorCount());
        ErrorMessage errorMessage = (ErrorMessage)((AutoPopulatingList)GlobalVariables.getMessageMap().getErrorMessages().get("document.customerPaymentMediumCode")).get(0);
        Assertions.assertEquals((Object)"error.ar.CustomerPaymentMediumIsNotValid", (Object)errorMessage.getErrorKey());
        Assertions.assertEquals((int)0, (int)errorMessage.getMessageParameters().length);
    }

    @Test
    void checkPaymentMedium_Null_False() {
        Assertions.assertFalse((boolean)this.cut.checkPaymentMedium(this.cashControlDocMock));
        Assertions.assertEquals((int)1, (int)GlobalVariables.getMessageMap().getErrorCount());
        ErrorMessage errorMessage = (ErrorMessage)((AutoPopulatingList)GlobalVariables.getMessageMap().getErrorMessages().get("document.customerPaymentMediumCode")).get(0);
        Assertions.assertEquals((Object)"error.ar.CustomerPaymentMediumIsNotValid", (Object)errorMessage.getErrorKey());
        Assertions.assertEquals((int)0, (int)errorMessage.getMessageParameters().length);
    }

    @Test
    void checkRefDocNumber_Valid_Cash_True() {
        Mockito.when((Object)this.cashControlDocMock.getCustomerPaymentMediumCode()).thenReturn((Object)"CA");
        Mockito.when((Object)this.cashControlDocMock.getReferenceFinancialDocumentNumber()).thenReturn((Object)"12345");
        Mockito.when((Object)this.documentSvcMock.documentExists("12345")).thenReturn((Object)true);
        Assertions.assertTrue((boolean)this.cut.checkRefDocNumber(this.cashControlDocMock), (String)("Business Rules should not have failed: " + IntegTestUtils.dumpMessageMapErrors()));
        Assertions.assertEquals((int)0, (int)GlobalVariables.getMessageMap().getErrorCount());
    }

    @Test
    void checkRefDocNumber_Null_Cash_False() {
        Mockito.when((Object)this.cashControlDocMock.getCustomerPaymentMediumCode()).thenReturn((Object)"CA");
        Mockito.when((Object)this.cashControlDocMock.getReferenceFinancialDocumentNumber()).thenReturn(null);
        Assertions.assertFalse((boolean)this.cut.checkRefDocNumber(this.cashControlDocMock));
        Assertions.assertEquals((int)1, (int)GlobalVariables.getMessageMap().getErrorCount());
        ErrorMessage errorMessage = (ErrorMessage)((AutoPopulatingList)GlobalVariables.getMessageMap().getErrorMessages().get("document.referenceFinancialDocumentNumber")).get(0);
        Assertions.assertEquals((Object)"error.ar.ReferenceDocNumberMustBeValidforPaymentMediumCash", (Object)errorMessage.getErrorKey());
        Assertions.assertEquals((int)0, (int)errorMessage.getMessageParameters().length);
    }

    @Test
    void checkAllAppDocsApproved_NoAppDocs_True() {
        ArrayList cashControlDetails = new ArrayList();
        Mockito.when((Object)this.cashControlDocMock.getCashControlDetails()).thenReturn(cashControlDetails);
        Assertions.assertTrue((boolean)this.cut.checkAllAppDocsApprovedOrCanceled(this.cashControlDocMock));
    }

    @Test
    void checkAllAppDocsApproved_ApprovedAppDoc_True(@Mock(stubOnly=true) DocumentHeader documentHeaderMock, @Mock(stubOnly=true) PaymentApplicationDocument paymentApplicationDocMock, @Mock(stubOnly=true) WorkflowDocument workflowDocumentMock) {
        CashControlDetail cashControlDetail = CashControlDocumentRuleTest.setupCashControlDetailWithWorkflowDocument(documentHeaderMock, paymentApplicationDocMock, workflowDocumentMock);
        ArrayList<CashControlDetail> cashControlDetails = new ArrayList<CashControlDetail>();
        cashControlDetails.add(cashControlDetail);
        Mockito.when((Object)this.cashControlDocMock.getCashControlDetails()).thenReturn(cashControlDetails);
        Mockito.when((Object)this.cashControlDocMock.getCashControlDetail(ArgumentMatchers.anyInt())).thenAnswer(invocation -> cashControlDetails.get((Integer)invocation.getArgument(0)));
        Mockito.when((Object)workflowDocumentMock.isApproved()).thenReturn((Object)true);
        Assertions.assertTrue((boolean)this.cut.checkAllAppDocsApprovedOrCanceled(this.cashControlDocMock));
    }

    private static CashControlDetail setupCashControlDetailWithWorkflowDocument(DocumentHeader documentHeaderMock, PaymentApplicationDocument paymentApplicationDocMock, WorkflowDocument workflowDocumentMock) {
        CashControlDetail cashControlDetail = new CashControlDetail();
        cashControlDetail.setFinancialDocumentLineAmount(KualiDecimal.ZERO);
        cashControlDetail.setReferenceFinancialDocument(paymentApplicationDocMock);
        Mockito.when((Object)documentHeaderMock.getWorkflowDocument()).thenReturn((Object)workflowDocumentMock);
        Mockito.when((Object)paymentApplicationDocMock.getDocumentHeader()).thenReturn((Object)documentHeaderMock);
        return cashControlDetail;
    }

    @Test
    void checkAllAppDocsApproved_ProcessedAppDoc_True(@Mock(stubOnly=true) DocumentHeader documentHeaderMock, @Mock(stubOnly=true) PaymentApplicationDocument paymentApplicationDocMock, @Mock(stubOnly=true) WorkflowDocumentImpl workflowDocumentMock) {
        CashControlDetail cashControlDetail = CashControlDocumentRuleTest.setupCashControlDetailWithWorkflowDocument(documentHeaderMock, paymentApplicationDocMock, (WorkflowDocument)workflowDocumentMock);
        ArrayList<CashControlDetail> cashControlDetails = new ArrayList<CashControlDetail>();
        cashControlDetails.add(cashControlDetail);
        Mockito.when((Object)this.cashControlDocMock.getCashControlDetails()).thenReturn(cashControlDetails);
        Mockito.when((Object)this.cashControlDocMock.getCashControlDetail(ArgumentMatchers.anyInt())).thenAnswer(invocation -> cashControlDetails.get((Integer)invocation.getArgument(0)));
        Mockito.when((Object)workflowDocumentMock.isProcessed()).thenReturn((Object)true);
        ((WorkflowDocumentImpl)Mockito.doCallRealMethod().when((Object)workflowDocumentMock)).isApproved();
        Assertions.assertTrue((boolean)this.cut.checkAllAppDocsApprovedOrCanceled(this.cashControlDocMock));
    }

    @Test
    void checkAllAppDocsApproved_FinalAppDoc_True(@Mock(stubOnly=true) DocumentHeader documentHeaderMock, @Mock(stubOnly=true) PaymentApplicationDocument paymentApplicationDocMock, @Mock(stubOnly=true) WorkflowDocumentImpl workflowDocumentMock) {
        CashControlDetail cashControlDetail = CashControlDocumentRuleTest.setupCashControlDetailWithWorkflowDocument(documentHeaderMock, paymentApplicationDocMock, (WorkflowDocument)workflowDocumentMock);
        ArrayList<CashControlDetail> cashControlDetails = new ArrayList<CashControlDetail>();
        cashControlDetails.add(cashControlDetail);
        Mockito.when((Object)this.cashControlDocMock.getCashControlDetails()).thenReturn(cashControlDetails);
        Mockito.when((Object)this.cashControlDocMock.getCashControlDetail(ArgumentMatchers.anyInt())).thenAnswer(invocation -> cashControlDetails.get((Integer)invocation.getArgument(0)));
        Mockito.when((Object)workflowDocumentMock.isFinal()).thenReturn((Object)true);
        ((WorkflowDocumentImpl)Mockito.doCallRealMethod().when((Object)workflowDocumentMock)).isApproved();
        Assertions.assertTrue((boolean)this.cut.checkAllAppDocsApprovedOrCanceled(this.cashControlDocMock));
    }

    @Test
    void checkAllAppDocsApproved_CanceledAppDoc_True(@Mock(stubOnly=true) DocumentHeader documentHeaderMock, @Mock(stubOnly=true) PaymentApplicationDocument paymentApplicationDocMock, @Mock(stubOnly=true) WorkflowDocument workflowDocumentMock) {
        CashControlDetail cashControlDetail = CashControlDocumentRuleTest.setupCashControlDetailWithWorkflowDocument(documentHeaderMock, paymentApplicationDocMock, workflowDocumentMock);
        ArrayList<CashControlDetail> cashControlDetails = new ArrayList<CashControlDetail>();
        cashControlDetails.add(cashControlDetail);
        Mockito.when((Object)this.cashControlDocMock.getCashControlDetails()).thenReturn(cashControlDetails);
        Mockito.when((Object)this.cashControlDocMock.getCashControlDetail(ArgumentMatchers.anyInt())).thenAnswer(invocation -> cashControlDetails.get((Integer)invocation.getArgument(0)));
        Mockito.when((Object)workflowDocumentMock.isCanceled()).thenReturn((Object)true);
        Assertions.assertTrue((boolean)this.cut.checkAllAppDocsApprovedOrCanceled(this.cashControlDocMock));
    }

    @Test
    void checkAllAppDocsApproved_DisapprovedAppDoc_False(@Mock(stubOnly=true) DocumentHeader documentHeaderMock, @Mock(stubOnly=true) PaymentApplicationDocument paymentApplicationDocMock, @Mock(stubOnly=true) WorkflowDocument workflowDocumentMock) {
        CashControlDetail cashControlDetail = CashControlDocumentRuleTest.setupCashControlDetailWithWorkflowDocument(documentHeaderMock, paymentApplicationDocMock, workflowDocumentMock);
        ArrayList<CashControlDetail> cashControlDetails = new ArrayList<CashControlDetail>();
        cashControlDetails.add(cashControlDetail);
        Mockito.when((Object)this.cashControlDocMock.getCashControlDetails()).thenReturn(cashControlDetails);
        Mockito.when((Object)this.cashControlDocMock.getCashControlDetail(ArgumentMatchers.anyInt())).thenAnswer(invocation -> cashControlDetails.get((Integer)invocation.getArgument(0)));
        Mockito.when((Object)workflowDocumentMock.isDisapproved()).thenReturn((Object)true);
        Assertions.assertTrue((boolean)this.cut.checkAllAppDocsApprovedOrCanceled(this.cashControlDocMock));
    }

    @Test
    void checkAllAppDocsApproved_EnrouteAppDoc_False(@Mock(stubOnly=true) DocumentHeader documentHeaderMock, @Mock(stubOnly=true) PaymentApplicationDocument paymentApplicationDocMock, @Mock(stubOnly=true) WorkflowDocument workflowDocumentMock) {
        CashControlDetail cashControlDetail = CashControlDocumentRuleTest.setupCashControlDetailWithWorkflowDocument(documentHeaderMock, paymentApplicationDocMock, workflowDocumentMock);
        ArrayList<CashControlDetail> cashControlDetails = new ArrayList<CashControlDetail>();
        cashControlDetails.add(cashControlDetail);
        Mockito.when((Object)this.cashControlDocMock.getCashControlDetails()).thenReturn(cashControlDetails);
        Mockito.when((Object)this.cashControlDocMock.getCashControlDetail(ArgumentMatchers.anyInt())).thenAnswer(invocation -> cashControlDetails.get((Integer)invocation.getArgument(0)));
        Assertions.assertFalse((boolean)this.cut.checkAllAppDocsApprovedOrCanceled(this.cashControlDocMock));
        Assertions.assertEquals((int)1, (int)GlobalVariables.getMessageMap().getErrorCount());
        ErrorMessage errorMessage = (ErrorMessage)((AutoPopulatingList)GlobalVariables.getMessageMap().getErrorMessages().get("document.cashControlDetail[0].status")).get(0);
        Assertions.assertEquals((Object)"error.ar.AllApplicationDocumentsMustBeApprovedCanceledOrDisapproved", (Object)errorMessage.getErrorKey());
        Assertions.assertEquals((int)0, (int)errorMessage.getMessageParameters().length);
    }

    @Test
    void checkCashControlDocumentHasDetails_HasDetails_True() {
        ArrayList<CashControlDetail> cashControlDetails = new ArrayList<CashControlDetail>();
        cashControlDetails.add(new CashControlDetail());
        Mockito.when((Object)this.cashControlDocMock.getCashControlDetails()).thenReturn(cashControlDetails);
        Assertions.assertTrue((boolean)this.cut.checkCashControlDocumentHasDetails(this.cashControlDocMock));
    }

    @Test
    void checkCashControlDocumentHasDetails_NoDetails_False() {
        ArrayList cashControlDetails = new ArrayList();
        Mockito.when((Object)this.cashControlDocMock.getCashControlDetails()).thenReturn(cashControlDetails);
        Assertions.assertFalse((boolean)this.cut.checkCashControlDocumentHasDetails(this.cashControlDocMock));
    }
}

