/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.ar.document.validation.impl;

import java.sql.Date;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.kuali.kfs.coa.businessobject.AccountingPeriod;
import org.kuali.kfs.coa.service.AccountingPeriodService;
import org.kuali.kfs.core.api.config.property.ConfigurationService;
import org.kuali.kfs.core.api.datetime.DateTimeService;
import org.kuali.kfs.integration.cg.ContractsAndGrantsBillingAward;
import org.kuali.kfs.kns.rule.event.PromptBeforeValidationEvent;
import org.kuali.kfs.krad.document.Document;
import org.kuali.kfs.module.ar.businessobject.InvoiceGeneralDetail;
import org.kuali.kfs.module.ar.document.ContractsGrantsInvoiceDocument;
import org.kuali.kfs.module.ar.document.validation.impl.ContractsGrantsInvoiceDocumentPreRules;
import org.kuali.kfs.sys.context.SpringContext;
import org.mockito.ArgumentMatchers;
import org.mockito.Mock;
import org.mockito.MockedStatic;
import org.mockito.Mockito;
import org.mockito.Spy;
import org.mockito.junit.jupiter.MockitoExtension;
import org.mockito.verification.VerificationMode;
import org.springframework.test.util.ReflectionTestUtils;

@ExtendWith(value={MockitoExtension.class})
class ContractsGrantsInvoiceDocumentPreRulesTest {
    private static final String ACCOUNTING_PERIOD_2012_03_END_DATE = "2011-09-30";
    private static final String ACCOUNTING_PERIOD_2012_02_END_DATE = "2011-08-30";
    @Spy
    private ContractsGrantsInvoiceDocumentPreRules cutSpy;
    @Mock
    private ContractsGrantsInvoiceDocument cinvDocumentMock;
    @Mock
    private InvoiceGeneralDetail invoiceGeneralDetailMock;
    @Mock(stubOnly=true)
    private ContractsAndGrantsBillingAward awardMock;
    @Mock(stubOnly=true)
    private ConfigurationService configurationSvcMock;
    @Mock(stubOnly=true)
    private AccountingPeriodService accountingPeriodSvcMock;
    @Mock(stubOnly=true)
    private DateTimeService dateTimeSvcMock;

    ContractsGrantsInvoiceDocumentPreRulesTest() {
    }

    @BeforeEach
    void setUp() {
        this.setupDocumentAndBusinessObjectMocks();
    }

    private void setupDocumentAndBusinessObjectMocks() {
        Mockito.when((Object)this.invoiceGeneralDetailMock.isFinalBillIndicator()).thenReturn((Object)true);
        Mockito.when((Object)this.cinvDocumentMock.getInvoiceGeneralDetail()).thenReturn((Object)this.invoiceGeneralDetailMock);
    }

    private void userSaysContinueAtFinalBilleIndicatorQuestion() {
        ((ContractsGrantsInvoiceDocumentPreRules)Mockito.doReturn((Object)true).when((Object)this.cutSpy)).askOrAnalyzeYesNoQuestion((String)ArgumentMatchers.eq((Object)"FinalBillIndicatorUpdateQuestion"), (String)ArgumentMatchers.any());
    }

    private void userSaysStopAtFinalBilleIndicatorQuestion() {
        ((ContractsGrantsInvoiceDocumentPreRules)Mockito.doReturn((Object)false).when((Object)this.cutSpy)).askOrAnalyzeYesNoQuestion((String)ArgumentMatchers.eq((Object)"FinalBillIndicatorUpdateQuestion"), (String)ArgumentMatchers.any());
    }

    @Test
    void checkForFinalBillIndicator_invoiceNotFinal() {
        Mockito.when((Object)this.invoiceGeneralDetailMock.isFinalBillIndicator()).thenReturn((Object)false);
        Assertions.assertTrue((boolean)this.cutSpy.doPrompts((Document)this.cinvDocumentMock));
    }

    @Test
    void checkForFinalBillIndicator_invoiceFinal_afterProjectEnd(@Mock(stubOnly=true) AccountingPeriod accountingPeriodMock_2012_03) {
        Date currentDate = Date.valueOf("2011-09-25");
        Mockito.when((Object)this.dateTimeSvcMock.getCurrentSqlDate()).thenReturn((Object)currentDate);
        Mockito.when((Object)this.accountingPeriodSvcMock.getByDate(currentDate)).thenReturn((Object)accountingPeriodMock_2012_03);
        Mockito.when((Object)accountingPeriodMock_2012_03.getUniversityFiscalPeriodEndDate()).thenReturn((Object)Date.valueOf(ACCOUNTING_PERIOD_2012_03_END_DATE));
        Mockito.when((Object)this.invoiceGeneralDetailMock.getAward()).thenReturn((Object)this.awardMock);
        Mockito.when((Object)this.awardMock.getAwardEndingDate()).thenReturn((Object)Date.valueOf("2011-09-22"));
        try (MockedStatic springContextMockedStatic = Mockito.mockStatic(SpringContext.class);){
            springContextMockedStatic.when(() -> SpringContext.getBean(DateTimeService.class)).thenReturn((Object)this.dateTimeSvcMock);
            springContextMockedStatic.when(() -> SpringContext.getBean(ConfigurationService.class)).thenReturn((Object)this.configurationSvcMock);
            springContextMockedStatic.when(() -> SpringContext.getBean(AccountingPeriodService.class)).thenReturn((Object)this.accountingPeriodSvcMock);
            Assertions.assertTrue((boolean)this.cutSpy.doPrompts((Document)this.cinvDocumentMock));
            ((ContractsGrantsInvoiceDocumentPreRules)Mockito.verify((Object)this.cutSpy, (VerificationMode)Mockito.never())).askOrAnalyzeYesNoQuestion((String)ArgumentMatchers.eq((Object)"FinalBillIndicatorUpdateQuestion"), (String)ArgumentMatchers.any());
        }
    }

    @Test
    void checkForFinalBillIndicator_invoiceFinal_afterProjectEnd_UserSaysContinue(@Mock(stubOnly=true) AccountingPeriod accountingPeriodMock_2012_02) {
        Date currentDate = Date.valueOf("2011-08-25");
        Mockito.when((Object)this.dateTimeSvcMock.getCurrentSqlDate()).thenReturn((Object)currentDate);
        Mockito.when((Object)this.accountingPeriodSvcMock.getByDate(currentDate)).thenReturn((Object)accountingPeriodMock_2012_02);
        Mockito.when((Object)accountingPeriodMock_2012_02.getUniversityFiscalPeriodEndDate()).thenReturn((Object)Date.valueOf(ACCOUNTING_PERIOD_2012_02_END_DATE));
        Mockito.when((Object)this.invoiceGeneralDetailMock.getAward()).thenReturn((Object)this.awardMock);
        Mockito.when((Object)this.awardMock.getAwardEndingDate()).thenReturn((Object)Date.valueOf("2011-09-22"));
        PromptBeforeValidationEvent promptBeforeValidationEvent = new PromptBeforeValidationEvent("description", "errorPathPrefix", (Document)this.cinvDocumentMock);
        ReflectionTestUtils.setField((Object)this.cutSpy, (String)"event", (Object)promptBeforeValidationEvent);
        this.userSaysContinueAtFinalBilleIndicatorQuestion();
        try (MockedStatic springContextMockedStatic = Mockito.mockStatic(SpringContext.class);){
            springContextMockedStatic.when(() -> SpringContext.getBean(AccountingPeriodService.class)).thenReturn((Object)this.accountingPeriodSvcMock);
            springContextMockedStatic.when(() -> SpringContext.getBean(DateTimeService.class)).thenReturn((Object)this.dateTimeSvcMock);
            springContextMockedStatic.when(() -> SpringContext.getBean(ConfigurationService.class)).thenReturn((Object)this.configurationSvcMock);
            Assertions.assertTrue((boolean)this.cutSpy.doPrompts((Document)this.cinvDocumentMock));
            ((ContractsGrantsInvoiceDocumentPreRules)Mockito.verify((Object)this.cutSpy, (VerificationMode)Mockito.atMostOnce())).askOrAnalyzeYesNoQuestion((String)ArgumentMatchers.eq((Object)"FinalBillIndicatorUpdateQuestion"), (String)ArgumentMatchers.any());
        }
    }

    @Test
    void checkForFinalBillIndicator_invoiceFinal_afterProjectEnd_UserSaysStop(@Mock(stubOnly=true) AccountingPeriod accountingPeriodMock_2012_02) {
        Date currentDate = Date.valueOf("2011-08-25");
        Mockito.when((Object)this.dateTimeSvcMock.getCurrentSqlDate()).thenReturn((Object)currentDate);
        Mockito.when((Object)this.accountingPeriodSvcMock.getByDate(currentDate)).thenReturn((Object)accountingPeriodMock_2012_02);
        Mockito.when((Object)accountingPeriodMock_2012_02.getUniversityFiscalPeriodEndDate()).thenReturn((Object)Date.valueOf(ACCOUNTING_PERIOD_2012_02_END_DATE));
        Mockito.when((Object)this.invoiceGeneralDetailMock.getAward()).thenReturn((Object)this.awardMock);
        Mockito.when((Object)this.awardMock.getAwardEndingDate()).thenReturn((Object)Date.valueOf("2011-09-22"));
        PromptBeforeValidationEvent promptBeforeValidationEvent = new PromptBeforeValidationEvent("description", "errorPathPrefix", (Document)this.cinvDocumentMock);
        ReflectionTestUtils.setField((Object)this.cutSpy, (String)"event", (Object)promptBeforeValidationEvent);
        this.userSaysStopAtFinalBilleIndicatorQuestion();
        try (MockedStatic springContextMockedStatic = Mockito.mockStatic(SpringContext.class);){
            springContextMockedStatic.when(() -> SpringContext.getBean(AccountingPeriodService.class)).thenReturn((Object)this.accountingPeriodSvcMock);
            springContextMockedStatic.when(() -> SpringContext.getBean(DateTimeService.class)).thenReturn((Object)this.dateTimeSvcMock);
            springContextMockedStatic.when(() -> SpringContext.getBean(ConfigurationService.class)).thenReturn((Object)this.configurationSvcMock);
            Assertions.assertFalse((boolean)this.cutSpy.doPrompts((Document)this.cinvDocumentMock));
            ((ContractsGrantsInvoiceDocumentPreRules)Mockito.verify((Object)this.cutSpy, (VerificationMode)Mockito.atMostOnce())).askOrAnalyzeYesNoQuestion((String)ArgumentMatchers.eq((Object)"FinalBillIndicatorUpdateQuestion"), (String)ArgumentMatchers.any());
        }
    }
}

