/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.ar.document.validation.impl;

import java.text.MessageFormat;
import java.util.List;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.kuali.kfs.core.api.CoreApiServiceLocator;
import org.kuali.kfs.core.api.config.property.ConfigurationService;
import org.kuali.kfs.core.api.util.type.KualiDecimal;
import org.kuali.kfs.core.impl.datetime.DateTimeServiceImpl;
import org.kuali.kfs.kim.api.identity.PersonService;
import org.kuali.kfs.kim.impl.identity.Person;
import org.kuali.kfs.kns.rule.event.PromptBeforeValidationEvent;
import org.kuali.kfs.krad.UserSession;
import org.kuali.kfs.krad.bo.Note;
import org.kuali.kfs.krad.bo.PersistableBusinessObject;
import org.kuali.kfs.krad.document.Document;
import org.kuali.kfs.krad.service.NoteService;
import org.kuali.kfs.krad.util.GlobalVariables;
import org.kuali.kfs.module.ar.businessobject.ContractsGrantsLetterOfCreditReviewDetail;
import org.kuali.kfs.module.ar.document.ContractsGrantsLetterOfCreditReviewDocument;
import org.kuali.kfs.module.ar.document.validation.impl.ContractsGrantsLetterOfCreditReviewDocumentPreRules;
import org.kuali.kfs.sys.context.SpringContext;
import org.mockito.ArgumentCaptor;
import org.mockito.ArgumentMatchers;
import org.mockito.Mock;
import org.mockito.MockedStatic;
import org.mockito.Mockito;
import org.mockito.Spy;
import org.mockito.junit.jupiter.MockitoExtension;
import org.mockito.verification.VerificationMode;
import org.springframework.test.util.ReflectionTestUtils;

@ExtendWith(value={MockitoExtension.class})
class ContractsGrantsLetterOfCreditReviewDocumentPreRulesTest {
    private static final String ACCOUNT_NUMBER1 = "1031400";
    private static final String ACCOUNT_NUMBER2 = "1031420";
    private static final double AMOUNT_500 = 500.0;
    private static final String INITIATOR_NAME = "initiator";
    private static final String NOTE_MESSAGE_TEXT = "note message text {0} {1} {2}";
    private static final String PROPOSAL_NUMBER = "80080";
    private static final String QUESTION_TEXT = "question text";
    @Spy
    private ContractsGrantsLetterOfCreditReviewDocumentPreRules cutSpy = new ContractsGrantsLetterOfCreditReviewDocumentPreRules();
    @Mock
    private ConfigurationService configurationSvcMock;
    @Mock
    private ContractsGrantsLetterOfCreditReviewDocument contractsGrantsLetterOfCreditReviewDocumentMock;
    @Mock
    private NoteService noteSvcMock;
    @Mock
    private Person personMock;
    @Mock
    private PersonService personSvcMock;
    @Mock
    private PromptBeforeValidationEvent eventMock;
    @Mock
    private UserSession userSessionMock;

    ContractsGrantsLetterOfCreditReviewDocumentPreRulesTest() {
    }

    @Test
    void doPrompts_amountToDrawDoesNotExceedMax() {
        ContractsGrantsLetterOfCreditReviewDetail detail = ContractsGrantsLetterOfCreditReviewDocumentPreRulesTest.setupDetail(KualiDecimal.ZERO, ACCOUNT_NUMBER1);
        Mockito.when((Object)this.contractsGrantsLetterOfCreditReviewDocumentMock.getAccountReviewDetails()).thenReturn(List.of(detail));
        Assertions.assertTrue((boolean)this.cutSpy.doPrompts((Document)this.contractsGrantsLetterOfCreditReviewDocumentMock));
    }

    private static ContractsGrantsLetterOfCreditReviewDetail setupDetail(KualiDecimal amountToDraw, String accountNumber) {
        ContractsGrantsLetterOfCreditReviewDetail detail1 = new ContractsGrantsLetterOfCreditReviewDetail();
        detail1.setHiddenAmountToDraw(KualiDecimal.ZERO);
        detail1.setAmountToDraw(amountToDraw);
        detail1.setProposalNumber(PROPOSAL_NUMBER);
        detail1.setAccountNumber(accountNumber);
        return detail1;
    }

    @Test
    void doPrompts_amountToDrawExceedsMaxUserSaysNo() {
        boolean shouldContinue;
        ContractsGrantsLetterOfCreditReviewDetail detail = ContractsGrantsLetterOfCreditReviewDocumentPreRulesTest.setupDetail(new KualiDecimal(500.0), ACCOUNT_NUMBER1);
        Mockito.when((Object)this.contractsGrantsLetterOfCreditReviewDocumentMock.getAccountReviewDetails()).thenReturn(List.of(detail));
        ((ContractsGrantsLetterOfCreditReviewDocumentPreRules)Mockito.doReturn((Object)false).when((Object)this.cutSpy)).askOrAnalyzeYesNoQuestion("LetterOfCreditReviewDocumentAmountToDrawQuestionID", null);
        ReflectionTestUtils.setField((Object)this.cutSpy, (String)"event", (Object)this.eventMock);
        try (MockedStatic springContextMockedStatic = Mockito.mockStatic(SpringContext.class);){
            springContextMockedStatic.when(() -> SpringContext.getBean(ConfigurationService.class)).thenReturn((Object)this.configurationSvcMock);
            shouldContinue = this.cutSpy.doPrompts((Document)this.contractsGrantsLetterOfCreditReviewDocumentMock);
        }
        Assertions.assertFalse((boolean)shouldContinue);
        Mockito.verifyNoInteractions((Object[])new Object[]{this.noteSvcMock});
    }

    @Test
    void doPrompts_amountToDrawExceedsMaxUserSaysYes() {
        boolean shouldContinue;
        ContractsGrantsLetterOfCreditReviewDetail detail = ContractsGrantsLetterOfCreditReviewDocumentPreRulesTest.setupDetail(new KualiDecimal(500.0), ACCOUNT_NUMBER1);
        Mockito.when((Object)this.contractsGrantsLetterOfCreditReviewDocumentMock.getAccountReviewDetails()).thenReturn(List.of(detail));
        ((ContractsGrantsLetterOfCreditReviewDocumentPreRules)Mockito.doReturn((Object)true).when((Object)this.cutSpy)).askOrAnalyzeYesNoQuestion("LetterOfCreditReviewDocumentAmountToDrawQuestionID", QUESTION_TEXT);
        ReflectionTestUtils.setField((Object)this.cutSpy, (String)"event", (Object)this.eventMock);
        Mockito.when((Object)this.configurationSvcMock.getPropertyValueAsString("warning.contractsGrantsLetterOfCreditReviewDocument.amountToDrawExceedsMaximum")).thenReturn((Object)QUESTION_TEXT);
        Mockito.when((Object)this.configurationSvcMock.getPropertyValueAsString("contractsGrantsLetterOfCreditReviewDocument.amountToDraw.exceeded.note")).thenReturn((Object)NOTE_MESSAGE_TEXT);
        Mockito.when((Object)this.personMock.getName()).thenReturn((Object)INITIATOR_NAME);
        Mockito.when((Object)this.userSessionMock.getPerson()).thenReturn((Object)this.personMock);
        Mockito.when((Object)this.personSvcMock.getPersonByPrincipalName("kfs")).thenReturn((Object)this.personMock);
        try (MockedStatic coreApiServiceLocatorMockedStatic = Mockito.mockStatic(CoreApiServiceLocator.class);
             MockedStatic globalVariablesMockedStatic = Mockito.mockStatic(GlobalVariables.class);
             MockedStatic springContextMockedStatic = Mockito.mockStatic(SpringContext.class);){
            coreApiServiceLocatorMockedStatic.when(CoreApiServiceLocator::getDateTimeService).thenReturn((Object)new DateTimeServiceImpl());
            globalVariablesMockedStatic.when(GlobalVariables::getUserSession).thenReturn((Object)this.userSessionMock);
            springContextMockedStatic.when(() -> SpringContext.getBean(ConfigurationService.class)).thenReturn((Object)this.configurationSvcMock);
            springContextMockedStatic.when(() -> SpringContext.getBean(NoteService.class)).thenReturn((Object)this.noteSvcMock);
            springContextMockedStatic.when(() -> SpringContext.getBean(PersonService.class)).thenReturn((Object)this.personSvcMock);
            shouldContinue = this.cutSpy.doPrompts((Document)this.contractsGrantsLetterOfCreditReviewDocumentMock);
        }
        Assertions.assertTrue((boolean)shouldContinue);
        ArgumentCaptor note = ArgumentCaptor.forClass(Note.class);
        PersistableBusinessObject noteTarget = this.contractsGrantsLetterOfCreditReviewDocumentMock.getNoteTarget();
        ((NoteService)Mockito.verify((Object)this.noteSvcMock)).createNote((Note)note.capture(), (PersistableBusinessObject)ArgumentMatchers.eq((Object)noteTarget), (String)ArgumentMatchers.eq(null));
        String expectedNoteText = MessageFormat.format(NOTE_MESSAGE_TEXT, PROPOSAL_NUMBER, ACCOUNT_NUMBER1, INITIATOR_NAME);
        Assertions.assertEquals((Object)expectedNoteText, (Object)((Note)note.getValue()).getNoteText());
        ((NoteService)Mockito.verify((Object)this.noteSvcMock)).save((Note)note.capture());
    }

    @Test
    void doPrompts_multipleAmountsToDrawExceedsMaxUserSaysNo() {
        boolean shouldContinue;
        ContractsGrantsLetterOfCreditReviewDetail detail1 = ContractsGrantsLetterOfCreditReviewDocumentPreRulesTest.setupDetail(new KualiDecimal(500.0), ACCOUNT_NUMBER1);
        ContractsGrantsLetterOfCreditReviewDetail detail2 = ContractsGrantsLetterOfCreditReviewDocumentPreRulesTest.setupDetail(new KualiDecimal(500.0), ACCOUNT_NUMBER2);
        Mockito.when((Object)this.contractsGrantsLetterOfCreditReviewDocumentMock.getAccountReviewDetails()).thenReturn(List.of(detail1, detail2));
        ((ContractsGrantsLetterOfCreditReviewDocumentPreRules)Mockito.doReturn((Object)false).when((Object)this.cutSpy)).askOrAnalyzeYesNoQuestion("LetterOfCreditReviewDocumentAmountToDrawQuestionID", null);
        ReflectionTestUtils.setField((Object)this.cutSpy, (String)"event", (Object)this.eventMock);
        try (MockedStatic springContextMockedStatic = Mockito.mockStatic(SpringContext.class);){
            springContextMockedStatic.when(() -> SpringContext.getBean(ConfigurationService.class)).thenReturn((Object)this.configurationSvcMock);
            shouldContinue = this.cutSpy.doPrompts((Document)this.contractsGrantsLetterOfCreditReviewDocumentMock);
        }
        Assertions.assertFalse((boolean)shouldContinue);
        Mockito.verifyNoInteractions((Object[])new Object[]{this.noteSvcMock});
    }

    @Test
    void doPrompts_multipleAmountsToDrawExceedsMaxUserSaysYes() {
        boolean shouldContinue;
        ContractsGrantsLetterOfCreditReviewDetail detail1 = ContractsGrantsLetterOfCreditReviewDocumentPreRulesTest.setupDetail(new KualiDecimal(500.0), ACCOUNT_NUMBER1);
        ContractsGrantsLetterOfCreditReviewDetail detail2 = ContractsGrantsLetterOfCreditReviewDocumentPreRulesTest.setupDetail(new KualiDecimal(500.0), ACCOUNT_NUMBER2);
        Mockito.when((Object)this.contractsGrantsLetterOfCreditReviewDocumentMock.getAccountReviewDetails()).thenReturn(List.of(detail1, detail2));
        ((ContractsGrantsLetterOfCreditReviewDocumentPreRules)Mockito.doReturn((Object)true).when((Object)this.cutSpy)).askOrAnalyzeYesNoQuestion("LetterOfCreditReviewDocumentAmountToDrawQuestionID", QUESTION_TEXT);
        ReflectionTestUtils.setField((Object)this.cutSpy, (String)"event", (Object)this.eventMock);
        Mockito.when((Object)this.configurationSvcMock.getPropertyValueAsString("warning.contractsGrantsLetterOfCreditReviewDocument.amountToDrawExceedsMaximum")).thenReturn((Object)QUESTION_TEXT);
        Mockito.when((Object)this.configurationSvcMock.getPropertyValueAsString("contractsGrantsLetterOfCreditReviewDocument.amountToDraw.exceeded.note")).thenReturn((Object)NOTE_MESSAGE_TEXT);
        Mockito.when((Object)this.personMock.getName()).thenReturn((Object)INITIATOR_NAME);
        Mockito.when((Object)this.userSessionMock.getPerson()).thenReturn((Object)this.personMock);
        Mockito.when((Object)this.personSvcMock.getPersonByPrincipalName("kfs")).thenReturn((Object)this.personMock);
        try (MockedStatic coreApiServiceLocatorMockedStatic = Mockito.mockStatic(CoreApiServiceLocator.class);
             MockedStatic globalVariablesMockedStatic = Mockito.mockStatic(GlobalVariables.class);
             MockedStatic springContextMockedStatic = Mockito.mockStatic(SpringContext.class);){
            coreApiServiceLocatorMockedStatic.when(CoreApiServiceLocator::getDateTimeService).thenReturn((Object)new DateTimeServiceImpl());
            globalVariablesMockedStatic.when(GlobalVariables::getUserSession).thenReturn((Object)this.userSessionMock);
            springContextMockedStatic.when(() -> SpringContext.getBean(ConfigurationService.class)).thenReturn((Object)this.configurationSvcMock);
            springContextMockedStatic.when(() -> SpringContext.getBean(NoteService.class)).thenReturn((Object)this.noteSvcMock);
            springContextMockedStatic.when(() -> SpringContext.getBean(PersonService.class)).thenReturn((Object)this.personSvcMock);
            shouldContinue = this.cutSpy.doPrompts((Document)this.contractsGrantsLetterOfCreditReviewDocumentMock);
        }
        Assertions.assertTrue((boolean)shouldContinue);
        ArgumentCaptor note = ArgumentCaptor.forClass(Note.class);
        PersistableBusinessObject noteTarget = this.contractsGrantsLetterOfCreditReviewDocumentMock.getNoteTarget();
        ((NoteService)Mockito.verify((Object)this.noteSvcMock, (VerificationMode)Mockito.times((int)2))).createNote((Note)note.capture(), (PersistableBusinessObject)ArgumentMatchers.eq((Object)noteTarget), (String)ArgumentMatchers.eq(null));
        String expectedNoteText1 = MessageFormat.format(NOTE_MESSAGE_TEXT, PROPOSAL_NUMBER, ACCOUNT_NUMBER1, INITIATOR_NAME);
        Assertions.assertEquals((Object)expectedNoteText1, (Object)((Note)note.getAllValues().get(0)).getNoteText());
        String expectedNoteText2 = MessageFormat.format(NOTE_MESSAGE_TEXT, PROPOSAL_NUMBER, ACCOUNT_NUMBER2, INITIATOR_NAME);
        Assertions.assertEquals((Object)expectedNoteText2, (Object)((Note)note.getAllValues().get(1)).getNoteText());
        ((NoteService)Mockito.verify((Object)this.noteSvcMock, (VerificationMode)Mockito.times((int)2))).save((Note)note.capture());
    }
}

