/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.ar.document.validation.impl;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.junit.jupiter.api.parallel.Execution;
import org.junit.jupiter.api.parallel.ExecutionMode;
import org.kuali.kfs.core.api.util.type.KualiDecimal;
import org.kuali.kfs.kew.api.WorkflowDocument;
import org.kuali.kfs.krad.UserSession;
import org.kuali.kfs.krad.service.BusinessObjectService;
import org.kuali.kfs.krad.util.ErrorMessage;
import org.kuali.kfs.krad.util.GlobalVariables;
import org.kuali.kfs.module.ar.businessobject.CustomerCreditMemoDetail;
import org.kuali.kfs.module.ar.document.CustomerCreditMemoDocument;
import org.kuali.kfs.module.ar.document.CustomerInvoiceDocument;
import org.kuali.kfs.module.ar.document.service.CustomerInvoiceDocumentService;
import org.kuali.kfs.module.ar.document.validation.impl.CustomerCreditMemoDocumentRule;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.Spy;
import org.mockito.junit.jupiter.MockitoExtension;
import org.springframework.util.AutoPopulatingList;

@Execution(value=ExecutionMode.SAME_THREAD)
@ExtendWith(value={MockitoExtension.class})
class CustomerCreditMemoDocumentRuleTest {
    private static final String INVOICE_DOCUMENT_NUMBER = "KLM0456";
    private static final String PRINCIPAL_ID = "khuntley";
    @Mock(stubOnly=true)
    private BusinessObjectService businessObjectSvcMock;
    @Mock(stubOnly=true)
    private CustomerInvoiceDocument customerInvoiceDocumentMock;
    @Mock(stubOnly=true)
    private CustomerInvoiceDocumentService customerInvoiceDocumentSvcMock;
    @Spy
    private CustomerCreditMemoDocumentRule cutSpy;

    CustomerCreditMemoDocumentRuleTest() {
    }

    @BeforeEach
    void setUp() throws Exception {
        GlobalVariables.getMessageMap().clearErrorMessages();
        this.cutSpy.setBusinessObjectService(this.businessObjectSvcMock);
        this.cutSpy.setCustomerInvoiceDocumentService(this.customerInvoiceDocumentSvcMock);
    }

    private void setupUserSession(UserSession userSessionMock) {
        Mockito.when((Object)userSessionMock.getPrincipalId()).thenReturn((Object)PRINCIPAL_ID);
        ((CustomerCreditMemoDocumentRule)Mockito.doReturn((Object)userSessionMock).when((Object)this.cutSpy)).getUserSession();
    }

    @AfterEach
    void tearDown() {
        GlobalVariables.getMessageMap().clearErrorMessages();
    }

    @Test
    void isQtyOrItemAmountEntered_EmptyString_True() {
        CustomerCreditMemoDetail detail = new CustomerCreditMemoDetail();
        Assertions.assertEquals((Object)"", (Object)this.cutSpy.isQtyOrItemAmountEntered(detail));
    }

    @Test
    void isQtyOrItemAmountEntered_OnlyQty_True() {
        CustomerCreditMemoDetail detail = new CustomerCreditMemoDetail();
        detail.setCreditMemoItemQuantity(new BigDecimal(1));
        Assertions.assertEquals((Object)"qty", (Object)this.cutSpy.isQtyOrItemAmountEntered(detail));
    }

    @Test
    void isQtyOrItemAmountEntered_OnlyAmount_True() {
        CustomerCreditMemoDetail detail = new CustomerCreditMemoDetail();
        detail.setCreditMemoItemTotalAmount(new KualiDecimal(1));
        Assertions.assertEquals((Object)"itemAmount", (Object)this.cutSpy.isQtyOrItemAmountEntered(detail));
    }

    @Test
    void isQtyOrItemAmountEntered_AmountAndQty_True() {
        CustomerCreditMemoDetail detail = new CustomerCreditMemoDetail();
        detail.setCreditMemoItemTotalAmount(new KualiDecimal(1));
        detail.setCreditMemoItemQuantity(new BigDecimal(1));
        Assertions.assertEquals((Object)"both", (Object)this.cutSpy.isQtyOrItemAmountEntered(detail));
    }

    @Test
    void isValueGreaterThanZero_Valid_True() {
        Assertions.assertTrue((boolean)this.cutSpy.isValueGreaterThanZero(BigDecimal.ONE));
        Assertions.assertFalse((boolean)GlobalVariables.getMessageMap().hasErrors());
    }

    @Test
    void isValueGreaterThanZero_Zero_False() {
        Assertions.assertFalse((boolean)this.cutSpy.isValueGreaterThanZero(BigDecimal.ZERO));
        Assertions.assertEquals((int)1, (int)GlobalVariables.getMessageMap().getErrorCount());
        Assertions.assertTrue((boolean)GlobalVariables.getMessageMap().containsMessageKey("error.document.customerCreditMemoDocument.invalidCustomerCreditMemoItemQuantity"));
    }

    @Test
    void tisValueGreaterThanZero_ValidKualiDecimal_True() {
        Assertions.assertTrue((boolean)this.cutSpy.isValueGreaterThanZero(new KualiDecimal(1)));
        Assertions.assertFalse((boolean)GlobalVariables.getMessageMap().hasErrors());
    }

    @Test
    void isValueGreaterThanZero_ZeroKualiDecimal_False() {
        Assertions.assertFalse((boolean)this.cutSpy.isValueGreaterThanZero(KualiDecimal.ZERO));
        Assertions.assertEquals((int)1, (int)GlobalVariables.getMessageMap().getErrorCount());
        Assertions.assertTrue((boolean)GlobalVariables.getMessageMap().containsMessageKey("error.document.customerCreditMemoDocument.invalidCustomerCreditMemoItemAmount"));
    }

    @Test
    void isCustomerCreditMemoItemAmountLessThanEqualToInvoiceOpenItemAmount_AmountEqual_True() {
        CustomerCreditMemoDetail detail = new CustomerCreditMemoDetail();
        detail.setInvoiceOpenItemAmount(new KualiDecimal(2));
        detail.setCreditMemoItemTotalAmount(new KualiDecimal(2));
        Assertions.assertTrue((boolean)this.cutSpy.isCustomerCreditMemoItemAmountLessThanEqualToInvoiceOpenItemAmount(detail));
        Assertions.assertFalse((boolean)GlobalVariables.getMessageMap().hasErrors());
    }

    @Test
    void isCustomerCreditMemoItemAmountLessThanEqualToInvoiceOpenItemAmount_CreditMemoLessThanInvoice_True() {
        CustomerCreditMemoDetail detail = new CustomerCreditMemoDetail();
        detail.setInvoiceOpenItemAmount(new KualiDecimal(2));
        detail.setCreditMemoItemTotalAmount(new KualiDecimal(1));
        Assertions.assertTrue((boolean)this.cutSpy.isCustomerCreditMemoItemAmountLessThanEqualToInvoiceOpenItemAmount(detail));
        Assertions.assertFalse((boolean)GlobalVariables.getMessageMap().hasErrors());
    }

    @Test
    void isCustomerCreditMemoItemAmountLessThanEqualToInvoiceOpenItemAmount_CreditMemoGreaterThanInvoiceFalse() {
        CustomerCreditMemoDetail detail = new CustomerCreditMemoDetail();
        detail.setInvoiceOpenItemAmount(new KualiDecimal(1));
        detail.setCreditMemoItemTotalAmount(new KualiDecimal(2));
        Assertions.assertFalse((boolean)this.cutSpy.isCustomerCreditMemoItemAmountLessThanEqualToInvoiceOpenItemAmount(detail));
        Assertions.assertEquals((int)1, (int)GlobalVariables.getMessageMap().getErrorCount());
        Assertions.assertTrue((boolean)GlobalVariables.getMessageMap().containsMessageKey("error.document.customerCreditMemoDocument.itemAmountGreaterThanParentItemAmount"));
    }

    @Test
    void isCustomerCreditMemoQtyLessThanEqualToInvoiceOpenQty_QtyEqual_True() {
        CustomerCreditMemoDetail detail = new CustomerCreditMemoDetail();
        detail.setInvoiceOpenItemQuantity(new BigDecimal(2));
        detail.setCreditMemoItemQuantity(new BigDecimal(2));
        Assertions.assertTrue((boolean)this.cutSpy.isCustomerCreditMemoQtyLessThanEqualToInvoiceOpenQty(detail));
        Assertions.assertFalse((boolean)GlobalVariables.getMessageMap().hasErrors());
    }

    @Test
    void isCustomerCreditMemoQtyLessThanEqualToInvoiceOpenQty_CreditMemoLessThanInvoice_True() {
        CustomerCreditMemoDetail detail = new CustomerCreditMemoDetail();
        detail.setInvoiceOpenItemQuantity(new BigDecimal(2));
        detail.setCreditMemoItemQuantity(new BigDecimal(1));
        Assertions.assertTrue((boolean)this.cutSpy.isCustomerCreditMemoQtyLessThanEqualToInvoiceOpenQty(detail));
        Assertions.assertFalse((boolean)GlobalVariables.getMessageMap().hasErrors());
    }

    @Test
    void isCustomerCreditMemoQtyLessThanEqualToInvoiceOpenQty_CreditMemoGreaterThanInvoice_False() {
        CustomerCreditMemoDetail detail = new CustomerCreditMemoDetail();
        detail.setInvoiceOpenItemQuantity(new BigDecimal(1));
        detail.setCreditMemoItemQuantity(new BigDecimal(2));
        Assertions.assertFalse((boolean)this.cutSpy.isCustomerCreditMemoQtyLessThanEqualToInvoiceOpenQty(detail));
        Assertions.assertEquals((int)1, (int)GlobalVariables.getMessageMap().getErrorCount());
        Assertions.assertTrue((boolean)GlobalVariables.getMessageMap().containsMessageKey("error.document.customerCreditMemoDocument.itemQuantityGreaterThanParentItemQuantity"));
    }

    @Test
    void checkIfCustomerCreditMemoQtyAndCustomerCreditMemoItemAmountValid_ExactMatch_True() {
        CustomerCreditMemoDetail detail = new CustomerCreditMemoDetail();
        detail.setCreditMemoItemTotalAmount(new KualiDecimal(4));
        detail.setCreditMemoItemQuantity(new BigDecimal(2));
        Assertions.assertTrue((boolean)this.cutSpy.checkIfCustomerCreditMemoQtyAndCustomerCreditMemoItemAmountValid(detail, new BigDecimal(2)));
        Assertions.assertFalse((boolean)GlobalVariables.getMessageMap().hasErrors());
    }

    @Test
    void checkIfCustomerCreditMemoQtyAndCustomerCreditMemoItemAmountValid_FarOff_False() {
        CustomerCreditMemoDetail detail = new CustomerCreditMemoDetail();
        detail.setCreditMemoItemTotalAmount(new KualiDecimal(50));
        detail.setCreditMemoItemQuantity(new BigDecimal(10));
        Assertions.assertFalse((boolean)this.cutSpy.checkIfCustomerCreditMemoQtyAndCustomerCreditMemoItemAmountValid(detail, new BigDecimal(10)));
        Assertions.assertEquals((int)2, (int)GlobalVariables.getMessageMap().getErrorCount());
        Map errorMessages = GlobalVariables.getMessageMap().getErrorMessages();
        AutoPopulatingList creditMemoItemQuantityErrorMessages = (AutoPopulatingList)errorMessages.get("creditMemoItemQuantity");
        ErrorMessage creditMemoItemQuantityErrorMessage = (ErrorMessage)creditMemoItemQuantityErrorMessages.get(0);
        Assertions.assertEquals((Object)"error.document.customerCreditMemoDocument.invalidDataInput", (Object)creditMemoItemQuantityErrorMessage.getErrorKey());
        AutoPopulatingList creditMemoItemTotalAmountErrorMessages = (AutoPopulatingList)errorMessages.get("creditMemoItemTotalAmount");
        ErrorMessage creditMemoItemTotalAmountErrrorMessage = (ErrorMessage)creditMemoItemTotalAmountErrorMessages.get(0);
        Assertions.assertEquals((Object)"error.document.customerCreditMemoDocument.invalidDataInput", (Object)creditMemoItemTotalAmountErrrorMessage.getErrorKey());
    }

    @Test
    void checkIfCustomerCreditMemoQtyAndCustomerCreditMemoItemAmountValid_JustAboveAllowedDeviation_False() {
        CustomerCreditMemoDetail detail = new CustomerCreditMemoDetail();
        detail.setCreditMemoItemTotalAmount(new KualiDecimal(50));
        detail.setCreditMemoItemQuantity(new BigDecimal("5.6"));
        Assertions.assertFalse((boolean)this.cutSpy.checkIfCustomerCreditMemoQtyAndCustomerCreditMemoItemAmountValid(detail, new BigDecimal(10)));
        Assertions.assertEquals((int)2, (int)GlobalVariables.getMessageMap().getErrorCount());
        Map errorMessages = GlobalVariables.getMessageMap().getErrorMessages();
        AutoPopulatingList creditMemoItemQuantityErrorMessages = (AutoPopulatingList)errorMessages.get("creditMemoItemQuantity");
        ErrorMessage creditMemoItemQuantityErrorMessage = (ErrorMessage)creditMemoItemQuantityErrorMessages.get(0);
        Assertions.assertEquals((Object)"error.document.customerCreditMemoDocument.invalidDataInput", (Object)creditMemoItemQuantityErrorMessage.getErrorKey());
        AutoPopulatingList creditMemoItemTotalAmountErrorMessages = (AutoPopulatingList)errorMessages.get("creditMemoItemTotalAmount");
        ErrorMessage creditMemoItemTotalAmountErrrorMessage = (ErrorMessage)creditMemoItemTotalAmountErrorMessages.get(0);
        Assertions.assertEquals((Object)"error.document.customerCreditMemoDocument.invalidDataInput", (Object)creditMemoItemTotalAmountErrrorMessage.getErrorKey());
    }

    @Test
    void checkIfCustomerCreditMemoQtyAndCustomerCreditMemoItemAmountValid_ExactlyAllowedDeviation_True() {
        CustomerCreditMemoDetail detail = new CustomerCreditMemoDetail();
        detail.setCreditMemoItemTotalAmount(new KualiDecimal(50));
        detail.setCreditMemoItemQuantity(new BigDecimal("5.5"));
        Assertions.assertTrue((boolean)this.cutSpy.checkIfCustomerCreditMemoQtyAndCustomerCreditMemoItemAmountValid(detail, new BigDecimal(10)));
        Assertions.assertFalse((boolean)GlobalVariables.getMessageMap().hasErrors());
    }

    @Test
    void checkIfCustomerCreditMemoQtyAndCustomerCreditMemoItemAmountValid_JustBelowAllowedDeviation_True() {
        CustomerCreditMemoDetail detail = new CustomerCreditMemoDetail();
        detail.setCreditMemoItemTotalAmount(new KualiDecimal(50));
        detail.setCreditMemoItemQuantity(new BigDecimal("5.4"));
        Assertions.assertTrue((boolean)this.cutSpy.checkIfCustomerCreditMemoQtyAndCustomerCreditMemoItemAmountValid(detail, new BigDecimal(10)));
        Assertions.assertFalse((boolean)GlobalVariables.getMessageMap().hasErrors());
    }

    @Test
    void checkIfCustomerCreditMemoQtyAndCustomerCreditMemoItemAmountZero_QuantityZero_False() {
        CustomerCreditMemoDetail detail = new CustomerCreditMemoDetail();
        detail.setCreditMemoItemTotalAmount(new KualiDecimal(0));
        detail.setCreditMemoItemQuantity(new BigDecimal(0));
        Assertions.assertFalse((boolean)this.cutSpy.checkIfCustomerCreditMemoQtyAndCustomerCreditMemoItemAmountValid(detail, new BigDecimal(10)));
        Assertions.assertFalse((boolean)GlobalVariables.getMessageMap().hasErrors());
    }

    @Test
    void checkIfInvoiceNumberIsFinal_blankInvoiceNumber_False() {
        Assertions.assertFalse((boolean)this.cutSpy.checkIfInvoiceNumberIsFinal(""));
        Assertions.assertEquals((int)1, (int)GlobalVariables.getMessageMap().getErrorCount());
        Assertions.assertTrue((boolean)GlobalVariables.getMessageMap().containsMessageKey("error.document.customerCreditMemoDocument.invRefNumberIsRequired"));
    }

    @Test
    void checkIfInvoiceNumberIsFinal_invalidInvoiceNumber_False() {
        Mockito.when((Object)this.customerInvoiceDocumentSvcMock.getInvoiceByInvoiceDocumentNumber(INVOICE_DOCUMENT_NUMBER)).thenReturn(null);
        Assertions.assertFalse((boolean)this.cutSpy.checkIfInvoiceNumberIsFinal(INVOICE_DOCUMENT_NUMBER));
        Assertions.assertEquals((int)1, (int)GlobalVariables.getMessageMap().getErrorCount());
        Assertions.assertTrue((boolean)GlobalVariables.getMessageMap().containsMessageKey("error.document.customerCreditMemoDocument.invalidInvoiceDocumentNumber"));
    }

    @Test
    void checkIfInvoiceNumberIsFinal_validInvoiceNumberFinal_True() {
        Mockito.when((Object)this.customerInvoiceDocumentSvcMock.getInvoiceByInvoiceDocumentNumber(INVOICE_DOCUMENT_NUMBER)).thenReturn((Object)this.customerInvoiceDocumentMock);
        Mockito.when((Object)this.customerInvoiceDocumentSvcMock.checkIfInvoiceNumberIsFinal(INVOICE_DOCUMENT_NUMBER)).thenReturn((Object)true);
        Assertions.assertTrue((boolean)this.cutSpy.checkIfInvoiceNumberIsFinal(INVOICE_DOCUMENT_NUMBER));
        Assertions.assertFalse((boolean)GlobalVariables.getMessageMap().hasErrors());
    }

    @Test
    void checkIfInvoiceNumberIsFinal_validInvoiceNumberNotFinal_False() {
        Mockito.when((Object)this.customerInvoiceDocumentSvcMock.getInvoiceByInvoiceDocumentNumber(INVOICE_DOCUMENT_NUMBER)).thenReturn((Object)this.customerInvoiceDocumentMock);
        Mockito.when((Object)this.customerInvoiceDocumentSvcMock.checkIfInvoiceNumberIsFinal(INVOICE_DOCUMENT_NUMBER)).thenReturn((Object)false);
        Assertions.assertFalse((boolean)this.cutSpy.checkIfInvoiceNumberIsFinal(INVOICE_DOCUMENT_NUMBER));
        Assertions.assertEquals((int)1, (int)GlobalVariables.getMessageMap().getErrorCount());
        Assertions.assertTrue((boolean)GlobalVariables.getMessageMap().containsMessageKey("error.document.customerInvoiceDocument.notFinal"));
    }

    @Test
    void checkIfThereIsNoAnotherCRMInRouteForTheInvoice_NoOtherCRMsForInvoiceFound_True() {
        HashMap<String, String> fieldValues = new HashMap<String, String>();
        fieldValues.put("financialDocumentReferenceInvoiceNumber", INVOICE_DOCUMENT_NUMBER);
        Mockito.when((Object)this.businessObjectSvcMock.findMatching(CustomerCreditMemoDocument.class, fieldValues)).thenReturn(Collections.emptyList());
        Assertions.assertTrue((boolean)this.cutSpy.checkIfThereIsNoAnotherCRMInRouteForTheInvoice(INVOICE_DOCUMENT_NUMBER));
        Assertions.assertFalse((boolean)GlobalVariables.getMessageMap().hasErrors());
    }

    @Test
    void checkIfThereIsNoAnotherCRMInRouteForTheInvoice_OtherEnrouteCRMsForInvoiceFound_False(@Mock(stubOnly=true) CustomerCreditMemoDocument customerCreditMemoDocumentMock, @Mock(stubOnly=true) UserSession userSessionMock, @Mock(stubOnly=true) WorkflowDocument workflowDocumentMock) {
        this.setupUserSession(userSessionMock);
        ArrayList<CustomerCreditMemoDocument> mockCustomerCreditMemoDocuments = new ArrayList<CustomerCreditMemoDocument>();
        mockCustomerCreditMemoDocuments.add(CustomerCreditMemoDocumentRuleTest.createMockCustomerCreditMemoDocument(customerCreditMemoDocumentMock, "1000"));
        HashMap<String, String> fieldValues = new HashMap<String, String>();
        fieldValues.put("financialDocumentReferenceInvoiceNumber", INVOICE_DOCUMENT_NUMBER);
        Mockito.when((Object)this.businessObjectSvcMock.findMatching(CustomerCreditMemoDocument.class, fieldValues)).thenReturn(mockCustomerCreditMemoDocuments);
        ((CustomerCreditMemoDocumentRule)Mockito.doReturn((Object)workflowDocumentMock).when((Object)this.cutSpy)).loadWorkflowDocument(PRINCIPAL_ID, "1000");
        Assertions.assertFalse((boolean)this.cutSpy.checkIfThereIsNoAnotherCRMInRouteForTheInvoice(INVOICE_DOCUMENT_NUMBER));
        Assertions.assertEquals((int)1, (int)GlobalVariables.getMessageMap().getErrorCount());
        Assertions.assertTrue((boolean)GlobalVariables.getMessageMap().containsMessageKey("error.document.customerCreditMemoDocument.onlyOneCRMInRoutePerInvoice"));
    }

    @Test
    void checkIfThereIsNoAnotherCRMInRouteForTheInvoice_OtherNonEnrouteCRMsForInvoiceFound_True(@Mock(stubOnly=true) CustomerCreditMemoDocument customerCreditMemoDocument1Mock, @Mock(stubOnly=true) CustomerCreditMemoDocument customerCreditMemoDocument2Mock, @Mock(stubOnly=true) CustomerCreditMemoDocument customerCreditMemoDocument3Mock, @Mock(stubOnly=true) CustomerCreditMemoDocument customerCreditMemoDocument4Mock, @Mock(stubOnly=true) UserSession userSessionMock, @Mock(stubOnly=true) WorkflowDocument approvedWorkflowDocumentMock, @Mock(stubOnly=true) WorkflowDocument processedWorkflowDocumentMock, @Mock(stubOnly=true) WorkflowDocument cancelledWorkflowDocumentMock, @Mock(stubOnly=true) WorkflowDocument disapprovedWorkflowDocumentMock) {
        this.setupUserSession(userSessionMock);
        ArrayList<CustomerCreditMemoDocument> mockCustomerCreditMemoDocuments = new ArrayList<CustomerCreditMemoDocument>();
        mockCustomerCreditMemoDocuments.add(CustomerCreditMemoDocumentRuleTest.createMockCustomerCreditMemoDocument(customerCreditMemoDocument1Mock, "1001"));
        mockCustomerCreditMemoDocuments.add(CustomerCreditMemoDocumentRuleTest.createMockCustomerCreditMemoDocument(customerCreditMemoDocument2Mock, "1002"));
        mockCustomerCreditMemoDocuments.add(CustomerCreditMemoDocumentRuleTest.createMockCustomerCreditMemoDocument(customerCreditMemoDocument3Mock, "1003"));
        mockCustomerCreditMemoDocuments.add(CustomerCreditMemoDocumentRuleTest.createMockCustomerCreditMemoDocument(customerCreditMemoDocument4Mock, "1004"));
        HashMap<String, String> fieldValues = new HashMap<String, String>();
        fieldValues.put("financialDocumentReferenceInvoiceNumber", INVOICE_DOCUMENT_NUMBER);
        Mockito.when((Object)this.businessObjectSvcMock.findMatching(CustomerCreditMemoDocument.class, fieldValues)).thenReturn(mockCustomerCreditMemoDocuments);
        Mockito.when((Object)approvedWorkflowDocumentMock.isApproved()).thenReturn((Object)true);
        Mockito.when((Object)processedWorkflowDocumentMock.isProcessed()).thenReturn((Object)true);
        Mockito.when((Object)cancelledWorkflowDocumentMock.isCanceled()).thenReturn((Object)true);
        Mockito.when((Object)disapprovedWorkflowDocumentMock.isDisapproved()).thenReturn((Object)true);
        ((CustomerCreditMemoDocumentRule)Mockito.doReturn((Object)approvedWorkflowDocumentMock).when((Object)this.cutSpy)).loadWorkflowDocument(PRINCIPAL_ID, "1001");
        ((CustomerCreditMemoDocumentRule)Mockito.doReturn((Object)processedWorkflowDocumentMock).when((Object)this.cutSpy)).loadWorkflowDocument(PRINCIPAL_ID, "1002");
        ((CustomerCreditMemoDocumentRule)Mockito.doReturn((Object)cancelledWorkflowDocumentMock).when((Object)this.cutSpy)).loadWorkflowDocument(PRINCIPAL_ID, "1003");
        ((CustomerCreditMemoDocumentRule)Mockito.doReturn((Object)disapprovedWorkflowDocumentMock).when((Object)this.cutSpy)).loadWorkflowDocument(PRINCIPAL_ID, "1004");
        Assertions.assertTrue((boolean)this.cutSpy.checkIfThereIsNoAnotherCRMInRouteForTheInvoice(INVOICE_DOCUMENT_NUMBER));
        Assertions.assertFalse((boolean)GlobalVariables.getMessageMap().hasErrors());
    }

    private static CustomerCreditMemoDocument createMockCustomerCreditMemoDocument(CustomerCreditMemoDocument customerCreditMemoDocumentMock, String documentNumber) {
        Mockito.when((Object)customerCreditMemoDocumentMock.getDocumentNumber()).thenReturn((Object)documentNumber);
        return customerCreditMemoDocumentMock;
    }
}

