/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.ar.document.validation.impl;

import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.kuali.kfs.coa.service.AccountService;
import org.kuali.kfs.krad.util.GlobalVariables;
import org.kuali.kfs.module.ar.businessobject.CustomerInvoiceDetail;
import org.kuali.kfs.module.ar.document.CustomerInvoiceDocument;
import org.kuali.kfs.module.ar.document.validation.impl.CustomerInvoiceDetailUnitPriceValidation;
import org.kuali.kfs.module.ar.fixture.CustomerInvoiceDetailFixture;
import org.kuali.kfs.sys.context.SpringContext;
import org.mockito.Mock;
import org.mockito.MockedStatic;
import org.mockito.Mockito;
import org.mockito.junit.jupiter.MockitoExtension;

@ExtendWith(value={MockitoExtension.class})
class CustomerInvoiceDetailUnitPriceValidationTest {
    private final CustomerInvoiceDetailUnitPriceValidation cut = new CustomerInvoiceDetailUnitPriceValidation();
    @Mock
    private CustomerInvoiceDocument customerInvoiceDocumentMock;

    CustomerInvoiceDetailUnitPriceValidationTest() {
    }

    @BeforeEach
    void setUp() {
        GlobalVariables.getMessageMap().clearErrorMessages();
    }

    @AfterEach
    void tearDown() {
        GlobalVariables.getMessageMap().clearErrorMessages();
    }

    @Test
    void validate_UnitPriceNotEqualToZero() {
        try (MockedStatic springContextStaticMock = Mockito.mockStatic(SpringContext.class);){
            springContextStaticMock.when(() -> SpringContext.getBean(AccountService.class)).thenReturn(Mockito.mock(AccountService.class));
            CustomerInvoiceDetail customerInvoiceDetail = CustomerInvoiceDetailFixture.BASE_CUSTOMER_INVOICE_DETAIL.createCustomerInvoiceDetail();
            this.cut.setCustomerInvoiceDetail(customerInvoiceDetail);
            this.cut.setCustomerInvoiceDocument(this.customerInvoiceDocumentMock);
            Assertions.assertTrue((boolean)this.cut.validate(null));
        }
        Assertions.assertFalse((boolean)GlobalVariables.getMessageMap().hasErrors());
    }

    @Test
    void validate_UnitPriceEqualToZero() {
        try (MockedStatic springContextStaticMock = Mockito.mockStatic(SpringContext.class);){
            springContextStaticMock.when(() -> SpringContext.getBean(AccountService.class)).thenReturn(Mockito.mock(AccountService.class));
            CustomerInvoiceDetail customerInvoiceDetail = CustomerInvoiceDetailFixture.CUSTOMER_INVOICE_DETAIL_AMOUNT_EQUALS_ZERO.createCustomerInvoiceDetail();
            this.cut.setCustomerInvoiceDetail(customerInvoiceDetail);
            this.cut.setCustomerInvoiceDocument(this.customerInvoiceDocumentMock);
            Assertions.assertFalse((boolean)this.cut.validate(null));
        }
        Assertions.assertEquals((int)1, (int)GlobalVariables.getMessageMap().getErrorCount());
        Assertions.assertTrue((boolean)GlobalVariables.getMessageMap().containsMessageKey("error.document.customerInvoiceDocument.invalidCustomerInvoiceDetailUnitPrice"));
    }

    @Test
    void validate_UnitPricePositiveWhenReversalAndDiscount() {
        try (MockedStatic springContextStaticMock = Mockito.mockStatic(SpringContext.class);){
            springContextStaticMock.when(() -> SpringContext.getBean(AccountService.class)).thenReturn(Mockito.mock(AccountService.class));
            CustomerInvoiceDetail customerInvoiceDetail = CustomerInvoiceDetailFixture.CUSTOMER_INVOICE_DETAIL_DISCOUNT_WITH_POSITIVE_AMOUNT.createCustomerInvoiceDetail();
            Mockito.when((Object)this.customerInvoiceDocumentMock.isInvoiceReversal()).thenReturn((Object)true);
            this.cut.setCustomerInvoiceDetail(customerInvoiceDetail);
            this.cut.setCustomerInvoiceDocument(this.customerInvoiceDocumentMock);
            Assertions.assertTrue((boolean)this.cut.validate(null));
        }
        Assertions.assertFalse((boolean)GlobalVariables.getMessageMap().hasErrors());
    }

    @Test
    void validate_UnitPriceNegativeWhenReversalAndDiscount() {
        try (MockedStatic springContextStaticMock = Mockito.mockStatic(SpringContext.class);){
            springContextStaticMock.when(() -> SpringContext.getBean(AccountService.class)).thenReturn(Mockito.mock(AccountService.class));
            CustomerInvoiceDetail customerInvoiceDetail = CustomerInvoiceDetailFixture.CUSTOMER_INVOICE_DETAIL_DISCOUNT_WITH_NEGATIVE_AMOUNT.createCustomerInvoiceDetail();
            Mockito.when((Object)this.customerInvoiceDocumentMock.isInvoiceReversal()).thenReturn((Object)true);
            this.cut.setCustomerInvoiceDetail(customerInvoiceDetail);
            this.cut.setCustomerInvoiceDocument(this.customerInvoiceDocumentMock);
            Assertions.assertFalse((boolean)this.cut.validate(null));
        }
        Assertions.assertEquals((int)1, (int)GlobalVariables.getMessageMap().getErrorCount());
        Assertions.assertTrue((boolean)GlobalVariables.getMessageMap().containsMessageKey("error.document.customerInvoiceDocument.invalidCustomerInvoiceDetailUnitPrice"));
    }

    @Test
    void validate_UnitPriceNegativeWhenReversalAndNotDiscount() {
        try (MockedStatic springContextStaticMock = Mockito.mockStatic(SpringContext.class);){
            springContextStaticMock.when(() -> SpringContext.getBean(AccountService.class)).thenReturn(Mockito.mock(AccountService.class));
            CustomerInvoiceDetail customerInvoiceDetail = CustomerInvoiceDetailFixture.CUSTOMER_INVOICE_DETAIL_WITH_NEGATIVE_AMOUNT.createCustomerInvoiceDetail();
            Mockito.when((Object)this.customerInvoiceDocumentMock.isInvoiceReversal()).thenReturn((Object)true);
            this.cut.setCustomerInvoiceDetail(customerInvoiceDetail);
            this.cut.setCustomerInvoiceDocument(this.customerInvoiceDocumentMock);
            Assertions.assertTrue((boolean)this.cut.validate(null));
        }
        Assertions.assertFalse((boolean)GlobalVariables.getMessageMap().hasErrors());
    }

    @Test
    void validate_UnitPricePositiveWhenReversalAndNotDiscount() {
        try (MockedStatic springContextStaticMock = Mockito.mockStatic(SpringContext.class);){
            springContextStaticMock.when(() -> SpringContext.getBean(AccountService.class)).thenReturn(Mockito.mock(AccountService.class));
            CustomerInvoiceDetail customerInvoiceDetail = CustomerInvoiceDetailFixture.BASE_CUSTOMER_INVOICE_DETAIL.createCustomerInvoiceDetail();
            Mockito.when((Object)this.customerInvoiceDocumentMock.isInvoiceReversal()).thenReturn((Object)true);
            this.cut.setCustomerInvoiceDetail(customerInvoiceDetail);
            this.cut.setCustomerInvoiceDocument(this.customerInvoiceDocumentMock);
            Assertions.assertFalse((boolean)this.cut.validate(null));
        }
        Assertions.assertEquals((int)1, (int)GlobalVariables.getMessageMap().getErrorCount());
        Assertions.assertTrue((boolean)GlobalVariables.getMessageMap().containsMessageKey("error.document.customerInvoiceDocument.invalidCustomerInvoiceDetailUnitPrice"));
    }

    @Test
    void validate_UnitPricePositiveWhenNotReversalAndNotDiscount() {
        try (MockedStatic springContextStaticMock = Mockito.mockStatic(SpringContext.class);){
            springContextStaticMock.when(() -> SpringContext.getBean(AccountService.class)).thenReturn(Mockito.mock(AccountService.class));
            CustomerInvoiceDetail customerInvoiceDetail = CustomerInvoiceDetailFixture.BASE_CUSTOMER_INVOICE_DETAIL.createCustomerInvoiceDetail();
            this.cut.setCustomerInvoiceDetail(customerInvoiceDetail);
            this.cut.setCustomerInvoiceDocument(this.customerInvoiceDocumentMock);
            Assertions.assertTrue((boolean)this.cut.validate(null));
        }
        Assertions.assertFalse((boolean)GlobalVariables.getMessageMap().hasErrors());
    }

    @Test
    void validate_UnitPriceNegativeWhenNotReversalAndNotDiscount() {
        try (MockedStatic springContextStaticMock = Mockito.mockStatic(SpringContext.class);){
            springContextStaticMock.when(() -> SpringContext.getBean(AccountService.class)).thenReturn(Mockito.mock(AccountService.class));
            CustomerInvoiceDetail customerInvoiceDetail = CustomerInvoiceDetailFixture.CUSTOMER_INVOICE_DETAIL_WITH_NEGATIVE_AMOUNT.createCustomerInvoiceDetail();
            this.cut.setCustomerInvoiceDetail(customerInvoiceDetail);
            this.cut.setCustomerInvoiceDocument(this.customerInvoiceDocumentMock);
            Assertions.assertFalse((boolean)this.cut.validate(null));
        }
        Assertions.assertEquals((int)1, (int)GlobalVariables.getMessageMap().getErrorCount());
        Assertions.assertTrue((boolean)GlobalVariables.getMessageMap().containsMessageKey("error.document.customerInvoiceDocument.invalidCustomerInvoiceDetailUnitPrice"));
    }
}

