/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.ar.document.validation.impl;

import java.util.Calendar;
import java.util.Date;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.kuali.kfs.core.api.datetime.DateTimeService;
import org.kuali.kfs.coreservice.framework.parameter.ParameterService;
import org.kuali.kfs.krad.util.GlobalVariables;
import org.kuali.kfs.module.ar.document.CustomerInvoiceDocument;
import org.kuali.kfs.module.ar.document.validation.impl.CustomerInvoiceDueDateValidation;
import org.kuali.kfs.sys.businessobject.DocumentHeader;
import org.kuali.kfs.sys.service.ConfigurableDateService;
import org.kuali.kfs.sys.service.impl.ConfigurableDateTimeServiceImpl;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.jupiter.MockitoExtension;

@ExtendWith(value={MockitoExtension.class})
class CustomerInvoiceDueDateValidationTest {
    private CustomerInvoiceDueDateValidation cut;
    @Mock(stubOnly=true)
    private CustomerInvoiceDocument customerInvoiceDocumentMock;
    @Mock(stubOnly=true)
    private ParameterService parameterSvcMock;
    private ConfigurableDateService configurableDateService;

    CustomerInvoiceDueDateValidationTest() {
    }

    @BeforeEach
    void setUp() {
        Mockito.when((Object)this.customerInvoiceDocumentMock.getDocumentHeader()).thenReturn((Object)new DocumentHeader());
        this.configurableDateService = new ConfigurableDateTimeServiceImpl();
        this.cut = new CustomerInvoiceDueDateValidation();
        this.cut.setCustomerInvoiceDocument(this.customerInvoiceDocumentMock);
        this.cut.setDateTimeService((DateTimeService)this.configurableDateService);
        this.cut.setParameterService(this.parameterSvcMock);
        GlobalVariables.getMessageMap().clearErrorMessages();
    }

    @AfterEach
    void tearDown() {
        GlobalVariables.getMessageMap().clearErrorMessages();
    }

    @Test
    void validate_ValidBillingDateBeforeDueDate() {
        Mockito.when((Object)this.parameterSvcMock.getParameterValueAsString(CustomerInvoiceDocument.class, "DUE_DATE_DAYS")).thenReturn((Object)"90");
        Date billingDate = new Date();
        this.configurableDateService.setCurrentDate(billingDate);
        Calendar c = Calendar.getInstance();
        c.setTime(billingDate);
        c.add(5, 1);
        Date dueDateOneDayAfterBillingDate = c.getTime();
        Mockito.when((Object)this.customerInvoiceDocumentMock.getInvoiceDueDate()).thenReturn((Object)new java.sql.Date(dueDateOneDayAfterBillingDate.getTime()));
        Assertions.assertTrue((boolean)this.cut.validate(null));
        Assertions.assertFalse((boolean)GlobalVariables.getMessageMap().hasErrors());
    }

    @Test
    void validate_InvalidBillingDateEqualToOrAfterDueDate() {
        Date billingDate = new Date();
        this.configurableDateService.setCurrentDate(billingDate);
        Calendar c = Calendar.getInstance();
        c.setTime(billingDate);
        c.add(5, -1);
        Date dueDateOneDayBeforeBillingDate = c.getTime();
        Mockito.when((Object)this.customerInvoiceDocumentMock.getInvoiceDueDate()).thenReturn((Object)new java.sql.Date(dueDateOneDayBeforeBillingDate.getTime()));
        Assertions.assertFalse((boolean)this.cut.validate(null));
        Assertions.assertEquals((int)1, (int)GlobalVariables.getMessageMap().getErrorCount());
        Assertions.assertTrue((boolean)GlobalVariables.getMessageMap().containsMessageKey("error.document.customerInvoiceDocument.invalidInvoiceDueDateBeforeOrEqualBillingDate"));
        Mockito.when((Object)this.customerInvoiceDocumentMock.getInvoiceDueDate()).thenReturn((Object)new java.sql.Date(billingDate.getTime()));
        Assertions.assertFalse((boolean)this.cut.validate(null));
        Assertions.assertEquals((int)1, (int)GlobalVariables.getMessageMap().getErrorCount());
        Assertions.assertTrue((boolean)GlobalVariables.getMessageMap().containsMessageKey("error.document.customerInvoiceDocument.invalidInvoiceDueDateBeforeOrEqualBillingDate"));
    }

    @Test
    void validate_ValidBillingDateNotAfterMaximumNumberOfDays() {
        Mockito.when((Object)this.parameterSvcMock.getParameterValueAsString(CustomerInvoiceDocument.class, "DUE_DATE_DAYS")).thenReturn((Object)"90");
        Date billingDate = new Date();
        this.configurableDateService.setCurrentDate(billingDate);
        Calendar c = Calendar.getInstance();
        c.setTime(billingDate);
        c.add(5, 9);
        Date dueDateNineDaysAfterBillingDate = c.getTime();
        Mockito.when((Object)this.customerInvoiceDocumentMock.getInvoiceDueDate()).thenReturn((Object)new java.sql.Date(dueDateNineDaysAfterBillingDate.getTime()));
        Assertions.assertTrue((boolean)this.cut.validate(null));
        Assertions.assertFalse((boolean)GlobalVariables.getMessageMap().hasErrors());
    }

    @Test
    void validate_InvalidBillingDateEqualToOrAfterMaximumNumberOfDays() {
        Mockito.when((Object)this.parameterSvcMock.getParameterValueAsString(CustomerInvoiceDocument.class, "DUE_DATE_DAYS")).thenReturn((Object)"90");
        Date billingDate = new Date();
        this.configurableDateService.setCurrentDate(billingDate);
        Calendar c = Calendar.getInstance();
        c.setTime(billingDate);
        c.add(5, 90);
        Date dueDateNinetyDaysAfterBillingDate = c.getTime();
        Mockito.when((Object)this.customerInvoiceDocumentMock.getInvoiceDueDate()).thenReturn((Object)new java.sql.Date(dueDateNinetyDaysAfterBillingDate.getTime()));
        Assertions.assertFalse((boolean)this.cut.validate(null));
        c.add(5, 91);
        Date dueDateNinetyOneDaysAfterBillingDate = c.getTime();
        Mockito.when((Object)this.customerInvoiceDocumentMock.getInvoiceDueDate()).thenReturn((Object)new java.sql.Date(dueDateNinetyOneDaysAfterBillingDate.getTime()));
        Assertions.assertFalse((boolean)this.cut.validate(null));
        Assertions.assertEquals((int)1, (int)GlobalVariables.getMessageMap().getErrorCount());
        Assertions.assertTrue((boolean)GlobalVariables.getMessageMap().containsMessageKey("error.document.customerInvoiceDocument.invalidInvoiceDueDateMoreThanXDays"));
    }
}

