/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.ar.document.validation.impl;

import java.util.HashMap;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.kuali.kfs.core.api.util.type.KualiDecimal;
import org.kuali.kfs.coreservice.framework.parameter.ParameterService;
import org.kuali.kfs.krad.service.BusinessObjectService;
import org.kuali.kfs.krad.util.GlobalVariables;
import org.kuali.kfs.module.ar.businessobject.CustomerInvoiceDetail;
import org.kuali.kfs.module.ar.businessobject.OrganizationAccountingDefault;
import org.kuali.kfs.module.ar.document.CustomerInvoiceDocument;
import org.kuali.kfs.module.ar.document.CustomerInvoiceWriteoffDocument;
import org.kuali.kfs.module.ar.document.validation.impl.CustomerInvoiceWriteoffDocumentRule;
import org.kuali.kfs.sys.service.UniversityDateService;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.jupiter.MockitoExtension;

@ExtendWith(value={MockitoExtension.class})
class CustomerInvoiceWriteoffDocumentRuleTest {
    private static final String VALID_CHART_OF_ACCOUNTS_CODE_FOR_PARM = "BL";
    private static final String INVALID_CHART_OF_ACCOUNTS_CODE_FOR_PARM = "XX";
    private static final String CHART_WRITEOFF_PARM_VALUE = "BL=5105";
    private static final String ORG_ACCT_DEFAULT_CHART = "UA";
    private static final String ORG_ACCT_DEFAULT_ORG = "VPIT";
    private static final String ORG_ACCT_DEFAULT_WRITEOFF_ACCT = "1031400";
    private static final String ORG_ACCT_DEFAULT_WRITEOFF_CHART = "BL";
    private static final String ORG_ACCT_DEFAULT_WRITEOFF_OBJECT_CODE = "1500";
    private static final int FISCAL_YEAR = 2018;
    private CustomerInvoiceWriteoffDocumentRule cut;
    @Mock(stubOnly=true)
    private BusinessObjectService businessObjectSvcMock;
    @Mock(stubOnly=true)
    private ParameterService parameterSvcMock;
    @Mock(stubOnly=true)
    private UniversityDateService universityDateSvcMock;

    CustomerInvoiceWriteoffDocumentRuleTest() {
    }

    @BeforeEach
    void setUp() {
        GlobalVariables.getMessageMap().clearErrorMessages();
        this.cut = new CustomerInvoiceWriteoffDocumentRule();
        this.cut.setBusinessObjectService(this.businessObjectSvcMock);
        this.cut.setParameterService(this.parameterSvcMock);
        this.cut.setUniversityDateService(this.universityDateSvcMock);
    }

    @AfterEach
    void tearDown() {
        GlobalVariables.getMessageMap().clearErrorMessages();
    }

    @Test
    void doesChartCodeHaveCorrespondingWriteoffObjectCode_Valid() {
        Mockito.when((Object)this.parameterSvcMock.getSubParameterValueAsString(CustomerInvoiceWriteoffDocument.class, "OBJECT_CODES", "BL")).thenReturn((Object)CHART_WRITEOFF_PARM_VALUE);
        CustomerInvoiceDetail customerInvoiceDetail = new CustomerInvoiceDetail();
        customerInvoiceDetail.setChartOfAccountsCode("BL");
        Assertions.assertTrue((boolean)this.cut.doesChartCodeHaveCorrespondingWriteoffObjectCode(customerInvoiceDetail));
        Assertions.assertFalse((boolean)GlobalVariables.getMessageMap().hasErrors());
    }

    @Test
    void doesChartCodeHaveCorrespondingWriteoffObjectCode_Invalid() {
        CustomerInvoiceDetail customerInvoiceDetail = new CustomerInvoiceDetail();
        customerInvoiceDetail.setChartOfAccountsCode(INVALID_CHART_OF_ACCOUNTS_CODE_FOR_PARM);
        Assertions.assertFalse((boolean)this.cut.doesChartCodeHaveCorrespondingWriteoffObjectCode(customerInvoiceDetail));
        Assertions.assertEquals((int)1, (int)GlobalVariables.getMessageMap().getErrorCount());
        Assertions.assertTrue((boolean)GlobalVariables.getMessageMap().containsMessageKey("error.document.customerInvoiceWriteoff.chartWriteoffObjectDoesntExist"));
    }

    @Test
    void doesOrganizationAccountingDefaultHaveWriteoffInformation_Valid(@Mock(stubOnly=true) CustomerInvoiceWriteoffDocument customerInvoiceWriteoffDocMock, @Mock(stubOnly=true) CustomerInvoiceDocument customerInvoiceDocMock) {
        Mockito.when((Object)this.universityDateSvcMock.getCurrentFiscalYear()).thenReturn((Object)2018);
        this.setupOrganizationAccountingDefault(customerInvoiceWriteoffDocMock, customerInvoiceDocMock, true);
        Assertions.assertTrue((boolean)this.cut.doesOrganizationAccountingDefaultHaveWriteoffInformation(customerInvoiceWriteoffDocMock));
        Assertions.assertFalse((boolean)GlobalVariables.getMessageMap().hasErrors());
    }

    private void setupOrganizationAccountingDefault(CustomerInvoiceWriteoffDocument customerInvoiceWriteoffDocMock, CustomerInvoiceDocument customerInvoiceDocMock, boolean includeWriteoffInfo) {
        Mockito.when((Object)this.universityDateSvcMock.getCurrentFiscalYear()).thenReturn((Object)2018);
        Mockito.when((Object)customerInvoiceDocMock.getBillByChartOfAccountCode()).thenReturn((Object)ORG_ACCT_DEFAULT_CHART);
        Mockito.when((Object)customerInvoiceDocMock.getBilledByOrganizationCode()).thenReturn((Object)ORG_ACCT_DEFAULT_ORG);
        Mockito.when((Object)customerInvoiceWriteoffDocMock.getCustomerInvoiceDocument()).thenReturn((Object)customerInvoiceDocMock);
        OrganizationAccountingDefault organizationAccountingDefault = new OrganizationAccountingDefault();
        organizationAccountingDefault.setChartOfAccountsCode(ORG_ACCT_DEFAULT_CHART);
        organizationAccountingDefault.setOrganizationCode(ORG_ACCT_DEFAULT_ORG);
        organizationAccountingDefault.setUniversityFiscalYear(Integer.valueOf(2018));
        if (includeWriteoffInfo) {
            organizationAccountingDefault.setWriteoffAccountNumber(ORG_ACCT_DEFAULT_WRITEOFF_ACCT);
            organizationAccountingDefault.setWriteoffFinancialObjectCode(ORG_ACCT_DEFAULT_WRITEOFF_OBJECT_CODE);
            organizationAccountingDefault.setWriteoffChartOfAccountsCode("BL");
        }
        HashMap<String, Object> criteria = new HashMap<String, Object>();
        criteria.put("universityFiscalYear", 2018);
        criteria.put("chartOfAccountsCode", ORG_ACCT_DEFAULT_CHART);
        criteria.put("organizationCode", ORG_ACCT_DEFAULT_ORG);
        Mockito.when((Object)((OrganizationAccountingDefault)this.businessObjectSvcMock.findByPrimaryKey(OrganizationAccountingDefault.class, criteria))).thenReturn((Object)organizationAccountingDefault);
    }

    @Test
    void doesOrganizationAccountingDefaultHaveWriteoffInformation_NoOrgAccountingDefault_Invalid(@Mock(stubOnly=true) CustomerInvoiceWriteoffDocument customerInvoiceWriteoffDocMock, @Mock(stubOnly=true) CustomerInvoiceDocument customerInvoiceDocMock) {
        Mockito.when((Object)this.universityDateSvcMock.getCurrentFiscalYear()).thenReturn((Object)2018);
        Mockito.when((Object)customerInvoiceDocMock.getBillByChartOfAccountCode()).thenReturn((Object)ORG_ACCT_DEFAULT_CHART);
        Mockito.when((Object)customerInvoiceDocMock.getBilledByOrganizationCode()).thenReturn((Object)ORG_ACCT_DEFAULT_ORG);
        Mockito.when((Object)customerInvoiceWriteoffDocMock.getCustomerInvoiceDocument()).thenReturn((Object)customerInvoiceDocMock);
        Assertions.assertFalse((boolean)this.cut.doesOrganizationAccountingDefaultHaveWriteoffInformation(customerInvoiceWriteoffDocMock));
        Assertions.assertEquals((int)1, (int)GlobalVariables.getMessageMap().getErrorCount());
        Assertions.assertTrue((boolean)GlobalVariables.getMessageMap().containsMessageKey("error.document.customerInvoiceWriteoff.writeoffFAUMustExist"));
    }

    @Test
    void doesOrganizationAccountingDefaultHaveWriteoffInformation_NoWriteoffAccount_ObjectCode_Chart_Invalid(@Mock(stubOnly=true) CustomerInvoiceWriteoffDocument customerInvoiceWriteoffDocMock, @Mock(stubOnly=true) CustomerInvoiceDocument customerInvoiceDocMock) {
        Mockito.when((Object)this.universityDateSvcMock.getCurrentFiscalYear()).thenReturn((Object)2018);
        this.setupOrganizationAccountingDefault(customerInvoiceWriteoffDocMock, customerInvoiceDocMock, false);
        Assertions.assertFalse((boolean)this.cut.doesOrganizationAccountingDefaultHaveWriteoffInformation(customerInvoiceWriteoffDocMock));
        Assertions.assertEquals((int)3, (int)GlobalVariables.getMessageMap().getErrorCount());
        Assertions.assertTrue((boolean)GlobalVariables.getMessageMap().containsMessageKey("error.document.customerInvoiceWriteoff.chartWriteoffFAUAccountMustExist"));
        Assertions.assertTrue((boolean)GlobalVariables.getMessageMap().containsMessageKey("error.document.customerInvoiceWriteoff.chartWriteoffFAUChartMustExist"));
        Assertions.assertTrue((boolean)GlobalVariables.getMessageMap().containsMessageKey("error.document.customerInvoiceWriteoff.chartWriteoffFAUObjectMustExist"));
    }

    @Test
    void doesCustomerInvoiceDocumentHaveValidBalance_Valid(@Mock(stubOnly=true) CustomerInvoiceWriteoffDocument customerInvoiceWriteoffDocMock, @Mock(stubOnly=true) CustomerInvoiceDocument customerInvoiceDocMock) {
        Mockito.when((Object)customerInvoiceWriteoffDocMock.getCustomerInvoiceDocument()).thenReturn((Object)customerInvoiceDocMock);
        Mockito.when((Object)customerInvoiceDocMock.getOpenAmount()).thenReturn((Object)new KualiDecimal(1));
        Assertions.assertTrue((boolean)this.cut.doesCustomerInvoiceDocumentHaveValidBalance(customerInvoiceWriteoffDocMock));
        Assertions.assertFalse((boolean)GlobalVariables.getMessageMap().hasErrors());
    }

    @Test
    void doesCustomerInvoiceDocumentHaveValidBalance_Invalid(@Mock(stubOnly=true) CustomerInvoiceWriteoffDocument customerInvoiceWriteoffDocMock, @Mock(stubOnly=true) CustomerInvoiceDocument customerInvoiceDocMock) {
        Mockito.when((Object)customerInvoiceWriteoffDocMock.getCustomerInvoiceDocument()).thenReturn((Object)customerInvoiceDocMock);
        Mockito.when((Object)customerInvoiceDocMock.getOpenAmount()).thenReturn((Object)new KualiDecimal(-1));
        Assertions.assertFalse((boolean)this.cut.doesCustomerInvoiceDocumentHaveValidBalance(customerInvoiceWriteoffDocMock));
        Assertions.assertEquals((int)1, (int)GlobalVariables.getMessageMap().getErrorCount());
        Assertions.assertTrue((boolean)GlobalVariables.getMessageMap().containsMessageKey("error.document.customerInvoiceWriteoff.invoiceHasCreditBalance"));
    }
}

