/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.ar.document.validation.impl;

import java.sql.Date;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.kuali.kfs.coa.businessobject.AccountingPeriod;
import org.kuali.kfs.coa.service.AccountingPeriodService;
import org.kuali.kfs.core.api.datetime.DateTimeService;
import org.kuali.kfs.integration.cg.ContractsAndGrantsBillingAward;
import org.kuali.kfs.module.ar.ArConstants;
import org.kuali.kfs.module.ar.batch.service.VerifyBillingFrequencyService;
import org.kuali.kfs.module.ar.batch.service.impl.VerifyBillingFrequencyServiceImpl;
import org.kuali.kfs.module.ar.businessobject.BillingFrequency;
import org.kuali.kfs.module.ar.businessobject.InvoiceGeneralDetail;
import org.kuali.kfs.module.ar.document.ContractsGrantsInvoiceDocument;
import org.kuali.kfs.module.ar.document.validation.impl.InvoiceBillingPeriodSuspensionCategory;
import org.kuali.kfs.module.ar.fixture.BillingFrequencyFixture;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.jupiter.MockitoExtension;

@ExtendWith(value={MockitoExtension.class})
class InvoiceBillingPeriodSuspensionCategoryTest {
    private InvoiceBillingPeriodSuspensionCategory cut;
    @Mock(stubOnly=true)
    private ContractsGrantsInvoiceDocument contractsGrantsInvoiceDocumentMock;
    @Mock(stubOnly=true)
    private InvoiceGeneralDetail invoiceGeneralDetailMock;
    @Mock(stubOnly=true)
    private AccountingPeriodService accountingPeriodSvcMock;
    @Mock(stubOnly=true)
    private DateTimeService dateTimeSvcMock;

    InvoiceBillingPeriodSuspensionCategoryTest() {
    }

    @BeforeEach
    void setUp() {
        Mockito.when((Object)this.contractsGrantsInvoiceDocumentMock.getInvoiceGeneralDetail()).thenReturn((Object)this.invoiceGeneralDetailMock);
        VerifyBillingFrequencyServiceImpl verifyBillingFrequencySvcSpy = (VerifyBillingFrequencyServiceImpl)Mockito.spy((Object)new VerifyBillingFrequencyServiceImpl());
        verifyBillingFrequencySvcSpy.setAccountingPeriodService(this.accountingPeriodSvcMock);
        verifyBillingFrequencySvcSpy.setDateTimeService(this.dateTimeSvcMock);
        this.cut = new InvoiceBillingPeriodSuspensionCategory();
        this.cut.setAccountingPeriodService(this.accountingPeriodSvcMock);
        this.cut.setDateTimeService(this.dateTimeSvcMock);
        this.cut.setVerifyBillingFrequencyService((VerifyBillingFrequencyService)verifyBillingFrequencySvcSpy);
    }

    @Test
    void shouldSuspend_Annual_BillingDateIsAfterBilingPeriod_No(@Mock(stubOnly=true) ContractsAndGrantsBillingAward awardMock, @Mock(stubOnly=true) AccountingPeriod accountingPeriodMock_2009_12, @Mock(stubOnly=true) AccountingPeriod accountingPeriodMock_2010_12, @Mock(stubOnly=true) AccountingPeriod accountingPeriodMock_2011_12, @Mock(stubOnly=true) AccountingPeriod accountingPeriodMock_2012_01) {
        Mockito.when((Object)accountingPeriodMock_2009_12.getUniversityFiscalPeriodCode()).thenReturn((Object)"12");
        Mockito.when((Object)accountingPeriodMock_2009_12.getUniversityFiscalPeriodEndDate()).thenReturn((Object)Date.valueOf("2009-06-30"));
        Mockito.when((Object)accountingPeriodMock_2010_12.getUniversityFiscalPeriodCode()).thenReturn((Object)"12");
        Mockito.when((Object)accountingPeriodMock_2010_12.getUniversityFiscalYear()).thenReturn((Object)2010);
        Mockito.when((Object)accountingPeriodMock_2011_12.getUniversityFiscalPeriodCode()).thenReturn((Object)"12");
        Mockito.when((Object)accountingPeriodMock_2011_12.getUniversityFiscalPeriodEndDate()).thenReturn((Object)Date.valueOf("2011-06-30"));
        Mockito.when((Object)accountingPeriodMock_2012_01.getUniversityFiscalPeriodCode()).thenReturn((Object)"01");
        Mockito.when((Object)accountingPeriodMock_2012_01.getUniversityFiscalYear()).thenReturn((Object)2012);
        Mockito.when((Object)this.accountingPeriodSvcMock.getByDate(Date.valueOf("2010-06-30"))).thenReturn((Object)accountingPeriodMock_2010_12);
        Mockito.when((Object)this.accountingPeriodSvcMock.getByDate(Date.valueOf("2011-07-01"))).thenReturn((Object)accountingPeriodMock_2012_01);
        Mockito.when((Object)this.accountingPeriodSvcMock.getByPeriod("12", Integer.valueOf(2009))).thenReturn((Object)accountingPeriodMock_2009_12);
        Mockito.when((Object)this.accountingPeriodSvcMock.getByPeriod("12", Integer.valueOf(2011))).thenReturn((Object)accountingPeriodMock_2011_12);
        Date today = Date.valueOf("2011-07-01");
        Mockito.when((Object)this.dateTimeSvcMock.getCurrentSqlDate()).thenReturn((Object)today);
        Mockito.when((Object)this.invoiceGeneralDetailMock.getBillingFrequencyCode()).thenReturn((Object)ArConstants.BillingFrequencyValues.ANNUALLY.getCode());
        AccountingPeriod todayAccountPeriodMock = this.accountingPeriodSvcMock.getByDate(today);
        Mockito.when((Object)this.accountingPeriodSvcMock.getPreviousAccountingPeriod(todayAccountPeriodMock)).thenReturn((Object)accountingPeriodMock_2011_12);
        Mockito.when((Object)awardMock.getAwardBeginningDate()).thenReturn((Object)Date.valueOf("2011-01-01"));
        Mockito.when((Object)awardMock.getLastBilledDate()).thenReturn((Object)Date.valueOf("2010-06-30"));
        BillingFrequency billingFrequency = BillingFrequencyFixture.BILL_FREQ_ANNUALLY.createBillingFrequency();
        Mockito.when((Object)awardMock.getBillingFrequencyCode()).thenReturn((Object)billingFrequency.getFrequency());
        Mockito.when((Object)this.invoiceGeneralDetailMock.getAward()).thenReturn((Object)awardMock);
        Assertions.assertFalse((boolean)this.cut.shouldSuspend(this.contractsGrantsInvoiceDocumentMock));
    }

    @Test
    void shouldSuspend_Annual_BillingDateIsOneMonthAfterBilingPeriod_Yes(@Mock(stubOnly=true) ContractsAndGrantsBillingAward awardMock, @Mock(stubOnly=true) AccountingPeriod accountingPeriodMock_2009_12, @Mock(stubOnly=true) AccountingPeriod accountingPeriodMock_2010_12, @Mock(stubOnly=true) AccountingPeriod accountingPeriodMock_2011_12, @Mock(stubOnly=true) AccountingPeriod accountingPeriodMock_2012_01, @Mock(stubOnly=true) AccountingPeriod accountingPeriodMock_2012_02) {
        Mockito.when((Object)accountingPeriodMock_2009_12.getUniversityFiscalPeriodCode()).thenReturn((Object)"12");
        Mockito.when((Object)accountingPeriodMock_2009_12.getUniversityFiscalPeriodEndDate()).thenReturn((Object)Date.valueOf("2009-06-30"));
        Mockito.when((Object)accountingPeriodMock_2010_12.getUniversityFiscalPeriodCode()).thenReturn((Object)"12");
        Mockito.when((Object)accountingPeriodMock_2010_12.getUniversityFiscalYear()).thenReturn((Object)2010);
        Mockito.when((Object)accountingPeriodMock_2011_12.getUniversityFiscalPeriodCode()).thenReturn((Object)"12");
        Mockito.when((Object)accountingPeriodMock_2011_12.getUniversityFiscalPeriodEndDate()).thenReturn((Object)Date.valueOf("2011-06-30"));
        Mockito.when((Object)accountingPeriodMock_2012_01.getUniversityFiscalPeriodEndDate()).thenReturn((Object)Date.valueOf("2011-07-31"));
        Mockito.when((Object)accountingPeriodMock_2012_02.getUniversityFiscalPeriodCode()).thenReturn((Object)"02");
        Mockito.when((Object)accountingPeriodMock_2012_02.getUniversityFiscalYear()).thenReturn((Object)2012);
        Mockito.when((Object)this.accountingPeriodSvcMock.getByDate(Date.valueOf("2010-06-30"))).thenReturn((Object)accountingPeriodMock_2010_12);
        Mockito.when((Object)this.accountingPeriodSvcMock.getByDate(Date.valueOf("2011-08-20"))).thenReturn((Object)accountingPeriodMock_2012_02);
        Mockito.when((Object)this.accountingPeriodSvcMock.getByPeriod("12", Integer.valueOf(2009))).thenReturn((Object)accountingPeriodMock_2009_12);
        Mockito.when((Object)this.accountingPeriodSvcMock.getByPeriod("12", Integer.valueOf(2011))).thenReturn((Object)accountingPeriodMock_2011_12);
        Date today = Date.valueOf("2011-08-20");
        Mockito.when((Object)this.dateTimeSvcMock.getCurrentSqlDate()).thenReturn((Object)today);
        Mockito.when((Object)this.invoiceGeneralDetailMock.getBillingFrequencyCode()).thenReturn((Object)ArConstants.BillingFrequencyValues.ANNUALLY.getCode());
        AccountingPeriod todayAccountPeriodMock = this.accountingPeriodSvcMock.getByDate(today);
        Mockito.when((Object)this.accountingPeriodSvcMock.getPreviousAccountingPeriod(todayAccountPeriodMock)).thenReturn((Object)accountingPeriodMock_2012_01);
        Mockito.when((Object)awardMock.getAwardBeginningDate()).thenReturn((Object)Date.valueOf("2011-01-01"));
        Mockito.when((Object)awardMock.getLastBilledDate()).thenReturn((Object)Date.valueOf("2010-06-30"));
        BillingFrequency billingFrequency = BillingFrequencyFixture.BILL_FREQ_ANNUALLY.createBillingFrequency();
        Mockito.when((Object)awardMock.getBillingFrequencyCode()).thenReturn((Object)billingFrequency.getFrequency());
        Mockito.when((Object)this.invoiceGeneralDetailMock.getAward()).thenReturn((Object)awardMock);
        Assertions.assertTrue((boolean)this.cut.shouldSuspend(this.contractsGrantsInvoiceDocumentMock));
    }

    @Test
    void shouldSuspend_SemiAnnual_BillingDateIsAfterBilingPeriod_No(@Mock(stubOnly=true) ContractsAndGrantsBillingAward awardMock, @Mock(stubOnly=true) AccountingPeriod accountingPeriodMock_2011_06, @Mock(stubOnly=true) AccountingPeriod accountingPeriodMock_2011_12, @Mock(stubOnly=true) AccountingPeriod accountingPeriodMock_2012_06, @Mock(stubOnly=true) AccountingPeriod accountingPeriodMock_2012_07) {
        Mockito.when((Object)accountingPeriodMock_2011_06.getUniversityFiscalPeriodCode()).thenReturn((Object)"06");
        Mockito.when((Object)accountingPeriodMock_2011_06.getUniversityFiscalPeriodEndDate()).thenReturn((Object)Date.valueOf("2010-12-31"));
        Mockito.when((Object)accountingPeriodMock_2011_12.getUniversityFiscalPeriodCode()).thenReturn((Object)"12");
        Mockito.when((Object)accountingPeriodMock_2011_12.getUniversityFiscalYear()).thenReturn((Object)2011);
        Mockito.when((Object)accountingPeriodMock_2012_06.getUniversityFiscalPeriodCode()).thenReturn((Object)"06");
        Mockito.when((Object)accountingPeriodMock_2012_06.getUniversityFiscalPeriodEndDate()).thenReturn((Object)Date.valueOf("2011-12-31"));
        Mockito.when((Object)accountingPeriodMock_2012_07.getUniversityFiscalPeriodCode()).thenReturn((Object)"07");
        Mockito.when((Object)accountingPeriodMock_2012_07.getUniversityFiscalYear()).thenReturn((Object)2012);
        Mockito.when((Object)this.accountingPeriodSvcMock.getByDate(Date.valueOf("2011-06-30"))).thenReturn((Object)accountingPeriodMock_2011_12);
        Mockito.when((Object)this.accountingPeriodSvcMock.getByDate(Date.valueOf("2012-01-01"))).thenReturn((Object)accountingPeriodMock_2012_07);
        Mockito.when((Object)this.accountingPeriodSvcMock.getByPeriod("06", Integer.valueOf(2011))).thenReturn((Object)accountingPeriodMock_2011_06);
        Mockito.when((Object)this.accountingPeriodSvcMock.getByPeriod("06", Integer.valueOf(2012))).thenReturn((Object)accountingPeriodMock_2012_06);
        Date today = Date.valueOf("2012-01-01");
        Mockito.when((Object)this.dateTimeSvcMock.getCurrentSqlDate()).thenReturn((Object)today);
        Mockito.when((Object)this.invoiceGeneralDetailMock.getBillingFrequencyCode()).thenReturn((Object)ArConstants.BillingFrequencyValues.SEMI_ANNUALLY.getCode());
        AccountingPeriod todayAccountPeriodMock = this.accountingPeriodSvcMock.getByDate(today);
        Mockito.when((Object)this.accountingPeriodSvcMock.getPreviousAccountingPeriod(todayAccountPeriodMock)).thenReturn((Object)accountingPeriodMock_2012_06);
        Mockito.when((Object)awardMock.getAwardBeginningDate()).thenReturn((Object)Date.valueOf("2011-01-01"));
        Mockito.when((Object)awardMock.getLastBilledDate()).thenReturn((Object)Date.valueOf("2011-06-30"));
        BillingFrequency billingFrequency = BillingFrequencyFixture.BILL_FREQ_SEMI_ANN.createBillingFrequency();
        Mockito.when((Object)awardMock.getBillingFrequencyCode()).thenReturn((Object)billingFrequency.getFrequency());
        Mockito.when((Object)this.invoiceGeneralDetailMock.getAward()).thenReturn((Object)awardMock);
        Assertions.assertFalse((boolean)this.cut.shouldSuspend(this.contractsGrantsInvoiceDocumentMock));
    }

    @Test
    void shouldSuspend_SemiAnnual_BillingDateIsAfterBilingPeriod_Yes(@Mock(stubOnly=true) ContractsAndGrantsBillingAward awardMock, @Mock(stubOnly=true) AccountingPeriod accountingPeriodMock_2011_06, @Mock(stubOnly=true) AccountingPeriod accountingPeriodMock_2011_12, @Mock(stubOnly=true) AccountingPeriod accountingPeriodMock_2012_03, @Mock(stubOnly=true) AccountingPeriod accountingPeriodMock_2012_04) {
        Mockito.when((Object)accountingPeriodMock_2011_06.getUniversityFiscalPeriodCode()).thenReturn((Object)"06");
        Mockito.when((Object)accountingPeriodMock_2011_06.getUniversityFiscalPeriodEndDate()).thenReturn((Object)Date.valueOf("2010-12-31"));
        Mockito.when((Object)accountingPeriodMock_2011_12.getUniversityFiscalPeriodCode()).thenReturn((Object)"12");
        Mockito.when((Object)accountingPeriodMock_2011_12.getUniversityFiscalYear()).thenReturn((Object)2011);
        Mockito.when((Object)accountingPeriodMock_2011_12.getUniversityFiscalPeriodEndDate()).thenReturn((Object)Date.valueOf("2011-06-30"));
        Mockito.when((Object)accountingPeriodMock_2012_03.getUniversityFiscalPeriodEndDate()).thenReturn((Object)Date.valueOf("2011-09-30"));
        Mockito.when((Object)accountingPeriodMock_2012_04.getUniversityFiscalPeriodCode()).thenReturn((Object)"04");
        Mockito.when((Object)accountingPeriodMock_2012_04.getUniversityFiscalYear()).thenReturn((Object)2012);
        Mockito.when((Object)this.accountingPeriodSvcMock.getByDate(Date.valueOf("2011-06-30"))).thenReturn((Object)accountingPeriodMock_2011_12);
        Mockito.when((Object)this.accountingPeriodSvcMock.getByDate(Date.valueOf("2011-10-09"))).thenReturn((Object)accountingPeriodMock_2012_04);
        Mockito.when((Object)this.accountingPeriodSvcMock.getByPeriod("06", Integer.valueOf(2011))).thenReturn((Object)accountingPeriodMock_2011_06);
        Mockito.when((Object)this.accountingPeriodSvcMock.getByPeriod("12", Integer.valueOf(2011))).thenReturn((Object)accountingPeriodMock_2011_12);
        Date today = Date.valueOf("2011-10-09");
        Mockito.when((Object)this.dateTimeSvcMock.getCurrentSqlDate()).thenReturn((Object)today);
        Mockito.when((Object)this.invoiceGeneralDetailMock.getBillingFrequencyCode()).thenReturn((Object)ArConstants.BillingFrequencyValues.SEMI_ANNUALLY.getCode());
        AccountingPeriod todayAccountPeriodMock = this.accountingPeriodSvcMock.getByDate(today);
        Mockito.when((Object)this.accountingPeriodSvcMock.getPreviousAccountingPeriod(todayAccountPeriodMock)).thenReturn((Object)accountingPeriodMock_2012_03);
        Mockito.when((Object)awardMock.getAwardBeginningDate()).thenReturn((Object)Date.valueOf("2011-01-01"));
        Mockito.when((Object)awardMock.getLastBilledDate()).thenReturn((Object)Date.valueOf("2011-06-30"));
        BillingFrequency billingFrequency = BillingFrequencyFixture.BILL_FREQ_SEMI_ANN.createBillingFrequency();
        Mockito.when((Object)awardMock.getBillingFrequencyCode()).thenReturn((Object)billingFrequency.getFrequency());
        Mockito.when((Object)this.invoiceGeneralDetailMock.getAward()).thenReturn((Object)awardMock);
        Assertions.assertTrue((boolean)this.cut.shouldSuspend(this.contractsGrantsInvoiceDocumentMock));
    }

    @Test
    void shouldSuspend_Quarterly_BillingDateIsAfterBilingPeriod_No(@Mock(stubOnly=true) ContractsAndGrantsBillingAward awardMock, @Mock(stubOnly=true) AccountingPeriod accountingPeriodMock_2011_12, @Mock(stubOnly=true) AccountingPeriod accountingPeriodMock_2012_01) {
        Mockito.when((Object)accountingPeriodMock_2011_12.getUniversityFiscalPeriodEndDate()).thenReturn((Object)Date.valueOf("2011-06-30"));
        Mockito.when((Object)accountingPeriodMock_2012_01.getUniversityFiscalPeriodCode()).thenReturn((Object)"01");
        Mockito.when((Object)accountingPeriodMock_2012_01.getUniversityFiscalYear()).thenReturn((Object)2012);
        Mockito.when((Object)this.accountingPeriodSvcMock.getByDate(Date.valueOf("2011-07-01"))).thenReturn((Object)accountingPeriodMock_2012_01);
        Mockito.when((Object)this.accountingPeriodSvcMock.getByPeriod("12", Integer.valueOf(2011))).thenReturn((Object)accountingPeriodMock_2011_12);
        Date today = Date.valueOf("2011-07-01");
        Mockito.when((Object)this.dateTimeSvcMock.getCurrentSqlDate()).thenReturn((Object)today);
        Mockito.when((Object)this.invoiceGeneralDetailMock.getBillingFrequencyCode()).thenReturn((Object)ArConstants.BillingFrequencyValues.QUARTERLY.getCode());
        AccountingPeriod todayAccountPeriodMock = this.accountingPeriodSvcMock.getByDate(today);
        Mockito.when((Object)this.accountingPeriodSvcMock.getPreviousAccountingPeriod(todayAccountPeriodMock)).thenReturn((Object)accountingPeriodMock_2011_12);
        Mockito.when((Object)awardMock.getAwardBeginningDate()).thenReturn((Object)Date.valueOf("2011-01-01"));
        BillingFrequency billingFrequency = BillingFrequencyFixture.BILL_FREQ_QUAR.createBillingFrequency();
        Mockito.when((Object)awardMock.getBillingFrequencyCode()).thenReturn((Object)billingFrequency.getFrequency());
        Mockito.when((Object)this.invoiceGeneralDetailMock.getAward()).thenReturn((Object)awardMock);
        Assertions.assertFalse((boolean)this.cut.shouldSuspend(this.contractsGrantsInvoiceDocumentMock));
    }

    @Test
    void shouldSuspend_Quarterly_BillingDateIsAfterBilingPeriod_Yes(@Mock(stubOnly=true) ContractsAndGrantsBillingAward awardMock, @Mock(stubOnly=true) AccountingPeriod accountingPeriodMock_2011_12, @Mock(stubOnly=true) AccountingPeriod accountingPeriodMock_2012_01, @Mock(stubOnly=true) AccountingPeriod accountingPeriodMock_2012_02) {
        Mockito.when((Object)accountingPeriodMock_2011_12.getUniversityFiscalPeriodEndDate()).thenReturn((Object)Date.valueOf("2011-06-30"));
        Mockito.when((Object)accountingPeriodMock_2012_01.getUniversityFiscalPeriodEndDate()).thenReturn((Object)Date.valueOf("2011-07-31"));
        Mockito.when((Object)accountingPeriodMock_2012_02.getUniversityFiscalPeriodCode()).thenReturn((Object)"02");
        Mockito.when((Object)accountingPeriodMock_2012_02.getUniversityFiscalYear()).thenReturn((Object)2012);
        Mockito.when((Object)this.accountingPeriodSvcMock.getByDate(Date.valueOf("2011-08-20"))).thenReturn((Object)accountingPeriodMock_2012_02);
        Mockito.when((Object)this.accountingPeriodSvcMock.getByPeriod("12", Integer.valueOf(2011))).thenReturn((Object)accountingPeriodMock_2011_12);
        Date today = Date.valueOf("2011-08-20");
        Mockito.when((Object)this.dateTimeSvcMock.getCurrentSqlDate()).thenReturn((Object)today);
        Mockito.when((Object)this.invoiceGeneralDetailMock.getBillingFrequencyCode()).thenReturn((Object)ArConstants.BillingFrequencyValues.QUARTERLY.getCode());
        AccountingPeriod todayAccountPeriodMock = this.accountingPeriodSvcMock.getByDate(today);
        Mockito.when((Object)this.accountingPeriodSvcMock.getPreviousAccountingPeriod(todayAccountPeriodMock)).thenReturn((Object)accountingPeriodMock_2012_01);
        Mockito.when((Object)awardMock.getAwardBeginningDate()).thenReturn((Object)Date.valueOf("2011-01-01"));
        BillingFrequency billingFrequency = BillingFrequencyFixture.BILL_FREQ_QUAR.createBillingFrequency();
        Mockito.when((Object)awardMock.getBillingFrequencyCode()).thenReturn((Object)billingFrequency.getFrequency());
        Mockito.when((Object)this.invoiceGeneralDetailMock.getAward()).thenReturn((Object)awardMock);
        Assertions.assertTrue((boolean)this.cut.shouldSuspend(this.contractsGrantsInvoiceDocumentMock));
    }

    @Test
    void shouldSuspend_PredeterminedBilling_No(@Mock(stubOnly=true) ContractsAndGrantsBillingAward awardMock) {
        Mockito.when((Object)this.invoiceGeneralDetailMock.getBillingFrequencyCode()).thenReturn((Object)ArConstants.BillingFrequencyValues.PREDETERMINED_BILLING.getCode());
        Mockito.when((Object)this.invoiceGeneralDetailMock.getAward()).thenReturn((Object)awardMock);
        Assertions.assertFalse((boolean)this.cut.shouldSuspend(this.contractsGrantsInvoiceDocumentMock));
    }

    @Test
    void shouldSuspend_Monthly_No(@Mock(stubOnly=true) ContractsAndGrantsBillingAward awardMock) {
        Mockito.when((Object)this.invoiceGeneralDetailMock.getBillingFrequencyCode()).thenReturn((Object)ArConstants.BillingFrequencyValues.MONTHLY.getCode());
        Mockito.when((Object)this.invoiceGeneralDetailMock.getAward()).thenReturn((Object)awardMock);
        Assertions.assertFalse((boolean)this.cut.shouldSuspend(this.contractsGrantsInvoiceDocumentMock));
    }

    @Test
    void shouldSuspend_Milestone_No(@Mock(stubOnly=true) ContractsAndGrantsBillingAward awardMock) {
        Mockito.when((Object)this.invoiceGeneralDetailMock.getBillingFrequencyCode()).thenReturn((Object)ArConstants.BillingFrequencyValues.MILESTONE.getCode());
        Mockito.when((Object)this.invoiceGeneralDetailMock.getAward()).thenReturn((Object)awardMock);
        Assertions.assertFalse((boolean)this.cut.shouldSuspend(this.contractsGrantsInvoiceDocumentMock));
    }
}

