/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.ar.document.validation.impl;

import java.util.HashMap;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.junit.jupiter.api.parallel.Execution;
import org.junit.jupiter.api.parallel.ExecutionMode;
import org.kuali.kfs.krad.service.BusinessObjectService;
import org.kuali.kfs.module.ar.businessobject.MilestoneSchedule;
import org.kuali.kfs.module.ar.document.validation.impl.MilestoneScheduleRuleUtil;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.jupiter.MockitoExtension;

@Execution(value=ExecutionMode.SAME_THREAD)
@ExtendWith(value={MockitoExtension.class})
class MilestoneScheduleRuleUtilTest {
    @Mock(stubOnly=true)
    private BusinessObjectService businessObjectSvcMock;

    MilestoneScheduleRuleUtilTest() {
    }

    @BeforeEach
    void setUp() throws Exception {
        MilestoneScheduleRuleUtil.setBusinessObjectService((BusinessObjectService)this.businessObjectSvcMock);
    }

    @Test
    void checkIfMilestonesExists_NullMilestoneSchedule() {
        Assertions.assertFalse((boolean)MilestoneScheduleRuleUtil.checkIfMilestonesExists(null));
    }

    @Test
    void checkIfMilestonesExists_MissingMilestoneSchedule() {
        MilestoneSchedule milestoneSchedule = new MilestoneSchedule();
        Assertions.assertFalse((boolean)MilestoneScheduleRuleUtil.checkIfMilestonesExists((MilestoneSchedule)milestoneSchedule));
    }

    @Test
    void checkIfMilestonesExists_ValidMilestoneSchedule() {
        String proposalNumber = "39928";
        String chartCode = "BL";
        String accountNumber = "1031400";
        MilestoneSchedule milestoneSchedule1 = new MilestoneSchedule();
        milestoneSchedule1.setProposalNumber("39928");
        milestoneSchedule1.setChartOfAccountsCode("BL");
        milestoneSchedule1.setAccountNumber("1031400");
        milestoneSchedule1.setObjectId("a different objectId");
        HashMap<String, String> primaryKeys = new HashMap<String, String>();
        primaryKeys.put("proposalNumber", "39928");
        primaryKeys.put("chartOfAccountsCode", "BL");
        primaryKeys.put("accountNumber", "1031400");
        Mockito.when((Object)((MilestoneSchedule)this.businessObjectSvcMock.findByPrimaryKey(MilestoneSchedule.class, primaryKeys))).thenReturn((Object)milestoneSchedule1);
        MilestoneSchedule milestoneSchedule = new MilestoneSchedule();
        milestoneSchedule.setProposalNumber("39928");
        milestoneSchedule.setChartOfAccountsCode("BL");
        milestoneSchedule.setAccountNumber("1031400");
        milestoneSchedule.setObjectId("objectId");
        Assertions.assertTrue((boolean)MilestoneScheduleRuleUtil.checkIfMilestonesExists((MilestoneSchedule)milestoneSchedule));
    }
}

