/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.ar.document.validation.impl;

import java.util.HashMap;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.junit.jupiter.api.parallel.Execution;
import org.junit.jupiter.api.parallel.ExecutionMode;
import org.kuali.kfs.krad.service.BusinessObjectService;
import org.kuali.kfs.module.ar.businessobject.PredeterminedBillingSchedule;
import org.kuali.kfs.module.ar.document.validation.impl.PredeterminedBillingScheduleRuleUtil;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.jupiter.MockitoExtension;

@Execution(value=ExecutionMode.SAME_THREAD)
@ExtendWith(value={MockitoExtension.class})
class PredeterminedBillingScheduleRuleUtilTest {
    @Mock(stubOnly=true)
    private BusinessObjectService businessObjectSvcMock;

    PredeterminedBillingScheduleRuleUtilTest() {
    }

    @BeforeEach
    void setUp() throws Exception {
        PredeterminedBillingScheduleRuleUtil.setBusinessObjectService((BusinessObjectService)this.businessObjectSvcMock);
    }

    @Test
    void checkIfBillsExist_NullPredeterminedBillingSchedule() {
        Assertions.assertFalse((boolean)PredeterminedBillingScheduleRuleUtil.checkIfBillsExist(null));
    }

    @Test
    void checkIfBillsExist_MissingPredeterminedBillingSchedule() {
        PredeterminedBillingSchedule predeterminedBillingSchedule = new PredeterminedBillingSchedule();
        Assertions.assertFalse((boolean)PredeterminedBillingScheduleRuleUtil.checkIfBillsExist((PredeterminedBillingSchedule)predeterminedBillingSchedule));
    }

    @Test
    void checkIfBillsExist_ValidPredeterminedBillingSchedule() {
        String proposalNumber = "39928";
        String chartCode = "BL";
        String accountNumber = "1031400";
        PredeterminedBillingSchedule predeterminedBillingSchedule1 = new PredeterminedBillingSchedule();
        predeterminedBillingSchedule1.setProposalNumber("39928");
        predeterminedBillingSchedule1.setChartOfAccountsCode("BL");
        predeterminedBillingSchedule1.setAccountNumber("1031400");
        predeterminedBillingSchedule1.setObjectId("a different objectId");
        HashMap<String, String> primaryKeys = new HashMap<String, String>();
        primaryKeys.put("proposalNumber", "39928");
        primaryKeys.put("chartOfAccountsCode", "BL");
        primaryKeys.put("accountNumber", "1031400");
        Mockito.when((Object)((PredeterminedBillingSchedule)this.businessObjectSvcMock.findByPrimaryKey(PredeterminedBillingSchedule.class, primaryKeys))).thenReturn((Object)predeterminedBillingSchedule1);
        PredeterminedBillingSchedule predeterminedBillingSchedule2 = new PredeterminedBillingSchedule();
        predeterminedBillingSchedule2.setProposalNumber("39928");
        predeterminedBillingSchedule2.setChartOfAccountsCode("BL");
        predeterminedBillingSchedule2.setAccountNumber("1031400");
        predeterminedBillingSchedule2.setObjectId("objectId");
        Assertions.assertTrue((boolean)PredeterminedBillingScheduleRuleUtil.checkIfBillsExist((PredeterminedBillingSchedule)predeterminedBillingSchedule2));
    }
}

