/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.ar.report.service.impl;

import java.text.ParseException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.kuali.kfs.integration.cg.ContractsAndGrantsBillingAward;
import org.kuali.kfs.kim.impl.identity.Person;
import org.kuali.kfs.krad.UserSession;
import org.kuali.kfs.krad.service.LookupService;
import org.kuali.kfs.module.ar.businessobject.Customer;
import org.kuali.kfs.module.ar.businessobject.InvoiceGeneralDetail;
import org.kuali.kfs.module.ar.document.ContractsGrantsInvoiceDocument;
import org.kuali.kfs.module.ar.document.service.ContractsGrantsInvoiceDocumentService;
import org.kuali.kfs.module.ar.report.service.ContractsGrantsReportHelperService;
import org.kuali.kfs.module.ar.report.service.impl.ContractsGrantsAgingReportServiceImpl;
import org.kuali.kfs.sys.businessobject.DocumentHeader;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.Spy;
import org.mockito.junit.jupiter.MockitoExtension;

@ExtendWith(value={MockitoExtension.class})
class ContractsGrantsAgingReportServiceImplTest {
    private static final String CUSTOMER_NUMBER = "ABB2";
    private static final String CUSTOMER_NAME = "WOODS CORPORATION";
    private static final String NON_MATCHING_CUSTOMER_NUMBER = "XXXX";
    @Mock(stubOnly=true)
    private ContractsGrantsInvoiceDocumentService contractsGrantsInvoiceDocumentSvcMock;
    @Mock(stubOnly=true)
    private ContractsGrantsReportHelperService contractsGrantsReportHelperSvcMock;
    @Mock(stubOnly=true)
    private LookupService lookupSvcMock;
    @Spy
    private ContractsGrantsAgingReportServiceImpl cutSpy;

    ContractsGrantsAgingReportServiceImplTest() {
    }

    @BeforeEach
    void setUp() {
        this.cutSpy.setContractsGrantsInvoiceDocumentService(this.contractsGrantsInvoiceDocumentSvcMock);
        this.cutSpy.setContractsGrantsReportHelperService(this.contractsGrantsReportHelperSvcMock);
        this.cutSpy.setLookupService(this.lookupSvcMock);
    }

    @Test
    void filterContractsGrantsAgingReport(@Mock(stubOnly=true) ContractsAndGrantsBillingAward awardMock, @Mock(stubOnly=true) ContractsGrantsInvoiceDocument contractsGrantsInvoiceDocumentMock, @Mock(stubOnly=true) Customer customerMock, @Mock(stubOnly=true) InvoiceGeneralDetail invoiceGeneralDetailMock, @Mock(stubOnly=true) Person personMock, @Mock(stubOnly=true) UserSession userSessionMock) throws ParseException {
        Mockito.when((Object)userSessionMock.getPerson()).thenReturn((Object)personMock);
        ((ContractsGrantsAgingReportServiceImpl)Mockito.doReturn((Object)userSessionMock).when((Object)this.cutSpy)).getUserSession();
        DocumentHeader documentHeader = new DocumentHeader();
        documentHeader.setFinancialDocumentStatusCode("A");
        Mockito.when((Object)contractsGrantsInvoiceDocumentMock.getDocumentNumber()).thenReturn((Object)"12345");
        Mockito.when((Object)customerMock.getCustomerNumber()).thenReturn((Object)CUSTOMER_NUMBER);
        Mockito.when((Object)customerMock.getCustomerName()).thenReturn((Object)CUSTOMER_NAME);
        Mockito.when((Object)contractsGrantsInvoiceDocumentMock.getCustomer()).thenReturn((Object)customerMock);
        Mockito.when((Object)invoiceGeneralDetailMock.getAward()).thenReturn((Object)awardMock);
        Mockito.when((Object)contractsGrantsInvoiceDocumentMock.getInvoiceGeneralDetail()).thenReturn((Object)invoiceGeneralDetailMock);
        HashMap<String, String> formProps = new HashMap<String, String>();
        formProps.put("accountsReceivableDocumentHeader.customerNumber", CUSTOMER_NUMBER);
        formProps.put("documentHeader.workflowDocumentTypeName", "CINV");
        formProps.put("openInvoiceIndicator", "true");
        ArrayList<ContractsGrantsInvoiceDocument> invoices = new ArrayList<ContractsGrantsInvoiceDocument>();
        invoices.add(contractsGrantsInvoiceDocumentMock);
        Mockito.when((Object)this.lookupSvcMock.findCollectionBySearch(ContractsGrantsInvoiceDocument.class, formProps)).thenReturn(invoices);
        Mockito.when((Object)this.contractsGrantsInvoiceDocumentSvcMock.canViewInvoice(contractsGrantsInvoiceDocumentMock, null)).thenReturn((Object)true);
        HashMap<String, String> fieldValues = new HashMap<String, String>();
        fieldValues.put("customerNumber", CUSTOMER_NUMBER);
        Map customerMap = this.cutSpy.filterContractsGrantsAgingReport(fieldValues, null, null);
        Assertions.assertNotNull((Object)customerMap);
        List invoices2 = (List)customerMap.get("ABB2-WOODS CORPORATION");
        Assertions.assertNotNull((Object)invoices2);
        Assertions.assertEquals((int)1, (int)invoices2.size());
        ContractsGrantsInvoiceDocument contractsGrantsInvoiceDocument = (ContractsGrantsInvoiceDocument)invoices2.get(0);
        Assertions.assertNotNull((Object)contractsGrantsInvoiceDocument);
        Assertions.assertEquals((Object)"12345", (Object)contractsGrantsInvoiceDocument.getDocumentNumber());
    }

    @Test
    void filterContractsGrantsAgingReport_NoMatchingCustomers(@Mock(stubOnly=true) Person personMock, @Mock(stubOnly=true) UserSession userSessionMock) throws ParseException {
        Mockito.when((Object)userSessionMock.getPerson()).thenReturn((Object)personMock);
        ((ContractsGrantsAgingReportServiceImpl)Mockito.doReturn((Object)userSessionMock).when((Object)this.cutSpy)).getUserSession();
        DocumentHeader documentHeader = new DocumentHeader();
        documentHeader.setFinancialDocumentStatusCode("A");
        HashMap<String, String> fieldValues = new HashMap<String, String>();
        fieldValues.put("customerNumber", NON_MATCHING_CUSTOMER_NUMBER);
        Map customerMap = this.cutSpy.filterContractsGrantsAgingReport(fieldValues, null, null);
        Assertions.assertNull((Object)customerMap);
    }
}

