/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.ar.rest.resource.requests;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.json.JsonMapper;
import java.util.List;
import java.util.stream.Stream;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.DisplayName;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.MethodSource;
import org.kuali.kfs.module.ar.rest.resource.requests.InvoiceApplicationDetailTest;
import org.kuali.kfs.module.ar.rest.resource.requests.PaymentApplicationAdjustmentRequest;

class InvoiceApplicationTest {
    static final String CUSTOMER_NUMBER = "CN";
    static final String DOCUMENT_NUMBER = "DN";
    static final String CUT_AS_JSON = "{    \"customerNumber\": \"CN\",    \"documentNumber\": \"DN\",    \"detailApplications\": [" + InvoiceApplicationDetailTest.CUT_AS_JSON + "    ]}";
    private static final JsonMapper MAPPER = new JsonMapper();
    private final PaymentApplicationAdjustmentRequest.InvoiceApplicationDetail detailApplication = new PaymentApplicationAdjustmentRequest.InvoiceApplicationDetail(InvoiceApplicationDetailTest.AMOUNT_APPLIED, InvoiceApplicationDetailTest.SEQUENCE_NUMBER);
    private final PaymentApplicationAdjustmentRequest.InvoiceApplication cut = new PaymentApplicationAdjustmentRequest.InvoiceApplication("CN", "DN", List.of(this.detailApplication));

    InvoiceApplicationTest() {
    }

    @DisplayName(value="Given valid JSON, it should be deserialized to the equivalent instance")
    @ParameterizedTest(name="requestJson = {0}")
    @MethodSource(value={"deserializeValidArgs"})
    void deserialize_valid(String requestJson) throws Exception {
        PaymentApplicationAdjustmentRequest.InvoiceApplication actual = (PaymentApplicationAdjustmentRequest.InvoiceApplication)MAPPER.readValue(requestJson, PaymentApplicationAdjustmentRequest.InvoiceApplication.class);
        Assertions.assertEquals((Object)this.cut, (Object)actual);
    }

    private static Stream<Arguments> deserializeValidArgs() {
        String withUnknown = "{    \"unknown\": \"unknown\"," + CUT_AS_JSON.substring(1);
        return Stream.of(Arguments.of((Object[])new Object[]{CUT_AS_JSON}), Arguments.of((Object[])new Object[]{withUnknown}));
    }

    @DisplayName(value="Given invalid JSON, deserialization should fail")
    @ParameterizedTest(name="requestJson = {0}")
    @MethodSource(value={"deserializeInvalidArgs"})
    void deserialize_invalid(String requestJson) {
        Assertions.assertThrows(JsonProcessingException.class, () -> MAPPER.readValue(requestJson, PaymentApplicationAdjustmentRequest.InvoiceApplication.class));
    }

    private static Stream<Arguments> deserializeInvalidArgs() {
        String missingCustomerNumber1 = "{    \"documentNumber\": \"DN\",    \"detailApplications\": [" + InvoiceApplicationDetailTest.CUT_AS_JSON + "    ]}";
        String missingCustomerNumber2 = "{    \"customerNumber\": ,    \"documentNumber\": \"DN\",    \"detailApplications\": [" + InvoiceApplicationDetailTest.CUT_AS_JSON + "    ]}";
        String missingCustomerNumber3 = "{    \"customerNumber\": \"\",    \"documentNumber\": \"DN\",    \"detailApplications\": [" + InvoiceApplicationDetailTest.CUT_AS_JSON + "    ]}";
        String missingCustomerNumber4 = "{    \"customerNumber\": \" \",    \"documentNumber\": \"DN\",    \"detailApplications\": [" + InvoiceApplicationDetailTest.CUT_AS_JSON + "    ]}";
        String missingCustomerNumber5 = "{    \"customerNumber\": null,    \"documentNumber\": \"DN\",    \"detailApplications\": [" + InvoiceApplicationDetailTest.CUT_AS_JSON + "    ]}";
        String missingDocumentNumber1 = "{    \"customerNumber\": \"CN\",    \"detailApplications\": [" + InvoiceApplicationDetailTest.CUT_AS_JSON + "    ]}";
        String missingDocumentNumber2 = "{    \"customerNumber\": \"CN\",    \"documentNumber\": ,    \"detailApplications\": [" + InvoiceApplicationDetailTest.CUT_AS_JSON + "    ]}";
        String missingDocumentNumber3 = "{    \"customerNumber\": \"CN\",    \"documentNumber\": \"\",    \"detailApplications\": [" + InvoiceApplicationDetailTest.CUT_AS_JSON + "    ]}";
        String missingDocumentNumber4 = "{    \"customerNumber\": \"CN\",    \"documentNumber\": \" \",    \"detailApplications\": [" + InvoiceApplicationDetailTest.CUT_AS_JSON + "    ]}";
        String missingDocumentNumber5 = "{    \"customerNumber\": \"CN\",    \"documentNumber\": null,    \"detailApplications\": [" + InvoiceApplicationDetailTest.CUT_AS_JSON + "    ]}";
        String missingDetailApplications1 = "{    \"customerNumber\": \"CN\",    \"documentNumber\": \"DN\"}";
        String missingDetailApplications2 = "{    \"customerNumber\": \"CN\",    \"documentNumber\": \"DN\",    \"detailApplications\": null}";
        String missingDetailApplications3 = "{    \"customerNumber\": \"CN\",    \"documentNumber\": \"DN\",    \"detailApplications\": [    ]}";
        return Stream.of(Arguments.of((Object[])new Object[]{missingCustomerNumber1}), Arguments.of((Object[])new Object[]{missingCustomerNumber2}), Arguments.of((Object[])new Object[]{missingCustomerNumber3}), Arguments.of((Object[])new Object[]{missingCustomerNumber4}), Arguments.of((Object[])new Object[]{missingCustomerNumber5}), Arguments.of((Object[])new Object[]{missingDocumentNumber1}), Arguments.of((Object[])new Object[]{missingDocumentNumber2}), Arguments.of((Object[])new Object[]{missingDocumentNumber3}), Arguments.of((Object[])new Object[]{missingDocumentNumber4}), Arguments.of((Object[])new Object[]{missingDocumentNumber5}), Arguments.of((Object[])new Object[]{"{    \"customerNumber\": \"CN\",    \"documentNumber\": \"DN\"}"}), Arguments.of((Object[])new Object[]{"{    \"customerNumber\": \"CN\",    \"documentNumber\": \"DN\",    \"detailApplications\": null}"}), Arguments.of((Object[])new Object[]{"{    \"customerNumber\": \"CN\",    \"documentNumber\": \"DN\",    \"detailApplications\": [    ]}"}));
    }
}

