/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.ar.service;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.kuali.kfs.core.api.util.type.KualiDecimal;
import org.kuali.kfs.krad.service.BusinessObjectService;
import org.kuali.kfs.module.ar.businessobject.Bill;
import org.kuali.kfs.module.ar.businessobject.Milestone;
import org.kuali.kfs.module.ar.businessobject.MilestoneSchedule;
import org.kuali.kfs.module.ar.businessobject.PredeterminedBillingSchedule;
import org.kuali.kfs.module.ar.service.impl.AccountsReceivableModuleBillingServiceImpl;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.jupiter.MockitoExtension;

@ExtendWith(value={MockitoExtension.class})
class AccountsReceivableModuleBillingServiceTest {
    private final AccountsReceivableModuleBillingServiceImpl cut = new AccountsReceivableModuleBillingServiceImpl();

    AccountsReceivableModuleBillingServiceTest() {
    }

    private void setupMilestoneSchedule(BusinessObjectService businessObjectServiceMock, String proposalNumber, String chartOfAccountsCode, String accountNumber, boolean billed, boolean active) {
        Milestone milestone = new Milestone();
        milestone.setProposalNumber(proposalNumber);
        milestone.setMilestoneNumber(proposalNumber);
        milestone.setMilestoneIdentifier(Long.valueOf(Long.parseLong(proposalNumber) + 1000L));
        milestone.setBilled(billed);
        milestone.setActive(active);
        MilestoneSchedule milestoneSchedule = new MilestoneSchedule();
        milestoneSchedule.setProposalNumber(proposalNumber);
        ArrayList<Milestone> milestones = new ArrayList<Milestone>();
        milestones.add(milestone);
        milestoneSchedule.setMilestones(milestones);
        HashMap<String, String> primaryKeys = new HashMap<String, String>();
        primaryKeys.put("proposalNumber", proposalNumber);
        primaryKeys.put("chartOfAccountsCode", chartOfAccountsCode);
        primaryKeys.put("accountNumber", accountNumber);
        Mockito.when((Object)((MilestoneSchedule)businessObjectServiceMock.findByPrimaryKey(MilestoneSchedule.class, primaryKeys))).thenReturn((Object)milestoneSchedule);
    }

    private void setupPredeterminedBillingSchedule(BusinessObjectService businessObjectServiceMock, String proposalNumber, String chartOfAccountsCode, String accountNumber, boolean billed, boolean active) {
        Bill bill = new Bill();
        bill.setProposalNumber(proposalNumber);
        bill.setBillNumber(proposalNumber);
        bill.setBillIdentifier(Long.valueOf(Long.parseLong(proposalNumber) + 1000L));
        bill.setBilled(billed);
        bill.setActive(active);
        PredeterminedBillingSchedule predeterminedBillingSchedule = new PredeterminedBillingSchedule();
        predeterminedBillingSchedule.setProposalNumber(proposalNumber);
        ArrayList<Bill> bills = new ArrayList<Bill>();
        bills.add(bill);
        predeterminedBillingSchedule.setBills(bills);
        HashMap<String, String> primaryKeys = new HashMap<String, String>();
        primaryKeys.put("proposalNumber", proposalNumber);
        primaryKeys.put("chartOfAccountsCode", chartOfAccountsCode);
        primaryKeys.put("accountNumber", accountNumber);
        Mockito.when((Object)((PredeterminedBillingSchedule)businessObjectServiceMock.findByPrimaryKey(PredeterminedBillingSchedule.class, primaryKeys))).thenReturn((Object)predeterminedBillingSchedule);
    }

    @Test
    void hasActiveUnbilledBills(@Mock BusinessObjectService businessObjectServiceMock) {
        this.cut.setBusinessObjectService(businessObjectServiceMock);
        this.setupPredeterminedBillingSchedule(businessObjectServiceMock, "3", "BL", "0211801", false, true);
        this.setupPredeterminedBillingSchedule(businessObjectServiceMock, "3", "BL", "0211802", true, false);
        this.setupPredeterminedBillingSchedule(businessObjectServiceMock, "4", "BA", "0211801", true, true);
        this.setupPredeterminedBillingSchedule(businessObjectServiceMock, "4", "BA", "0211802", false, false);
        Assertions.assertTrue((boolean)this.cut.hasActiveUnbilledBills("3", "BL", "0211801"));
        Assertions.assertFalse((boolean)this.cut.hasActiveUnbilledBills("3", "BL", "0211802"));
        Assertions.assertFalse((boolean)this.cut.hasActiveUnbilledBills("4", "BA", "0211801"));
        Assertions.assertFalse((boolean)this.cut.hasActiveUnbilledBills("4", "BA", "0211802"));
        Assertions.assertFalse((boolean)this.cut.hasActiveUnbilledBills("111", "XX", "1234567"));
    }

    @Test
    void hasPredeterminedBillingSchedule(@Mock BusinessObjectService businessObjectServiceMock) {
        this.cut.setBusinessObjectService(businessObjectServiceMock);
        this.setupPredeterminedBillingSchedule(businessObjectServiceMock, "3", "BL", "0211801", false, true);
        this.setupPredeterminedBillingSchedule(businessObjectServiceMock, "4", "BA", "0211802", false, false);
        Assertions.assertTrue((boolean)this.cut.hasPredeterminedBillingSchedule("3", "BL", "0211801"));
        Assertions.assertTrue((boolean)this.cut.hasPredeterminedBillingSchedule("4", "BA", "0211802"));
        Assertions.assertFalse((boolean)this.cut.hasPredeterminedBillingSchedule("111", "XX", "1234567"));
    }

    @Test
    void hasActiveUnbilledMilestones(@Mock BusinessObjectService businessObjectServiceMock) {
        this.cut.setBusinessObjectService(businessObjectServiceMock);
        this.setupMilestoneSchedule(businessObjectServiceMock, "1", "BL", "0211801", false, true);
        this.setupMilestoneSchedule(businessObjectServiceMock, "1", "BL", "0211802", true, false);
        this.setupMilestoneSchedule(businessObjectServiceMock, "2", "BA", "0211801", true, true);
        this.setupMilestoneSchedule(businessObjectServiceMock, "2", "BA", "0211802", false, false);
        Assertions.assertTrue((boolean)this.cut.hasActiveUnbilledMilestones("1", "BL", "0211801"));
        Assertions.assertFalse((boolean)this.cut.hasActiveUnbilledMilestones("1", "BL", "0211802"));
        Assertions.assertFalse((boolean)this.cut.hasActiveUnbilledMilestones("2", "BA", "0211801"));
        Assertions.assertFalse((boolean)this.cut.hasActiveUnbilledMilestones("2", "BA", "0211802"));
        Assertions.assertFalse((boolean)this.cut.hasActiveUnbilledMilestones("111", "XX", "1234567"));
    }

    @Test
    void hasMilestoneSchedule(@Mock BusinessObjectService businessObjectServiceMock) {
        this.cut.setBusinessObjectService(businessObjectServiceMock);
        this.setupMilestoneSchedule(businessObjectServiceMock, "1", "BL", "0211801", false, true);
        this.setupMilestoneSchedule(businessObjectServiceMock, "2", "BA", "0211802", false, false);
        Assertions.assertTrue((boolean)this.cut.hasMilestoneSchedule("1", "BL", "0211801"));
        Assertions.assertTrue((boolean)this.cut.hasMilestoneSchedule("2", "BA", "0211802"));
        Assertions.assertFalse((boolean)this.cut.hasMilestoneSchedule("111", "XX", "1234567"));
    }

    @Test
    void getMilestoneTotalAmount_HasNoMilestones(@Mock BusinessObjectService businessObjectServiceMock) {
        this.cut.setBusinessObjectService(businessObjectServiceMock);
        HashMap<String, Object> fieldValues = new HashMap<String, Object>();
        fieldValues.put("proposalNumber", "1");
        fieldValues.put("active", true);
        Mockito.when((Object)businessObjectServiceMock.findMatching(Milestone.class, fieldValues)).thenReturn(Collections.emptyList());
        Assertions.assertEquals((Object)new KualiDecimal(0.0), (Object)this.cut.getMilestonesTotalAmount("1"));
    }

    @Test
    void getMilestoneTotalAmount_HasMilestones(@Mock BusinessObjectService businessObjectServiceMock) {
        this.cut.setBusinessObjectService(businessObjectServiceMock);
        ArrayList<Milestone> milestones = new ArrayList<Milestone>();
        milestones.add(this.setupMilestone(new KualiDecimal(1000), "BL", "1234567"));
        milestones.add(this.setupMilestone(new KualiDecimal(2000), "BL", "2345678"));
        milestones.add(this.setupMilestone(new KualiDecimal(500), "BA", "1234567"));
        HashMap<String, Object> fieldValues = new HashMap<String, Object>();
        fieldValues.put("proposalNumber", "1");
        fieldValues.put("active", true);
        Mockito.when((Object)businessObjectServiceMock.findMatching(Milestone.class, fieldValues)).thenReturn(milestones);
        Assertions.assertEquals((Object)new KualiDecimal(3500.0), (Object)this.cut.getMilestonesTotalAmount("1"));
    }

    @Test
    void getMilestonesTotalAmountForOtherSchedules_HasNoOtherMilestones_CurrentScheduleNotPersisted(@Mock BusinessObjectService businessObjectServiceMock) {
        this.cut.setBusinessObjectService(businessObjectServiceMock);
        HashMap<String, Object> fieldValues = new HashMap<String, Object>();
        fieldValues.put("proposalNumber", "1");
        fieldValues.put("active", true);
        Mockito.when((Object)businessObjectServiceMock.findMatching(Milestone.class, fieldValues)).thenReturn(Collections.emptyList());
        Assertions.assertEquals((Object)new KualiDecimal(0.0), (Object)this.cut.getMilestonesTotalAmountForOtherSchedules("1", "BL", "1234567"));
    }

    @Test
    void getMilestonesTotalAmountForOtherSchedules_HasNoOtherMilestones_CurrentSchedulePersisted(@Mock BusinessObjectService businessObjectServiceMock) {
        this.cut.setBusinessObjectService(businessObjectServiceMock);
        ArrayList<Milestone> milestones = new ArrayList<Milestone>();
        milestones.add(this.setupMilestone(new KualiDecimal(1000), "BL", "1234567"));
        HashMap<String, Object> fieldValues = new HashMap<String, Object>();
        fieldValues.put("proposalNumber", "1");
        fieldValues.put("active", true);
        Mockito.when((Object)businessObjectServiceMock.findMatching(Milestone.class, fieldValues)).thenReturn(milestones);
        Assertions.assertEquals((Object)new KualiDecimal(0.0), (Object)this.cut.getMilestonesTotalAmountForOtherSchedules("1", "BL", "1234567"));
    }

    @Test
    void getMilestonesTotalAmountForOtherSchedules_HasOtherMilestones(@Mock BusinessObjectService businessObjectServiceMock) {
        this.cut.setBusinessObjectService(businessObjectServiceMock);
        ArrayList<Milestone> milestones = new ArrayList<Milestone>();
        milestones.add(this.setupMilestone(new KualiDecimal(1000), "BL", "1234567"));
        milestones.add(this.setupMilestone(new KualiDecimal(2000), "BL", "2345678"));
        milestones.add(this.setupMilestone(new KualiDecimal(500), "BA", "1234567"));
        HashMap<String, Object> fieldValues = new HashMap<String, Object>();
        fieldValues.put("proposalNumber", "1");
        fieldValues.put("active", true);
        Mockito.when((Object)businessObjectServiceMock.findMatching(Milestone.class, fieldValues)).thenReturn(milestones);
        Assertions.assertEquals((Object)new KualiDecimal(2500.0), (Object)this.cut.getMilestonesTotalAmountForOtherSchedules("1", "BL", "1234567"));
    }

    @Test
    void getMilestonesTotalAmountForOtherSchedules_HasOtherMilestones_OneWithNullAmount_DoesNotThrowException(@Mock BusinessObjectService businessObjectServiceMock) {
        this.cut.setBusinessObjectService(businessObjectServiceMock);
        ArrayList<Milestone> milestones = new ArrayList<Milestone>();
        milestones.add(this.setupMilestone(new KualiDecimal(1000), "BL", "1234567"));
        milestones.add(this.setupMilestone(new KualiDecimal(2000), "BL", "2345678"));
        milestones.add(this.setupMilestone(null, "BA", "1234567"));
        HashMap<String, Object> fieldValues = new HashMap<String, Object>();
        fieldValues.put("proposalNumber", "1");
        fieldValues.put("active", true);
        Mockito.when((Object)businessObjectServiceMock.findMatching(Milestone.class, fieldValues)).thenReturn(milestones);
        Assertions.assertEquals((Object)new KualiDecimal(2000.0), (Object)this.cut.getMilestonesTotalAmountForOtherSchedules("1", "BL", "1234567"));
    }

    private Milestone setupMilestone(KualiDecimal milestoneAmount, String chartOfAccountsCode, String accountNumber) {
        Milestone milestone = new Milestone();
        milestone.setMilestoneAmount(milestoneAmount);
        milestone.setChartOfAccountsCode(chartOfAccountsCode);
        milestone.setAccountNumber(accountNumber);
        return milestone;
    }

    @Test
    void getBillTotalAmount_HasNoBills(@Mock BusinessObjectService businessObjectServiceMock) {
        this.cut.setBusinessObjectService(businessObjectServiceMock);
        HashMap<String, Object> fieldValues = new HashMap<String, Object>();
        fieldValues.put("proposalNumber", "1");
        fieldValues.put("active", true);
        Mockito.when((Object)businessObjectServiceMock.findMatching(Bill.class, fieldValues)).thenReturn(Collections.emptyList());
        Assertions.assertEquals((Object)new KualiDecimal(0.0), (Object)this.cut.getBillsTotalAmount("1"));
    }

    @Test
    void getBillTotalAmount_HasBills(@Mock BusinessObjectService businessObjectServiceMock) {
        this.cut.setBusinessObjectService(businessObjectServiceMock);
        ArrayList<Bill> bills = new ArrayList<Bill>();
        bills.add(this.setupBill(new KualiDecimal(1000), "BL", "1234567"));
        bills.add(this.setupBill(new KualiDecimal(2000), "BL", "2345678"));
        bills.add(this.setupBill(new KualiDecimal(500), "BA", "1234567"));
        HashMap<String, Object> fieldValues = new HashMap<String, Object>();
        fieldValues.put("proposalNumber", "1");
        fieldValues.put("active", true);
        Mockito.when((Object)businessObjectServiceMock.findMatching(Bill.class, fieldValues)).thenReturn(bills);
        Assertions.assertEquals((Object)new KualiDecimal(3500.0), (Object)this.cut.getBillsTotalAmount("1"));
    }

    @Test
    void getBillsTotalAmountForOtherSchedules_HasNoOtherBills_CurrentScheduleNotPersisted(@Mock BusinessObjectService businessObjectServiceMock) {
        this.cut.setBusinessObjectService(businessObjectServiceMock);
        HashMap<String, Object> fieldValues = new HashMap<String, Object>();
        fieldValues.put("proposalNumber", "1");
        fieldValues.put("active", true);
        Mockito.when((Object)businessObjectServiceMock.findMatching(Bill.class, fieldValues)).thenReturn(Collections.emptyList());
        Assertions.assertEquals((Object)new KualiDecimal(0.0), (Object)this.cut.getBillsTotalAmountForOtherSchedules("1", "BL", "1234567"));
    }

    @Test
    void getBillsTotalAmountForOtherSchedules_HasNoOtherBills_CurrentSchedulePersisted(@Mock BusinessObjectService businessObjectServiceMock) {
        this.cut.setBusinessObjectService(businessObjectServiceMock);
        ArrayList<Bill> bills = new ArrayList<Bill>();
        bills.add(this.setupBill(new KualiDecimal(1000), "BL", "1234567"));
        HashMap<String, Object> fieldValues = new HashMap<String, Object>();
        fieldValues.put("proposalNumber", "1");
        fieldValues.put("active", true);
        Mockito.when((Object)businessObjectServiceMock.findMatching(Bill.class, fieldValues)).thenReturn(bills);
        Assertions.assertEquals((Object)new KualiDecimal(0.0), (Object)this.cut.getBillsTotalAmountForOtherSchedules("1", "BL", "1234567"));
    }

    @Test
    void getBillsTotalAmountForOtherSchedules_HasOtherBills(@Mock BusinessObjectService businessObjectServiceMock) {
        this.cut.setBusinessObjectService(businessObjectServiceMock);
        ArrayList<Bill> bills = new ArrayList<Bill>();
        bills.add(this.setupBill(new KualiDecimal(1000), "BL", "1234567"));
        bills.add(this.setupBill(new KualiDecimal(2000), "BL", "2345678"));
        bills.add(this.setupBill(new KualiDecimal(500), "BA", "1234567"));
        HashMap<String, Object> fieldValues = new HashMap<String, Object>();
        fieldValues.put("proposalNumber", "1");
        fieldValues.put("active", true);
        Mockito.when((Object)businessObjectServiceMock.findMatching(Bill.class, fieldValues)).thenReturn(bills);
        Assertions.assertEquals((Object)new KualiDecimal(2500.0), (Object)this.cut.getBillsTotalAmountForOtherSchedules("1", "BL", "1234567"));
    }

    @Test
    void getBillsTotalAmountForOtherSchedules_HasOtherBills_OneWithNullAmount_DoesNotThrowException(@Mock BusinessObjectService businessObjectServiceMock) {
        this.cut.setBusinessObjectService(businessObjectServiceMock);
        ArrayList<Bill> bills = new ArrayList<Bill>();
        bills.add(this.setupBill(new KualiDecimal(1000), "BL", "1234567"));
        bills.add(this.setupBill(new KualiDecimal(2000), "BL", "2345678"));
        bills.add(this.setupBill(null, "BA", "1234567"));
        HashMap<String, Object> fieldValues = new HashMap<String, Object>();
        fieldValues.put("proposalNumber", "1");
        fieldValues.put("active", true);
        Mockito.when((Object)businessObjectServiceMock.findMatching(Bill.class, fieldValues)).thenReturn(bills);
        Assertions.assertEquals((Object)new KualiDecimal(2000.0), (Object)this.cut.getBillsTotalAmountForOtherSchedules("1", "BL", "1234567"));
    }

    private Bill setupBill(KualiDecimal estimatedAmount, String chartOfAccountsCode, String accountNumber) {
        Bill bill = new Bill();
        bill.setEstimatedAmount(estimatedAmount);
        bill.setChartOfAccountsCode(chartOfAccountsCode);
        bill.setAccountNumber(accountNumber);
        return bill;
    }
}

