/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.ar.service.impl;

import java.util.Random;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.kuali.kfs.datadictionary.legacy.DataDictionaryService;
import org.kuali.kfs.module.ar.businessobject.CustomerAddress;
import org.kuali.kfs.module.ar.service.impl.CustomerDocumentServiceImpl;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.jupiter.MockitoExtension;

@ExtendWith(value={MockitoExtension.class})
class CustomerDocumentServiceImplTest {
    private static final int CUSTOMER_ADDRESS_NAME_LENGTH = 40;
    private CustomerDocumentServiceImpl cut;
    @Mock
    private DataDictionaryService dataDictionarySvcMock;
    private char[] characters;
    private Random rand;

    CustomerDocumentServiceImplTest() {
    }

    @BeforeEach
    void setUp() {
        int i;
        Mockito.when((Object)this.dataDictionarySvcMock.getAttributeMaxLength(CustomerAddress.class, "customerAddressName")).thenReturn((Object)40);
        this.cut = new CustomerDocumentServiceImpl();
        this.cut.setDataDictionaryService(this.dataDictionarySvcMock);
        this.characters = new char[52];
        int count = 0;
        for (i = 65; i <= 90; i = (int)((char)(i + 1))) {
            this.characters[count] = i;
            ++count;
        }
        for (i = 97; i <= 122; i = (int)((char)(i + 1))) {
            this.characters[count] = i;
            ++count;
        }
        this.rand = new Random();
    }

    @Test
    void truncateField() {
        String customerAddressNameShort = this.randomString(37);
        String customerAddressNameLong = this.randomString(47);
        String customerAddressNameBabyBear = this.randomString(40);
        String customerAddressNameShortTruncated = this.cut.truncateField(CustomerAddress.class, "customerAddressName", customerAddressNameShort);
        String customerAddressNameLongTruncated = this.cut.truncateField(CustomerAddress.class, "customerAddressName", customerAddressNameLong);
        String customerAddressNameBabyBearTruncated = this.cut.truncateField(CustomerAddress.class, "customerAddressName", customerAddressNameBabyBear);
        Assertions.assertEquals((int)customerAddressNameShort.length(), (int)customerAddressNameShortTruncated.length(), (String)"Customer Address Name Short should have the same length as truncated version");
        Assertions.assertEquals((Object)customerAddressNameShort, (Object)customerAddressNameShortTruncated, (String)"Customer Address Name Short should be the same String as the truncated version");
        Assertions.assertEquals((int)40, (int)customerAddressNameLongTruncated.length(), (String)"Customer Address Name Long should have the max length of the customer address name field");
        Assertions.assertTrue((boolean)customerAddressNameLong.startsWith(customerAddressNameLongTruncated), (String)"Customer Address Name Long should start with the truncated version");
        Assertions.assertEquals((int)customerAddressNameBabyBear.length(), (int)customerAddressNameBabyBearTruncated.length(), (String)"Customer Address Name Baby Bear should have the same length as the truncated version");
        Assertions.assertEquals((int)40, (int)customerAddressNameBabyBearTruncated.length(), (String)"Customer Address Name Baby Bear should have the same length as the customer address name field");
        Assertions.assertEquals((Object)customerAddressNameBabyBear, (Object)customerAddressNameBabyBearTruncated, (String)"Customer Address Name Baby Bear should be the exact same string as the truncated version");
    }

    private String randomString(int size) {
        StringBuilder s = new StringBuilder();
        for (int count = 0; count < size; ++count) {
            int idx = this.rand.nextInt(this.characters.length);
            s.append(this.characters[idx]);
        }
        return s.toString();
    }
}

